/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import jmri.IdTag;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.Reporter;
import jmri.beans.Identifiable;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.divisions.Division;
import jmri.jmrit.operations.locations.divisions.DivisionManager;
import jmri.jmrit.operations.rollingstock.Bundle;
import jmri.jmrit.operations.rollingstock.cars.CarColors;
import jmri.jmrit.operations.rollingstock.cars.CarOwners;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RollingStock
extends PropertyChangeSupport
implements Identifiable,
PropertyChangeListener {
    public static final String NONE = "";
    public static final int DEFAULT_BLOCKING_ORDER = 0;
    public static final int MAX_BLOCKING_ORDER = 100;
    public static final boolean FORCE = true;
    protected static final String DEFAULT_WEIGHT = "0";
    protected String _id = "";
    protected String _number = "";
    protected String _road = "";
    protected String _type = "";
    protected String _length = "0";
    protected String _color = "";
    protected String _weight = "0";
    protected String _weightTons = "0";
    protected String _built = "";
    protected String _owner = "";
    protected String _comment = "";
    protected String _routeId = "";
    protected String _rfid = "";
    protected String _value = "";
    protected Date _lastDate = null;
    protected boolean _locationUnknown = false;
    protected boolean _outOfService = false;
    protected boolean _selected = false;
    protected Location _location = null;
    protected Track _track = null;
    protected Location _destination = null;
    protected Track _trackDestination = null;
    protected Train _train = null;
    protected RouteLocation _routeLocation = null;
    protected RouteLocation _routeDestination = null;
    protected Division _division = null;
    protected int _moves = 0;
    protected String _lastLocationId = "0";
    protected String _lastTrackId = "0";
    protected Train _lastTrain = null;
    protected int _blocking = 0;
    protected String _pickupTime = "";
    protected String _setoutTime = "";
    protected IdTag _tag = null;
    protected PropertyChangeListener _tagListener = null;
    protected Location _whereLastSeen = null;
    protected Date _whenLastSeen = null;
    public static final String LOCATION_UNKNOWN = "0";
    protected int number = 0;
    public static final String ERROR_TRACK = "ERROR wrong track for location";
    public static final String TRACK_CHANGED_PROPERTY = "rolling stock track location";
    public static final String DESTINATION_TRACK_CHANGED_PROPERTY = "rolling stock track destination";
    public static final String TRAIN_CHANGED_PROPERTY = "rolling stock train";
    public static final String LENGTH_CHANGED_PROPERTY = "rolling stock length";
    public static final String TYPE_CHANGED_PROPERTY = "rolling stock type";
    public static final String ROUTE_LOCATION_CHANGED_PROPERTY = "rolling stock route location";
    public static final String ROUTE_DESTINATION_CHANGED_PROPERTY = "rolling stock route destination";
    public static final String COMMENT_CHANGED_PROPERTY = "rolling stock comment";
    public static final int COUPLERS = Setup.getLengthUnit().equals(Setup.FEET) ? Integer.parseInt(Bundle.getMessage("DrawBarLengthFeet")) : Integer.parseInt(Bundle.getMessage("DrawBarLengthMeter"));
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    protected boolean _lengthChange = false;
    private static final Logger log = LoggerFactory.getLogger(RollingStock.class);

    public RollingStock() {
        this._lastDate = new GregorianCalendar().getGregorianChange();
    }

    public RollingStock(String road, String number) {
        this();
        log.debug("New rolling stock ({} {})", (Object)road, (Object)number);
        this._road = road;
        this._number = number;
        this._id = RollingStock.createId(road, number);
        this.addPropertyChangeListeners();
    }

    public static String createId(String road, String number) {
        return road + number;
    }

    @Override
    public String getId() {
        return this._id;
    }

    public void setNumber(String number) {
        String oldNumber = this._number;
        this._number = number;
        if (!oldNumber.equals(number)) {
            this.firePropertyChange("rolling stock number", oldNumber, number);
            String oldId = this._id;
            this._id = RollingStock.createId(this._road, number);
            this.setDirtyAndFirePropertyChange("id", oldId, this._id);
        }
    }

    public String getNumber() {
        return this._number;
    }

    public void setRoadName(String road) {
        String old = this._road;
        this._road = road;
        if (!old.equals(road)) {
            this.firePropertyChange("rolling stock road", old, road);
            String oldId = this._id;
            this._id = RollingStock.createId(road, this._number);
            this.setDirtyAndFirePropertyChange("id", oldId, this._id);
        }
    }

    public String getRoadName() {
        return this._road;
    }

    public String toString() {
        return this.getRoadName() + " " + this.getNumber();
    }

    public void setTypeName(String type) {
        String old = this._type;
        this._type = type;
        if (!old.equals(type)) {
            this.setDirtyAndFirePropertyChange(TYPE_CHANGED_PROPERTY, old, type);
        }
    }

    public String getTypeName() {
        return this._type;
    }

    public void setLength(String length) {
        String old = this._length;
        if (!old.equals(length)) {
            if (this.getLocation() != null && this.getTrack() != null) {
                this.getLocation().setUsedLength(this.getLocation().getUsedLength() + Integer.parseInt(length) - Integer.parseInt(old));
                this.getTrack().setUsedLength(this.getTrack().getUsedLength() + Integer.parseInt(length) - Integer.parseInt(old));
                if (this.getDestination() != null && this.getDestinationTrack() != null && !this._lengthChange) {
                    this._lengthChange = true;
                    log.debug("Rolling stock ({}) has destination ({}, {})", new Object[]{this, this.getDestination().getName(), this.getDestinationTrack().getName()});
                    this.getTrack().deletePickupRS(this);
                    this.getDestinationTrack().deleteDropRS(this);
                    this._length = length;
                    this.getTrack().addPickupRS(this);
                    this.getDestinationTrack().addDropRS(this);
                    this._lengthChange = false;
                }
            }
            this._length = length;
            this.setDirtyAndFirePropertyChange(LENGTH_CHANGED_PROPERTY, old, length);
        }
    }

    public String getLength() {
        return this._length;
    }

    public int getLengthInteger() {
        try {
            return Integer.parseInt(this.getLength());
        }
        catch (NumberFormatException e) {
            log.error("Rolling stock ({}) length ({}) is not valid ", (Object)this, (Object)this.getLength());
            return 0;
        }
    }

    public int getTotalLength() {
        return this.getLengthInteger() + COUPLERS;
    }

    public void setColor(String color) {
        String old = this._color;
        this._color = color;
        if (!old.equals(color)) {
            this.setDirtyAndFirePropertyChange("rolling stock color", old, color);
        }
    }

    public String getColor() {
        return this._color;
    }

    public void setWeight(String weight) {
        String old = this._weight;
        this._weight = weight;
        if (!old.equals(weight)) {
            this.setDirtyAndFirePropertyChange("rolling stock weight", old, weight);
        }
    }

    public String getWeight() {
        return this._weight;
    }

    public void setWeightTons(String weight) {
        String old = this._weightTons;
        this._weightTons = weight;
        if (!old.equals(weight)) {
            this.setDirtyAndFirePropertyChange("rolling stock weight tons", old, weight);
        }
    }

    public String getWeightTons() {
        if (!this._weightTons.equals("0")) {
            return this._weightTons;
        }
        double weight = 0.0;
        try {
            weight = Double.parseDouble(this.getWeight());
        }
        catch (NumberFormatException e) {
            log.trace("Weight not set for rolling stock ({})", (Object)this);
        }
        return Integer.toString((int)(weight * (double)Setup.getScaleTonRatio()));
    }

    public int getAdjustedWeightTons() {
        int weightTons = 0;
        try {
            weightTons = Integer.parseInt(this.getWeightTons());
        }
        catch (NumberFormatException e) {
            log.debug("Rolling stock ({}) weight not set", (Object)this);
        }
        return weightTons;
    }

    public void setBuilt(String built) {
        String old = this._built;
        this._built = built;
        if (!old.equals(built)) {
            this.setDirtyAndFirePropertyChange("rolling stock built", old, built);
        }
    }

    public String getBuilt() {
        return this._built;
    }

    public String getStatus() {
        return this.isLocationUnknown() ? "<?> " : (this.isOutOfService() ? "<O> " : NONE);
    }

    public Location getLocation() {
        return this._location;
    }

    public String getLocationName() {
        if (this.getLocation() != null) {
            return this.getLocation().getName();
        }
        return NONE;
    }

    public String getSplitLocationName() {
        return TrainCommon.splitString(this.getLocationName());
    }

    public String getLocationId() {
        if (this.getLocation() != null) {
            return this.getLocation().getId();
        }
        return NONE;
    }

    public Track getTrack() {
        return this._track;
    }

    public void setTrack(Track track) {
        if (track != null) {
            this._location = track.getLocation();
        }
        this._track = track;
    }

    public String getTrackName() {
        if (this.getTrack() != null) {
            return this.getTrack().getName();
        }
        return NONE;
    }

    public String getSplitTrackName() {
        return TrainCommon.splitString(this.getTrackName());
    }

    public String getTrackType() {
        if (this.getTrack() != null) {
            return this.getTrack().getTrackTypeName();
        }
        return NONE;
    }

    public String getTrackId() {
        if (this.getTrack() != null) {
            return this.getTrack().getId();
        }
        return NONE;
    }

    public String setLocation(Location location, Track track) {
        return this.setLocation(location, track, false);
    }

    public String setLocation(Location location, Track track, boolean force) {
        String status;
        Location oldLocation = this.getLocation();
        Track oldTrack = this.getTrack();
        if (!(force || oldLocation == location && oldTrack == track || (status = this.testLocation(location, track)).equals(Track.OKAY))) {
            return status;
        }
        this._location = location;
        this._track = track;
        if (oldLocation != location || oldTrack != track) {
            if (oldLocation != null) {
                oldLocation.deleteRS(this);
                oldLocation.removePropertyChangeListener(this);
                if (oldTrack != null) {
                    oldTrack.deleteRS(this);
                    oldTrack.removePropertyChangeListener(this);
                    if (this.getDestination() != null) {
                        oldLocation.deletePickupRS();
                        oldTrack.deletePickupRS(this);
                        if (!oldLocation.isStaging() || location == null || !location.isStaging() || this.getTrain() != null && this.getTrain().getRoute() != null && this.getTrain().getRoute().size() > 2) {
                            this.setLastLocationId(oldLocation.getId());
                            this.setLastTrackId(oldTrack.getId());
                        }
                    }
                }
            }
            if (this.getLocation() != null) {
                this.getLocation().addRS(this);
                this.getLocation().addPropertyChangeListener(this);
            }
            if (this.getTrack() != null) {
                this.getTrack().addRS(this);
                this.getTrack().addPropertyChangeListener(this);
                if (this.getDestination() != null) {
                    this.getLocation().addPickupRS();
                    this.getTrack().addPickupRS(this);
                }
            }
            this.setDirtyAndFirePropertyChange(TRACK_CHANGED_PROPERTY, oldTrack, track);
        }
        return Track.OKAY;
    }

    public String testLocation(Location location, Track track) {
        if (track == null) {
            return Track.OKAY;
        }
        if (location != null && !location.isTrackAtLocation(track)) {
            return ERROR_TRACK;
        }
        return track.isRollingStockAccepted(this);
    }

    public String setDestination(Location destination, Track track) {
        return this.setDestination(destination, track, false);
    }

    public String setDestination(Location destination, Track track, boolean force) {
        String status;
        if (!force && !(status = this.rsCheckDestination(destination, track)).equals(Track.OKAY)) {
            return status;
        }
        Location oldDestination = this.getDestination();
        this._destination = destination;
        Track oldTrack = this.getDestinationTrack();
        this._trackDestination = track;
        if (oldDestination != destination || oldTrack != track) {
            if (oldDestination != null) {
                oldDestination.deleteDropRS();
                oldDestination.removePropertyChangeListener(this);
                if (this.getLocation() != null && this.getTrack() != null) {
                    this.getLocation().deletePickupRS();
                    this.getTrack().deletePickupRS(this);
                }
            }
            if (oldTrack != null) {
                oldTrack.deleteDropRS(this);
                oldTrack.removePropertyChangeListener(this);
            }
            if (this.getDestination() != null) {
                this.getDestination().addDropRS();
                if (this.getLocation() != null && this.getTrack() != null) {
                    this.getLocation().addPickupRS();
                    this.getTrack().addPickupRS(this);
                }
                this.getDestination().addPropertyChangeListener(this);
            }
            if (this.getDestinationTrack() != null) {
                this.getDestinationTrack().addDropRS(this);
                this.getDestinationTrack().addPropertyChangeListener(this);
            } else {
                if (this.getTrain() != null && this.getTrain().getRoute() != null) {
                    this.setLastRouteId(this.getTrain().getRoute().getId());
                }
                this.setRouteLocation(null);
                this.setRouteDestination(null);
            }
            this.setDirtyAndFirePropertyChange(DESTINATION_TRACK_CHANGED_PROPERTY, oldTrack, track);
        }
        return Track.OKAY;
    }

    public String checkDestination(Location destination, Track track) {
        return this.rsCheckDestination(destination, track);
    }

    private String rsCheckDestination(Location destination, Track track) {
        if (destination != null && !destination.isTrackAtLocation(track)) {
            return ERROR_TRACK;
        }
        if (destination != null && !destination.acceptsTypeName(this.getTypeName())) {
            return Track.TYPE + " (" + this.getTypeName() + ")";
        }
        if (destination == null || track == null) {
            return Track.OKAY;
        }
        return track.isRollingStockAccepted(this);
    }

    public Location getDestination() {
        return this._destination;
    }

    public void setDestination(Location destination) {
        this._destination = destination;
    }

    public String getDestinationName() {
        if (this.getDestination() != null) {
            return this.getDestination().getName();
        }
        return NONE;
    }

    public String getSplitDestinationName() {
        return TrainCommon.splitString(this.getDestinationName());
    }

    public String getDestinationId() {
        if (this.getDestination() != null) {
            return this.getDestination().getId();
        }
        return NONE;
    }

    public void setDestinationTrack(Track track) {
        if (track != null) {
            this._destination = track.getLocation();
        }
        this._trackDestination = track;
    }

    public Track getDestinationTrack() {
        return this._trackDestination;
    }

    public String getDestinationTrackName() {
        if (this.getDestinationTrack() != null) {
            return this.getDestinationTrack().getName();
        }
        return NONE;
    }

    public String getSplitDestinationTrackName() {
        return TrainCommon.splitString(this.getDestinationTrackName());
    }

    public String getDestinationTrackId() {
        if (this.getDestinationTrack() != null) {
            return this.getDestinationTrack().getId();
        }
        return NONE;
    }

    public void setDivision(Division division) {
        Division old = this._division;
        this._division = division;
        if (old != this._division) {
            this.setDirtyAndFirePropertyChange("homeDivisionChange", old, division);
        }
    }

    public Division getDivision() {
        return this._division;
    }

    public String getDivisionName() {
        if (this.getDivision() != null) {
            return this.getDivision().getName();
        }
        return NONE;
    }

    public String getDivisionId() {
        if (this.getDivision() != null) {
            return this.getDivision().getId();
        }
        return NONE;
    }

    public void setLastLocationId(String id) {
        this._lastLocationId = id;
    }

    public String getLastLocationId() {
        return this._lastLocationId;
    }

    public String getLastLocationName() {
        Location location = this.locationManager.getLocationById(this.getLastLocationId());
        if (location != null) {
            return location.getName();
        }
        return NONE;
    }

    public void setLastTrackId(String id) {
        this._lastTrackId = id;
    }

    public String getLastTrackId() {
        return this._lastTrackId;
    }

    public String getLastTrackName() {
        Track track;
        Location location = this.locationManager.getLocationById(this.getLastLocationId());
        if (location != null && (track = location.getTrackById(this.getLastTrackId())) != null) {
            return track.getName();
        }
        return NONE;
    }

    public void setMoves(int moves) {
        int old = this._moves;
        this._moves = moves;
        if (old != moves) {
            this.setDirtyAndFirePropertyChange("rolling stock moves", Integer.toString(old), Integer.toString(moves));
        }
    }

    public int getMoves() {
        return this._moves;
    }

    public void setTrain(Train train) {
        Train old = this._train;
        this._train = train;
        if (old != train) {
            if (old != null) {
                old.removePropertyChangeListener(this);
            }
            if (train != null) {
                train.addPropertyChangeListener(this);
            }
            this.setDirtyAndFirePropertyChange(TRAIN_CHANGED_PROPERTY, old, train);
        }
    }

    public Train getTrain() {
        return this._train;
    }

    public String getTrainName() {
        if (this.getTrain() != null) {
            return this.getTrain().getName();
        }
        return NONE;
    }

    public void setLastTrain(Train train) {
        Train old = this._lastTrain;
        this._lastTrain = train;
        if (old != train) {
            if (old != null) {
                old.removePropertyChangeListener(this);
            }
            if (train != null) {
                train.addPropertyChangeListener(this);
            }
            this.setDirtyAndFirePropertyChange(TRAIN_CHANGED_PROPERTY, old, train);
        }
    }

    public Train getLastTrain() {
        return this._lastTrain;
    }

    public String getLastTrainName() {
        if (this.getLastTrain() != null) {
            return this.getLastTrain().getName();
        }
        return NONE;
    }

    public void setRouteLocation(RouteLocation routeLocation) {
        if (this.getLocation() == null && routeLocation != null) {
            log.debug("WARNING rolling stock ({}) does not have an assigned location", (Object)this);
        } else if (routeLocation != null && this.getLocation() != null && !routeLocation.getName().equals(this.getLocation().getName())) {
            log.error("ERROR route location name({}) not equal to location name ({}) for rolling stock ({})", new Object[]{routeLocation.getName(), this.getLocation().getName(), this});
        }
        RouteLocation old = this._routeLocation;
        this._routeLocation = routeLocation;
        if (old != routeLocation) {
            this.setDirtyAndFirePropertyChange(ROUTE_LOCATION_CHANGED_PROPERTY, old, routeLocation);
        }
    }

    public RouteLocation getRouteLocation() {
        return this._routeLocation;
    }

    public String getRouteLocationId() {
        if (this.getRouteLocation() != null) {
            return this.getRouteLocation().getId();
        }
        return NONE;
    }

    public String getLastRouteId() {
        return this._routeId;
    }

    public void setLastRouteId(String id) {
        this._routeId = id;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        String old = this._value;
        this._value = value;
        if (!old.equals(value)) {
            this.setDirtyAndFirePropertyChange("rolling stock value", old, value);
        }
    }

    public String getRfid() {
        return this._rfid;
    }

    public void setRfid(String id) {
        String old = this._rfid;
        if (id != null && !id.equals(old)) {
            log.debug("Setting IdTag for {} to {}", (Object)this, (Object)id);
            this._rfid = id;
            if (!id.equals(NONE)) {
                try {
                    IdTag tag = InstanceManager.getDefault(IdTagManager.class).provideIdTag(id);
                    this.setIdTag(tag);
                }
                catch (IllegalArgumentException e) {
                    log.error("Exception recording tag {} - exception value {}", (Object)id, (Object)e.getMessage());
                }
            }
            this.setDirtyAndFirePropertyChange("rolling stock rfid", old, id);
        }
    }

    public IdTag getIdTag() {
        return this._tag;
    }

    public void setIdTag(IdTag tag) {
        if (this._tag != null) {
            this._tag.removePropertyChangeListener(this._tagListener);
        }
        this._tag = tag;
        if (this._tagListener == null) {
            this._tagListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("whereLastSeen")) {
                        log.debug("Tag Reader Position update received for {}", (Object)this);
                        if (e.getNewValue() != null) {
                            Track newTrack = RollingStock.this.locationManager.getTrackByReporter((Reporter)e.getNewValue());
                            if (newTrack != null) {
                                if (newTrack != RollingStock.this.getTrack()) {
                                    RollingStock.this.setLocation(newTrack.getLocation(), newTrack);
                                    RollingStock.this._whereLastSeen = newTrack.getLocation();
                                    RollingStock.this.setDirtyAndFirePropertyChange("rolling stock whereLastSeen", RollingStock.this._whereLastSeen, RollingStock.this._whereLastSeen);
                                }
                            } else {
                                Location newLocation = RollingStock.this.locationManager.getLocationByReporter((Reporter)e.getNewValue());
                                if (newLocation != RollingStock.this.getLocation()) {
                                    RollingStock.this._whereLastSeen = newLocation;
                                    RollingStock.this.setDirtyAndFirePropertyChange("rolling stock whereLastSeen", RollingStock.this._whereLastSeen, RollingStock.this._whereLastSeen);
                                }
                            }
                        }
                    }
                    if (e.getPropertyName().equals("whenLastSeen")) {
                        log.debug("Tag Reader Time at Location update received for {}", (Object)this);
                        if (e.getNewValue() != null) {
                            Date newDate = (Date)e.getNewValue();
                            RollingStock.this.setLastDate(newDate);
                            RollingStock.this._whenLastSeen = newDate;
                            RollingStock.this.setDirtyAndFirePropertyChange("rolling stock whenLastSeen", RollingStock.this._whenLastSeen, RollingStock.this._whenLastSeen);
                        }
                    }
                }
            };
        }
        if (this._tag != null) {
            this._tag.addPropertyChangeListener(this._tagListener);
            this.setRfid(this._tag.getSystemName());
        } else {
            this.setRfid(NONE);
        }
        this._whereLastSeen = this.getWhereLastSeen();
        this._whenLastSeen = this.getWhenLastSeen();
    }

    public String getWhereLastSeenName() {
        if (this.getWhereLastSeen() != null) {
            return this.getWhereLastSeen().getName();
        }
        return NONE;
    }

    public Location getWhereLastSeen() {
        if (this._tag == null) {
            return null;
        }
        Reporter r = this._tag.getWhereLastSeen();
        Track t = this.locationManager.getTrackByReporter(r);
        if (t != null) {
            return t.getLocation();
        }
        return this.locationManager.getLocationByReporter(r);
    }

    public Track getTrackLastSeen() {
        if (this._tag == null) {
            return null;
        }
        Reporter r = this._tag.getWhereLastSeen();
        if (r == null) {
            return null;
        }
        return this.locationManager.getTrackByReporter(r);
    }

    public String getTrackLastSeenName() {
        Track t = this.getTrackLastSeen();
        if (t != null) {
            return t.getName();
        }
        return NONE;
    }

    public Date getWhenLastSeen() {
        if (this._tag == null) {
            return null;
        }
        return this._tag.getWhenLastSeen();
    }

    public String getWhenLastSeenDate() {
        if (this.getWhenLastSeen() == null) {
            return NONE;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return format.format(this.getWhenLastSeen());
    }

    public String getSortDate() {
        if (this._lastDate.equals(new GregorianCalendar().getGregorianChange())) {
            return NONE;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return format.format(this._lastDate);
    }

    public String getLastDate() {
        if (this._lastDate.equals(new GregorianCalendar().getGregorianChange())) {
            return NONE;
        }
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return format.format(this._lastDate);
    }

    public void setLastDate(Date date) {
        Date old = this._lastDate;
        this._lastDate = date;
        if (!old.equals(this._lastDate)) {
            this.setDirtyAndFirePropertyChange("rolling stock date", old, date);
        }
    }

    public Date getLastMoveDate() {
        return this._lastDate;
    }

    public void setLastDate(String date) {
        Date d = TrainCommon.convertStringToDate(date);
        if (d != null) {
            this._lastDate = d;
        }
    }

    public void setBlocking(int number) {
        int old = this._blocking;
        this._blocking = number;
        if (old != number) {
            this.setDirtyAndFirePropertyChange("rolling stock blocking changed", old, number);
        }
    }

    public int getBlocking() {
        return this._blocking;
    }

    public void setRouteDestination(RouteLocation routeDestination) {
        if (routeDestination != null && this.getDestination() != null && !routeDestination.getName().equals(this.getDestination().getName())) {
            log.debug("WARNING route destination name ({}) not equal to destination name ({}) for rolling stock ({})", new Object[]{routeDestination.getName(), this.getDestination().getName(), this});
        }
        RouteLocation old = this._routeDestination;
        this._routeDestination = routeDestination;
        if (old != routeDestination) {
            this.setDirtyAndFirePropertyChange(ROUTE_DESTINATION_CHANGED_PROPERTY, old, routeDestination);
        }
    }

    public RouteLocation getRouteDestination() {
        return this._routeDestination;
    }

    public String getRouteDestinationId() {
        if (this.getRouteDestination() != null) {
            return this.getRouteDestination().getId();
        }
        return NONE;
    }

    public void setOwnerName(String owner) {
        String old = this._owner;
        this._owner = owner;
        if (!old.equals(owner)) {
            this.setDirtyAndFirePropertyChange("rolling stock owner", old, owner);
        }
    }

    public String getOwnerName() {
        return this._owner;
    }

    public void setLocationUnknown(boolean unknown) {
        boolean old = this._locationUnknown;
        this._locationUnknown = unknown;
        if (!old == unknown) {
            this.setDirtyAndFirePropertyChange("car location known", old ? "true" : "false", unknown ? "true" : "false");
        }
    }

    public boolean isLocationUnknown() {
        return this._locationUnknown;
    }

    public void setOutOfService(boolean outOfService) {
        boolean old = this._outOfService;
        this._outOfService = outOfService;
        if (!old == outOfService) {
            this.setDirtyAndFirePropertyChange("car out of service", old ? "true" : "false", outOfService ? "true" : "false");
        }
    }

    public boolean isOutOfService() {
        return this._outOfService;
    }

    public void setSelected(boolean selected) {
        boolean old = this._selected;
        this._selected = selected;
        if (!old == selected) {
            this.setDirtyAndFirePropertyChange("selected", old ? "true" : "false", selected ? "true" : "false");
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setComment(String comment) {
        String old = this._comment;
        this._comment = comment;
        if (!old.equals(comment)) {
            this.setDirtyAndFirePropertyChange(COMMENT_CHANGED_PROPERTY, old, comment);
        }
    }

    public String getComment() {
        return this._comment;
    }

    public void setPickupTime(String time) {
        String old = this._pickupTime;
        this._pickupTime = time;
        this.setDirtyAndFirePropertyChange("Pickup Time Changed", old, time);
    }

    public String getPickupTime() {
        if (this.getTrain() != null) {
            return this._pickupTime;
        }
        return NONE;
    }

    public void setSetoutTime(String time) {
        String old = this._setoutTime;
        this._setoutTime = time;
        this.setDirtyAndFirePropertyChange("Setout Time Changed", old, time);
    }

    public String getSetoutTime() {
        if (this.getTrain() != null) {
            return this._setoutTime;
        }
        return NONE;
    }

    protected void moveRollingStock(RouteLocation current, RouteLocation next) {
        if (current == this.getRouteLocation()) {
            this.setLastDate(Calendar.getInstance().getTime());
            if (this.getRouteLocation() == this.getRouteDestination() || next == null) {
                if (this.getRouteLocation() == this.getRouteDestination()) {
                    log.debug("Rolling stock ({}) has arrived at destination ({})", (Object)this, (Object)this.getDestination());
                } else {
                    log.error("Rolling stock ({}) has a null route location for next", (Object)this);
                }
                this.setLocation(this.getDestination(), this.getDestinationTrack(), true);
                this.setDestination(null, null);
                this.setLastTrain(this.getTrain());
                this.setTrain(null);
                this.setMoves(this.getMoves() + 1);
            } else {
                log.debug("Rolling stock ({}) is in train ({}) leaves location ({}) destination ({})", new Object[]{this, this.getTrainName(), current.getName(), next.getName()});
                this.setLocation(next.getLocation(), null, true);
                this.setRouteLocation(next);
            }
        }
    }

    public void reset() {
        this.setTrain(null);
        this.setDestination(null, null);
    }

    public void dispose() {
        this.setTrain(null);
        this.setDestination(null, null);
        this.setLocation(null, null);
        InstanceManager.getDefault(CarRoads.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarOwners.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarColors.class).removePropertyChangeListener(this);
        if (this.getIdTag() != null) {
            this.getIdTag().removePropertyChangeListener(this._tagListener);
        }
    }

    public RollingStock(Element e) {
        this();
        Attribute a = e.getAttribute("id");
        if (a != null) {
            this._id = a.getValue();
        } else {
            log.warn("no id attribute in rolling stock element when reading operations");
        }
        a = e.getAttribute("roadNumber");
        if (a != null) {
            this._number = a.getValue();
        }
        if ((a = e.getAttribute("roadName")) != null) {
            this._road = a.getValue();
        }
        if (this._id == null || !this._id.equals(RollingStock.createId(this._road, this._number))) {
            this._id = RollingStock.createId(this._road, this._number);
        }
        if ((a = e.getAttribute("type")) != null) {
            this._type = a.getValue();
        }
        if ((a = e.getAttribute("length")) != null) {
            this._length = a.getValue();
        }
        if ((a = e.getAttribute("color")) != null) {
            this._color = a.getValue();
        }
        if ((a = e.getAttribute("weight")) != null) {
            this._weight = a.getValue();
        }
        if ((a = e.getAttribute("weightTons")) != null) {
            this._weightTons = a.getValue();
        }
        if ((a = e.getAttribute("built")) != null) {
            this._built = a.getValue();
        }
        Location location = null;
        Track track = null;
        a = e.getAttribute("locationId");
        if (a != null) {
            location = this.locationManager.getLocationById(a.getValue());
        }
        if ((a = e.getAttribute("secLocationId")) != null && location != null) {
            track = location.getTrackById(a.getValue());
        }
        this.setLocation(location, track, true);
        Location destination = null;
        track = null;
        a = e.getAttribute("destinationId");
        if (a != null) {
            destination = this.locationManager.getLocationById(a.getValue());
        }
        if ((a = e.getAttribute("secDestinationId")) != null && destination != null) {
            track = destination.getTrackById(a.getValue());
        }
        this.setDestination(destination, track, true);
        a = e.getAttribute("divisionId");
        if (a != null) {
            this._division = InstanceManager.getDefault(DivisionManager.class).getDivisionById(a.getValue());
        }
        if ((a = e.getAttribute("DivisionId")) != null) {
            this._division = InstanceManager.getDefault(DivisionManager.class).getDivisionById(a.getValue());
        }
        if ((a = e.getAttribute("moves")) != null) {
            try {
                this._moves = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException nfe) {
                log.error("Move count ({}) for rollingstock ({}) isn't a valid number!", (Object)a.getValue(), (Object)this.toString());
            }
        }
        if ((a = e.getAttribute("lastLocationId")) != null) {
            this._lastLocationId = a.getValue();
        }
        if ((a = e.getAttribute("lastTrackId")) != null) {
            this._lastTrackId = a.getValue();
        }
        if ((a = e.getAttribute("trainId")) != null) {
            this.setTrain(InstanceManager.getDefault(TrainManager.class).getTrainById(a.getValue()));
        } else {
            a = e.getAttribute("train");
            if (a != null) {
                this.setTrain(InstanceManager.getDefault(TrainManager.class).getTrainByName(a.getValue()));
            }
        }
        if (this.getTrain() != null && this.getTrain().getRoute() != null && (a = e.getAttribute("routeLocationId")) != null) {
            this._routeLocation = this.getTrain().getRoute().getRouteLocationById(a.getValue());
            a = e.getAttribute("routeDestinationId");
            if (a != null) {
                this._routeDestination = this.getTrain().getRoute().getRouteLocationById(a.getValue());
            }
        }
        if ((a = e.getAttribute("lastTrainId")) != null) {
            this.setLastTrain(InstanceManager.getDefault(TrainManager.class).getTrainById(a.getValue()));
        }
        if ((a = e.getAttribute("lastRouteId")) != null) {
            this._routeId = a.getValue();
        }
        if ((a = e.getAttribute("owner")) != null) {
            this._owner = a.getValue();
        }
        if ((a = e.getAttribute("comment")) != null) {
            this._comment = a.getValue();
        }
        if ((a = e.getAttribute("value")) != null) {
            this._value = a.getValue();
        }
        if ((a = e.getAttribute("rfid")) != null) {
            this.setRfid(a.getValue());
        }
        if ((a = e.getAttribute("locUnknown")) != null) {
            this._locationUnknown = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("outOfService")) != null) {
            this._outOfService = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("selected")) != null) {
            this._selected = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("date")) != null) {
            this.setLastDate(a.getValue());
        }
        if ((a = e.getAttribute("pickupTime")) != null) {
            this._pickupTime = a.getValue();
        }
        if ((a = e.getAttribute("setoutTime")) != null) {
            this._setoutTime = a.getValue();
        }
        if ((a = e.getAttribute("blocking")) != null) {
            try {
                this._blocking = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException nfe) {
                log.error("Blocking ({}) for rollingstock ({}) isn't a valid number!", (Object)a.getValue(), (Object)this.toString());
            }
        }
        if (this.getLocation() != null && this.getTrack() == null && this.getTrain() == null) {
            log.warn("Rollingstock ({}) at ({}) doesn't have a track assignment", (Object)this, (Object)this.getLocationName());
        }
        this.addPropertyChangeListeners();
    }

    protected Element store(Element e) {
        e.setAttribute("id", this.getId());
        e.setAttribute("roadName", this.getRoadName());
        e.setAttribute("roadNumber", this.getNumber());
        e.setAttribute("type", this.getTypeName());
        e.setAttribute("length", this.getLength());
        if (!this.getColor().equals(NONE)) {
            e.setAttribute("color", this.getColor());
        }
        if (!this.getWeight().equals("0")) {
            e.setAttribute("weight", this.getWeight());
        }
        if (!this.getWeightTons().equals(NONE)) {
            e.setAttribute("weightTons", this.getWeightTons());
        }
        if (!this.getBuilt().equals(NONE)) {
            e.setAttribute("built", this.getBuilt());
        }
        if (!this.getLocationId().equals(NONE)) {
            e.setAttribute("locationId", this.getLocationId());
        }
        if (!this.getRouteLocationId().equals(NONE)) {
            e.setAttribute("routeLocationId", this.getRouteLocationId());
        }
        if (!this.getTrackId().equals(NONE)) {
            e.setAttribute("secLocationId", this.getTrackId());
        }
        if (!this.getDestinationId().equals(NONE)) {
            e.setAttribute("destinationId", this.getDestinationId());
        }
        if (!this.getRouteDestinationId().equals(NONE)) {
            e.setAttribute("routeDestinationId", this.getRouteDestinationId());
        }
        if (!this.getDestinationTrackId().equals(NONE)) {
            e.setAttribute("secDestinationId", this.getDestinationTrackId());
        }
        if (!this.getDivisionId().equals(NONE)) {
            e.setAttribute("divisionId", this.getDivisionId());
        }
        if (!this.getLastRouteId().equals(NONE)) {
            e.setAttribute("lastRouteId", this.getLastRouteId());
        }
        e.setAttribute("moves", Integer.toString(this.getMoves()));
        e.setAttribute("date", this.getLastDate());
        e.setAttribute("selected", this.isSelected() ? "true" : "false");
        if (!this.getLastLocationId().equals("0")) {
            e.setAttribute("lastLocationId", this.getLastLocationId());
        }
        if (!this.getLastTrackId().equals("0")) {
            e.setAttribute("lastTrackId", this.getLastTrackId());
        }
        if (!this.getTrainName().equals(NONE)) {
            e.setAttribute("train", this.getTrainName());
            e.setAttribute("trainId", this.getTrain().getId());
        }
        if (!this.getLastTrainName().equals(NONE)) {
            e.setAttribute("lastTrain", this.getLastTrainName());
            e.setAttribute("lastTrainId", this.getLastTrain().getId());
        }
        if (!this.getOwnerName().equals(NONE)) {
            e.setAttribute("owner", this.getOwnerName());
        }
        if (!this.getValue().equals(NONE)) {
            e.setAttribute("value", this.getValue());
        }
        if (!this.getRfid().equals(NONE)) {
            e.setAttribute("rfid", this.getRfid());
        }
        if (this.isLocationUnknown()) {
            e.setAttribute("locUnknown", this.isLocationUnknown() ? "true" : "false");
        }
        if (this.isOutOfService()) {
            e.setAttribute("outOfService", this.isOutOfService() ? "true" : "false");
        }
        if (!this.getPickupTime().equals(NONE)) {
            e.setAttribute("pickupTime", this.getPickupTime());
        }
        if (!this.getSetoutTime().equals(NONE)) {
            e.setAttribute("setoutTime", this.getSetoutTime());
        }
        if (this.getBlocking() != 0) {
            e.setAttribute("blocking", Integer.toString(this.getBlocking()));
        }
        if (!this.getComment().equals(NONE)) {
            e.setAttribute("comment", this.getComment());
        }
        return e;
    }

    private void addPropertyChangeListeners() {
        InstanceManager.getDefault(CarRoads.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(CarOwners.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(CarColors.class).addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("locationName")) {
            log.debug("Property change for rolling stock: ({}) property name: ({}) old: ({}) new: ({})", new Object[]{this, e.getPropertyName(), e.getOldValue(), e.getNewValue()});
            this.setDirtyAndFirePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
        }
        if (e.getPropertyName().equals("locationDispose")) {
            if (e.getSource() == this.getLocation()) {
                log.debug("delete location for rolling stock: ({})", (Object)this);
                this.setLocation(null, null);
            }
            if (e.getSource() == this.getDestination()) {
                log.debug("delete destination for rolling stock: ({})", (Object)this);
                this.setDestination(null, null);
            }
        }
        if (e.getPropertyName().equals("trackDispose")) {
            if (e.getSource() == this.getTrack()) {
                log.debug("delete location for rolling stock: ({})", (Object)this);
                this.setLocation(this.getLocation(), null);
            }
            if (e.getSource() == this.getDestinationTrack()) {
                log.debug("delete destination for rolling stock: ({})", (Object)this);
                this.setDestination(this.getDestination(), null);
            }
        }
        if (e.getPropertyName().equals("TrainDispose") && e.getSource() == this.getTrain()) {
            log.debug("delete train for rolling stock: ({})", (Object)this);
            this.setTrain(null);
        }
        if (e.getPropertyName().equals("TrainLocation") && e.getSource() == this.getTrain()) {
            log.debug("Rolling stock ({}) is serviced by train ({})", (Object)this, (Object)this.getTrainName());
            this.moveRollingStock((RouteLocation)e.getOldValue(), (RouteLocation)e.getNewValue());
        }
        if (e.getPropertyName().equals("TrainStatus") && e.getNewValue().equals(Train.TRAIN_RESET) && e.getSource() == this.getTrain()) {
            log.debug("Rolling stock ({}) is removed from train ({}) by reset", (Object)this, (Object)this.getTrainName());
            this.reset();
        }
        if (e.getPropertyName().equals("TrainName")) {
            this.setDirtyAndFirePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
        }
        if (e.getPropertyName().equals("CarRoads Name") && e.getOldValue().equals(this.getRoadName())) {
            log.debug("Rolling stock ({}) sees road name change from ({}) to ({})", new Object[]{this, e.getOldValue(), e.getNewValue()});
            if (e.getNewValue() != null) {
                this.setRoadName((String)e.getNewValue());
            }
        }
        if (e.getPropertyName().equals("CarOwners Name") && e.getOldValue().equals(this.getOwnerName())) {
            log.debug("Rolling stock ({}) sees owner name change from ({}) to ({})", new Object[]{this, e.getOldValue(), e.getNewValue()});
            this.setOwnerName((String)e.getNewValue());
        }
        if (e.getPropertyName().equals("CarColorsName") && e.getOldValue().equals(this.getColor())) {
            log.debug("Rolling stock ({}) sees color name change from ({}) to ({})", new Object[]{this, e.getOldValue(), e.getNewValue()});
            this.setColor((String)e.getNewValue());
        }
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        this.firePropertyChange(p, old, n);
    }
}

