/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.OperationsPanel;
import jmri.util.StringUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RollingStockAttribute
extends PropertyChangeSupport {
    protected static final int MIN_NAME_LENGTH = 1;
    protected List<String> list = new ArrayList<String>();
    protected String maxName = "";
    protected int maxNameLength = 0;
    protected int maxNameSubStringLength = 0;
    private static final Logger log = LoggerFactory.getLogger(RollingStockAttribute.class);

    public void dispose() {
        this.list.clear();
    }

    public String[] getNames() {
        if (this.list.isEmpty()) {
            this.list.addAll(Arrays.asList(this.getDefaultNames().split(",")));
        }
        return this.list.toArray(new String[0]);
    }

    protected String getDefaultNames() {
        return "Error";
    }

    public void setNames(String[] names) {
        if (names.length > 0) {
            Arrays.sort(names);
            for (String name : names) {
                if (this.list.contains(name)) continue;
                this.list.add(name);
            }
        }
    }

    public void setValues(String[] lengths) {
        if (lengths.length == 0) {
            return;
        }
        try {
            StringUtil.numberSort(lengths);
        }
        catch (NumberFormatException e) {
            log.error("lengths are not all numeric, list:");
            for (int i = 0; i < lengths.length; ++i) {
                try {
                    Integer.parseInt(lengths[i]);
                    log.error("length {} = {}", (Object)i, (Object)lengths[i]);
                    continue;
                }
                catch (NumberFormatException ee) {
                    log.error("length {} = {} is not a valid number!", (Object)i, (Object)lengths[i]);
                }
            }
        }
        for (String length : lengths) {
            if (this.list.contains(length)) continue;
            this.list.add(length);
        }
    }

    public void sort() {
        Collections.sort(this.list);
    }

    public void addName(String name) {
        if (name == null) {
            return;
        }
        if (this.list.contains(name)) {
            return;
        }
        this.list.add(name);
        this.sort();
        this.maxNameLength = 0;
        this.maxNameSubStringLength = 0;
    }

    public void deleteName(String name) {
        this.list.remove(name);
        this.maxNameLength = 0;
        this.maxNameSubStringLength = 0;
    }

    public boolean containsName(String name) {
        return this.list.contains(name);
    }

    public JComboBox<String> getComboBox() {
        JComboBox<String> box = new JComboBox<String>();
        this.updateComboBox(box);
        OperationsPanel.padComboBox(box);
        return box;
    }

    public void updateComboBox(JComboBox<String> box) {
        box.removeAllItems();
        for (String name : this.getNames()) {
            box.addItem(name);
        }
    }

    public int getMaxNameLength() {
        if (this.maxNameLength == 0) {
            this.maxName = "";
            this.maxNameLength = this.getMinNameLength();
            for (String name : this.getNames()) {
                if (name.length() <= this.maxNameLength) continue;
                this.maxName = name;
                this.maxNameLength = name.length();
            }
        }
        return this.maxNameLength;
    }

    public int getMaxNameSubStringLength() {
        if (this.maxNameSubStringLength == 0) {
            this.maxName = "";
            this.maxNameSubStringLength = this.getMinNameLength();
            for (String name : this.getNames()) {
                String[] subString = name.split("-");
                if (subString.length <= 0 || subString[0].length() <= this.maxNameSubStringLength) continue;
                this.maxName = name;
                this.maxNameSubStringLength = subString[0].length();
            }
        }
        return this.maxNameSubStringLength;
    }

    protected int getMinNameLength() {
        return 1;
    }

    public void store(Element root, String eNames, String eName) {
        Element names = new Element(eNames);
        for (String name : this.getNames()) {
            Element e = new Element(eName);
            if (eName.equals("length")) {
                e.setAttribute(new Attribute("value", name));
            } else {
                e.setAttribute(new Attribute("name", name));
            }
            names.addContent((Content)e);
        }
        root.addContent((Content)names);
    }

    public void load(Element root, String eNames, String eName, String oldName) {
        if (root.getChild(eNames) != null) {
            List l = root.getChild(eNames).getChildren(eName);
            String[] names = new String[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                Element name = (Element)l.get(i);
                Attribute a = name.getAttribute("name");
                if (a != null) {
                    names[i] = a.getValue();
                }
                if ((a = name.getAttribute("value")) == null) continue;
                names[i] = a.getValue();
            }
            this.setNames(names);
        } else if (root.getChild(oldName) != null) {
            String[] names = root.getChildText(oldName).split("%%");
            this.setNames(names);
        }
    }
}

