/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.rollingstock.Bundle;
import jmri.jmrit.operations.rollingstock.cars.CarOwners;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RollingStockAttributeEditFrame
extends OperationsFrame
implements PropertyChangeListener {
    public JLabel textAttribute = new JLabel();
    JLabel textSep = new JLabel();
    public JLabel quanity = new JLabel("0");
    public JButton addButton = new JButton(Bundle.getMessage("Add"));
    public JButton deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
    public JButton replaceButton = new JButton(Bundle.getMessage("Replace"));
    public JComboBox<String> comboBox;
    public JTextField addTextBox = new JTextField(Control.max_len_string_attibute);
    public static final String ROAD = "Road";
    public static final String OWNER = "Owner";
    public static final String TYPE = "Type";
    public static final String LENGTH = "Length";
    @SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL"})
    protected static boolean showDialogBox = true;
    @SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL"})
    protected static boolean showQuanity = false;
    public static final String DISPOSE = "dispose";
    public String _attribute;
    public static final String FAILED = "failed";
    protected boolean deleteUnused = false;
    protected boolean cancel = false;
    private static final Logger log = LoggerFactory.getLogger(RollingStockAttributeEditFrame.class);

    public void initComponents(String attribute, String name) {
        this.getContentPane().removeAll();
        this._attribute = attribute;
        this.loadCombobox();
        this.comboBox.setSelectedItem(name);
        this.getContentPane().setLayout(new GridBagLayout());
        this.textAttribute.setText(attribute);
        this.quanity.setVisible(showQuanity);
        this.addItem(this.textAttribute, 2, 1);
        this.addItem(this.addTextBox, 2, 2);
        this.addItem(this.addButton, 3, 2);
        this.addItem(this.quanity, 1, 3);
        this.addItem(this.comboBox, 2, 3);
        this.addItem(this.deleteButton, 3, 3);
        this.addItem(this.replaceButton, 3, 4);
        this.addButtonAction(this.addButton);
        this.addButtonAction(this.deleteButton);
        this.addButtonAction(this.replaceButton);
        this.addComboBoxAction(this.comboBox);
        this.updateAttributeQuanity();
        this.deleteButton.setToolTipText(Bundle.getMessage("TipDeleteAttributeName", attribute));
        this.addButton.setToolTipText(Bundle.getMessage("TipAddAttributeName", attribute));
        this.replaceButton.setToolTipText(Bundle.getMessage("TipReplaceAttributeName", attribute));
        this.initMinimumSize(new Dimension(400, 250));
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GUI ease of use")
    public void buttonActionPerformed(ActionEvent ae) {
        log.debug("edit frame button activated");
        if (ae.getSource() == this.addButton) {
            if (!this.checkItemName(Bundle.getMessage("canNotAdd"))) {
                return;
            }
            this.addAttributeName(this.addTextBox.getText().trim());
        }
        if (ae.getSource() == this.deleteButton) {
            this.deleteAttributeName((String)this.comboBox.getSelectedItem());
        }
        if (ae.getSource() == this.replaceButton) {
            if (!this.checkItemName(Bundle.getMessage("canNotReplace"))) {
                return;
            }
            String newItem = this.addTextBox.getText().trim();
            String oldItem = (String)this.comboBox.getSelectedItem();
            if (JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("replaceMsg", oldItem, newItem), Bundle.getMessage("replaceAll"), 0) != 0) {
                return;
            }
            if (newItem.equals(oldItem)) {
                return;
            }
            boolean oldShow = showDialogBox;
            showDialogBox = false;
            this.addAttributeName(newItem);
            showDialogBox = oldShow;
            this.replaceItem(oldItem, newItem);
            this.deleteAttributeName(oldItem);
        }
    }

    protected boolean checkItemName(String errorMessage) {
        String[] s;
        String itemName = this.addTextBox.getText().trim();
        if (itemName.isEmpty()) {
            return false;
        }
        if (itemName.contains("-") && (s = itemName.split("-")).length == 0) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("HyphenFeature"), MessageFormat.format(errorMessage, this._attribute), 0);
            return false;
        }
        if (this._attribute.equals(LENGTH) && this.convertLength(itemName).equals(FAILED)) {
            return false;
        }
        if (this._attribute.equals(ROAD) && !OperationsXml.checkFileName(itemName)) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("NameResChar") + "\n" + Bundle.getMessage("ReservedChar"), MessageFormat.format(errorMessage, this._attribute), 0);
            return false;
        }
        String[] item = new String[]{itemName};
        if (this._attribute.equals(TYPE)) {
            if (itemName.contains(" & ")) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("carNameNoAndChar", " & "), MessageFormat.format(errorMessage, this._attribute), 0);
                return false;
            }
            item = itemName.split("-");
        }
        if (item[0].length() > Control.max_len_string_attibute) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("rsAttributeName", Control.max_len_string_attibute), MessageFormat.format(errorMessage, this._attribute), 0);
            return false;
        }
        return true;
    }

    protected void deleteAttributeName(String deleteItem) {
        log.debug("delete attribute {}", (Object)deleteItem);
        if (this._attribute.equals(ROAD)) {
            InstanceManager.getDefault(CarRoads.class).replaceName(deleteItem, null);
        }
        if (this._attribute.equals(OWNER)) {
            InstanceManager.getDefault(CarOwners.class).deleteName(deleteItem);
        }
    }

    protected void addAttributeName(String addItem) {
        if (this._attribute.equals(ROAD)) {
            InstanceManager.getDefault(CarRoads.class).addName(addItem);
        }
        if (this._attribute.equals(OWNER)) {
            InstanceManager.getDefault(CarOwners.class).addName(addItem);
        }
    }

    protected void replaceItem(String oldItem, String newItem) {
        if (this._attribute.equals(ROAD)) {
            InstanceManager.getDefault(CarRoads.class).replaceName(oldItem, newItem);
        }
        if (this._attribute.equals(OWNER)) {
            InstanceManager.getDefault(CarOwners.class).replaceName(oldItem, newItem);
        }
    }

    protected void loadCombobox() {
        if (this._attribute.equals(ROAD)) {
            this.comboBox = InstanceManager.getDefault(CarRoads.class).getComboBox();
            InstanceManager.getDefault(CarRoads.class).addPropertyChangeListener(this);
        }
        if (this._attribute.equals(OWNER)) {
            this.comboBox = InstanceManager.getDefault(CarOwners.class).getComboBox();
            InstanceManager.getDefault(CarOwners.class).addPropertyChangeListener(this);
        }
    }

    public String convertLength(String addItem) {
        if (addItem.endsWith("\"")) {
            addItem = addItem.substring(0, addItem.length() - 1);
            try {
                double inches = Double.parseDouble(addItem);
                int feet = (int)(inches * (double)Setup.getScaleRatio() / 12.0);
                addItem = Integer.toString(feet);
            }
            catch (NumberFormatException e) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("CanNotConvertFeet"), Bundle.getMessage("ErrorRsLength"), 0);
                return FAILED;
            }
            this.addTextBox.setText(addItem);
        }
        if (addItem.endsWith("cm")) {
            addItem = addItem.substring(0, addItem.length() - 2);
            try {
                double cm = Double.parseDouble(addItem);
                int meter = (int)(cm * (double)Setup.getScaleRatio() / 100.0);
                addItem = Integer.toString(meter);
            }
            catch (NumberFormatException e) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("CanNotConvertMeter"), Bundle.getMessage("ErrorRsLength"), 0);
                return FAILED;
            }
            this.addTextBox.setText(addItem);
        }
        try {
            int length = Integer.parseInt(addItem);
            if (length < 0) {
                log.error("length ({}) has to be a positive number", (Object)addItem);
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorRsLength"), Bundle.getMessage("canNotAdd", this._attribute), 0);
                return FAILED;
            }
            if (addItem.length() > Control.max_len_string_length_name) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("RsAttribute", Control.max_len_string_length_name), Bundle.getMessage("canNotAdd", this._attribute), 0);
                return FAILED;
            }
        }
        catch (NumberFormatException e) {
            log.error("length ({}) is not an integer", (Object)addItem);
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorRsLength"), Bundle.getMessage("canNotAdd", this._attribute), 0);
            return FAILED;
        }
        return addItem;
    }

    @Override
    protected void comboBoxActionPerformed(ActionEvent ae) {
        log.debug("Combo box action");
        this.updateAttributeQuanity();
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GUI ease of use")
    public void toggleShowQuanity() {
        showQuanity = !showQuanity;
        this.quanity.setVisible(showQuanity);
        this.updateAttributeQuanity();
    }

    public void deleteUnusedAttributes() {
        int items;
        if (!showQuanity) {
            this.toggleShowQuanity();
        }
        this.deleteUnused = true;
        this.cancel = false;
        for (int i = items = this.comboBox.getItemCount() - 1; i >= 0; --i) {
            this.comboBox.setSelectedIndex(i);
        }
        this.deleteUnused = false;
        this.comboBox.setSelectedIndex(0);
    }

    protected void confirmDelete(String item) {
        if (!this.cancel) {
            int results = JmriJOptionPane.showOptionDialog(this, MessageFormat.format(Bundle.getMessage("ConfirmDeleteAttribute"), this._attribute, item), Bundle.getMessage("DeleteAttribute?"), -1, 3, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonCancel")}, Bundle.getMessage("ButtonYes"));
            if (results == 0) {
                this.deleteAttributeName((String)this.comboBox.getSelectedItem());
            }
            if (results == 2 || results == -1) {
                this.cancel = true;
            }
        }
    }

    protected abstract void updateAttributeQuanity();

    @Override
    public void dispose() {
        InstanceManager.getDefault(CarRoads.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarOwners.class).removePropertyChangeListener(this);
        this.firePropertyChange(DISPOSE, this._attribute, null);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("CarRoads Length")) {
            InstanceManager.getDefault(CarRoads.class).updateComboBox(this.comboBox);
        }
        if (e.getPropertyName().equals("CarOwners Length")) {
            InstanceManager.getDefault(CarOwners.class).updateComboBox(this.comboBox);
        }
        this.comboBox.setSelectedItem(this.addTextBox.getText().trim());
    }
}

