/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.trains.Train;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RollingStockManager<T extends RollingStock>
extends PropertyChangeSupport
implements PropertyChangeListener {
    public static final String NONE = "";
    protected Hashtable<String, T> _hashTable = new Hashtable();
    public static final String LISTLENGTH_CHANGED_PROPERTY = "RollingStockListLength";
    private static final int PAGE_SIZE = 64;
    private static final int NOT_INTEGER = -999999999;
    protected static final int BY_NUMBER = 0;
    protected static final int BY_ROAD = 1;
    protected static final int BY_TYPE = 2;
    protected static final int BY_COLOR = 3;
    protected static final int BY_LOCATION = 4;
    protected static final int BY_DESTINATION = 5;
    protected static final int BY_TRAIN = 6;
    protected static final int BY_MOVES = 7;
    protected static final int BY_BUILT = 8;
    protected static final int BY_OWNER = 9;
    protected static final int BY_RFID = 10;
    protected static final int BY_VALUE = 11;
    protected static final int BY_LAST = 12;
    protected static final int BY_BLOCKING = 13;
    protected static final int BY_COMMENT = 14;
    private static final Logger log = LoggerFactory.getLogger(RollingStockManager.class);

    public abstract RollingStock newRS(String var1, String var2);

    public int getNumEntries() {
        return this._hashTable.size();
    }

    public void dispose() {
        this.deleteAll();
    }

    public T getById(String id) {
        return (T)((RollingStock)this._hashTable.get(id));
    }

    public T getByRoadAndNumber(String road, String number) {
        String id = RollingStock.createId(road, number);
        return this.getById(id);
    }

    public T getByTypeAndRoad(String type, String road) {
        Enumeration<String> en = this._hashTable.keys();
        while (en.hasMoreElements()) {
            T rs = this.getById(en.nextElement());
            if (!((RollingStock)rs).getTypeName().equals(type) || !((RollingStock)rs).getRoadName().equals(road)) continue;
            return rs;
        }
        return null;
    }

    public T getByRfid(String rfid) {
        Enumeration<String> en = this._hashTable.keys();
        while (en.hasMoreElements()) {
            T rs = this.getById(en.nextElement());
            if (!((RollingStock)rs).getRfid().equals(rfid)) continue;
            return rs;
        }
        return null;
    }

    public void register(T rs) {
        if (!this._hashTable.containsKey(((RollingStock)rs).getId())) {
            int oldSize = this._hashTable.size();
            ((PropertyChangeSupport)rs).addPropertyChangeListener(this);
            this._hashTable.put(((RollingStock)rs).getId(), rs);
            this.firePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._hashTable.size());
        } else {
            log.error("Duplicate rolling stock id: ({})", (Object)((RollingStock)rs).getId());
            ((RollingStock)rs).dispose();
        }
    }

    public void deregister(T rs) {
        ((PropertyChangeSupport)rs).removePropertyChangeListener(this);
        ((RollingStock)rs).dispose();
        int oldSize = this._hashTable.size();
        this._hashTable.remove(((RollingStock)rs).getId());
        this.firePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._hashTable.size());
    }

    public void deleteAll() {
        int oldSize = this._hashTable.size();
        Enumeration<String> en = this._hashTable.keys();
        while (en.hasMoreElements()) {
            T rs = this.getById(en.nextElement());
            ((RollingStock)rs).dispose();
            this._hashTable.remove(((RollingStock)rs).getId());
        }
        this.firePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._hashTable.size());
    }

    public void resetMoves() {
        this.resetMoves(this.getList());
    }

    public void resetMoves(List<T> list) {
        for (RollingStock rs : list) {
            rs.setMoves(0);
        }
    }

    public List<T> getList() {
        return new ArrayList<T>(this._hashTable.values());
    }

    public List<T> getByIdList() {
        Enumeration<String> en = this._hashTable.keys();
        Object[] arr = new String[this._hashTable.size()];
        ArrayList<T> out = new ArrayList<T>();
        int i = 0;
        while (en.hasMoreElements()) {
            arr[i++] = en.nextElement();
        }
        Arrays.sort(arr);
        for (i = 0; i < arr.length; ++i) {
            out.add(this.getById((String)arr[i]));
        }
        return out;
    }

    public List<T> getByRoadNameList() {
        return this.getByList(this.getByIdList(), 1);
    }

    public List<T> getByNumberList() {
        List<T> sortIn = this.getByRoadNameList();
        ArrayList<RollingStock> out = new ArrayList<RollingStock>();
        int rsNumber = 0;
        int outRsNumber = 0;
        for (RollingStock rs : sortIn) {
            int divisor;
            boolean rsAdded = false;
            try {
                rs.number = rsNumber = Integer.parseInt(rs.getNumber());
            }
            catch (NumberFormatException e) {
                try {
                    String[] number = rs.getNumber().split("-");
                    rs.number = rsNumber = Integer.parseInt(number[0]);
                }
                catch (NumberFormatException e2) {
                    rs.number = -999999999;
                    String numberIn = rs.getNumber();
                    for (int k = out.size() - 1; k >= 0; --k) {
                        String numberOut = ((RollingStock)out.get(k)).getNumber();
                        try {
                            Integer.parseInt(numberOut);
                            out.add(k + 1, rs);
                            rsAdded = true;
                            break;
                        }
                        catch (NumberFormatException e3) {
                            if (numberIn.compareToIgnoreCase(numberOut) < 0) continue;
                            out.add(k + 1, rs);
                            rsAdded = true;
                            break;
                        }
                    }
                    if (rsAdded) continue;
                    out.add(0, rs);
                    continue;
                }
            }
            int start = 0;
            for (int k = divisor = out.size() / 64; k > 0; --k) {
                outRsNumber = ((RollingStock)out.get((int)((out.size() - 1) * k / divisor))).number;
                if (outRsNumber == -999999999 || rsNumber < outRsNumber) continue;
                start = (out.size() - 1) * k / divisor;
                break;
            }
            for (int j = start; j < out.size(); ++j) {
                outRsNumber = ((RollingStock)out.get((int)j)).number;
                if (outRsNumber == -999999999) {
                    try {
                        outRsNumber = Integer.parseInt(((RollingStock)out.get(j)).getNumber());
                    }
                    catch (NumberFormatException e) {
                        try {
                            String[] number = ((RollingStock)out.get(j)).getNumber().split("-");
                            outRsNumber = Integer.parseInt(number[0]);
                        }
                        catch (NumberFormatException e2) {
                            outRsNumber = rsNumber + 1;
                        }
                    }
                }
                if (rsNumber >= outRsNumber) continue;
                out.add(j, rs);
                rsAdded = true;
                break;
            }
            if (rsAdded) continue;
            out.add(rs);
        }
        return out;
    }

    public List<T> getByTypeList() {
        return this.getByList(this.getByRoadNameList(), 2);
    }

    public List<T> getByTypeList(String type) {
        List<T> typeList = this.getByTypeList();
        ArrayList<RollingStock> out = new ArrayList<RollingStock>();
        for (RollingStock rs : typeList) {
            if (!rs.getTypeName().equals(type)) continue;
            out.add(rs);
        }
        return out;
    }

    public List<T> getByColorList() {
        return this.getByList(this.getByTypeList(), 3);
    }

    public List<T> getByLocationList() {
        return this.getByList(this.getByNumberList(), 4);
    }

    public List<T> getByDestinationList() {
        return this.getByList(this.getByLocationList(), 5);
    }

    public List<T> getByTrainList() {
        List<T> byDest = this.getByList(this.getByIdList(), 5);
        List<T> byLoc = this.getByList(byDest, 4);
        return this.getByList(byLoc, 6);
    }

    public List<T> getByMovesList() {
        return this.getByList(this.getList(), 7);
    }

    public List<T> getByBuiltList() {
        return this.getByList(this.getByIdList(), 8);
    }

    public List<T> getByOwnerList() {
        return this.getByList(this.getByIdList(), 9);
    }

    public List<T> getByValueList() {
        return this.getByList(this.getByIdList(), 11);
    }

    public List<T> getByRfidList() {
        return this.getByList(this.getByIdList(), 10);
    }

    public List<T> getByLastDateList() {
        return this.getByList(this.getByIdList(), 12);
    }

    public List<T> getByCommentList() {
        return this.getByList(this.getByIdList(), 14);
    }

    public List<T> getByLastDateList(List<T> inList) {
        return this.getByList(inList, 12);
    }

    protected List<T> getByList(List<T> sortIn, int attribute) {
        ArrayList<T> out = new ArrayList<T>(sortIn);
        out.sort(this.getComparator(attribute));
        return out;
    }

    protected Comparator<T> getComparator(int attribute) {
        switch (attribute) {
            case 0: {
                return (r1, r2) -> r1.getNumber().compareToIgnoreCase(r2.getNumber());
            }
            case 1: {
                return (r1, r2) -> r1.getRoadName().compareToIgnoreCase(r2.getRoadName());
            }
            case 2: {
                return (r1, r2) -> r1.getTypeName().compareToIgnoreCase(r2.getTypeName());
            }
            case 3: {
                return (r1, r2) -> r1.getColor().compareToIgnoreCase(r2.getColor());
            }
            case 4: {
                return (r1, r2) -> (r1.getStatus() + r1.getLocationName() + r1.getTrackName()).compareToIgnoreCase(r2.getStatus() + r2.getLocationName() + r2.getTrackName());
            }
            case 5: {
                return (r1, r2) -> (r1.getDestinationName() + r1.getDestinationTrackName()).compareToIgnoreCase(r2.getDestinationName() + r2.getDestinationTrackName());
            }
            case 6: {
                return (r1, r2) -> r1.getTrainName().compareToIgnoreCase(r2.getTrainName());
            }
            case 7: {
                return (r1, r2) -> r1.getMoves() - r2.getMoves();
            }
            case 8: {
                return (r1, r2) -> RollingStockManager.convertBuildDate(r1.getBuilt()).compareToIgnoreCase(RollingStockManager.convertBuildDate(r2.getBuilt()));
            }
            case 9: {
                return (r1, r2) -> r1.getOwnerName().compareToIgnoreCase(r2.getOwnerName());
            }
            case 10: {
                return (r1, r2) -> r1.getRfid().compareToIgnoreCase(r2.getRfid());
            }
            case 11: {
                return (r1, r2) -> r1.getValue().compareToIgnoreCase(r2.getValue());
            }
            case 12: {
                return (r1, r2) -> r1.getLastMoveDate().compareTo(r2.getLastMoveDate());
            }
            case 13: {
                return (r1, r2) -> r1.getBlocking() - r2.getBlocking();
            }
            case 14: {
                return (r1, r2) -> r1.getComment().compareToIgnoreCase(r2.getComment());
            }
        }
        return (r1, r2) -> (r1.getRoadName() + r1.getNumber()).compareToIgnoreCase(r2.getRoadName() + r2.getNumber());
    }

    public static String convertBuildDate(String date) {
        String[] built = date.split("-");
        if (built.length == 2) {
            try {
                int d = Integer.parseInt(built[1]);
                if (d < 100) {
                    d += 1900;
                }
                return Integer.toString(d);
            }
            catch (NumberFormatException e) {
                log.debug("Unable to parse built date ({})", (Object)date);
            }
        } else {
            try {
                int d = Integer.parseInt(date);
                if (d < 100) {
                    d += 1900;
                }
                return Integer.toString(d);
            }
            catch (NumberFormatException e) {
                log.debug("Unable to parse built date ({})", (Object)date);
            }
        }
        return date;
    }

    public List<T> getByTrainList(Train train) {
        return this.getByList(this.getList(train), 4);
    }

    public List<T> getList(Train train) {
        ArrayList out = new ArrayList();
        this.getList().stream().filter(rs -> rs.getTrain() == train).forEachOrdered(rs -> out.add(rs));
        return out;
    }

    public List<T> getList(Location location) {
        ArrayList out = new ArrayList();
        this.getList().stream().filter(rs -> rs.getLocation() == location).forEachOrdered(rs -> out.add(rs));
        return out;
    }

    public List<T> getList(Track track) {
        ArrayList out = new ArrayList();
        this.getList().stream().filter(rs -> rs.getTrack() == track).forEachOrdered(rs -> out.add(rs));
        return out;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("id")) {
            RollingStock rs = (RollingStock)evt.getSource();
            this._hashTable.remove(evt.getOldValue());
            if (this._hashTable.containsKey(rs.getId())) {
                log.error("Duplicate rolling stock id: ({})", (Object)rs.getId());
                rs.dispose();
            } else {
                this._hashTable.put(rs.getId(), rs);
            }
            this.firePropertyChange(LISTLENGTH_CHANGED_PROPERTY, this._hashTable.size(), this._hashTable.size());
        }
    }
}

