/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComboBox;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.operations.OperationsPanel;
import jmri.jmrit.operations.rollingstock.RollingStockAttribute;
import jmri.jmrit.operations.rollingstock.cars.Bundle;
import jmri.jmrit.operations.rollingstock.cars.CarLoad;
import jmri.jmrit.operations.rollingstock.cars.CarManagerXml;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.trains.TrainManifestHeaderText;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarLoads
extends RollingStockAttribute
implements InstanceManagerAutoDefault {
    protected Hashtable<String, List<CarLoad>> listCarLoads = new Hashtable();
    protected String _emptyName = Bundle.getMessage("EmptyCar");
    protected String _loadName = Bundle.getMessage("LoadedCar");
    public static final String NONE = "";
    public static final String LOAD_CHANGED_PROPERTY = "CarLoads_Load";
    public static final String LOAD_TYPE_CHANGED_PROPERTY = "CarLoads_Load_Type";
    public static final String LOAD_PRIORITY_CHANGED_PROPERTY = "CarLoads_Load_Priority";
    public static final String LOAD_NAME_CHANGED_PROPERTY = "CarLoads_Name";
    public static final String LOAD_COMMENT_CHANGED_PROPERTY = "CarLoads_Load_Comment";
    public static final String LOAD_HAZARDOUS_CHANGED_PROPERTY = "CarLoads_Load_Hazardous";
    int maxCommentLength = 0;
    private static final Logger log = LoggerFactory.getLogger(CarLoads.class);

    public void addType(String type) {
        this.listCarLoads.put(type, new ArrayList());
    }

    public void replaceType(String oldType, String newType) {
        List<String> names = this.getNames(oldType);
        this.addType(newType);
        for (String name : names) {
            this.addName(newType, name);
            this.setLoadType(newType, name, this.getLoadType(oldType, name));
            this.setPriority(newType, name, this.getPriority(oldType, name));
            this.setHazardous(newType, name, this.isHazardous(oldType, name));
            this.setDropComment(newType, name, this.getDropComment(oldType, name));
            this.setPickupComment(newType, name, this.getPickupComment(oldType, name));
        }
        this.listCarLoads.remove(oldType);
    }

    public JComboBox<String> getSelectComboBox(String type) {
        JComboBox<String> box = new JComboBox<String>();
        box.addItem(NONE);
        for (String load : this.getNames(type)) {
            box.addItem(load);
        }
        return box;
    }

    public JComboBox<String> getComboBox(String type) {
        JComboBox<String> box = new JComboBox<String>();
        this.updateComboBox(type, box);
        return box;
    }

    public JComboBox<String> getPriorityComboBox() {
        JComboBox<String> box = new JComboBox<String>();
        box.addItem(CarLoad.PRIORITY_LOW);
        box.addItem(CarLoad.PRIORITY_MEDIUM);
        box.addItem(CarLoad.PRIORITY_HIGH);
        return box;
    }

    public JComboBox<String> getHazardousComboBox() {
        JComboBox<String> box = new JComboBox<String>();
        box.addItem(Bundle.getMessage("ButtonNo"));
        box.addItem(Bundle.getMessage("ButtonYes"));
        return box;
    }

    public JComboBox<String> getLoadTypesComboBox() {
        JComboBox<String> box = new JComboBox<String>();
        box.addItem(CarLoad.LOAD_TYPE_EMPTY);
        box.addItem(CarLoad.LOAD_TYPE_LOAD);
        return box;
    }

    public List<String> getNames(String type) {
        ArrayList<String> names = new ArrayList<String>();
        if (type == null) {
            names.add(this.getDefaultEmptyName());
            names.add(this.getDefaultLoadName());
            return names;
        }
        List<CarLoad> loads = this.listCarLoads.get(type);
        if (loads == null) {
            this.addType(type);
            loads = this.listCarLoads.get(type);
        }
        if (loads.isEmpty()) {
            loads.add(new CarLoad(this.getDefaultEmptyName()));
            loads.add(new CarLoad(this.getDefaultLoadName()));
        }
        for (CarLoad carLoad : loads) {
            names.add(carLoad.getName());
        }
        Collections.sort(names);
        return names;
    }

    public void addName(String type, String name) {
        if (this.containsName(type, name)) {
            return;
        }
        List<CarLoad> loads = this.listCarLoads.get(type);
        if (loads == null) {
            log.debug("car type ({}) does not exist", (Object)type);
            return;
        }
        loads.add(new CarLoad(name));
        this.maxNameLength = 0;
        this.setDirtyAndFirePropertyChange(LOAD_CHANGED_PROPERTY, null, name);
    }

    public void deleteName(String type, String name) {
        List<CarLoad> loads = this.listCarLoads.get(type);
        if (loads == null) {
            log.debug("car type ({}) does not exist", (Object)type);
            return;
        }
        for (CarLoad cl : loads) {
            if (!cl.getName().equals(name)) continue;
            loads.remove(cl);
            break;
        }
        this.maxNameLength = 0;
        this.setDirtyAndFirePropertyChange(LOAD_CHANGED_PROPERTY, name, null);
    }

    public boolean containsName(String type, String name) {
        List<String> names = this.getNames(type);
        return names.contains(name);
    }

    public void updateComboBox(String type, JComboBox<String> box) {
        box.removeAllItems();
        List<String> names = this.getNames(type);
        for (String name : names) {
            box.addItem(name);
        }
        OperationsPanel.padComboBox(box, this.getMaxNameLength() + 1);
    }

    @Override
    public void updateComboBox(JComboBox<String> box) {
        box.removeAllItems();
        ArrayList<String> names = new ArrayList<String>();
        for (String type : InstanceManager.getDefault(CarTypes.class).getNames()) {
            for (String load : this.getNames(type)) {
                if (names.contains(load)) continue;
                names.add(load);
            }
        }
        Collections.sort(names);
        for (String load : names) {
            box.addItem(load);
        }
    }

    public void updateRweComboBox(String type, JComboBox<String> box) {
        box.removeAllItems();
        List<String> loads = this.getNames(type);
        for (String name : loads) {
            if (!this.getLoadType(type, name).equals(CarLoad.LOAD_TYPE_EMPTY)) continue;
            box.addItem(name);
        }
    }

    public void updateRwlComboBox(String type, JComboBox<String> box) {
        box.removeAllItems();
        List<String> loads = this.getNames(type);
        for (String name : loads) {
            if (!this.getLoadType(type, name).equals(CarLoad.LOAD_TYPE_LOAD)) continue;
            box.addItem(name);
        }
    }

    public void replaceName(String type, String oldName, String newName) {
        this.addName(type, newName);
        this.deleteName(type, oldName);
        this.setDirtyAndFirePropertyChange(LOAD_NAME_CHANGED_PROPERTY, oldName, newName);
    }

    public String getDefaultLoadName() {
        return this._loadName;
    }

    public void setDefaultLoadName(String name) {
        String old = this._loadName;
        this._loadName = name;
        this.setDirtyAndFirePropertyChange(LOAD_NAME_CHANGED_PROPERTY, old, name);
    }

    public String getDefaultEmptyName() {
        return this._emptyName;
    }

    public void setDefaultEmptyName(String name) {
        String old = this._emptyName;
        this._emptyName = name;
        this.setDirtyAndFirePropertyChange(LOAD_NAME_CHANGED_PROPERTY, old, name);
    }

    public void setLoadType(String type, String name, String loadType) {
        List<CarLoad> loads = this.listCarLoads.get(type);
        if (loads != null) {
            for (CarLoad cl : loads) {
                if (!cl.getName().equals(name)) continue;
                String oldType = cl.getLoadType();
                cl.setLoadType(loadType);
                if (oldType.equals(loadType)) continue;
                this.setDirtyAndFirePropertyChange(LOAD_TYPE_CHANGED_PROPERTY, oldType, loadType);
            }
        }
    }

    public String getLoadType(String type, String name) {
        if (!this.containsName(type, name)) {
            if (name != null && name.equals(this.getDefaultEmptyName())) {
                return CarLoad.LOAD_TYPE_EMPTY;
            }
            return CarLoad.LOAD_TYPE_LOAD;
        }
        List<CarLoad> loads = this.listCarLoads.get(type);
        for (CarLoad cl : loads) {
            if (!cl.getName().equals(name)) continue;
            return cl.getLoadType();
        }
        return "error";
    }

    public void setPriority(String type, String name, String priority) {
        List<CarLoad> loads = this.listCarLoads.get(type);
        if (loads != null) {
            for (CarLoad cl : loads) {
                if (!cl.getName().equals(name)) continue;
                String oldPriority = cl.getPriority();
                cl.setPriority(priority);
                if (oldPriority.equals(priority)) continue;
                this.setDirtyAndFirePropertyChange(LOAD_PRIORITY_CHANGED_PROPERTY, oldPriority, priority);
            }
        }
    }

    public String getPriority(String type, String name) {
        if (!this.containsName(type, name)) {
            return CarLoad.PRIORITY_LOW;
        }
        List<CarLoad> loads = this.listCarLoads.get(type);
        if (loads != null) {
            for (CarLoad cl : loads) {
                if (!cl.getName().equals(name)) continue;
                return cl.getPriority();
            }
        }
        return "error";
    }

    public void setHazardous(String type, String name, boolean isHazardous) {
        List<CarLoad> loads = this.listCarLoads.get(type);
        if (loads != null) {
            for (CarLoad cl : loads) {
                if (!cl.getName().equals(name)) continue;
                boolean oldIsHazardous = cl.isHazardous();
                cl.setHazardous(isHazardous);
                if (oldIsHazardous == isHazardous) continue;
                this.setDirtyAndFirePropertyChange(LOAD_HAZARDOUS_CHANGED_PROPERTY, oldIsHazardous, isHazardous);
            }
        }
    }

    public boolean isHazardous(String type, String name) {
        if (!this.containsName(type, name)) {
            return false;
        }
        List<CarLoad> loads = this.listCarLoads.get(type);
        for (CarLoad cl : loads) {
            if (!cl.getName().equals(name)) continue;
            return cl.isHazardous();
        }
        return false;
    }

    public void setPickupComment(String type, String name, String comment) {
        if (!this.containsName(type, name)) {
            return;
        }
        List<CarLoad> loads = this.listCarLoads.get(type);
        if (loads != null) {
            for (CarLoad cl : loads) {
                if (!cl.getName().equals(name)) continue;
                String oldComment = cl.getPickupComment();
                cl.setPickupComment(comment);
                if (oldComment.equals(comment)) continue;
                this.maxCommentLength = 0;
                this.setDirtyAndFirePropertyChange(LOAD_COMMENT_CHANGED_PROPERTY, oldComment, comment);
            }
        }
    }

    public String getPickupComment(String type, String name) {
        if (!this.containsName(type, name)) {
            return NONE;
        }
        List<CarLoad> loads = this.listCarLoads.get(type);
        for (CarLoad cl : loads) {
            if (!cl.getName().equals(name)) continue;
            return cl.getPickupComment();
        }
        return NONE;
    }

    public void setDropComment(String type, String name, String comment) {
        if (!this.containsName(type, name)) {
            return;
        }
        List<CarLoad> loads = this.listCarLoads.get(type);
        if (loads != null) {
            for (CarLoad cl : loads) {
                if (!cl.getName().equals(name)) continue;
                String oldComment = cl.getDropComment();
                cl.setDropComment(comment);
                if (oldComment.equals(comment)) continue;
                this.maxCommentLength = 0;
                this.setDirtyAndFirePropertyChange(LOAD_COMMENT_CHANGED_PROPERTY, oldComment, comment);
            }
        }
    }

    public String getDropComment(String type, String name) {
        if (!this.containsName(type, name)) {
            return NONE;
        }
        List<CarLoad> loads = this.listCarLoads.get(type);
        for (CarLoad cl : loads) {
            if (!cl.getName().equals(name)) continue;
            return cl.getDropComment();
        }
        return NONE;
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="I18N of Info Message")
    public int getMaxNameLength() {
        if (this.maxNameLength == 0) {
            this.maxName = NONE;
            this.maxNameLength = 1;
            String carTypeName = NONE;
            Enumeration<String> en = this.listCarLoads.keys();
            while (en.hasMoreElements()) {
                String cartype = en.nextElement();
                List<CarLoad> loads = this.listCarLoads.get(cartype);
                for (CarLoad load : loads) {
                    if (load.getName().split("-")[0].length() <= this.maxNameLength) continue;
                    this.maxName = load.getName().split("-")[0];
                    this.maxNameLength = load.getName().split("-")[0].length();
                    carTypeName = cartype;
                }
            }
            log.info(Bundle.getMessage("InfoMaxLoad", this.maxName, this.maxNameLength, carTypeName));
        }
        return this.maxNameLength;
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="I18N of Info Message")
    public int getMaxLoadCommentLength() {
        if (this.maxCommentLength == 0) {
            String maxComment = NONE;
            String carTypeName = NONE;
            String carLoadName = NONE;
            Enumeration<String> en = this.listCarLoads.keys();
            while (en.hasMoreElements()) {
                String carType = en.nextElement();
                List<CarLoad> loads = this.listCarLoads.get(carType);
                for (CarLoad load : loads) {
                    if (load.getDropComment().length() > this.maxCommentLength) {
                        maxComment = load.getDropComment();
                        this.maxCommentLength = load.getDropComment().length();
                        carTypeName = carType;
                        carLoadName = load.getName();
                    }
                    if (load.getPickupComment().length() <= this.maxCommentLength) continue;
                    maxComment = load.getPickupComment();
                    this.maxCommentLength = load.getPickupComment().length();
                    carTypeName = carType;
                    carLoadName = load.getName();
                }
            }
            if (this.maxCommentLength < TrainManifestHeaderText.getStringHeader_Drop_Comment().length()) {
                this.maxCommentLength = TrainManifestHeaderText.getStringHeader_Drop_Comment().length();
            }
            if (this.maxCommentLength < TrainManifestHeaderText.getStringHeader_Pickup_Comment().length()) {
                this.maxCommentLength = TrainManifestHeaderText.getStringHeader_Pickup_Comment().length();
            }
            log.info(Bundle.getMessage("InfoMaxLoadMessage", maxComment, this.maxCommentLength, carTypeName, carLoadName));
        }
        return this.maxCommentLength;
    }

    private List<CarLoad> getSortedList(String type) {
        List<CarLoad> loads = this.listCarLoads.get(type);
        List<String> names = this.getNames(type);
        ArrayList<CarLoad> out = new ArrayList<CarLoad>();
        block0: for (String name : names) {
            for (CarLoad carLoad : loads) {
                if (!name.equals(carLoad.getName())) continue;
                out.add(carLoad);
                continue block0;
            }
        }
        return out;
    }

    public Hashtable<String, List<CarLoad>> getList() {
        return (Hashtable)this.listCarLoads.clone();
    }

    @Override
    public void dispose() {
        this.listCarLoads.clear();
        this.setDefaultEmptyName(Bundle.getMessage("EmptyCar"));
        this.setDefaultLoadName(Bundle.getMessage("LoadedCar"));
        super.dispose();
    }

    public void store(Element root) {
        String[] carTypeNames;
        Element values = new Element("loads");
        Element defaults = new Element("defaults");
        defaults.setAttribute("empty", this.getDefaultEmptyName());
        defaults.setAttribute("load", this.getDefaultLoadName());
        values.addContent((Content)defaults);
        for (String carType : carTypeNames = InstanceManager.getDefault(CarTypes.class).getNames()) {
            if (!this.listCarLoads.containsKey(carType)) continue;
            List<CarLoad> loads = this.getSortedList(carType);
            Element xmlLoad = new Element("load");
            xmlLoad.setAttribute("type", carType);
            boolean mustStore = false;
            for (CarLoad load : loads) {
                if ((load.getName().equals(this.getDefaultEmptyName()) || load.getName().equals(this.getDefaultLoadName())) && load.getPriority().equals(CarLoad.PRIORITY_LOW) && !load.isHazardous() && load.getPickupComment().equals(NONE) && load.getDropComment().equals(NONE)) continue;
                Element xmlCarLoad = new Element("carLoad");
                xmlCarLoad.setAttribute("name", load.getName());
                if (!load.getPriority().equals(CarLoad.PRIORITY_LOW)) {
                    xmlCarLoad.setAttribute("priority", load.getPriority());
                    mustStore = true;
                }
                if (load.isHazardous()) {
                    xmlCarLoad.setAttribute("hazardous", load.isHazardous() ? "true" : "false");
                    mustStore = true;
                }
                if (!load.getPickupComment().equals(NONE)) {
                    xmlCarLoad.setAttribute("pickupComment", load.getPickupComment());
                    mustStore = true;
                }
                if (!load.getDropComment().equals(NONE)) {
                    xmlCarLoad.setAttribute("dropComment", load.getDropComment());
                    mustStore = true;
                }
                xmlCarLoad.setAttribute("loadType", load.getLoadType());
                xmlLoad.addContent((Content)xmlCarLoad);
            }
            if (loads.size() <= 2 && !mustStore) continue;
            values.addContent((Content)xmlLoad);
        }
        root.addContent((Content)values);
    }

    public void load(Element e) {
        Attribute a;
        if (e.getChild("loads") == null) {
            return;
        }
        Element defaults = e.getChild("loads").getChild("defaults");
        if (defaults != null) {
            a = defaults.getAttribute("load");
            if (a != null) {
                this._loadName = a.getValue();
            }
            if ((a = defaults.getAttribute("empty")) != null) {
                this._emptyName = a.getValue();
            }
        }
        List eLoads = e.getChild("loads").getChildren("load");
        log.debug("readFile sees {} car loads", (Object)eLoads.size());
        for (Element eLoad : eLoads) {
            a = eLoad.getAttribute("type");
            if (a == null) continue;
            String type = a.getValue();
            this.addType(type);
            a = eLoad.getAttribute("names");
            if (a != null) {
                String names = a.getValue();
                Object[] loadNames = names.split("%%");
                Arrays.sort(loadNames);
                log.debug("Car load type: {} loads: {}", (Object)type, (Object)names);
                int j = loadNames.length;
                while (j > 0) {
                    this.addName(type, (String)loadNames[--j]);
                }
            }
            List eCarLoads = eLoad.getChildren("carLoad");
            log.debug("{} car loads for type: {}", (Object)eCarLoads.size(), (Object)type);
            for (Element eCarLoad : eCarLoads) {
                a = eCarLoad.getAttribute("name");
                if (a == null) continue;
                String name = a.getValue();
                this.addName(type, name);
                a = eCarLoad.getAttribute("priority");
                if (a != null) {
                    this.setPriority(type, name, a.getValue());
                }
                if ((a = eCarLoad.getAttribute("hazardous")) != null) {
                    this.setHazardous(type, name, a.getValue().equals("true"));
                }
                if ((a = eCarLoad.getAttribute("pickupComment")) != null) {
                    this.setPickupComment(type, name, a.getValue());
                }
                if ((a = eCarLoad.getAttribute("dropComment")) != null) {
                    this.setDropComment(type, name, a.getValue());
                }
                if ((a = eCarLoad.getAttribute("loadType")) == null) continue;
                this.setLoadType(type, name, a.getValue());
            }
        }
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(CarManagerXml.class).setDirty(true);
        super.firePropertyChange(p, old, n);
    }
}

