/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.RollingStockManager;
import jmri.jmrit.operations.rollingstock.cars.Bundle;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarLoad;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManagerXml;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManifestHeaderText;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarManager
extends RollingStockManager<Car>
implements InstanceManagerAutoDefault,
InstanceManagerAutoInitialize {
    private static final int BY_LOAD = 30;
    private static final int BY_KERNEL = 31;
    private static final int BY_RWE = 32;
    private static final int BY_FINAL_DEST = 33;
    private static final int BY_WAIT = 34;
    private static final int BY_PICKUP = 35;
    private static final int BY_HAZARD = 36;
    private static final int BY_RWL = 37;
    private static final int BY_ROUTE = 38;
    private static final int BY_DIVISION = 39;
    private static final int BY_SPLIT_FINAL_DEST = 40;
    private static final int BY_SPLIT_LOCATION = 41;
    private static final int BY_SPLIT_DESTINATION = 42;
    int cloneCreationOrder = 0;
    int _commentLength = 0;
    private static final Logger log = LoggerFactory.getLogger(CarManager.class);

    @Override
    public Car newRS(String road, String number) {
        Car car = (Car)this.getByRoadAndNumber(road, number);
        if (car == null) {
            car = new Car(road, number);
            this.register(car);
        }
        return car;
    }

    @Override
    public void deregister(Car car) {
        super.deregister(car);
        InstanceManager.getDefault(CarManagerXml.class).setDirty(true);
    }

    @Override
    public List<Car> getByLocationList() {
        List byFinal = this.getByList(this.getByNumberList(), 33);
        List byKernel = this.getByList(byFinal, 31);
        return this.getByList(byKernel, 4);
    }

    public List<Car> getByKernelList() {
        return this.getByList(this.getByList(this.getByNumberList(), 13), 31);
    }

    public List<Car> getByLoadList() {
        return this.getByList(this.getByLocationList(), 30);
    }

    public List<Car> getByRweList() {
        return this.getByList(this.getByLocationList(), 32);
    }

    public List<Car> getByRwlList() {
        return this.getByList(this.getByLocationList(), 37);
    }

    public List<Car> getByRouteList() {
        return this.getByList(this.getByLocationList(), 38);
    }

    public List<Car> getByDivisionList() {
        return this.getByList(this.getByLocationList(), 39);
    }

    public List<Car> getByFinalDestinationList() {
        return this.getByList(this.getByDestinationList(), 33);
    }

    public List<Car> getByWaitList() {
        return this.getByList(this.getByIdList(), 34);
    }

    public List<Car> getByPickupList() {
        return this.getByList(this.getByDestinationList(), 35);
    }

    @Override
    protected Comparator<Car> getComparator(int attribute) {
        switch (attribute) {
            case 30: {
                return (c1, c2) -> c1.getLoadName().compareToIgnoreCase(c2.getLoadName());
            }
            case 31: {
                return (c1, c2) -> c1.getKernelName().compareToIgnoreCase(c2.getKernelName());
            }
            case 32: {
                return (c1, c2) -> (c1.getReturnWhenEmptyDestinationName() + c1.getReturnWhenEmptyDestTrackName()).compareToIgnoreCase(c2.getReturnWhenEmptyDestinationName() + c2.getReturnWhenEmptyDestTrackName());
            }
            case 37: {
                return (c1, c2) -> (c1.getReturnWhenLoadedDestinationName() + c1.getReturnWhenLoadedDestTrackName()).compareToIgnoreCase(c2.getReturnWhenLoadedDestinationName() + c2.getReturnWhenLoadedDestTrackName());
            }
            case 33: {
                return (c1, c2) -> (c1.getFinalDestinationName() + c1.getFinalDestinationTrackName()).compareToIgnoreCase(c2.getFinalDestinationName() + c2.getFinalDestinationTrackName());
            }
            case 38: {
                return (c1, c2) -> c1.getRoutePath().compareToIgnoreCase(c2.getRoutePath());
            }
            case 39: {
                return (c1, c2) -> c1.getDivisionName().compareToIgnoreCase(c2.getDivisionName());
            }
            case 34: {
                return (c1, c2) -> c1.getWait() - c2.getWait();
            }
            case 35: {
                return (c1, c2) -> c1.getPickupScheduleName().compareToIgnoreCase(c2.getPickupScheduleName());
            }
            case 36: {
                return (c1, c2) -> (c1.isHazardous() ? 1 : 0) - (c2.isHazardous() ? 1 : 0);
            }
            case 40: {
                return (c1, c2) -> (c1.getSplitFinalDestinationName() + c1.getSplitFinalDestinationTrackName()).compareToIgnoreCase(c2.getSplitFinalDestinationName() + c2.getSplitFinalDestinationTrackName());
            }
            case 41: {
                return (c1, c2) -> (c1.getStatus() + c1.getSplitLocationName() + c1.getSplitTrackName()).compareToIgnoreCase(c2.getStatus() + c2.getSplitLocationName() + c2.getSplitTrackName());
            }
            case 42: {
                return (c1, c2) -> (c1.getSplitDestinationName() + c1.getSplitDestinationTrackName()).compareToIgnoreCase(c2.getSplitDestinationName() + c2.getSplitDestinationTrackName());
            }
        }
        return super.getComparator(attribute);
    }

    public List<Car> getAvailableTrainList(Train train) {
        ArrayList<Car> out = new ArrayList<Car>();
        Route route = train.getRoute();
        if (route == null) {
            return out;
        }
        List<RouteLocation> routeList = route.getLocationsBySequenceList();
        RouteLocation destination = null;
        if (routeList.size() > 1) {
            destination = routeList.get(routeList.size() - 1);
            for (int i = 0; i < routeList.size() - 1; ++i) {
                if (!destination.getName().equals(routeList.get(i).getName())) continue;
                destination = null;
                break;
            }
            if (destination != null && destination.isPickUpAllowed() && destination.getLocation() != null && !destination.getLocation().isStaging()) {
                destination = null;
            }
        }
        List<Car> sortByPriority = this.sortByPriority(this.getByMovesList());
        for (Car car : sortByPriority) {
            RouteLocation rl;
            if (car.getLocation() == null || (rl = route.getLastLocationByName(car.getLocationName())) == null || rl == destination || car.getTrain() != null && !train.equals(car.getTrain())) continue;
            out.add(car);
        }
        return out;
    }

    protected List<Car> sortByPriority(List<Car> list) {
        ArrayList<Car> out = new ArrayList<Car>();
        for (Car car : list) {
            if (!car.getLoadPriority().equals(CarLoad.PRIORITY_HIGH)) continue;
            out.add(car);
        }
        for (Car car : list) {
            if (!car.getLoadPriority().equals(CarLoad.PRIORITY_MEDIUM)) continue;
            out.add(car);
        }
        for (Car car : list) {
            if (out.contains(car)) continue;
            out.add(car);
        }
        return out;
    }

    public List<Car> getByTrainDestinationList(Train train) {
        List byFinal = this.getByList(this.getList(train), 40);
        List byLocation = this.getByList(byFinal, 41);
        List byHazard = this.getByList(byLocation, 36);
        List byDestination = this.getByList(byHazard, 42);
        ArrayList<Car> out = new ArrayList<Car>();
        int lastCarsIndex = 0;
        for (Car car : byDestination) {
            int index;
            if (car.getKernel() != null && !car.isLead() && !car.isPassenger()) continue;
            if (!(car.isCaboose() || car.hasFred() || car.isPassenger())) {
                if (car.getDestinationTrack() != null && car.getDestinationTrack().getBlockingOrder() > 0) {
                    for (int j = 0; j < out.size(); ++j) {
                        if (((Car)out.get(j)).getDestinationTrack() == null) continue;
                        if (car.getRouteDestination() != null && (car.getRouteDestination().getTrainDirectionString().equals(RouteLocation.WEST_DIR) || car.getRouteDestination().getTrainDirectionString().equals(RouteLocation.NORTH_DIR))) {
                            if (car.getDestinationTrack().getBlockingOrder() >= ((Car)out.get(j)).getDestinationTrack().getBlockingOrder()) continue;
                            out.add(j, car);
                            break;
                        }
                        if (car.getDestinationTrack().getBlockingOrder() <= ((Car)out.get(j)).getDestinationTrack().getBlockingOrder()) continue;
                        out.add(j, car);
                        break;
                    }
                }
                if (!out.contains(car)) {
                    out.add(out.size() - lastCarsIndex, car);
                }
            } else if (car.isPassenger()) {
                if (car.getBlocking() < 0) {
                    Car carTest;
                    for (index = 0; index < out.size() && (carTest = (Car)out.get(index)).isPassenger() && carTest.getBlocking() <= car.getBlocking(); ++index) {
                    }
                    out.add(index, car);
                } else {
                    for (index = 0; index < lastCarsIndex; ++index) {
                        Car carTest = (Car)out.get(out.size() - 1 - index);
                        log.debug("Car ({}) has blocking number: {}", (Object)carTest.toString(), (Object)carTest.getBlocking());
                        if (carTest.isPassenger() && !carTest.isCaboose() && !carTest.hasFred() && carTest.getBlocking() < car.getBlocking()) break;
                    }
                    out.add(out.size() - index, car);
                    ++lastCarsIndex;
                }
            } else if (car.isCaboose() || car.hasFred()) {
                out.add(car);
                ++lastCarsIndex;
            }
            if (!car.isLead()) continue;
            index = out.indexOf(car);
            int numberOfCars = 1;
            for (Car kcar : car.getKernel().getCars()) {
                if (car == kcar || kcar.isPassenger()) continue;
                for (int j = 0; j < numberOfCars; ++j) {
                    if (kcar.getBlocking() >= ((Car)out.get(index + j)).getBlocking()) continue;
                    out.add(index + j, kcar);
                    break;
                }
                if (!out.contains(kcar)) {
                    out.add(index + numberOfCars, kcar);
                }
                ++numberOfCars;
                if (!car.hasFred() && !car.isCaboose() && (!car.isPassenger() || car.getBlocking() <= 0)) continue;
                ++lastCarsIndex;
            }
        }
        return out;
    }

    public List<String> getCabooseRoadNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration en = this._hashTable.keys();
        while (en.hasMoreElements()) {
            Car car = (Car)this.getById((String)en.nextElement());
            if (!car.isCaboose() || names.contains(car.getRoadName())) continue;
            names.add(car.getRoadName());
        }
        Collections.sort(names);
        return names;
    }

    public List<String> getFredRoadNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration en = this._hashTable.keys();
        while (en.hasMoreElements()) {
            Car car = (Car)this.getById((String)en.nextElement());
            if (!car.hasFred() || names.contains(car.getRoadName())) continue;
            names.add(car.getRoadName());
        }
        Collections.sort(names);
        return names;
    }

    public void replaceLoad(String type, String oldLoadName, String newLoadName) {
        List cars = this.getList();
        for (Car car : cars) {
            if (car.getTypeName().equals(type) && car.getLoadName().equals(oldLoadName)) {
                if (newLoadName != null) {
                    car.setLoadName(newLoadName);
                } else {
                    car.setLoadName(InstanceManager.getDefault(CarLoads.class).getDefaultEmptyName());
                }
            }
            if (car.getTypeName().equals(type) && car.getReturnWhenEmptyLoadName().equals(oldLoadName)) {
                if (newLoadName != null) {
                    car.setReturnWhenEmptyLoadName(newLoadName);
                } else {
                    car.setReturnWhenEmptyLoadName(InstanceManager.getDefault(CarLoads.class).getDefaultEmptyName());
                }
            }
            if (!car.getTypeName().equals(type) || !car.getReturnWhenLoadedLoadName().equals(oldLoadName)) continue;
            if (newLoadName != null) {
                car.setReturnWhenLoadedLoadName(newLoadName);
                continue;
            }
            car.setReturnWhenLoadedLoadName(InstanceManager.getDefault(CarLoads.class).getDefaultLoadName());
        }
    }

    public List<Car> getCarsLocationUnknown() {
        ArrayList<Car> mias = new ArrayList<Car>();
        List cars = this.getByIdList();
        for (Car rs : cars) {
            Car car = rs;
            if (!car.isLocationUnknown()) continue;
            mias.add(car);
        }
        return mias;
    }

    public static String calculateCarWeight(String carLength) throws NumberFormatException {
        double doubleCarLength = Double.parseDouble(carLength) * 12.0 / (double)Setup.getScaleRatio();
        double doubleCarWeight = ((double)Setup.getInitalWeight() + doubleCarLength * (double)Setup.getAddWeight()) / 1000.0;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(1);
        return nf.format(doubleCarWeight);
    }

    public boolean isThereDivisions() {
        for (Car car : this.getList()) {
            if (car.getDivision() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isThereClones() {
        for (Car car : this.getList()) {
            if (!car.isClone()) continue;
            return true;
        }
        return false;
    }

    public int getCloneCreationOrder() {
        if (this.cloneCreationOrder == 0) {
            for (Car car : this.getList()) {
                String[] number;
                int creationOrder;
                if (!car.isClone() || (creationOrder = Integer.parseInt((number = car.getNumber().split("-\\(Clone\\)"))[1])) <= this.cloneCreationOrder) continue;
                this.cloneCreationOrder = creationOrder;
            }
        }
        return ++this.cloneCreationOrder;
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="I18N of Info Message")
    public int getMaxCommentLength() {
        if (this._commentLength == 0) {
            this._commentLength = TrainManifestHeaderText.getStringHeader_Comment().length();
            String comment = "";
            RollingStock carMax = null;
            for (Car car : this.getList()) {
                if (car.getComment().length() <= this._commentLength) continue;
                this._commentLength = car.getComment().length();
                comment = car.getComment();
                carMax = car;
            }
            if (carMax != null) {
                log.info(Bundle.getMessage("InfoMaxComment", carMax.toString(), comment, this._commentLength));
            }
        }
        return this._commentLength;
    }

    public void load(Element root) {
        if (root.getChild("cars") != null) {
            List eCars = root.getChild("cars").getChildren("car");
            log.debug("readFile sees {} cars", (Object)eCars.size());
            for (Element eCar : eCars) {
                this.register(new Car(eCar));
            }
        }
    }

    public void store(Element root) {
        root.addContent((Content)new Element("options"));
        Element values = new Element("cars");
        root.addContent((Content)values);
        List carList = this.getByIdList();
        Iterator iterator = carList.iterator();
        while (iterator.hasNext()) {
            Car rs;
            Car car = rs = (Car)iterator.next();
            values.addContent((Content)car.store());
        }
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(CarManagerXml.class).setDirty(true);
        super.firePropertyChange(p, old, n);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("rolling stock comment")) {
            this._commentLength = 0;
        }
        super.propertyChange(evt);
    }

    @Override
    public void initialize() {
        InstanceManager.getDefault(OperationsSetupXml.class);
        InstanceManager.getDefault(CarManagerXml.class);
    }
}

