/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.LocationManagerXml;
import jmri.jmrit.operations.rollingstock.RollingStockLogger;
import jmri.jmrit.operations.rollingstock.cars.Bundle;
import jmri.jmrit.operations.rollingstock.cars.CarColors;
import jmri.jmrit.operations.rollingstock.cars.CarLengths;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarOwners;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.cars.KernelManager;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.setup.Setup;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarManagerXml
extends OperationsXml
implements InstanceManagerAutoDefault,
InstanceManagerAutoInitialize {
    static final String CAR_ROUTER_REPORTS = "carRouterReports";
    static final String CAR_ROUTER_REPORTS_RAW = "carRouterReports";
    private String operationsFileName = "OperationsCarRoster.xml";
    private static final Logger log = LoggerFactory.getLogger(CarManagerXml.class);

    @Override
    public void writeFile(String name) throws FileNotFoundException, IOException {
        log.debug("writeFile {}", (Object)name);
        File file = this.findFile(name);
        if (file == null) {
            file = new File(name);
        }
        Element root = new Element("operations-config");
        Document doc = CarManagerXml.newDocument(root, this.dtdLocation + "operations-cars.dtd");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "text/xsl");
        m.put("href", "/xml/XSLT/operations-cars.xsl");
        ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
        doc.addContent(0, (Content)p);
        InstanceManager.getDefault(CarRoads.class).store(root);
        InstanceManager.getDefault(CarTypes.class).store(root);
        InstanceManager.getDefault(CarColors.class).store(root);
        InstanceManager.getDefault(CarLengths.class).store(root);
        InstanceManager.getDefault(CarOwners.class).store(root);
        InstanceManager.getDefault(CarLoads.class).store(root);
        InstanceManager.getDefault(KernelManager.class).store(root);
        InstanceManager.getDefault(CarManager.class).store(root);
        this.writeXML(file, doc);
        this.setDirty(false);
    }

    @Override
    public void readFile(String name) throws JDOMException, IOException {
        if (this.findFile(name) == null) {
            log.debug("{} file could not be found", (Object)name);
            return;
        }
        Element root = this.rootFromName(name);
        if (root == null) {
            log.debug("{} file could not be read", (Object)name);
            return;
        }
        if (!root.getName().equals("operations-config")) {
            log.warn("OperationsPro car file corrupted");
            return;
        }
        InstanceManager.getDefault(CarRoads.class).load(root);
        InstanceManager.getDefault(CarTypes.class).load(root);
        InstanceManager.getDefault(CarColors.class).load(root);
        InstanceManager.getDefault(CarLengths.class).load(root);
        InstanceManager.getDefault(CarOwners.class).load(root);
        InstanceManager.getDefault(CarLoads.class).load(root);
        InstanceManager.getDefault(KernelManager.class).load(root);
        InstanceManager.getDefault(CarManager.class).load(root);
        log.debug("Cars have been loaded!");
        InstanceManager.getDefault(RollingStockLogger.class).enableCarLogging(Setup.isCarLoggerEnabled());
        this.setDirty(false);
        InstanceManager.getDefault(LocationManagerXml.class).setDirty(false);
    }

    @Override
    public void setOperationsFileName(String name) {
        this.operationsFileName = name;
    }

    @Override
    public String getOperationsFileName() {
        return this.operationsFileName;
    }

    public File createCarRouterReportFile(String name) {
        return this.createFile(this.defaultCarRouterReportFileName(name), false);
    }

    public File getCarRouterReportFile(String name) {
        File file = new File(this.defaultCarRouterReportFileName(name));
        return file;
    }

    public String defaultCarRouterReportFileName(String name) {
        return OperationsXml.getFileLocation() + OperationsXml.getOperationsDirectoryName() + File.separator + "carRouterReports" + File.separator + Bundle.getMessage("RoutingReportCar", name);
    }

    public File createRawCarRouterReportFile(String name) {
        this.createFile(this.defaultCarRouterReportFileName(name), false);
        return this.createFile(this.defaultRawCarRouterReportFileName(name), false);
    }

    public File getRawCarRouterReportFile(String name) {
        File file = new File(this.defaultRawCarRouterReportFileName(name));
        return file;
    }

    public String defaultRawCarRouterReportFileName(String name) {
        return OperationsXml.getFileLocation() + OperationsXml.getOperationsDirectoryName() + File.separator + "carRouterReports" + File.separator + "carRouterReports" + File.separator + Bundle.getMessage("RoutingReportCar", name);
    }

    public void dispose() {
    }

    @Override
    public void initialize() {
        InstanceManager.getDefault(OperationsSetupXml.class);
        InstanceManager.getDefault(LocationManagerXml.class);
        this.load();
    }
}

