/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.operations.rollingstock.RollingStockAttribute;
import jmri.jmrit.operations.rollingstock.cars.Bundle;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarManagerXml;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarRoads
extends RollingStockAttribute
implements InstanceManagerAutoDefault {
    private static final String ROADS = Bundle.getMessage("carRoadNames");
    public static final String CARROADS_CHANGED_PROPERTY = "CarRoads Length";
    public static final String CARROADS_NAME_CHANGED_PROPERTY = "CarRoads Name";
    private static final Logger log = LoggerFactory.getLogger(CarRoads.class);

    @Override
    protected String getDefaultNames() {
        return ROADS;
    }

    @Override
    public void addName(String road) {
        super.addName(road);
        this.setDirtyAndFirePropertyChange(CARROADS_CHANGED_PROPERTY, null, road);
    }

    @Override
    public void deleteName(String road) {
        super.deleteName(road);
        this.setDirtyAndFirePropertyChange(CARROADS_CHANGED_PROPERTY, road, null);
    }

    public void replaceName(String oldName, String newName) {
        super.addName(newName);
        this.setDirtyAndFirePropertyChange(CARROADS_NAME_CHANGED_PROPERTY, oldName, newName);
        super.deleteName(oldName);
        if (newName == null) {
            this.setDirtyAndFirePropertyChange(CARROADS_CHANGED_PROPERTY, this.list.size() + 1, this.list.size());
        }
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="I18N of Info Message")
    public int getMaxNameLength() {
        if (this.maxNameSubStringLength == 0) {
            super.getMaxNameSubStringLength();
            log.info(Bundle.getMessage("InfoMaxRoad", this.maxName, this.maxNameSubStringLength));
        }
        return this.maxNameSubStringLength;
    }

    public List<String> getNames(String type) {
        ArrayList<String> names = new ArrayList<String>();
        List cars = InstanceManager.getDefault(CarManager.class).getByTypeList(type);
        for (Car car : cars) {
            if (names.contains(car.getRoadName())) continue;
            names.add(car.getRoadName());
        }
        Collections.sort(names);
        return names;
    }

    public void store(Element root) {
        this.store(root, "roads", "road");
    }

    public void load(Element root) {
        this.load(root, "roads", "road", "roadNames");
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(CarManagerXml.class).setDirty(true);
        super.firePropertyChange(p, old, n);
    }
}

