/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.operations.rollingstock.RollingStockAttribute;
import jmri.jmrit.operations.rollingstock.cars.Bundle;
import jmri.jmrit.operations.rollingstock.cars.CarManagerXml;
import jmri.jmrit.operations.setup.Setup;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarTypes
extends RollingStockAttribute
implements InstanceManagerAutoDefault {
    private static final String TYPES = Bundle.getMessage("carTypeNames");
    private static final String CONVERT_TYPES = Bundle.getMessage("carTypeConvert");
    private static final String ARR_TYPES = Bundle.getMessage("carTypeARR");
    public static final String CARTYPES_CHANGED_PROPERTY = "CarTypes Length";
    public static final String CARTYPES_NAME_CHANGED_PROPERTY = "CarTypes Name";
    private static final Logger log = LoggerFactory.getLogger(CarTypes.class);

    @Override
    protected String getDefaultNames() {
        if (Setup.getCarTypes().equals(Setup.AAR)) {
            return ARR_TYPES;
        }
        return TYPES;
    }

    public void changeDefaultNames(String type) {
        String[] types;
        String[] convert = CONVERT_TYPES.split(",");
        if (convert.length != (types = TYPES.split(",")).length) {
            log.warn("Properties file doesn't have equal length conversion strings, carTypeNames {}, carTypeConvert {}", (Object)types.length, (Object)convert.length);
            return;
        }
        if (type.equals(Setup.DESCRIPTIVE)) {
            int i;
            for (int i2 = 0; i2 < convert.length; ++i2) {
                this.replaceName(convert[i2], types[i2]);
            }
            String[] aarTypes = ARR_TYPES.split(",");
            for (i = 0; i < aarTypes.length; ++i) {
                this.list.remove(aarTypes[i]);
            }
            for (i = 0; i < types.length; ++i) {
                if (this.list.contains(types[i])) continue;
                this.list.add(types[i]);
            }
        } else {
            int i;
            for (i = 0; i < convert.length; ++i) {
                this.replaceName(types[i], convert[i]);
            }
            for (i = 0; i < types.length; ++i) {
                this.list.remove(types[i]);
            }
            types = ARR_TYPES.split(",");
            for (i = 0; i < types.length; ++i) {
                if (this.list.contains(types[i])) continue;
                this.list.add(types[i]);
            }
        }
    }

    @Override
    public void addName(String type) {
        super.addName(type);
        this.setDirtyAndFirePropertyChange(CARTYPES_CHANGED_PROPERTY, null, type);
    }

    @Override
    public void deleteName(String type) {
        super.deleteName(type);
        this.setDirtyAndFirePropertyChange(CARTYPES_CHANGED_PROPERTY, type, null);
    }

    public void replaceName(String oldName, String newName) {
        super.addName(newName);
        this.setDirtyAndFirePropertyChange(CARTYPES_NAME_CHANGED_PROPERTY, oldName, newName);
        super.deleteName(oldName);
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="I18N of Info Message")
    public int getMaxNameLength() {
        if (this.maxNameSubStringLength == 0) {
            super.getMaxNameSubStringLength();
            log.info(Bundle.getMessage("InfoMaxType", this.maxName, this.maxNameSubStringLength));
        }
        return this.maxNameSubStringLength;
    }

    public int getMaxFullNameLength() {
        return super.getMaxNameLength();
    }

    public void store(Element root) {
        this.store(root, "types", "type");
    }

    public void load(Element root) {
        this.load(root, "types", "type", "carTypes");
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(CarManagerXml.class).setDirty(true);
        super.firePropertyChange(p, old, n);
    }
}

