/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars;

import java.util.List;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.operations.rollingstock.RollingStockGroupManager;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManagerXml;
import jmri.jmrit.operations.rollingstock.cars.Kernel;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelManager
extends RollingStockGroupManager
implements InstanceManagerAutoDefault {
    private static final Logger log = LoggerFactory.getLogger(KernelManager.class);

    public Kernel newKernel(String name) {
        Kernel kernel = this.getKernelByName(name);
        if (kernel == null && !name.equals("")) {
            kernel = new Kernel(name);
            int oldSize = this._groupHashTable.size();
            this._groupHashTable.put(name, kernel);
            this.setDirtyAndFirePropertyChange("GroupListLengthChanged", oldSize, this._groupHashTable.size());
        }
        return kernel;
    }

    public void deleteKernel(String name) {
        Kernel kernel = this.getKernelByName(name);
        if (kernel != null) {
            kernel.dispose();
            Integer oldSize = this._groupHashTable.size();
            this._groupHashTable.remove(name);
            this.setDirtyAndFirePropertyChange("GroupListLengthChanged", oldSize, this._groupHashTable.size());
        }
    }

    public Kernel getKernelByName(String name) {
        return (Kernel)this._groupHashTable.get(name);
    }

    public void replaceKernelName(String oldName, String newName) {
        Kernel oldKernel = this.getKernelByName(oldName);
        if (oldKernel != null) {
            Kernel newKernel = this.newKernel(newName);
            Car leadCar = (Car)oldKernel.getLead();
            if (leadCar != null) {
                leadCar.setKernel(newKernel);
            }
            for (Car car : oldKernel.getCars()) {
                car.setKernel(newKernel);
            }
        }
    }

    public void load(Element root) {
        block3: {
            String names;
            block2: {
                if (root.getChild("newKernels") == null) break block2;
                List eKernels = root.getChild("newKernels").getChildren("kernel");
                log.debug("Kernel manager sees {} kernels", (Object)eKernels.size());
                for (Element eKernel : eKernels) {
                    Attribute a = eKernel.getAttribute("name");
                    if (a == null) continue;
                    this.newKernel(a.getValue());
                }
                break block3;
            }
            if (root.getChild("kernels") == null || (names = root.getChildText("kernels")).isEmpty()) break block3;
            String[] kernelNames = names.split("%%");
            log.debug("kernels: {}", (Object)names);
            for (String name : kernelNames) {
                this.newKernel(name);
            }
        }
    }

    public void store(Element root) {
        List<String> names = this.getNameList();
        Element kernels = new Element("newKernels");
        for (String name : names) {
            Element kernel = new Element("kernel");
            kernel.setAttribute(new Attribute("name", name));
            kernels.addContent((Content)kernel);
        }
        root.addContent((Content)kernels);
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(CarManagerXml.class).setDirty(true);
        super.firePropertyChange(p, old, n);
    }
}

