/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars.gui;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsMenu;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.schedules.ScheduleManager;
import jmri.jmrit.operations.locations.tools.ModifyLocationsAction;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.gui.Bundle;
import jmri.jmrit.operations.rollingstock.cars.gui.CarEditFrame;
import jmri.jmrit.operations.rollingstock.cars.gui.CarRosterMenu;
import jmri.jmrit.operations.rollingstock.cars.gui.CarsTableModel;
import jmri.jmrit.operations.rollingstock.cars.tools.CarsSetFrameAction;
import jmri.jmrit.operations.rollingstock.cars.tools.PrintCarLoadsAction;
import jmri.jmrit.operations.rollingstock.cars.tools.ResetCheckboxesCarsTableAction;
import jmri.jmrit.operations.rollingstock.cars.tools.ShowCheckboxesCarsTableAction;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.tools.TrainsByCarTypeAction;
import jmri.swing.JTablePersistenceManager;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarsTableFrame
extends OperationsFrame
implements TableModelListener {
    public CarsTableModel carsTableModel;
    public JTable carsTable;
    boolean showAllCars;
    String locationName;
    String trackName;
    CarManager carManager = InstanceManager.getDefault(CarManager.class);
    JLabel numCars = new JLabel();
    JLabel textCars = new JLabel(Bundle.getMessage("cars"));
    JLabel textSep1 = new JLabel("      ");
    JRadioButton sortByNumber = new JRadioButton(Bundle.getMessage("Number"));
    JRadioButton sortByRoad = new JRadioButton(Bundle.getMessage("Road"));
    JRadioButton sortByType = new JRadioButton(Bundle.getMessage("Type"));
    JRadioButton sortByColor = new JRadioButton(Bundle.getMessage("Color"));
    JRadioButton sortByLoad = new JRadioButton(Bundle.getMessage("Load"));
    JRadioButton sortByKernel = new JRadioButton(Bundle.getMessage("Kernel"));
    JRadioButton sortByLocation = new JRadioButton(Bundle.getMessage("Location"));
    JRadioButton sortByDestination = new JRadioButton(Bundle.getMessage("Destination"));
    JRadioButton sortByFinalDestination = new JRadioButton(Bundle.getMessage("FD"));
    JRadioButton sortByRwe = new JRadioButton(Bundle.getMessage("RWE"));
    JRadioButton sortByRwl = new JRadioButton(Bundle.getMessage("RWL"));
    JRadioButton sortByRoute = new JRadioButton(Bundle.getMessage("Route"));
    JRadioButton sortByDivision = new JRadioButton(Bundle.getMessage("Division"));
    JRadioButton sortByTrain = new JRadioButton(Bundle.getMessage("Train"));
    JRadioButton sortByMoves = new JRadioButton(Bundle.getMessage("Moves"));
    JRadioButton sortByBuilt = new JRadioButton(Bundle.getMessage("Built"));
    JRadioButton sortByOwner = new JRadioButton(Bundle.getMessage("Owner"));
    JRadioButton sortByValue = new JRadioButton(Setup.getValueLabel());
    JRadioButton sortByRfid = new JRadioButton(Setup.getRfidLabel());
    JRadioButton sortByWait = new JRadioButton(Bundle.getMessage("Wait"));
    JRadioButton sortByPickup = new JRadioButton(Bundle.getMessage("Pickup"));
    JRadioButton sortByLast = new JRadioButton(Bundle.getMessage("Last"));
    JRadioButton sortByComment = new JRadioButton(Bundle.getMessage("Comment"));
    ButtonGroup group = new ButtonGroup();
    JButton addButton = new JButton(Bundle.getMessage("TitleCarAdd"));
    JButton findButton = new JButton(Bundle.getMessage("Find"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JTextField findCarTextBox = new JTextField(6);
    CarEditFrame f = null;
    private static final Logger log = LoggerFactory.getLogger(CarsTableFrame.class);

    public CarsTableFrame(boolean showAllCars, String locationName, String trackName) {
        super(Bundle.getMessage("TitleCarsTable"));
        this.showAllCars = showAllCars;
        this.locationName = locationName;
        this.trackName = trackName;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.carsTableModel = new CarsTableModel(showAllCars, locationName, trackName);
        this.carsTable = new JTable(this.carsTableModel);
        JScrollPane carsPane = new JScrollPane(this.carsTable);
        carsPane.setVerticalScrollBarPolicy(20);
        this.carsTableModel.initTable(this.carsTable, this);
        this.updateNumCars();
        this.carsTableModel.addTableModelListener(this);
        JPanel cp1 = new JPanel();
        cp1.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SortBy")));
        cp1.add(this.sortByNumber);
        cp1.add(this.sortByRoad);
        cp1.add(this.sortByType);
        JPanel clp = new JPanel();
        clp.setBorder(BorderFactory.createTitledBorder(""));
        clp.add(this.sortByLoad);
        clp.add(this.sortByColor);
        cp1.add(clp);
        cp1.add(this.sortByKernel);
        cp1.add(this.sortByLocation);
        JPanel destp = new JPanel();
        destp.setBorder(BorderFactory.createTitledBorder(""));
        destp.add(this.sortByDestination);
        destp.add(this.sortByFinalDestination);
        destp.add(this.sortByRwe);
        destp.add(this.sortByRwl);
        destp.add(this.sortByRoute);
        cp1.add(destp);
        cp1.add(this.sortByDivision);
        cp1.add(this.sortByTrain);
        JPanel movep = new JPanel();
        movep.setBorder(BorderFactory.createTitledBorder(""));
        movep.add(this.sortByMoves);
        movep.add(this.sortByBuilt);
        movep.add(this.sortByOwner);
        if (Setup.isValueEnabled()) {
            movep.add(this.sortByValue);
        }
        if (Setup.isRfidEnabled()) {
            movep.add(this.sortByRfid);
        }
        if (InstanceManager.getDefault(ScheduleManager.class).numEntries() > 0) {
            movep.add(this.sortByWait);
            movep.add(this.sortByPickup);
        }
        movep.add(this.sortByLast);
        movep.add(this.sortByComment);
        cp1.add(movep);
        JPanel cp2 = new JPanel();
        cp2.setLayout(new BoxLayout(cp2, 0));
        JPanel cp2Add = new JPanel();
        cp2Add.setBorder(BorderFactory.createTitledBorder(""));
        this.addButton.setToolTipText(Bundle.getMessage("TipAddButton"));
        cp2Add.add(this.numCars);
        cp2Add.add(this.textCars);
        cp2Add.add(this.textSep1);
        cp2Add.add(this.addButton);
        cp2.add(cp2Add);
        JPanel cp2Find = new JPanel();
        cp2Find.setBorder(BorderFactory.createTitledBorder(""));
        this.findButton.setToolTipText(Bundle.getMessage("findCar"));
        this.findCarTextBox.setToolTipText(Bundle.getMessage("findCar"));
        cp2Find.add(this.findButton);
        cp2Find.add(this.findCarTextBox);
        cp2.add(cp2Find);
        JPanel cp2Save = new JPanel();
        cp2Save.setBorder(BorderFactory.createTitledBorder(""));
        cp2Save.add(this.saveButton);
        cp2.add(cp2Save);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 1));
        controlPanel.add(cp1);
        controlPanel.add(cp2);
        this.sortByFinalDestination.setToolTipText(Bundle.getMessage("FinalDestination"));
        this.sortByRwe.setToolTipText(Bundle.getMessage("ReturnWhenEmpty"));
        this.sortByRwl.setToolTipText(Bundle.getMessage("ReturnWhenLoaded"));
        this.sortByPickup.setToolTipText(Bundle.getMessage("TipPickup"));
        this.sortByLast.setToolTipText(Bundle.getMessage("TipLastMoved"));
        JScrollPane controlPane = new JScrollPane(controlPanel);
        this.getContentPane().add(carsPane);
        this.getContentPane().add(controlPane);
        this.addButtonAction(this.addButton);
        this.addButtonAction(this.findButton);
        this.addButtonAction(this.saveButton);
        this.sortByNumber.setSelected(true);
        this.addRadioButtonAction(this.sortByNumber);
        this.addRadioButtonAction(this.sortByRoad);
        this.addRadioButtonAction(this.sortByType);
        this.addRadioButtonAction(this.sortByColor);
        this.addRadioButtonAction(this.sortByLoad);
        this.addRadioButtonAction(this.sortByKernel);
        this.addRadioButtonAction(this.sortByLocation);
        this.addRadioButtonAction(this.sortByDestination);
        this.addRadioButtonAction(this.sortByFinalDestination);
        this.addRadioButtonAction(this.sortByRwe);
        this.addRadioButtonAction(this.sortByRwl);
        this.addRadioButtonAction(this.sortByRoute);
        this.addRadioButtonAction(this.sortByDivision);
        this.addRadioButtonAction(this.sortByTrain);
        this.addRadioButtonAction(this.sortByMoves);
        this.addRadioButtonAction(this.sortByBuilt);
        this.addRadioButtonAction(this.sortByOwner);
        this.addRadioButtonAction(this.sortByValue);
        this.addRadioButtonAction(this.sortByRfid);
        this.addRadioButtonAction(this.sortByWait);
        this.addRadioButtonAction(this.sortByPickup);
        this.addRadioButtonAction(this.sortByLast);
        this.addRadioButtonAction(this.sortByComment);
        this.group.add(this.sortByNumber);
        this.group.add(this.sortByRoad);
        this.group.add(this.sortByType);
        this.group.add(this.sortByColor);
        this.group.add(this.sortByLoad);
        this.group.add(this.sortByKernel);
        this.group.add(this.sortByLocation);
        this.group.add(this.sortByDestination);
        this.group.add(this.sortByFinalDestination);
        this.group.add(this.sortByRwe);
        this.group.add(this.sortByRwl);
        this.group.add(this.sortByRoute);
        this.group.add(this.sortByDivision);
        this.group.add(this.sortByTrain);
        this.group.add(this.sortByMoves);
        this.group.add(this.sortByBuilt);
        this.group.add(this.sortByOwner);
        this.group.add(this.sortByValue);
        this.group.add(this.sortByRfid);
        this.group.add(this.sortByWait);
        this.group.add(this.sortByPickup);
        this.group.add(this.sortByLast);
        this.group.add(this.sortByComment);
        if (!showAllCars) {
            this.sortByLocation.doClick();
            if (locationName != null) {
                String title = Bundle.getMessage("TitleCarsTable") + " " + locationName;
                if (trackName != null) {
                    title = title + " " + trackName;
                }
                this.setTitle(title);
            }
        }
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new CarRosterMenu(Bundle.getMessage("TitleCarRoster"), 1, this));
        toolMenu.addSeparator();
        toolMenu.add(new ShowCheckboxesCarsTableAction(this.carsTableModel));
        toolMenu.add(new ResetCheckboxesCarsTableAction(this.carsTableModel));
        toolMenu.addSeparator();
        toolMenu.add(new ModifyLocationsAction());
        toolMenu.add(new TrainsByCarTypeAction());
        toolMenu.addSeparator();
        toolMenu.add(new PrintCarLoadsAction(false));
        toolMenu.add(new PrintCarLoadsAction(true));
        toolMenu.addSeparator();
        toolMenu.add(new CarsSetFrameAction(this.carsTable));
        menuBar.add(toolMenu);
        menuBar.add(new OperationsMenu());
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_Cars", true);
        this.initMinimumSize();
        this.addHorizontalScrollBarKludgeFix(controlPane, controlPanel);
        this.createShutDownTask();
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button activated");
        this.clearTableSort(this.carsTable);
        if (ae.getSource() == this.sortByNumber) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_NUMBER);
        }
        if (ae.getSource() == this.sortByRoad) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_ROAD);
        }
        if (ae.getSource() == this.sortByType) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_TYPE);
        }
        if (ae.getSource() == this.sortByColor) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_COLOR);
        }
        if (ae.getSource() == this.sortByLoad) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_LOAD);
        }
        if (ae.getSource() == this.sortByKernel) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_KERNEL);
        }
        if (ae.getSource() == this.sortByLocation) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_LOCATION);
        }
        if (ae.getSource() == this.sortByDestination) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_DESTINATION);
        }
        if (ae.getSource() == this.sortByFinalDestination) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_FINALDESTINATION);
        }
        if (ae.getSource() == this.sortByRwe) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_RWE);
        }
        if (ae.getSource() == this.sortByRwl) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_RWL);
        }
        if (ae.getSource() == this.sortByRoute) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_ROUTE);
        }
        if (ae.getSource() == this.sortByDivision) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_DIVISION);
        }
        if (ae.getSource() == this.sortByTrain) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_TRAIN);
        }
        if (ae.getSource() == this.sortByMoves) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_MOVES);
        }
        if (ae.getSource() == this.sortByBuilt) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_BUILT);
        }
        if (ae.getSource() == this.sortByOwner) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_OWNER);
        }
        if (ae.getSource() == this.sortByValue) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_VALUE);
        }
        if (ae.getSource() == this.sortByRfid) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_RFID);
        }
        if (ae.getSource() == this.sortByWait) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_WAIT);
        }
        if (ae.getSource() == this.sortByPickup) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_PICKUP);
        }
        if (ae.getSource() == this.sortByLast) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_LAST);
        }
        if (ae.getSource() == this.sortByComment) {
            this.carsTableModel.setSort(this.carsTableModel.SORTBY_COMMENT);
        }
    }

    public List<Car> getSortByList() {
        return this.carsTableModel.carList;
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.findButton) {
            int rowindex = this.carsTableModel.findCarByRoadNumber(this.findCarTextBox.getText());
            if (rowindex < 0) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("carWithRoadNumNotFound", this.findCarTextBox.getText()), Bundle.getMessage("carCouldNotFind"), 1);
                return;
            }
            this.clearTableSort(this.carsTable);
            this.carsTable.changeSelection(rowindex, 0, false, false);
            return;
        }
        if (ae.getSource() == this.addButton) {
            if (this.f != null) {
                this.f.dispose();
            }
            this.f = new CarEditFrame();
            this.f.initComponents();
        }
        if (ae.getSource() == this.saveButton) {
            if (this.carsTable.isEditing()) {
                log.debug("cars table edit true");
                this.carsTable.getCellEditor().stopCellEditing();
            }
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    protected int[] getCurrentTableColumnWidths() {
        TableColumnModel tcm = this.carsTable.getColumnModel();
        int[] widths = new int[tcm.getColumnCount()];
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            widths[i] = tcm.getColumn(i).getWidth();
        }
        return widths;
    }

    @Override
    public void dispose() {
        this.carsTableModel.removeTableModelListener(this);
        this.carsTableModel.dispose();
        if (this.f != null) {
            this.f.dispose();
        }
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(tpm -> tpm.stopPersisting(this.carsTable));
        super.dispose();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateNumCars();
    }

    private void updateNumCars() {
        String count = this.filterCarList(InstanceManager.getDefault(CarManager.class).getList());
        if (this.showAllCars) {
            this.numCars.setText(count);
            return;
        }
        String showCount = this.filterCarList(this.getSortByList());
        this.numCars.setText(showCount + "/" + count);
    }

    private String filterCarList(List<Car> list) {
        int count = 0;
        for (Car car : list) {
            if (car.isClone()) continue;
            ++count;
        }
        return Integer.toString(count);
    }
}

