/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars.tools;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.locations.tools.LocationsByCarTypeFrame;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.RollingStockAttributeEditFrame;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarColors;
import jmri.jmrit.operations.rollingstock.cars.CarLengths;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarOwners;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.cars.KernelManager;
import jmri.jmrit.operations.rollingstock.cars.tools.Bundle;
import jmri.jmrit.operations.rollingstock.cars.tools.CarAttributeAction;
import jmri.jmrit.operations.rollingstock.cars.tools.CarDeleteAttributeAction;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.trains.tools.TrainsByCarTypeFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarAttributeEditFrame
extends RollingStockAttributeEditFrame {
    CarManager carManager = InstanceManager.getDefault(CarManager.class);
    public static final String COLOR = "Color";
    public static final String KERNEL = "Kernel";
    private static final Logger log = LoggerFactory.getLogger(CarAttributeEditFrame.class);

    public void initComponents(String attribute) {
        this.initComponents(attribute, "");
    }

    @Override
    public void initComponents(String attribute, String name) {
        super.initComponents(attribute, name);
        this.setTitle(Bundle.getMessage("TitleCarEditAtrribute", attribute));
        this.carManager.addPropertyChangeListener(this);
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new CarAttributeAction(this));
        toolMenu.add(new CarDeleteAttributeAction(this));
        menuBar.add(toolMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_EditCarAttributes", true);
    }

    @Override
    protected void deleteAttributeName(String deleteItem) {
        super.deleteAttributeName(deleteItem);
        if (this._attribute.equals("Type")) {
            InstanceManager.getDefault(CarTypes.class).deleteName(deleteItem);
        }
        if (this._attribute.equals(COLOR)) {
            InstanceManager.getDefault(CarColors.class).deleteName(deleteItem);
        }
        if (this._attribute.equals("Length")) {
            InstanceManager.getDefault(CarLengths.class).deleteName(deleteItem);
        }
        if (this._attribute.equals(KERNEL)) {
            InstanceManager.getDefault(KernelManager.class).deleteKernel(deleteItem);
        }
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GUI ease of use")
    protected void addAttributeName(String addItem) {
        super.addAttributeName(addItem);
        if (this._attribute.equals("Type")) {
            InstanceManager.getDefault(CarTypes.class).addName(addItem);
            if (showDialogBox) {
                OperationsFrame lf;
                int results = JmriJOptionPane.showOptionDialog(this, Bundle.getMessage("AddNewCarType"), Bundle.getMessage("ModifyLocations"), -1, 3, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonDontShow")}, Bundle.getMessage("ButtonNo"));
                if (results == 0) {
                    lf = new LocationsByCarTypeFrame();
                    ((LocationsByCarTypeFrame)lf).initComponents(addItem);
                }
                if (results == 2) {
                    showDialogBox = false;
                }
                if ((results = JmriJOptionPane.showOptionDialog(this, Bundle.getMessage("AddNewCarType"), Bundle.getMessage("ModifyTrains"), -1, 3, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonDontShow")}, Bundle.getMessage("ButtonNo"))) == 0) {
                    lf = new TrainsByCarTypeFrame();
                    ((TrainsByCarTypeFrame)lf).initComponents(addItem);
                }
                if (results == 2) {
                    showDialogBox = false;
                }
            }
        }
        if (this._attribute.equals(COLOR)) {
            InstanceManager.getDefault(CarColors.class).addName(addItem);
        }
        if (this._attribute.equals("Length")) {
            InstanceManager.getDefault(CarLengths.class).addName(addItem);
            this.comboBox.setSelectedItem(addItem);
        }
        if (this._attribute.equals(KERNEL)) {
            InstanceManager.getDefault(KernelManager.class).newKernel(addItem);
        }
        if (this._attribute.equals("Owner")) {
            InstanceManager.getDefault(CarOwners.class).addName(addItem);
        }
    }

    @Override
    protected void replaceItem(String oldItem, String newItem) {
        super.replaceItem(oldItem, newItem);
        if (this._attribute.equals(KERNEL)) {
            InstanceManager.getDefault(KernelManager.class).replaceKernelName(oldItem, newItem);
        }
        if (this._attribute.equals("Type")) {
            InstanceManager.getDefault(CarTypes.class).replaceName(oldItem, newItem);
            InstanceManager.getDefault(CarLoads.class).replaceType(oldItem, newItem);
        }
        if (this._attribute.equals("Length")) {
            InstanceManager.getDefault(CarLengths.class).replaceName(oldItem, newItem);
        }
        if (this._attribute.equals(COLOR)) {
            InstanceManager.getDefault(CarColors.class).replaceName(oldItem, newItem);
        }
    }

    @Override
    protected void loadCombobox() {
        super.loadCombobox();
        if (this._attribute.equals("Type")) {
            this.comboBox = InstanceManager.getDefault(CarTypes.class).getComboBox();
            InstanceManager.getDefault(CarTypes.class).addPropertyChangeListener(this);
        }
        if (this._attribute.equals(COLOR)) {
            this.comboBox = InstanceManager.getDefault(CarColors.class).getComboBox();
            InstanceManager.getDefault(CarColors.class).addPropertyChangeListener(this);
        }
        if (this._attribute.equals("Length")) {
            this.comboBox = InstanceManager.getDefault(CarLengths.class).getComboBox();
            InstanceManager.getDefault(CarLengths.class).addPropertyChangeListener(this);
        }
        if (this._attribute.equals(KERNEL)) {
            this.comboBox = InstanceManager.getDefault(KernelManager.class).getComboBox();
            InstanceManager.getDefault(KernelManager.class).addPropertyChangeListener(this);
        }
    }

    @Override
    protected void updateAttributeQuanity() {
        if (!showQuanity) {
            return;
        }
        int number = 0;
        String item = (String)this.comboBox.getSelectedItem();
        log.debug("Selected item {}", (Object)item);
        for (Car car : this.carManager.getList()) {
            if (this._attribute.equals("Road") && car.getRoadName().equals(item)) {
                ++number;
            }
            if (this._attribute.equals("Type") && car.getTypeName().equals(item)) {
                ++number;
            }
            if (this._attribute.equals(COLOR) && car.getColor().equals(item)) {
                ++number;
            }
            if (this._attribute.equals("Length") && car.getLength().equals(item)) {
                ++number;
            }
            if (this._attribute.equals("Owner") && car.getOwnerName().equals(item)) {
                ++number;
            }
            if (!this._attribute.equals(KERNEL) || !car.getKernelName().equals(item)) continue;
            ++number;
        }
        this.quanity.setText(Integer.toString(number));
        if (number == 0 && this.deleteUnused) {
            if (this._attribute.equals("Road")) {
                for (RollingStock rs : InstanceManager.getDefault(EngineManager.class).getList()) {
                    if (!rs.getRoadName().equals(item)) continue;
                    log.info("Engine ({} {}) is assigned road name ({})", new Object[]{rs.getRoadName(), rs.getNumber(), item});
                    return;
                }
            }
            if (this._attribute.equals("Owner")) {
                for (RollingStock rs : InstanceManager.getDefault(EngineManager.class).getList()) {
                    if (!rs.getOwnerName().equals(item)) continue;
                    log.info("Engine ({} {}) is assigned owner name ({})", new Object[]{rs.getRoadName(), rs.getNumber(), item});
                    return;
                }
            }
            this.confirmDelete(item);
        }
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(CarTypes.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarColors.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarLengths.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(KernelManager.class).removePropertyChangeListener(this);
        this.carManager.removePropertyChangeListener(this);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("CarTypes Length")) {
            InstanceManager.getDefault(CarTypes.class).updateComboBox(this.comboBox);
        }
        if (e.getPropertyName().equals("CarColors")) {
            InstanceManager.getDefault(CarColors.class).updateComboBox(this.comboBox);
        }
        if (e.getPropertyName().equals("CarLengths")) {
            InstanceManager.getDefault(CarLengths.class).updateComboBox(this.comboBox);
        }
        if (e.getPropertyName().equals("GroupListLengthChanged")) {
            InstanceManager.getDefault(KernelManager.class).updateComboBox(this.comboBox);
        }
        if (e.getPropertyName().equals("RollingStockListLength")) {
            this.updateAttributeQuanity();
        }
        super.propertyChange(e);
    }
}

