/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.schedules.ScheduleManager;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.cars.tools.Bundle;
import jmri.jmrit.operations.rollingstock.cars.tools.CarLoadAttributeAction;
import jmri.jmrit.operations.rollingstock.cars.tools.PrintCarLoadsAction;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarLoadEditFrame
extends OperationsFrame
implements PropertyChangeListener {
    CarLoads carLoads = InstanceManager.getDefault(CarLoads.class);
    CarTypes carTypes = InstanceManager.getDefault(CarTypes.class);
    JLabel textSep = new JLabel();
    JLabel quanity = new JLabel("0");
    JButton addButton = new JButton(Bundle.getMessage("Add"));
    JButton deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
    JButton replaceButton = new JButton(Bundle.getMessage("Replace"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JComboBox<String> typeComboBox = this.carTypes.getComboBox();
    JComboBox<String> loadComboBox;
    JComboBox<String> priorityComboBox = this.carLoads.getPriorityComboBox();
    JComboBox<String> hazardousComboBox = this.carLoads.getHazardousComboBox();
    JComboBox<String> loadTypeComboBox = this.carLoads.getLoadTypesComboBox();
    JCheckBox allTypesCheckBox = new JCheckBox(Bundle.getMessage("All"));
    JTextField addTextBox = new JTextField(Control.max_len_string_attibute);
    JTextField pickupCommentTextField = new JTextField(35);
    JTextField dropCommentTextField = new JTextField(35);
    String _type;
    boolean menuActive = false;
    boolean showQuanity = false;
    private static final Logger log = LoggerFactory.getLogger(CarLoadEditFrame.class);

    public CarLoadEditFrame() {
        super(Bundle.getMessage("TitleCarEditLoad"));
    }

    public void initComponents(String type, String selectedItem) {
        this.getContentPane().removeAll();
        this._type = type;
        this.typeComboBox.setSelectedItem(this._type);
        this.loadComboBox = this.carLoads.getComboBox(this._type);
        this.carLoads.addPropertyChangeListener(this);
        this.loadComboBox.setSelectedItem(selectedItem);
        this.updateLoadType();
        this.updatePriority();
        this.updateHazardous();
        this.quanity.setVisible(this.showQuanity);
        JPanel pType = new JPanel();
        pType.setLayout(new GridBagLayout());
        pType.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Type")));
        this.addItem(pType, this.typeComboBox, 0, 0);
        this.addItem(pType, this.allTypesCheckBox, 1, 0);
        this.allTypesCheckBox.setToolTipText(Bundle.getMessage("TipCarLoadAll"));
        JPanel pLoad = new JPanel();
        pLoad.setLayout(new GridBagLayout());
        pLoad.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Load")));
        this.addItem(pLoad, this.addTextBox, 2, 2);
        this.addItem(pLoad, this.addButton, 3, 2);
        this.addItem(pLoad, this.quanity, 1, 3);
        this.addItem(pLoad, this.loadComboBox, 2, 3);
        this.addItem(pLoad, this.deleteButton, 3, 3);
        this.addItem(pLoad, this.replaceButton, 3, 4);
        this.deleteButton.setToolTipText(Bundle.getMessage("TipDeleteAttributeName", Bundle.getMessage("Load")));
        this.addButton.setToolTipText(Bundle.getMessage("TipAddAttributeName", Bundle.getMessage("Load")));
        this.replaceButton.setToolTipText(Bundle.getMessage("TipReplaceAttributeName", Bundle.getMessage("Load")));
        JPanel pLoadType = new JPanel();
        pLoadType.setLayout(new BoxLayout(pLoadType, 1));
        pLoadType.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutLoadType")));
        this.addItem(pLoadType, this.loadTypeComboBox, 0, 0);
        JPanel pPriority = new JPanel();
        pPriority.setLayout(new BoxLayout(pPriority, 1));
        pPriority.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutPriority")));
        this.addItem(pPriority, this.priorityComboBox, 0, 0);
        JPanel pHazardous = new JPanel();
        pHazardous.setLayout(new BoxLayout(pHazardous, 1));
        pHazardous.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Hazardous")));
        this.addItem(pHazardous, this.hazardousComboBox, 0, 0);
        JPanel pOptionalPickup = new JPanel();
        pOptionalPickup.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutOptionalPickup")));
        this.addItem(pOptionalPickup, this.pickupCommentTextField, 0, 0);
        JPanel pOptionalDrop = new JPanel();
        pOptionalDrop.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutOptionalDrop")));
        this.addItem(pOptionalDrop, this.dropCommentTextField, 0, 0);
        JPanel pControl = new JPanel();
        pControl.setLayout(new BoxLayout(pControl, 1));
        this.addItem(pControl, this.saveButton, 0, 0);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(pType);
        this.getContentPane().add(pLoad);
        this.getContentPane().add(pLoadType);
        this.getContentPane().add(pPriority);
        this.getContentPane().add(pHazardous);
        this.getContentPane().add(pOptionalPickup);
        this.getContentPane().add(pOptionalDrop);
        this.getContentPane().add(pControl);
        this.addButtonAction(this.addButton);
        this.addButtonAction(this.deleteButton);
        this.addButtonAction(this.replaceButton);
        this.addButtonAction(this.saveButton);
        this.addComboBoxAction(this.typeComboBox);
        this.addComboBoxAction(this.loadComboBox);
        this.addCheckBoxAction(this.allTypesCheckBox);
        this.updateCarCommentFields();
        this.enableButtons();
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new CarLoadAttributeAction(this));
        toolMenu.add(new PrintCarLoadsAction(true));
        toolMenu.add(new PrintCarLoadsAction(false));
        menuBar.add(toolMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_EditCarLoads", true);
        this.initMinimumSize(new Dimension(400, 500));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        String loadName = this.addTextBox.getText().trim();
        if (!(ae.getSource() != this.addButton && ae.getSource() != this.replaceButton || this.checkLoadName(loadName))) {
            return;
        }
        if (ae.getSource() == this.addButton) {
            this.addLoadName(loadName);
        }
        if (ae.getSource() == this.deleteButton) {
            this.deleteLoadName();
        }
        if (ae.getSource() == this.replaceButton) {
            this.replaceLoadName(loadName);
        }
        if (ae.getSource() == this.saveButton) {
            this.saveLoadName();
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    private boolean checkLoadName(String loadName) {
        if (loadName.equals("")) {
            return false;
        }
        String[] splitLoadName = loadName.split("-");
        if (loadName.contains("-") && splitLoadName.length == 0) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("HyphenFeature"), Bundle.getMessage("canNotAdd", Bundle.getMessage("load")), 0);
            return false;
        }
        if (splitLoadName[0].length() > Control.max_len_string_attibute) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("carAttribute", Control.max_len_string_attibute), Bundle.getMessage("canNotUseLoadName"), 0);
            return false;
        }
        if (loadName.contains(" & ")) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("carNameNoAndChar", " & "), Bundle.getMessage("canNotUseLoadName"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected void comboBoxActionPerformed(ActionEvent ae) {
        log.debug("Combo box action");
        if (ae.getSource() == this.typeComboBox) {
            this._type = (String)this.typeComboBox.getSelectedItem();
            this.updateLoadComboBox();
            this.enableButtons();
        }
        this.updateCarQuanity();
        this.updateLoadType();
        this.updatePriority();
        this.updateHazardous();
        this.updateCarCommentFields();
    }

    @Override
    protected void checkBoxActionPerformed(ActionEvent ae) {
        this.typeComboBox.setEnabled(!this.allTypesCheckBox.isSelected());
    }

    private void addLoadName(String loadName) {
        if (this.allTypesCheckBox.isSelected()) {
            for (String type : this.carTypes.getNames()) {
                this.carLoads.addName(type, loadName);
            }
        } else {
            this.carLoads.addName(this._type, loadName);
        }
    }

    private void deleteLoadName() {
        String deleteLoad = (String)this.loadComboBox.getSelectedItem();
        if (deleteLoad.equals(this.carLoads.getDefaultEmptyName()) || deleteLoad.equals(this.carLoads.getDefaultLoadName())) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("carLoadDefault"), Bundle.getMessage("canNotDelete", Bundle.getMessage("Load")), 0);
            return;
        }
        if (this.allTypesCheckBox.isSelected()) {
            for (String type : this.carTypes.getNames()) {
                this.replaceLoad(type, deleteLoad, null);
                this.carLoads.deleteName(type, deleteLoad);
            }
        } else {
            this.replaceLoad(this._type, deleteLoad, null);
            this.carLoads.deleteName(this._type, deleteLoad);
        }
    }

    private void replaceLoadName(String loadName) {
        String oldLoadName = (String)this.loadComboBox.getSelectedItem();
        if (oldLoadName.equals(this.carLoads.getDefaultEmptyName())) {
            if (JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("replaceDefaultEmpty", oldLoadName, loadName), Bundle.getMessage("replaceAll"), 0) != 0) {
                return;
            }
            if (loadName.equals(this.carLoads.getDefaultEmptyName()) || loadName.equals(this.carLoads.getDefaultLoadName())) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("carDefault"), Bundle.getMessage("canNotReplace", Bundle.getMessage("Load")), 0);
                return;
            }
            this.carLoads.setDefaultEmptyName(loadName);
            this.replaceAllLoads(oldLoadName, loadName);
            return;
        }
        if (oldLoadName.equals(this.carLoads.getDefaultLoadName())) {
            if (JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("replaceDefaultLoad", oldLoadName, loadName), Bundle.getMessage("replaceAll"), 0) != 0) {
                return;
            }
            if (loadName.equals(this.carLoads.getDefaultEmptyName()) || loadName.equals(this.carLoads.getDefaultLoadName())) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("carDefault"), Bundle.getMessage("canNotReplace", Bundle.getMessage("Load")), 0);
                return;
            }
            this.carLoads.setDefaultLoadName(loadName);
            this.replaceAllLoads(oldLoadName, loadName);
            return;
        }
        if (JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("replaceMsg", oldLoadName, loadName), Bundle.getMessage("replaceAll"), 0) != 0) {
            return;
        }
        if (oldLoadName.equals(loadName)) {
            return;
        }
        String loadType = this.carLoads.getLoadType(this._type, oldLoadName);
        String loadPriority = this.carLoads.getPriority(this._type, oldLoadName);
        boolean isHazardous = this.carLoads.isHazardous(this._type, oldLoadName);
        String pickupComment = this.carLoads.getPickupComment(this._type, oldLoadName);
        String dropComment = this.carLoads.getDropComment(this._type, oldLoadName);
        if (this.allTypesCheckBox.isSelected()) {
            for (String type : this.carTypes.getNames()) {
                this.carLoads.addName(type, loadName);
                this.carLoads.setLoadType(type, loadName, loadType);
                this.carLoads.setPriority(type, loadName, loadPriority);
                this.carLoads.setHazardous(type, loadName, isHazardous);
                this.carLoads.setPickupComment(type, loadName, pickupComment);
                this.carLoads.setDropComment(type, loadName, dropComment);
                this.replaceLoad(type, oldLoadName, loadName);
                this.carLoads.deleteName(type, oldLoadName);
            }
        } else {
            this.carLoads.addName(this._type, loadName);
            this.carLoads.setLoadType(this._type, loadName, loadType);
            this.carLoads.setPriority(this._type, loadName, loadPriority);
            this.carLoads.setHazardous(this._type, loadName, isHazardous);
            this.carLoads.setPickupComment(this._type, loadName, pickupComment);
            this.carLoads.setDropComment(this._type, loadName, dropComment);
            this.replaceLoad(this._type, oldLoadName, loadName);
            this.carLoads.deleteName(this._type, oldLoadName);
        }
    }

    private void saveLoadName() {
        if (this.allTypesCheckBox.isSelected()) {
            for (String type : this.carTypes.getNames()) {
                this.saveLoadName(type);
            }
        } else {
            this.saveLoadName(this._type);
        }
    }

    private void saveLoadName(String type) {
        this.carLoads.setLoadType(type, (String)this.loadComboBox.getSelectedItem(), (String)this.loadTypeComboBox.getSelectedItem());
        this.carLoads.setPriority(type, (String)this.loadComboBox.getSelectedItem(), (String)this.priorityComboBox.getSelectedItem());
        this.carLoads.setHazardous(type, (String)this.loadComboBox.getSelectedItem(), this.hazardousComboBox.getSelectedItem().equals(Bundle.getMessage("ButtonYes")));
        this.carLoads.setPickupComment(type, (String)this.loadComboBox.getSelectedItem(), this.pickupCommentTextField.getText());
        this.carLoads.setDropComment(type, (String)this.loadComboBox.getSelectedItem(), this.dropCommentTextField.getText());
    }

    private void replaceAllLoads(String oldLoad, String newLoad) {
        for (String type : this.carTypes.getNames()) {
            if (this.carLoads.containsName(type, newLoad)) {
                this.carLoads.deleteName(type, newLoad);
            }
            this.carLoads.addName(type, newLoad);
            this.replaceLoad(type, oldLoad, newLoad);
            this.carLoads.deleteName(type, oldLoad);
        }
    }

    private void replaceLoad(String type, String oldLoad, String newLoad) {
        InstanceManager.getDefault(CarManager.class).replaceLoad(type, oldLoad, newLoad);
        InstanceManager.getDefault(ScheduleManager.class).replaceLoad(type, oldLoad, newLoad);
        InstanceManager.getDefault(TrainManager.class).replaceLoad(type, oldLoad, newLoad);
        InstanceManager.getDefault(LocationManager.class).replaceLoad(type, oldLoad, newLoad);
    }

    public void toggleShowQuanity() {
        this.showQuanity = !this.showQuanity;
        this.quanity.setVisible(this.showQuanity);
        this.updateCarQuanity();
    }

    private void updateCarQuanity() {
        if (!this.showQuanity) {
            return;
        }
        int number = 0;
        String item = (String)this.loadComboBox.getSelectedItem();
        for (Car car : InstanceManager.getDefault(CarManager.class).getList()) {
            if (!car.getLoadName().equals(item)) continue;
            ++number;
        }
        this.quanity.setText(Integer.toString(number));
    }

    private void updateLoadComboBox() {
        this.carLoads.updateComboBox(this._type, this.loadComboBox);
        this.loadComboBox.setSelectedItem(this.addTextBox.getText().trim());
    }

    private void updateLoadType() {
        String loadName = (String)this.loadComboBox.getSelectedItem();
        this.loadTypeComboBox.setSelectedItem(this.carLoads.getLoadType(this._type, loadName));
        if (loadName != null && (loadName.equals(InstanceManager.getDefault(CarLoads.class).getDefaultEmptyName()) || loadName.equals(InstanceManager.getDefault(CarLoads.class).getDefaultLoadName()))) {
            this.loadTypeComboBox.setEnabled(false);
        } else {
            this.loadTypeComboBox.setEnabled(true);
        }
    }

    private void updatePriority() {
        this.priorityComboBox.setSelectedItem(this.carLoads.getPriority(this._type, (String)this.loadComboBox.getSelectedItem()));
    }

    private void updateHazardous() {
        this.hazardousComboBox.setSelectedItem(this.carLoads.isHazardous(this._type, (String)this.loadComboBox.getSelectedItem()) ? Bundle.getMessage("ButtonYes") : Bundle.getMessage("ButtonNo"));
    }

    private void updateCarCommentFields() {
        this.pickupCommentTextField.setText(this.carLoads.getPickupComment(this._type, (String)this.loadComboBox.getSelectedItem()));
        this.dropCommentTextField.setText(this.carLoads.getDropComment(this._type, (String)this.loadComboBox.getSelectedItem()));
    }

    private void enableButtons() {
        this.addButton.setEnabled(this._type != null);
        this.deleteButton.setEnabled(this._type != null);
        this.replaceButton.setEnabled(this._type != null);
        this.saveButton.setEnabled(this._type != null);
    }

    @Override
    public void dispose() {
        this.carLoads.removePropertyChangeListener(this);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("CarLoads_Load")) {
            this.updateLoadComboBox();
        }
    }
}

