/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars.tools;

import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.swing.AbstractAction;
import jmri.InstanceManager;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManagerXml;
import jmri.jmrit.operations.rollingstock.cars.gui.CarSetFrame;
import jmri.jmrit.operations.rollingstock.cars.tools.Bundle;
import jmri.jmrit.operations.router.Router;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.TrainPrintUtilities;
import jmri.jmrit.operations.trains.TrainUtilities;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarRoutingReportAction
extends AbstractAction {
    CarSetFrame _csFrame;
    boolean _isPreview;
    private static final Logger log = LoggerFactory.getLogger(CarRoutingReportAction.class);

    public CarRoutingReportAction(CarSetFrame frame, boolean isPreview) {
        super(isPreview ? Bundle.getMessage("MenuPreviewRoutingReport") : Bundle.getMessage("MenuPrintRoutingReport"));
        this._csFrame = frame;
        this._isPreview = isPreview;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.createCarRoutingReport(this._csFrame._car);
    }

    private void createCarRoutingReport(Car car) {
        if (car != null && car.getLocation() != null && car.getFinalDestination() != null) {
            PrintWriter printWriter = this.getCarRouterBuildReportPrintWriter(car);
            Router router = InstanceManager.getDefault(Router.class);
            router.isCarRouteable(car, null, car.getFinalDestination(), car.getFinalDestinationTrack(), printWriter);
            this.showCarRoutingReport(car);
        } else {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("WarnMsgNoLocOrFD"), Bundle.getMessage("WarnMsgNoLocOrFD"), 2);
        }
    }

    private PrintWriter getCarRouterBuildReportPrintWriter(Car car) {
        PrintWriter printWriter = null;
        File file = InstanceManager.getDefault(CarManagerXml.class).createRawCarRouterReportFile(car.toString());
        try {
            printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), true);
        }
        catch (IOException e) {
            log.error("Can not open build report file: {}", (Object)e.getLocalizedMessage());
        }
        return printWriter;
    }

    private void showCarRoutingReport(Car car) {
        CarManagerXml carManagerXml = InstanceManager.getDefault(CarManagerXml.class);
        TrainPrintUtilities.editReport(carManagerXml.getRawCarRouterReportFile(car.toString()), carManagerXml.createCarRouterReportFile(car.toString()));
        File file = carManagerXml.getCarRouterReportFile(car.toString());
        if (this._isPreview && Setup.isBuildReportEditorEnabled()) {
            TrainUtilities.openDesktop(file);
        } else {
            TrainPrintUtilities.printReport(file, Bundle.getMessage("RoutingReportCar", car.toString()), this._isPreview, "", false, "", "", Setup.PORTRAIT, Setup.getBuildReportFontSize(), true, null);
        }
    }
}

