/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars.tools;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JTable;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.gui.CarSetFrame;
import jmri.jmrit.operations.rollingstock.cars.gui.CarsTableModel;
import jmri.jmrit.operations.rollingstock.cars.tools.Bundle;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarsSetFrame
extends CarSetFrame {
    CarsTableModel _carsTableModel;
    JTable _carsTable;
    private static boolean ignoreStatusCheckBoxSelected = true;
    private static boolean ignoreLocationCheckBoxSelected = true;
    private static boolean ignoreDivisionCheckBoxSelected = true;
    private static boolean ignoreRWECheckBoxSelected = true;
    private static boolean ignoreRWLCheckBoxSelected = true;
    private static boolean ignoreLoadCheckBoxSelected = true;
    private static boolean ignoreKernelCheckBoxSelected = true;
    private static boolean ignoreDestinationCheckBoxSelected = true;
    private static boolean ignoreFinalDestinationCheckBoxSelected = true;
    private static boolean ignoreTrainCheckBoxSelected = true;
    boolean toggle = false;
    private static final Logger log = LoggerFactory.getLogger(CarsSetFrame.class);

    public void initComponents(JTable carsTable) {
        this._carsTable = carsTable;
        this._carsTableModel = (CarsTableModel)carsTable.getModel();
        super.initComponents("package.jmri.jmrit.operations.Operations_SetCars");
        this.setTitle(Bundle.getMessage("TitleSetCars"));
        this.saveButton.setText(Bundle.getMessage("ButtonApply"));
        this.ignoreStatusCheckBox.setVisible(true);
        this.ignoreLocationCheckBox.setVisible(true);
        this.ignoreDivisionCheckBox.setVisible(true);
        this.ignoreRWECheckBox.setVisible(true);
        this.ignoreRWLCheckBox.setVisible(true);
        this.ignoreLoadCheckBox.setVisible(true);
        this.ignoreKernelCheckBox.setVisible(true);
        this.ignoreDestinationCheckBox.setVisible(true);
        this.ignoreFinalDestinationCheckBox.setVisible(true);
        this.ignoreTrainCheckBox.setVisible(true);
        this.ignoreAllButton.setVisible(true);
        this.ignoreStatusCheckBox.setSelected(ignoreStatusCheckBoxSelected);
        this.ignoreLocationCheckBox.setSelected(ignoreLocationCheckBoxSelected);
        this.ignoreDivisionCheckBox.setSelected(ignoreDivisionCheckBoxSelected);
        this.ignoreRWECheckBox.setSelected(ignoreRWECheckBoxSelected);
        this.ignoreRWLCheckBox.setSelected(ignoreRWLCheckBoxSelected);
        this.ignoreLoadCheckBox.setSelected(ignoreLoadCheckBoxSelected);
        this.ignoreKernelCheckBox.setSelected(ignoreKernelCheckBoxSelected);
        this.ignoreDestinationCheckBox.setSelected(ignoreDestinationCheckBoxSelected);
        this.ignoreFinalDestinationCheckBox.setSelected(ignoreFinalDestinationCheckBoxSelected);
        this.ignoreTrainCheckBox.setSelected(ignoreTrainCheckBoxSelected);
        int[] rows = this._carsTable.getSelectedRows();
        if (rows.length > 0) {
            Car car = this._carsTableModel.getCarAtIndex(this._carsTable.convertRowIndexToModel(rows[0]));
            super.load(car);
        } else {
            this.enableComponents(true);
            this.showMessageDialogWarning();
        }
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        super.buttonActionPerformed(ae);
        if (ae.getSource() == this.ignoreAllButton) {
            this.ignoreAll(this.toggle);
        }
    }

    protected void ignoreAll(boolean b) {
        this.ignoreStatusCheckBox.setSelected(!this.locationUnknownCheckBox.isSelected() & b);
        this.ignoreLocationCheckBox.setSelected(b);
        this.ignoreDivisionCheckBox.setSelected(b);
        this.ignoreRWECheckBox.setSelected(b);
        this.ignoreRWLCheckBox.setSelected(b);
        this.ignoreLoadCheckBox.setSelected(b);
        this.ignoreKernelCheckBox.setSelected(b);
        this.ignoreDestinationCheckBox.setSelected(b);
        this.ignoreFinalDestinationCheckBox.setSelected(b);
        this.ignoreTrainCheckBox.setSelected(b);
        this.enableComponents(!this.locationUnknownCheckBox.isSelected());
        this.toggle = !b;
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GUI ease of use")
    protected boolean save() {
        ignoreStatusCheckBoxSelected = this.ignoreStatusCheckBox.isSelected();
        ignoreLocationCheckBoxSelected = this.ignoreLocationCheckBox.isSelected();
        ignoreDivisionCheckBoxSelected = this.ignoreDivisionCheckBox.isSelected();
        ignoreRWECheckBoxSelected = this.ignoreRWECheckBox.isSelected();
        ignoreRWLCheckBoxSelected = this.ignoreRWLCheckBox.isSelected();
        ignoreLoadCheckBoxSelected = this.ignoreLoadCheckBox.isSelected();
        ignoreKernelCheckBoxSelected = this.ignoreKernelCheckBox.isSelected();
        ignoreDestinationCheckBoxSelected = this.ignoreKernelCheckBox.isSelected();
        ignoreFinalDestinationCheckBoxSelected = this.ignoreFinalDestinationCheckBox.isSelected();
        ignoreTrainCheckBoxSelected = this.ignoreTrainCheckBox.isSelected();
        ArrayList<Car> cars = new ArrayList<Car>();
        int[] rows = this._carsTable.getSelectedRows();
        for (int row : rows) {
            Car car = this._carsTableModel.getCarAtIndex(this._carsTable.convertRowIndexToModel(row));
            log.debug("Adding selected car {} to change list", (Object)car.toString());
            cars.add(car);
        }
        if (rows.length == 0) {
            this.showMessageDialogWarning();
            return false;
        }
        if (cars.get(0) != this._car) {
            log.debug("Default car isn't the first one selected");
            if (JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("doYouWantToChange", ((Car)cars.get(0)).toString()), Bundle.getMessage("changeDefaultCar"), 0) == 0) {
                super.load((Car)cars.get(0));
                return false;
            }
        }
        this.askKernelChange = false;
        Object object = cars.iterator();
        block1: while (object.hasNext()) {
            Car car = (Car)object.next();
            if (car.getKernel() == null) continue;
            for (Car c : car.getKernel().getCars()) {
                if (cars.contains(c)) continue;
                this.askKernelChange = true;
                continue block1;
            }
        }
        for (Car car : cars) {
            if (!super.change(car)) {
                return false;
            }
            if (car.getKernel() == null || this.ignoreKernelCheckBox.isSelected()) continue;
            this.askKernelChange = false;
        }
        return false;
    }

    private void showMessageDialogWarning() {
        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("selectCars"), Bundle.getMessage("carNoneSelected"), 2);
    }
}

