/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars.tools;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import jmri.InstanceManager;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.gui.CarsTableFrame;
import jmri.jmrit.operations.rollingstock.cars.tools.Bundle;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteCarRosterAction
extends AbstractAction {
    CarsTableFrame _carsTableFrame;
    private static final Logger log = LoggerFactory.getLogger(DeleteCarRosterAction.class);

    public DeleteCarRosterAction(CarsTableFrame carsTableFrame) {
        super(Bundle.getMessage("MenuItemDelete"));
        if (carsTableFrame.carsTableModel.trackName != null) {
            String actionName = Bundle.getMessage("MenuDeleteCarsTrack", carsTableFrame.carsTableModel.trackName);
            this.putValue("Name", actionName);
        } else if (carsTableFrame.carsTableModel.locationName != null) {
            String actionName = Bundle.getMessage("MenuDeleteCarsLocation", carsTableFrame.carsTableModel.locationName);
            this.putValue("Name", actionName);
        }
        this._carsTableFrame = carsTableFrame;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this._carsTableFrame.carsTableModel.trackName == null && this._carsTableFrame.carsTableModel.locationName == null) {
            if (JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("carSureDelete"), Bundle.getMessage("carDeleteAll"), 2) == 0) {
                log.debug("removing all cars from roster");
                InstanceManager.getDefault(CarManager.class).deleteAll();
            }
        } else {
            String message = Bundle.getMessage("carDeleteCarsTrack", this._carsTableFrame.carsTableModel.trackName);
            if (this._carsTableFrame.carsTableModel.trackName == null) {
                message = Bundle.getMessage("carDeleteCarsLocation", this._carsTableFrame.carsTableModel.locationName);
            }
            if (JmriJOptionPane.showConfirmDialog(null, message, Bundle.getMessage("carDeleteAll"), 2) == 0) {
                for (Car car : this._carsTableFrame.carsTableModel.getSelectedCarList()) {
                    InstanceManager.getDefault(CarManager.class).deregister(car);
                }
            }
        }
    }
}

