/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import jmri.jmrit.XmlFile;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.tools.Bundle;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.swing.JmriJOptionPane;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportCars
extends XmlFile {
    protected static final String LOCATION_TRACK_SEPARATOR = "-";
    List<Car> _carList;
    private static String operationsFileName = "ExportOperationsCarRoster.csv";
    private static final Logger log = LoggerFactory.getLogger(ExportCars.class);

    public ExportCars(List<Car> carList) {
        this._carList = carList;
    }

    public void writeOperationsCarFile() {
        this.makeBackupFile(ExportCars.defaultOperationsFilename());
        try {
            if (!this.checkFile(ExportCars.defaultOperationsFilename())) {
                File file = new File(ExportCars.defaultOperationsFilename());
                File parentDir = file.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdir()) {
                    log.error("Directory wasn't created");
                }
                if (file.createNewFile()) {
                    log.debug("File created");
                }
            }
            this.writeFile(ExportCars.defaultOperationsFilename());
        }
        catch (IOException e) {
            log.error("Exception while writing the new CSV operations file, may not be complete: {}", (Object)e.getLocalizedMessage());
        }
    }

    private void writeFile(String name) {
        log.debug("writeFile {}", (Object)name);
        File file = this.findFile(name);
        if (file == null) {
            file = new File(name);
        }
        try (CSVPrinter fileOut = new CSVPrinter((Appendable)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), CSVFormat.DEFAULT);){
            fileOut.printRecord(new Object[]{Bundle.getMessage("Number"), Bundle.getMessage("Road"), Bundle.getMessage("Type"), Bundle.getMessage("Length"), Bundle.getMessage("Weight"), Bundle.getMessage("Color"), Bundle.getMessage("Owner"), Bundle.getMessage("Built"), Bundle.getMessage("Location"), LOCATION_TRACK_SEPARATOR, Bundle.getMessage("Track"), Bundle.getMessage("Load"), Bundle.getMessage("Kernel"), Bundle.getMessage("Moves"), Setup.getValueLabel(), Bundle.getMessage("Comment"), Bundle.getMessage("Miscellaneous"), Bundle.getMessage("Extensions"), Bundle.getMessage("Wait"), Bundle.getMessage("Pickup"), Bundle.getMessage("Last"), Bundle.getMessage("RWELocation"), LOCATION_TRACK_SEPARATOR, Bundle.getMessage("Track"), Bundle.getMessage("RWELoad"), Bundle.getMessage("RWLLocation"), LOCATION_TRACK_SEPARATOR, Bundle.getMessage("Track"), Bundle.getMessage("RWLLoad"), Bundle.getMessage("Division"), Bundle.getMessage("Train"), Bundle.getMessage("Destination"), LOCATION_TRACK_SEPARATOR, Bundle.getMessage("Track"), Bundle.getMessage("FinalDestination"), LOCATION_TRACK_SEPARATOR, Bundle.getMessage("Track"), Bundle.getMessage("SchId"), Bundle.getMessage("RFID_Tag"), Bundle.getMessage("RoutePath"), Bundle.getMessage("LastLocation"), LOCATION_TRACK_SEPARATOR, Bundle.getMessage("Track"), Bundle.getMessage("LastTrain")});
            for (Car car : this._carList) {
                fileOut.printRecord(new Object[]{car.getNumber(), car.getRoadName(), car.getTypeName(), car.getLength(), car.getWeight(), car.getColor(), car.getOwnerName(), car.getBuilt(), car.getLocationName(), LOCATION_TRACK_SEPARATOR, car.getTrackName(), car.getLoadName(), car.getKernelName(), car.getMoves(), car.getValue(), car.getComment(), car.isOutOfService() ? Bundle.getMessage("OutOfService") : "", car.getTypeExtensions(), car.getWait(), car.getPickupScheduleName(), car.getSortDate(), car.getReturnWhenEmptyDestinationName(), LOCATION_TRACK_SEPARATOR, car.getReturnWhenEmptyDestTrackName(), car.getReturnWhenEmptyLoadName(), car.getReturnWhenLoadedDestinationName(), LOCATION_TRACK_SEPARATOR, car.getReturnWhenLoadedDestTrackName(), car.getReturnWhenLoadedLoadName(), car.getDivisionName(), car.getTrainName(), car.getDestinationName(), LOCATION_TRACK_SEPARATOR, car.getDestinationTrackName(), car.getFinalDestinationName(), LOCATION_TRACK_SEPARATOR, car.getFinalDestinationTrackName(), car.getScheduleItemId(), car.getRfid(), car.getRoutePath(), car.getLastLocationName(), LOCATION_TRACK_SEPARATOR, car.getLastTrackName(), car.getLastTrainName()});
            }
            fileOut.flush();
            fileOut.close();
            log.info("Exported {} cars to file {}", (Object)this._carList.size(), (Object)ExportCars.defaultOperationsFilename());
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ExportedCarsToFile", this._carList.size(), ExportCars.defaultOperationsFilename()), Bundle.getMessage("ExportComplete"), 1);
        }
        catch (IOException e) {
            log.error("Can not open export cars CSV file: {}", (Object)e.getLocalizedMessage());
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ExportedCarsToFile", 0, ExportCars.defaultOperationsFilename()), Bundle.getMessage("ExportFailed"), 0);
        }
    }

    public static String defaultOperationsFilename() {
        return OperationsSetupXml.getFileLocation() + OperationsSetupXml.getOperationsDirectoryName() + File.separator + ExportCars.getOperationsFileName();
    }

    public static void setOperationsFileName(String name) {
        operationsFileName = name;
    }

    public static String getOperationsFileName() {
        return operationsFileName;
    }
}

