/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.divisions.Division;
import jmri.jmrit.operations.locations.divisions.DivisionManager;
import jmri.jmrit.operations.rollingstock.ImportCommon;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarColors;
import jmri.jmrit.operations.rollingstock.cars.CarLengths;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarOwners;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.cars.Kernel;
import jmri.jmrit.operations.rollingstock.cars.KernelManager;
import jmri.jmrit.operations.rollingstock.cars.tools.Bundle;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportCars
extends ImportCommon {
    CarManager carManager = InstanceManager.getDefault(CarManager.class);
    private int weightResults = 1;
    private boolean autoCalculate = true;
    private boolean askAutoCreateTypes = true;
    private boolean askAutoCreateLocations = true;
    private boolean askAutoCreateTracks = true;
    private boolean askAutoLocationType = true;
    private boolean askAutoIncreaseTrackLength = true;
    private boolean askAutoForceCar = true;
    private boolean autoCreateTypes = false;
    private boolean autoCreateLocations = false;
    private boolean autoCreateTracks = false;
    private boolean autoAdjustLocationType = false;
    private boolean autoAdjustTrackLength = false;
    private boolean autoForceCar = false;
    private final boolean autoCreateRoads = true;
    private final boolean autoCreateLoads = true;
    private final boolean autoCreateLengths = true;
    private final boolean autoCreateColors = true;
    private final boolean autoCreateOwners = true;
    private static final int CAR_NUMBER = 0;
    private static final int CAR_ROAD = 1;
    private static final int CAR_TYPE = 2;
    private static final int CAR_LENGTH = 3;
    private static final int CAR_WEIGHT = 4;
    private static final int CAR_COLOR = 5;
    private static final int CAR_OWNER = 6;
    private static final int CAR_BUILT = 7;
    private static final int CAR_LOCATION = 8;
    private static final int CAR_LOCATION_TRACK_SEPARATOR = 9;
    private static final int CAR_TRACK = 10;
    private static final int CAR_LOAD = 11;
    private static final int CAR_KERNEL = 12;
    private static final int CAR_MOVES = 13;
    private static final int CAR_VALUE = 14;
    private static final int CAR_COMMENT = 15;
    private static final int CAR_MISCELLANEOUS = 16;
    private static final int CAR_EXTENSIONS = 17;
    private static final int CAR_RWE_DESTINATION = 21;
    private static final int CAR_RWE_TRACK = 23;
    private static final int CAR_RWE_LOAD = 24;
    private static final int CAR_RWL_DESTINATION = 25;
    private static final int CAR_RWL_TRACK = 27;
    private static final int CAR_RWL_LOAD = 28;
    private static final int CAR_DIVISION = 29;
    private static final int CAR_TRAIN = 30;
    private static final int CAR_DESTINATION = 31;
    private static final int CAR_DEST_TRACK = 33;
    private static final int CAR_FINAL_DESTINATION = 34;
    private static final int CAR_FINAL_TRACK = 36;
    private static final int CAR_SCH_ID = 37;
    private static final int CAR_RFID_TAG = 38;
    private static final Logger log = LoggerFactory.getLogger(ImportCars.class);

    @Override
    public void run() {
        int carsAdded;
        boolean importOkay;
        BufferedReader in;
        block125: {
            File file = this.getFile();
            if (file == null) {
                return;
            }
            in = this.getBufferedReader(file);
            if (in == null) {
                return;
            }
            this.createStatusFrame(Bundle.getMessage("ImportCars"));
            importOkay = false;
            boolean comma = false;
            boolean importKernel = false;
            int lineNum = 0;
            carsAdded = 0;
            String line = " ";
            String carColor = "";
            String carOwner = "";
            String carBuilt = "";
            String carLocationName = "";
            String carTrackName = "";
            String carLoadName = "";
            String carKernelName = "";
            int carMoves = 0;
            String carValue = "";
            String carComment = "";
            if (file.getAbsolutePath().endsWith(".csv")) {
                log.info("Using comma as delimiter for import cars");
                comma = true;
            }
            while (true) {
                String carRoad;
                String carNumber;
                this.lineNumber.setText(Bundle.getMessage("LineNumber") + " " + Integer.toString(++lineNum));
                try {
                    line = in.readLine();
                }
                catch (IOException e) {
                    break block125;
                }
                if (line == null) {
                    importOkay = true;
                    break block125;
                }
                if (!this.fstatus.isShowing()) break block125;
                line = line.trim();
                log.debug("Import: {}", (Object)line);
                this.importLine.setText(line);
                if (line.startsWith(Bundle.getMessage("Number"))) continue;
                if (line.equalsIgnoreCase("kernel")) {
                    log.info("Importing kernel names");
                    importKernel = true;
                    continue;
                }
                if (line.equalsIgnoreCase("comma")) {
                    log.info("Using comma as delimiter for import cars");
                    comma = true;
                    continue;
                }
                String[] inputLine = comma ? this.parseCommaLine(line) : line.split("\\s+");
                if (inputLine.length < 1 || line.isEmpty()) {
                    log.debug("Skipping blank line");
                    continue;
                }
                int base = 1;
                if (comma || !inputLine[0].isEmpty()) {
                    --base;
                }
                if (inputLine.length > base + 3) {
                    String status;
                    String newTag;
                    Location destination;
                    Track rweTrack;
                    int results;
                    Car existingCar;
                    String carWeight;
                    String carLength;
                    String carType;
                    block127: {
                        block126: {
                            carNumber = inputLine[base + 0].trim();
                            carRoad = inputLine[base + 1].trim();
                            carType = inputLine[base + 2].trim();
                            carLength = inputLine[base + 3].trim();
                            carWeight = "0";
                            carColor = "";
                            carOwner = "";
                            carBuilt = "";
                            carLocationName = "";
                            carTrackName = "";
                            carLoadName = InstanceManager.getDefault(CarLoads.class).getDefaultEmptyName();
                            carKernelName = "";
                            carMoves = 0;
                            carValue = "";
                            carComment = "";
                            if (inputLine.length > base + 4) {
                                carWeight = inputLine[base + 4].trim();
                            }
                            if (inputLine.length > base + 5) {
                                carColor = inputLine[base + 5].trim();
                            }
                            log.debug("Checking car number ({}) road ({}) type ({}) length ({}) weight ({}) color ({})", new Object[]{carNumber, carRoad, carType, carLength, carWeight, carColor});
                            if (carNumber.isEmpty()) {
                                log.info("Import line {} missing car number", (Object)lineNum);
                                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("RoadNumberNotSpecified", lineNum), Bundle.getMessage("RoadNumberMissing"), 0);
                                break block125;
                            }
                            if (carRoad.isEmpty()) {
                                log.info("Import line {} missing car road", (Object)lineNum);
                                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("RoadNameNotSpecified", lineNum), Bundle.getMessage("RoadNameMissing"), 0);
                                break block125;
                            }
                            if (carType.isEmpty()) {
                                log.info("Import line {} missing car type", (Object)lineNum);
                                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CarTypeNotSpecified", carRoad, carNumber, lineNum), Bundle.getMessage("CarTypeMissing"), 0);
                                break block125;
                            }
                            if (carLength.isEmpty()) {
                                log.info("Import line {} missing car length", (Object)lineNum);
                                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CarLengthNotSpecified", carRoad, carNumber, lineNum), Bundle.getMessage("CarLengthMissing"), 0);
                                break block125;
                            }
                            if (TrainCommon.splitString(carNumber).length() > Control.max_len_string_road_number) {
                                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CarRoadNumberTooLong", carRoad, carNumber, carNumber), Bundle.getMessage("RoadNumMustBeLess", Control.max_len_string_road_number + 1), 0);
                                break block125;
                            }
                            try {
                                if (carRoad.split("-")[0].length() > Control.max_len_string_attibute) {
                                    JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CarRoadNameTooLong", carRoad, carNumber, carRoad), Bundle.getMessage("carAttribute", Control.max_len_string_attibute), 0);
                                }
                                break block126;
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CarRoadNameWrong", carRoad, lineNum), Bundle.getMessage("CarAttributeMissing"), 0);
                                log.error("Road ({}) name not valid line {}", (Object)carRoad, (Object)lineNum);
                            }
                            break block125;
                        }
                        try {
                            if (carType.split("-")[0].length() > Control.max_len_string_attibute) {
                                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CarTypeNameTooLong", carRoad, carNumber, carType), Bundle.getMessage("carAttribute", Control.max_len_string_attibute), 0);
                            }
                            break block127;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CarTypeNameWrong", carType, lineNum), Bundle.getMessage("CarAttributeMissing"), 0);
                            log.error("Type ({}) name not valid line {}", (Object)carType, (Object)lineNum);
                        }
                        break block125;
                    }
                    if (!InstanceManager.getDefault(CarTypes.class).containsName(carType)) {
                        if (this.autoCreateTypes) {
                            log.debug("Adding car type ({})", (Object)carType);
                            InstanceManager.getDefault(CarTypes.class).addName(carType);
                        } else {
                            int results2 = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("Car") + " (" + carRoad + " " + carNumber + ")\n" + Bundle.getMessage("typeNameNotExist", carType), Bundle.getMessage("carAddType"), 1);
                            if (results2 == 0) {
                                InstanceManager.getDefault(CarTypes.class).addName(carType);
                                if (this.askAutoCreateTypes && (results2 = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToAutoAddCarTypes"), Bundle.getMessage("OnlyAskedOnce"), 0)) == 0) {
                                    this.autoCreateTypes = true;
                                }
                                this.askAutoCreateTypes = false;
                            } else if (results2 == 2) break block125;
                        }
                    }
                    if (carLength.length() > Control.max_len_string_length_name) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CarLengthNameTooLong", carRoad, carNumber, carLength), Bundle.getMessage("carAttribute", Control.max_len_string_length_name), 0);
                        break block125;
                    }
                    try {
                        Integer.parseInt(carLength);
                    }
                    catch (NumberFormatException e) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CarLengthNameNotNumber", carRoad, carNumber, carLength), Bundle.getMessage("CarLengthMissing"), 0);
                        break block125;
                    }
                    if (carWeight.length() > Control.max_len_string_weight_name) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CarWeightNameTooLong", carRoad, carNumber, carWeight), Bundle.getMessage("carAttribute", Control.max_len_string_weight_name), 0);
                        break block125;
                    }
                    if (carColor.length() > Control.max_len_string_attibute) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CarColorNameTooLong", carRoad, carNumber, carColor), Bundle.getMessage("carAttribute", Control.max_len_string_attibute), 0);
                        break block125;
                    }
                    if (carWeight.equals("0")) {
                        try {
                            carWeight = CarManager.calculateCarWeight(carLength);
                        }
                        catch (NumberFormatException e) {
                            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("carLengthMustBe"), Bundle.getMessage("carWeigthCanNot"), 0);
                        }
                    }
                    if ((existingCar = (Car)this.carManager.getByRoadAndNumber(carRoad, carNumber)) != null) {
                        log.info("Can not add, car number ({}) road ({}) already exists!", (Object)carNumber, (Object)carRoad);
                        continue;
                    }
                    if (inputLine.length > base + 6 && (carOwner = inputLine[base + 6].trim()).length() > Control.max_len_string_attibute) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CarOwnerNameTooLong", carRoad, carNumber, carOwner), Bundle.getMessage("carAttribute", Control.max_len_string_attibute), 0);
                        break block125;
                    }
                    if (inputLine.length > base + 7 && (carBuilt = inputLine[base + 7].trim()).length() > Control.max_len_string_built_name) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CarBuiltNameTooLong", carRoad, carNumber, carBuilt), Bundle.getMessage("carAttribute", Control.max_len_string_built_name), 0);
                        break block125;
                    }
                    if (inputLine.length > base + 8) {
                        carLocationName = inputLine[base + 8].trim();
                    }
                    if (comma && inputLine.length > base + 10) {
                        carTrackName = inputLine[base + 10].trim();
                    }
                    if (!comma) {
                        int i;
                        int j = 0;
                        StringBuffer name = new StringBuffer(carLocationName);
                        for (i = base + 9; i < inputLine.length; ++i) {
                            if (inputLine[i].equals("-")) {
                                j = i + 1;
                                break;
                            }
                            name.append(" " + inputLine[i]);
                        }
                        carLocationName = name.toString();
                        log.debug("Car ({} {}) has location ({})", new Object[]{carRoad, carNumber, carLocationName});
                        name = new StringBuffer();
                        if (j != 0 && j < inputLine.length) {
                            name.append(inputLine[j]);
                            for (i = j + 1; i < inputLine.length; ++i) {
                                name.append(" " + inputLine[i]);
                            }
                            log.debug("Car ({} {}) has track ({})", new Object[]{carRoad, carNumber, carTrackName});
                        }
                        carTrackName = name.toString();
                    }
                    if (comma && inputLine.length > 11) {
                        if (!inputLine[11].isBlank()) {
                            carLoadName = inputLine[11].trim();
                            log.debug("Car ({} {}) has load ({})", new Object[]{carRoad, carNumber, carLoadName});
                        }
                        if (carLoadName.length() > Control.max_len_string_attibute) {
                            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CarLoadNameTooLong", carRoad, carNumber, carLoadName), Bundle.getMessage("carAttribute", Control.max_len_string_attibute), 0);
                            break block125;
                        }
                    }
                    if (comma && inputLine.length > 12) {
                        carKernelName = inputLine[12].trim();
                        log.debug("Car ({} {}) has kernel name ({})", new Object[]{carRoad, carNumber, carKernelName});
                    }
                    if (comma && inputLine.length > 13 && !inputLine[13].trim().isEmpty()) {
                        try {
                            carMoves = Integer.parseInt(inputLine[13].trim());
                            log.debug("Car ({} {}) has move count ({})", new Object[]{carRoad, carNumber, carMoves});
                        }
                        catch (NumberFormatException e) {
                            log.error("Car ({} {}) has move count ({}) not a number", new Object[]{carRoad, carNumber, carMoves});
                        }
                    }
                    if (comma && inputLine.length > 14) {
                        carValue = inputLine[14].trim();
                    }
                    if (comma && inputLine.length > 15) {
                        carComment = inputLine[15];
                    }
                    if (TrainCommon.splitString(carLocationName).length() > Control.max_len_string_location_name) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CarLocationNameTooLong", carRoad, carNumber, carLocationName), Bundle.getMessage("carAttribute", Control.max_len_string_location_name), 0);
                        break block125;
                    }
                    if (TrainCommon.splitString(carTrackName).length() > Control.max_len_string_track_name) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CarTrackNameTooLong", carRoad, carNumber, carTrackName), Bundle.getMessage("carAttribute", Control.max_len_string_track_name), 0);
                        break block125;
                    }
                    Location location = InstanceManager.getDefault(LocationManager.class).getLocationByName(carLocationName);
                    Track track = null;
                    if (location == null && !carLocationName.isEmpty()) {
                        if (this.autoCreateLocations) {
                            log.debug("Create location ({})", (Object)carLocationName);
                            location = InstanceManager.getDefault(LocationManager.class).newLocation(carLocationName);
                        } else {
                            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CarLocationDoesNotExist", carRoad, carNumber, carLocationName), Bundle.getMessage("carLocation"), 0);
                            results = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToCreateLoc", carLocationName), Bundle.getMessage("carLocation"), 0);
                            if (results != 0) break block125;
                            log.debug("Create location ({})", (Object)carLocationName);
                            location = InstanceManager.getDefault(LocationManager.class).newLocation(carLocationName);
                            if (this.askAutoCreateLocations && (results = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToAutoCreateLoc"), Bundle.getMessage("OnlyAskedOnce"), 0)) == 0) {
                                this.autoCreateLocations = true;
                            }
                            this.askAutoCreateLocations = false;
                        }
                    }
                    if (location != null && !carTrackName.isEmpty() && (track = location.getTrackByName(carTrackName, null)) == null) {
                        if (this.autoCreateTracks) {
                            if (!location.isStaging()) {
                                log.debug("Create 1000 foot yard track ({})", (Object)carTrackName);
                                track = location.addTrack(carTrackName, "Yard");
                            } else {
                                log.debug("Create 1000 foot staging track ({})", (Object)carTrackName);
                                track = location.addTrack(carTrackName, "Staging");
                            }
                            track.setLength(1000);
                        } else {
                            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CarTrackDoesNotExist", carRoad, carNumber, carTrackName, carLocationName), Bundle.getMessage("carTrack"), 0);
                            results = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToCreateTrack", carTrackName, carLocationName), Bundle.getMessage("carTrack"), 0);
                            if (results != 0) break block125;
                            if (!location.isStaging()) {
                                log.debug("Create 1000 foot yard track ({})", (Object)carTrackName);
                                track = location.addTrack(carTrackName, "Yard");
                            } else {
                                log.debug("Create 1000 foot staging track ({})", (Object)carTrackName);
                                track = location.addTrack(carTrackName, "Staging");
                            }
                            track.setLength(1000);
                            if (this.askAutoCreateTracks) {
                                results = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToAutoCreateTrack"), Bundle.getMessage("OnlyAskedOnce"), 0);
                                if (results == 0) {
                                    this.autoCreateTracks = true;
                                }
                                this.askAutoCreateTracks = false;
                            }
                        }
                    }
                    log.debug("Add car ({} {}) owner ({}) built ({}) location ({}, {})", new Object[]{carRoad, carNumber, carOwner, carBuilt, carLocationName, carTrackName});
                    Car car = this.carManager.newRS(carRoad, carNumber);
                    car.setTypeName(carType);
                    car.setLength(carLength);
                    car.setWeight(carWeight);
                    car.setColor(carColor);
                    car.setOwnerName(carOwner);
                    car.setBuilt(carBuilt);
                    car.setLoadName(carLoadName);
                    car.setKernel(InstanceManager.getDefault(KernelManager.class).newKernel(carKernelName));
                    car.setMoves(carMoves);
                    car.setValue(carValue);
                    car.setComment(carComment);
                    ++carsAdded;
                    car.setCaboose(carType.equals("Caboose"));
                    if (comma && inputLine.length > 16) {
                        car.setOutOfService(inputLine[16].equals(Bundle.getMessage("OutOfService")));
                    }
                    if (comma && inputLine.length > 17) {
                        String extensions = inputLine[17];
                        log.debug("Car ({}) has extension ({})", (Object)car.toString(), (Object)extensions);
                        String[] ext = extensions.split(" ");
                        for (int i = 0; i < ext.length; ++i) {
                            if (ext[i].equals(Car.CABOOSE_EXTENSION)) {
                                car.setCaboose(true);
                            }
                            if (ext[i].equals(Car.FRED_EXTENSION)) {
                                car.setFred(true);
                            }
                            if (ext[i].equals(Car.PASSENGER_EXTENSION)) {
                                car.setPassenger(true);
                                car.setBlocking(Integer.parseInt(ext[i + 1]));
                            }
                            if (ext[i].equals(Car.UTILITY_EXTENSION)) {
                                car.setUtility(true);
                            }
                            if (!ext[i].equals(Car.HAZARDOUS_EXTENSION)) continue;
                            car.setCarHazardous(true);
                        }
                    }
                    if (comma && inputLine.length > 21) {
                        Location rweDestination = InstanceManager.getDefault(LocationManager.class).getLocationByName(inputLine[21]);
                        car.setReturnWhenEmptyDestination(rweDestination);
                        if (rweDestination != null && inputLine.length > 23) {
                            rweTrack = rweDestination.getTrackByName(inputLine[23], null);
                            car.setReturnWhenEmptyDestTrack(rweTrack);
                        }
                    }
                    if (comma && inputLine.length > 24 && !inputLine[24].isBlank()) {
                        car.setReturnWhenEmptyLoadName(inputLine[24].trim());
                    }
                    if (comma && inputLine.length > 25) {
                        Location rwlDestination = InstanceManager.getDefault(LocationManager.class).getLocationByName(inputLine[25]);
                        car.setReturnWhenLoadedDestination(rwlDestination);
                        if (rwlDestination != null && inputLine.length > 27) {
                            rweTrack = rwlDestination.getTrackByName(inputLine[27], null);
                            car.setReturnWhenLoadedDestTrack(rweTrack);
                        }
                    }
                    if (comma && inputLine.length > 28 && !inputLine[28].isBlank()) {
                        car.setReturnWhenLoadedLoadName(inputLine[28].trim());
                    }
                    if (comma && inputLine.length > 29) {
                        Division division = InstanceManager.getDefault(DivisionManager.class).getDivisionByName(inputLine[29].trim());
                        car.setDivision(division);
                    }
                    if (comma && inputLine.length > 30) {
                        Train train = InstanceManager.getDefault(TrainManager.class).getTrainByName(inputLine[30].trim());
                        car.setTrain(train);
                    }
                    if (comma && inputLine.length > 31 && (destination = InstanceManager.getDefault(LocationManager.class).getLocationByName(inputLine[31])) != null && inputLine.length > 33) {
                        Track destTrack = destination.getTrackByName(inputLine[33], null);
                        car.setDestination(destination, destTrack);
                    }
                    if (comma && inputLine.length > 34) {
                        Location finalDestination = InstanceManager.getDefault(LocationManager.class).getLocationByName(inputLine[34]);
                        car.setFinalDestination(finalDestination);
                        if (finalDestination != null && inputLine.length > 36) {
                            Track finalTrack = finalDestination.getTrackByName(inputLine[36], null);
                            car.setFinalDestinationTrack(finalTrack);
                        }
                    }
                    if (comma && inputLine.length > 37) {
                        car.setScheduleItemId(inputLine[37]);
                    }
                    if (comma && inputLine.length > 38 && !(newTag = inputLine[38]).trim().isEmpty()) {
                        InstanceManager.getDefault(IdTagManager.class).provideIdTag(newTag);
                        log.debug("New ID tag added - {}", (Object)newTag);
                        car.setRfid(newTag);
                    }
                    if (!InstanceManager.getDefault(CarRoads.class).containsName(carRoad)) {
                        log.debug("add car road {}", (Object)carRoad);
                        InstanceManager.getDefault(CarRoads.class).addName(carRoad);
                    }
                    if (!InstanceManager.getDefault(CarLoads.class).containsName(carLoadName)) {
                        log.debug("add car load {}", (Object)carLoadName);
                        InstanceManager.getDefault(CarLoads.class).addName(carType, carLoadName);
                    }
                    if (!InstanceManager.getDefault(CarLengths.class).containsName(carLength)) {
                        log.debug("add car length {}", (Object)carLength);
                        InstanceManager.getDefault(CarLengths.class).addName(carLength);
                    }
                    if (!InstanceManager.getDefault(CarColors.class).containsName(carColor)) {
                        log.debug("add car color {}", (Object)carColor);
                        InstanceManager.getDefault(CarColors.class).addName(carColor);
                    }
                    if (!InstanceManager.getDefault(CarOwners.class).containsName(carOwner)) {
                        log.debug("add car owner {}", (Object)carOwner);
                        InstanceManager.getDefault(CarOwners.class).addName(carOwner);
                    }
                    if (car.getWeight().isEmpty()) {
                        log.debug("Car ({}) weight not specified", (Object)car.toString());
                        if (this.weightResults != 2) {
                            this.weightResults = JmriJOptionPane.showOptionDialog(null, Bundle.getMessage("CarWeightNotFound", car.toString()), Bundle.getMessage("CarWeightMissing"), -1, 1, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonDontShow")}, this.autoCalculate ? Bundle.getMessage("ButtonYes") : Bundle.getMessage("ButtonNo"));
                        }
                        if (this.weightResults == 1) {
                            this.autoCalculate = false;
                        }
                        if (this.weightResults == 0 || this.autoCalculate && this.weightResults == 2) {
                            this.autoCalculate = true;
                            try {
                                carWeight = CarManager.calculateCarWeight(carLength);
                                car.setWeight(carWeight);
                                int tons = (int)(Double.parseDouble(carWeight) * (double)Setup.getScaleTonRatio());
                                if (car.isCaboose() || car.isPassenger()) {
                                    tons = (int)(Double.parseDouble(car.getLength()) * 0.9);
                                }
                                car.setWeightTons(Integer.toString(tons));
                            }
                            catch (NumberFormatException e) {
                                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("carLengthMustBe"), Bundle.getMessage("carWeigthCanNot"), 0);
                            }
                        }
                    }
                    if (location == null || track == null || (status = car.setLocation(location, track)).equals(Track.OKAY)) continue;
                    log.debug("Can't set car's location because of {}", (Object)status);
                    if (status.startsWith(Track.TYPE)) {
                        if (this.autoAdjustLocationType) {
                            location.addTypeName(carType);
                            track.addTypeName(carType);
                            status = car.setLocation(location, track);
                        } else {
                            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CanNotSetCarAtLocation", car.toString(), carType, carLocationName, carTrackName, status), Bundle.getMessage("rsCanNotLoc"), 0);
                            int results3 = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToAllowService", carLocationName, carTrackName, car.toString(), carType), Bundle.getMessage("ServiceCarType"), 0);
                            if (results3 != 0) break block125;
                            location.addTypeName(carType);
                            track.addTypeName(carType);
                            status = car.setLocation(location, track);
                            log.debug("Set car's location status: {}", (Object)status);
                            if (this.askAutoLocationType) {
                                results3 = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToAutoAdjustLocations"), Bundle.getMessage("OnlyAskedOnce"), 0);
                                if (results3 == 0) {
                                    this.autoAdjustLocationType = true;
                                }
                                this.askAutoLocationType = false;
                            }
                        }
                    }
                    if (status.startsWith(Track.LENGTH) || status.startsWith(Track.CAPACITY)) {
                        if (this.autoAdjustTrackLength) {
                            track.setLength(track.getLength() + 1000);
                            status = car.setLocation(location, track);
                            log.debug("Set track length status: {}", (Object)status);
                        } else {
                            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CanNotSetCarAtLocation", car.toString(), carType, carLocationName, carTrackName, status), Bundle.getMessage("rsCanNotLoc"), 0);
                            int results4 = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantIncreaseLength", carTrackName), Bundle.getMessage("TrackLength"), 0);
                            if (results4 != 0) break block125;
                            track.setLength(track.getLength() + 1000);
                            status = car.setLocation(location, track);
                            log.debug("Set track length status: {}", (Object)status);
                            if (this.askAutoIncreaseTrackLength) {
                                results4 = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToAutoAdjustTrackLength"), Bundle.getMessage("OnlyAskedOnce"), 0);
                                if (results4 == 0) {
                                    this.autoAdjustTrackLength = true;
                                }
                                this.askAutoIncreaseTrackLength = false;
                            }
                        }
                    }
                    if (status.equals(Track.OKAY)) continue;
                    if (this.autoForceCar) {
                        car.setLocation(location, track, true);
                        continue;
                    }
                    JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CanNotSetCarAtLocation", car.toString(), carType, carLocationName, carTrackName, status), Bundle.getMessage("rsCanNotLoc"), 0);
                    int results5 = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToForceCar", car.toString(), carLocationName, carTrackName), Bundle.getMessage("OverRide"), 0);
                    if (results5 == 0) {
                        car.setLocation(location, track, true);
                        if (!this.askAutoForceCar) continue;
                        results5 = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToAutoForceCar"), Bundle.getMessage("OnlyAskedOnce"), 0);
                        if (results5 == 0) {
                            this.autoForceCar = true;
                        }
                        this.askAutoForceCar = false;
                        continue;
                    }
                    break block125;
                }
                if (importKernel && inputLine.length == base + 3) {
                    carNumber = inputLine[base + 0].trim();
                    carRoad = inputLine[base + 1].trim();
                    String kernelName = inputLine[base + 2].trim();
                    Car car = (Car)this.carManager.getByRoadAndNumber(carRoad, carNumber);
                    if (car != null) {
                        Kernel kernel = InstanceManager.getDefault(KernelManager.class).newKernel(kernelName);
                        car.setKernel(kernel);
                        ++carsAdded;
                        continue;
                    }
                    log.info("Car number ({}) road ({}) does not exist!", (Object)carNumber, (Object)carRoad);
                    break block125;
                }
                if (!line.isEmpty()) break;
            }
            log.info("Car import line {} missing attributes: {}", (Object)lineNum, (Object)line);
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ImportMissingAttributes", lineNum) + "\n" + line + "\n" + Bundle.getMessage("ImportMissingAttributes2"), Bundle.getMessage("CarAttributeMissing"), 0);
        }
        try {
            in.close();
        }
        catch (IOException e) {
            log.error("Import cars failed: {}", (Object)e.getLocalizedMessage());
        }
        if (importOkay) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ImportCarsAdded", carsAdded), Bundle.getMessage("SuccessfulImport"), 1);
        } else {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ImportCarsAdded", carsAdded), Bundle.getMessage("ImportFailed"), 0);
        }
        this.fstatus.dispose();
    }
}

