/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars.tools;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractAction;
import jmri.InstanceManager;
import jmri.jmrit.operations.rollingstock.cars.CarLoad;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.cars.tools.Bundle;
import jmri.jmrit.operations.setup.Control;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintCarLoadsAction
extends AbstractAction {
    boolean _isPreview;
    private static final Logger log = LoggerFactory.getLogger(PrintCarLoadsAction.class);

    public PrintCarLoadsAction(boolean isPreview) {
        super(isPreview ? Bundle.getMessage("MenuItemCarLoadsPreview") : Bundle.getMessage("MenuItemCarLoadsPrint"));
        this._isPreview = isPreview;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new CarLoadPrintOption();
    }

    private static String tabString(String s, int fieldSize) {
        if (s.length() > fieldSize) {
            s = s.substring(0, fieldSize - 1);
        }
        StringBuffer buf = new StringBuffer(s + " ");
        while (buf.length() < fieldSize) {
            buf.append(" ");
        }
        return buf.toString();
    }

    public class CarLoadPrintOption {
        static final String TAB = "\t";
        static final String NEW_LINE = "\n";

        public CarLoadPrintOption() {
            this.printCars();
        }

        private void printCars() {
            try (HardcopyWriter writer = new HardcopyWriter(new Frame(), Bundle.getMessage("TitleCarLoads"), Control.reportFontSize, 0.5, 0.5, 0.5, 0.5, PrintCarLoadsAction.this._isPreview);){
                String[] carTypes = InstanceManager.getDefault(CarTypes.class).getNames();
                Hashtable<String, List<CarLoad>> list = InstanceManager.getDefault(CarLoads.class).getList();
                String header = Bundle.getMessage("Type") + TAB + PrintCarLoadsAction.tabString(Bundle.getMessage("Load"), InstanceManager.getDefault(CarLoads.class).getMaxNameLength() + 1) + Bundle.getMessage("Type") + "  " + Bundle.getMessage("Priority") + "  " + PrintCarLoadsAction.tabString(Bundle.getMessage("Hazardous"), 4) + Bundle.getMessage("LoadPickupMessage") + "   " + Bundle.getMessage("LoadDropMessage") + NEW_LINE;
                writer.write(header);
                for (String carType : carTypes) {
                    List<CarLoad> carLoads = list.get(carType);
                    if (carLoads == null) continue;
                    boolean printType = true;
                    for (CarLoad carLoad : carLoads) {
                        if ((carLoad.getName().equals(InstanceManager.getDefault(CarLoads.class).getDefaultEmptyName()) || carLoad.getName().equals(InstanceManager.getDefault(CarLoads.class).getDefaultLoadName())) && carLoad.getPickupComment().equals("") && carLoad.getDropComment().equals("") && carLoad.getPriority().equals(CarLoad.PRIORITY_LOW) && !carLoad.isHazardous()) continue;
                        if (printType) {
                            writer.write(carType + NEW_LINE);
                            printType = false;
                        }
                        StringBuffer buf = new StringBuffer(TAB);
                        buf.append(PrintCarLoadsAction.tabString(carLoad.getName(), InstanceManager.getDefault(CarLoads.class).getMaxNameLength() + 1));
                        buf.append(PrintCarLoadsAction.tabString(carLoad.getLoadType(), 6));
                        buf.append(PrintCarLoadsAction.tabString(carLoad.getPriority(), 5));
                        buf.append(PrintCarLoadsAction.tabString(carLoad.isHazardous() ? Bundle.getMessage("ButtonYes") : Bundle.getMessage("ButtonNo"), 4));
                        buf.append(PrintCarLoadsAction.tabString(carLoad.getPickupComment(), 27));
                        buf.append(PrintCarLoadsAction.tabString(carLoad.getDropComment(), 27));
                        writer.write(buf.toString() + NEW_LINE);
                    }
                }
            }
            catch (HardcopyWriter.PrintCanceledException ex) {
                log.debug("Print canceled");
            }
            catch (IOException ex) {
                log.error("Error printing car roster: {}", (Object)ex.getLocalizedMessage());
            }
        }
    }
}

