/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.cars.tools;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsPanel;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarColors;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarOwners;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.cars.gui.CarsTableFrame;
import jmri.jmrit.operations.rollingstock.cars.tools.Bundle;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintCarRosterFrame
extends OperationsFrame {
    boolean _isPreview;
    CarsTableFrame _ctf;
    JComboBox<String> sortByComboBox = new JComboBox();
    JComboBox<String> manifestOrientationComboBox = new JComboBox();
    JComboBox<Integer> fontSizeComboBox = new JComboBox();
    JCheckBox printCarsWithLocation = new JCheckBox(Bundle.getMessage("PrintCarsWithLocation"));
    JCheckBox printCarLength = new JCheckBox(Bundle.getMessage("PrintCarLength"));
    JCheckBox printCarWeight = new JCheckBox(Bundle.getMessage("PrintCarWeight"));
    JCheckBox printCarColor = new JCheckBox(Bundle.getMessage("PrintCarColor"));
    JCheckBox printCarOwner = new JCheckBox(Bundle.getMessage("PrintCarOwner"));
    JCheckBox printCarBuilt = new JCheckBox(Bundle.getMessage("PrintCarBuilt"));
    JCheckBox printCarLoad = new JCheckBox(Bundle.getMessage("PrintCarLoad"));
    JCheckBox printCarKernel = new JCheckBox(Bundle.getMessage("PrintKernel"));
    JCheckBox printCarValue = new JCheckBox(Bundle.getMessage("PrintCar", Setup.getValueLabel()));
    JCheckBox printCarRfid = new JCheckBox(Bundle.getMessage("PrintCar", Setup.getRfidLabel()));
    JCheckBox printCarLast = new JCheckBox(Bundle.getMessage("PrintCarLastMoved"));
    JCheckBox printCarWait = new JCheckBox(Bundle.getMessage("PrintCarWait"));
    JCheckBox printCarPickup = new JCheckBox(Bundle.getMessage("PrintCarPickup"));
    JCheckBox printCarLocation = new JCheckBox(Bundle.getMessage("PrintCarLocation"));
    JCheckBox printCarTrain = new JCheckBox(Bundle.getMessage("PrintCarTrain"));
    JCheckBox printCarDestination = new JCheckBox(Bundle.getMessage("PrintCarDestination"));
    JCheckBox printCarFinalDestination = new JCheckBox(Bundle.getMessage("PrintCarFinalDestination"));
    JCheckBox printCarRoutePath = new JCheckBox(Bundle.getMessage("PrintCarRoutePath"));
    JCheckBox printCarRWE = new JCheckBox(Bundle.getMessage("PrintCarReturnWhenEmpty"));
    JCheckBox printCarRWL = new JCheckBox(Bundle.getMessage("PrintCarReturnWhenLoaded"));
    JCheckBox printDivision = new JCheckBox(Bundle.getMessage("PrintCarDivision"));
    JCheckBox printCarStatus = new JCheckBox(Bundle.getMessage("PrintCarStatus"));
    JCheckBox printCarComment = new JCheckBox(Bundle.getMessage("PrintCarComment"));
    JCheckBox printSpace = new JCheckBox(Bundle.getMessage("PrintSpace"));
    JCheckBox printPage = new JCheckBox(Bundle.getMessage("PrintPage"));
    JButton okayButton = new JButton(Bundle.getMessage("ButtonOK"));
    int numberCharPerLine;
    private static final Logger log = LoggerFactory.getLogger(PrintCarRosterFrame.class);

    public PrintCarRosterFrame(boolean isPreview, CarsTableFrame carsTableFrame) {
        this._isPreview = isPreview;
        this._ctf = carsTableFrame;
        JPanel pSortBy = new JPanel();
        pSortBy.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SortBy")));
        pSortBy.add(this.sortByComboBox);
        this.addComboBoxAction(this.sortByComboBox);
        JPanel pOrientation = new JPanel();
        pOrientation.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutOrientation")));
        pOrientation.add(this.manifestOrientationComboBox);
        this.manifestOrientationComboBox.addItem(Setup.PORTRAIT);
        this.manifestOrientationComboBox.addItem(Setup.LANDSCAPE);
        JPanel pFontSize = new JPanel();
        pFontSize.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutFontSize")));
        pFontSize.add(this.fontSizeComboBox);
        OperationsPanel.loadFontSizeComboBox(this.fontSizeComboBox);
        this.fontSizeComboBox.setSelectedItem(Control.reportFontSize);
        JPanel pPanel = new JPanel();
        pPanel.setLayout(new GridBagLayout());
        JScrollPane panePanel = new JScrollPane(pPanel);
        panePanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PrintOptions")));
        this.addItemLeft(pPanel, this.printCarsWithLocation, 0, 0);
        this.addItemLeft(pPanel, this.printCarLength, 0, 1);
        this.addItemLeft(pPanel, this.printCarWeight, 0, 2);
        this.addItemLeft(pPanel, this.printCarColor, 0, 3);
        this.addItemLeft(pPanel, this.printCarLoad, 0, 4);
        this.addItemLeft(pPanel, this.printCarKernel, 0, 5);
        this.addItemLeft(pPanel, this.printCarOwner, 0, 6);
        this.addItemLeft(pPanel, this.printCarBuilt, 0, 7);
        this.addItemLeft(pPanel, this.printCarLast, 0, 8);
        this.addItemLeft(pPanel, this.printCarWait, 0, 9);
        this.addItemLeft(pPanel, this.printCarPickup, 0, 10);
        if (Setup.isValueEnabled()) {
            this.addItemLeft(pPanel, this.printCarValue, 0, 11);
        }
        if (Setup.isRfidEnabled()) {
            this.addItemLeft(pPanel, this.printCarRfid, 0, 12);
        }
        this.addItemLeft(pPanel, this.printCarLocation, 0, 13);
        this.addItemLeft(pPanel, this.printCarTrain, 0, 14);
        this.addItemLeft(pPanel, this.printCarDestination, 0, 15);
        this.addItemLeft(pPanel, this.printCarFinalDestination, 0, 16);
        this.addItemLeft(pPanel, this.printCarRWE, 0, 17);
        this.addItemLeft(pPanel, this.printCarRWL, 0, 18);
        this.addItemLeft(pPanel, this.printDivision, 0, 19);
        this.addItemLeft(pPanel, this.printCarStatus, 0, 20);
        this.addItemLeft(pPanel, this.printCarRoutePath, 0, 21);
        this.addItemLeft(pPanel, this.printCarComment, 0, 22);
        this.addItemLeft(pPanel, this.printSpace, 0, 23);
        this.addItemLeft(pPanel, this.printPage, 0, 24);
        this.printCarsWithLocation.setSelected(false);
        this.printCarLength.setSelected(true);
        this.printCarWeight.setSelected(false);
        this.printCarColor.setSelected(true);
        this.printCarLoad.setSelected(false);
        this.printCarKernel.setSelected(false);
        this.printCarOwner.setSelected(false);
        this.printCarBuilt.setSelected(false);
        this.printCarLast.setSelected(false);
        this.printCarWait.setSelected(false);
        this.printCarPickup.setSelected(false);
        this.printCarValue.setSelected(false);
        this.printCarRfid.setSelected(false);
        this.printCarLocation.setSelected(true);
        this.printCarTrain.setSelected(false);
        this.printCarDestination.setSelected(false);
        this.printCarFinalDestination.setSelected(false);
        this.printCarRoutePath.setSelected(false);
        this.printCarRWE.setSelected(false);
        this.printCarRWL.setSelected(false);
        this.printDivision.setSelected(false);
        this.printCarStatus.setSelected(false);
        this.printCarComment.setSelected(false);
        this.printSpace.setSelected(false);
        this.printPage.setSelected(false);
        this.printSpace.setToolTipText(Bundle.getMessage("TipSelectSortByLoc"));
        this.printPage.setToolTipText(Bundle.getMessage("TipSelectSortByLoc"));
        JPanel pButtons = new JPanel();
        pButtons.setLayout(new GridBagLayout());
        pButtons.add(this.okayButton);
        pButtons.setBorder(BorderFactory.createTitledBorder(""));
        this.addButtonAction(this.okayButton);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(pSortBy);
        this.getContentPane().add(pOrientation);
        this.getContentPane().add(pFontSize);
        this.getContentPane().add(panePanel);
        this.getContentPane().add(pButtons);
        this.initMinimumSize(new Dimension(300, 500));
        if (this._isPreview) {
            this.setTitle(Bundle.getMessage("MenuItemPreview"));
        } else {
            this.setTitle(Bundle.getMessage("MenuItemPrint"));
        }
        this.loadSortByComboBox(this.sortByComboBox);
        this.updateLocationCheckboxes();
    }

    private void loadSortByComboBox(JComboBox<String> box) {
        box.removeAllItems();
        for (int i = this._ctf.carsTableModel.SORTBY_NUMBER; i <= this._ctf.carsTableModel.SORTBY_COMMENT; ++i) {
            box.addItem(this._ctf.carsTableModel.getSortByName(i));
        }
        box.setSelectedItem(this._ctf.carsTableModel.getSortByName());
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        this.setVisible(false);
        this.printCars();
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        this.updateLocationCheckboxes();
    }

    private void updateLocationCheckboxes() {
        if (this.sortByComboBox.getSelectedItem() != null && this.sortByComboBox.getSelectedItem().equals(this._ctf.carsTableModel.getSortByName(this._ctf.carsTableModel.SORTBY_LOCATION))) {
            this.printSpace.setEnabled(true);
            this.printPage.setEnabled(true);
        } else {
            this.printSpace.setEnabled(false);
            this.printPage.setEnabled(false);
            this.printSpace.setSelected(false);
            this.printPage.setSelected(false);
        }
    }

    private void printCars() {
        boolean isLandscape = false;
        if (this.manifestOrientationComboBox.getSelectedItem() != null && this.manifestOrientationComboBox.getSelectedItem().equals(Setup.LANDSCAPE)) {
            isLandscape = true;
        }
        int fontSize = (Integer)this.fontSizeComboBox.getSelectedItem();
        try (HardcopyWriter writer = new HardcopyWriter(new Frame(), Bundle.getMessage("TitleCarRoster"), fontSize, 0.5, 0.5, 0.5, 0.5, this._isPreview, "", isLandscape, true, null, null);){
            this.numberCharPerLine = writer.getCharactersPerLine();
            this.printHeader(writer);
            this.printRoster(writer);
        }
        catch (HardcopyWriter.PrintCanceledException ex) {
            log.debug("Print canceled");
        }
        catch (IOException we) {
            log.error("Error printing car roster: {}", (Object)we.getLocalizedMessage());
        }
    }

    private void printHeader(HardcopyWriter writer) throws IOException {
        Object s = this.padAttribute(Bundle.getMessage("Number"), Control.max_len_string_print_road_number) + this.padAttribute(Bundle.getMessage("Road"), InstanceManager.getDefault(CarRoads.class).getMaxNameLength()) + this.padAttribute(Bundle.getMessage("Type"), InstanceManager.getDefault(CarTypes.class).getMaxFullNameLength()) + (String)(this.printCarLength.isSelected() ? Bundle.getMessage("Len") + "  " : "") + (this.printCarWeight.isSelected() ? "     " : "") + (this.printCarColor.isSelected() ? this.padAttribute(Bundle.getMessage("Color"), InstanceManager.getDefault(CarColors.class).getMaxNameLength()) : "") + (this.printCarLoad.isSelected() ? this.padAttribute(Bundle.getMessage("Load"), InstanceManager.getDefault(CarLoads.class).getMaxNameLength()) : "") + (this.printCarKernel.isSelected() ? this.padAttribute("Kernel", Control.max_len_string_attibute) : "") + (this.printCarOwner.isSelected() ? this.padAttribute(Bundle.getMessage("Owner"), InstanceManager.getDefault(CarOwners.class).getMaxNameLength()) : "") + (String)(this.printCarBuilt.isSelected() ? Bundle.getMessage("Built") + " " : "") + (String)(this.printCarLast.isSelected() ? Bundle.getMessage("LastMoved") + " " : "") + (String)(this.printCarWait.isSelected() ? Bundle.getMessage("Wait") + " " : "") + (this.printCarPickup.isSelected() ? this.padAttribute(Bundle.getMessage("Pickup"), 10) : "") + (this.printCarValue.isSelected() ? this.padAttribute(Setup.getValueLabel(), Control.max_len_string_attibute) : "") + (this.printCarRfid.isSelected() ? this.padAttribute(Setup.getRfidLabel(), Control.max_len_string_attibute) : "") + (this.printCarLocation.isSelected() ? this.padAttribute(Bundle.getMessage("Location"), InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3) : "") + (this.printCarTrain.isSelected() ? this.padAttribute(Bundle.getMessage("Train"), Control.max_len_string_train_name / 2) : "") + (this.printCarDestination.isSelected() ? this.padAttribute(Bundle.getMessage("Destination"), InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3) : "") + (this.printCarFinalDestination.isSelected() ? this.padAttribute(Bundle.getMessage("FinalDestination"), InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3) : "") + (this.printCarRWE.isSelected() ? this.padAttribute(Bundle.getMessage("ReturnWhenEmpty"), InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3) : "") + (this.printCarRWL.isSelected() ? this.padAttribute(Bundle.getMessage("ReturnWhenLoaded"), InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3) : "") + (String)(this.printDivision.isSelected() ? Bundle.getMessage("HomeDivision") + " " : "") + (String)(this.printCarStatus.isSelected() ? Bundle.getMessage("Status") + " " : "") + (this.printCarRoutePath.isSelected() ? this.padAttribute(Bundle.getMessage("Route"), InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3) : "") + (this.printCarComment.isSelected() ? Bundle.getMessage("Comment") : "");
        if (((String)s).length() > this.numberCharPerLine) {
            s = ((String)s).substring(0, this.numberCharPerLine);
            writer.write(Bundle.getMessage("WarningTextPage") + "\n");
        }
        writer.write((String)s + "\n");
    }

    private void printRoster(HardcopyWriter writer) throws IOException {
        Object location = "";
        String length = "";
        String weight = "";
        String color = "";
        String owner = "";
        String built = "";
        String load = "";
        String kernel = "";
        String train = "";
        Object destination = "";
        Object finalDestination = "";
        Object returnWhenEmpty = "";
        Object returnWhenLoaded = "";
        String division = "";
        String value = "";
        String rfid = "";
        String last = "";
        String wait = "";
        String schedule = "";
        String status = "";
        Object routePath = "";
        String comment = "";
        String previousLocation = null;
        List<Car> cars = this._ctf.carsTableModel.getCarList(this.sortByComboBox.getSelectedIndex());
        for (Car car : cars) {
            if (this.printCarsWithLocation.isSelected() && car.getLocation() == null) continue;
            location = "";
            destination = "";
            finalDestination = "";
            returnWhenEmpty = "";
            returnWhenLoaded = "";
            if (this.printCarLocation.isSelected()) {
                if (car.getLocation() != null) {
                    location = car.getLocationName().trim() + " - " + car.getTrackName().trim();
                }
                location = this.padAttribute((String)location, InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3);
            }
            if (previousLocation != null && !car.getLocationName().trim().equals(previousLocation) && this.printPage.isSelected()) {
                writer.pageBreak();
                this.printHeader(writer);
            } else if (previousLocation != null && !car.getLocationName().trim().equals(previousLocation) && this.printSpace.isSelected()) {
                writer.write("\n");
            }
            previousLocation = car.getLocationName().trim();
            String number = this.padAttribute(car.getNumber().trim(), Control.max_len_string_print_road_number);
            String road = this.padAttribute(car.getRoadName().trim(), InstanceManager.getDefault(CarRoads.class).getMaxNameLength());
            String type = this.padAttribute(car.getTypeName().trim(), InstanceManager.getDefault(CarTypes.class).getMaxFullNameLength());
            if (this.printCarLength.isSelected()) {
                length = this.padAttribute(car.getLength().trim(), Control.max_len_string_length_name);
            }
            if (this.printCarWeight.isSelected()) {
                weight = this.padAttribute(car.getWeight().trim(), Control.max_len_string_weight_name);
            }
            if (this.printCarColor.isSelected()) {
                color = this.padAttribute(car.getColor().trim(), InstanceManager.getDefault(CarColors.class).getMaxNameLength());
            }
            if (this.printCarLoad.isSelected()) {
                load = this.padAttribute(car.getLoadName().trim(), InstanceManager.getDefault(CarLoads.class).getMaxNameLength());
            }
            if (this.printCarKernel.isSelected()) {
                kernel = this.padAttribute(car.getKernelName().trim(), Control.max_len_string_attibute);
            }
            if (this.printCarOwner.isSelected()) {
                owner = this.padAttribute(car.getOwnerName().trim(), InstanceManager.getDefault(CarOwners.class).getMaxNameLength());
            }
            if (this.printCarBuilt.isSelected()) {
                built = this.padAttribute(car.getBuilt().trim(), Control.max_len_string_built_name);
            }
            if (this.printCarLast.isSelected()) {
                last = this.padAttribute(car.getSortDate().split(" ")[0], 10);
            }
            if (this.printCarWait.isSelected()) {
                wait = this.padAttribute(Integer.toString(car.getWait()), 4);
            }
            if (this.printCarPickup.isSelected()) {
                schedule = this.padAttribute(car.getPickupScheduleName(), 10);
            }
            if (this.printCarValue.isSelected()) {
                value = this.padAttribute(car.getValue().trim(), Control.max_len_string_attibute);
            }
            if (this.printCarRfid.isSelected()) {
                rfid = this.padAttribute(car.getRfid().trim(), Control.max_len_string_attibute);
            }
            if (this.printCarTrain.isSelected()) {
                train = this.padAttribute(car.getTrainName().trim(), Control.max_len_string_train_name / 2);
            }
            if (this.printCarDestination.isSelected()) {
                if (car.getDestination() != null) {
                    destination = car.getDestinationName().trim() + " - " + car.getDestinationTrackName().trim();
                }
                destination = this.padAttribute((String)destination, InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3);
            }
            if (this.printCarFinalDestination.isSelected()) {
                if (car.getFinalDestination() != null) {
                    finalDestination = car.getFinalDestinationName().trim();
                    if (car.getFinalDestinationTrack() != null) {
                        finalDestination = (String)finalDestination + " - " + car.getFinalDestinationTrackName().trim();
                    }
                }
                finalDestination = this.padAttribute((String)finalDestination, InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3);
            }
            if (this.printCarRoutePath.isSelected()) {
                routePath = car.getRoutePath() + " ";
            }
            if (this.printCarRWE.isSelected()) {
                if (car.getReturnWhenEmptyDestination() != null) {
                    returnWhenEmpty = car.getReturnWhenEmptyDestinationName().trim() + " - " + car.getReturnWhenEmptyDestTrackName().trim();
                }
                returnWhenEmpty = this.padAttribute((String)returnWhenEmpty, InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3);
            }
            if (this.printCarRWL.isSelected()) {
                if (car.getReturnWhenLoadedDestination() != null) {
                    returnWhenLoaded = car.getReturnWhenLoadedDestinationName().trim() + " - " + car.getReturnWhenLoadedDestTrackName().trim();
                }
                returnWhenLoaded = this.padAttribute((String)returnWhenLoaded, InstanceManager.getDefault(LocationManager.class).getMaxLocationAndTrackNameLength() + 3);
            }
            if (this.printDivision.isSelected()) {
                division = this.padAttribute(car.getDivisionName(), Bundle.getMessage("HomeDivision").length());
            }
            if (this.printCarStatus.isSelected()) {
                status = this.padAttribute(car.getStatus(), Bundle.getMessage("Status").length());
            }
            if (this.printCarComment.isSelected()) {
                comment = car.getComment().trim();
            }
            Object s = number + road + type + length + weight + color + load + kernel + owner + built + last + wait + schedule + value + rfid + (String)location + train + (String)destination + (String)finalDestination + (String)returnWhenEmpty + (String)returnWhenLoaded + division + status + (String)routePath + comment;
            if (((String)(s = ((String)s).trim())).length() > this.numberCharPerLine) {
                writer.write(((String)s).substring(0, this.numberCharPerLine) + "\n");
                s = ((String)s).substring(this.numberCharPerLine, ((String)s).length());
                String tab = this.getTab();
                int subStringLength = this.numberCharPerLine - tab.length();
                while (tab.length() + ((String)s).length() > this.numberCharPerLine) {
                    writer.write(tab + ((String)s).substring(0, subStringLength) + "\n");
                    s = ((String)s).substring(subStringLength, ((String)s).length());
                }
                s = tab + (String)s;
            }
            writer.write((String)s + "\n");
        }
    }

    private String padAttribute(String attribute, int length) {
        return TrainCommon.padAndTruncate(attribute, length) + " ";
    }

    private String getTab() {
        return this.padAttribute("", Control.max_len_string_print_road_number + InstanceManager.getDefault(CarRoads.class).getMaxNameLength() + 1);
    }
}

