/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines;

import java.util.List;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.operations.rollingstock.RollingStockGroupManager;
import jmri.jmrit.operations.rollingstock.engines.Consist;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManagerXml;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistManager
extends RollingStockGroupManager
implements InstanceManagerAutoDefault {
    private static final Logger log = LoggerFactory.getLogger(ConsistManager.class);

    public Consist newConsist(String name) {
        Consist consist = this.getConsistByName(name);
        if (consist == null && !name.equals("")) {
            consist = new Consist(name);
            int oldSize = this._groupHashTable.size();
            this._groupHashTable.put(name, consist);
            this.setDirtyAndFirePropertyChange("GroupListLengthChanged", oldSize, this._groupHashTable.size());
        }
        return consist;
    }

    public void deleteConsist(String name) {
        Consist consist = this.getConsistByName(name);
        if (consist != null) {
            consist.dispose();
            Integer oldSize = this._groupHashTable.size();
            this._groupHashTable.remove(name);
            this.setDirtyAndFirePropertyChange("GroupListLengthChanged", oldSize, this._groupHashTable.size());
        }
    }

    public Consist getConsistByName(String name) {
        return (Consist)this._groupHashTable.get(name);
    }

    public void replaceConsistName(String oldName, String newName) {
        Consist oldConsist = this.getConsistByName(oldName);
        if (oldConsist != null) {
            Consist newConsist = this.newConsist(newName);
            Engine leadEngine = (Engine)oldConsist.getLead();
            if (leadEngine != null) {
                leadEngine.setConsist(newConsist);
            }
            for (Engine engine : oldConsist.getEngines()) {
                engine.setConsist(newConsist);
            }
        }
    }

    public void load(Element root) {
        block3: {
            String names;
            block2: {
                if (root.getChild("newConsists") == null) break block2;
                List eConsists = root.getChild("newConsists").getChildren("consist");
                log.debug("Consist manager sees {} consists", (Object)eConsists.size());
                for (Element eConsist : eConsists) {
                    Attribute a = eConsist.getAttribute("name");
                    if (a == null) continue;
                    this.newConsist(a.getValue());
                }
                break block3;
            }
            if (root.getChild("consists") == null || (names = root.getChildText("consists")).isEmpty()) break block3;
            String[] consistNames = names.split("%%");
            log.debug("consists: {}", (Object)names);
            for (String name : consistNames) {
                this.newConsist(name);
            }
        }
    }

    public void store(Element root) {
        List<String> names = this.getNameList();
        Element consists = new Element("newConsists");
        for (String name : names) {
            Element consist = new Element("consist");
            consist.setAttribute(new Attribute("name", name));
            consists.addContent((Content)consist);
        }
        root.addContent((Content)consists);
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(EngineManagerXml.class).setDirty(true);
        super.firePropertyChange(p, old, n);
    }
}

