/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines;

import java.util.Comparator;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.operations.rollingstock.RollingStockAttribute;
import jmri.jmrit.operations.rollingstock.engines.Bundle;
import jmri.jmrit.operations.rollingstock.engines.EngineManagerXml;
import org.jdom2.Element;

public class EngineLengths
extends RollingStockAttribute
implements InstanceManagerAutoDefault {
    private static final String LENGTHS = Bundle.getMessage("engineDefaultLengths");
    public static final String ENGINELENGTHS_CHANGED_PROPERTY = "EngineLengths";
    public static final String ENGINELENGTHS_NAME_CHANGED_PROPERTY = "EngineLengthsName";

    @Override
    protected String getDefaultNames() {
        return LENGTHS;
    }

    @Override
    public void setNames(String[] lengths) {
        this.setValues(lengths);
    }

    @Override
    public void addName(String length) {
        super.addName(length);
        this.setDirtyAndFirePropertyChange(ENGINELENGTHS_CHANGED_PROPERTY, null, length);
    }

    @Override
    public void deleteName(String length) {
        super.deleteName(length);
        this.setDirtyAndFirePropertyChange(ENGINELENGTHS_CHANGED_PROPERTY, length, null);
    }

    public void replaceName(String oldName, String newName) {
        super.addName(newName);
        this.setDirtyAndFirePropertyChange(ENGINELENGTHS_NAME_CHANGED_PROPERTY, oldName, newName);
        super.deleteName(oldName);
    }

    @Override
    public void sort() {
        this.list.sort(Comparator.comparingInt(Integer::parseInt));
    }

    public void store(Element root) {
        this.store(root, "lengths", "length");
    }

    public void load(Element root) {
        this.load(root, "lengths", "length", "engineLengths");
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(EngineManagerXml.class).setDirty(true);
        super.firePropertyChange(p, old, n);
    }
}

