/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComboBox;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.jmrit.operations.OperationsPanel;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.RollingStockManager;
import jmri.jmrit.operations.rollingstock.engines.Bundle;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManagerXml;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManifestHeaderText;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineManager
extends RollingStockManager<Engine>
implements InstanceManagerAutoDefault,
InstanceManagerAutoInitialize {
    private static final int BY_MODEL = 30;
    private static final int BY_CONSIST = 31;
    private static final int BY_HP = 32;
    int _commentLength = 0;
    private static final Logger log = LoggerFactory.getLogger(EngineManager.class);

    @Override
    public Engine newRS(String engineRoad, String engineNumber) {
        Engine engine = (Engine)this.getByRoadAndNumber(engineRoad, engineNumber);
        if (engine == null) {
            engine = new Engine(engineRoad, engineNumber);
            this.register(engine);
        }
        return engine;
    }

    @Override
    public void deregister(Engine engine) {
        super.deregister(engine);
        InstanceManager.getDefault(EngineManagerXml.class).setDirty(true);
    }

    public List<Engine> getByModelList() {
        return this.getByList(this.getByRoadNameList(), 30);
    }

    public List<Engine> getByConsistList() {
        return this.getByList(this.getByRoadNameList(), 31);
    }

    public List<Engine> getByHpList() {
        return this.getByList(this.getByModelList(), 32);
    }

    @Override
    protected Comparator<Engine> getComparator(int attribute) {
        switch (attribute) {
            case 30: {
                return (e1, e2) -> e1.getModel().compareToIgnoreCase(e2.getModel());
            }
            case 31: {
                return (e1, e2) -> e1.getConsistName().compareToIgnoreCase(e2.getConsistName());
            }
            case 32: {
                return (e1, e2) -> e1.getHpInteger() - e2.getHpInteger();
            }
        }
        return super.getComparator(attribute);
    }

    public List<Engine> getAvailableTrainList(Train train) {
        ArrayList<Engine> out = new ArrayList<Engine>();
        for (RollingStock rs : this.getByMovesList()) {
            Engine engine = (Engine)rs;
            if (engine.getTrack() == null || engine.getTrain() != null && engine.getTrain() != train) continue;
            out.add(engine);
        }
        return out;
    }

    public List<Engine> getByTrainBlockingList(Train train) {
        return this.getByList(super.getByTrainList(train), 13);
    }

    public List<String> getEngineRoadNames(String model) {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration en = this._hashTable.keys();
        while (en.hasMoreElements()) {
            Engine engine = (Engine)this.getById((String)en.nextElement());
            if (!engine.getModel().equals(model) && !model.equals("") || names.contains(engine.getRoadName())) continue;
            names.add(engine.getRoadName());
        }
        Collections.sort(names);
        return names;
    }

    public void updateEngineRoadComboBox(String engineModel, JComboBox<String> roadEngineBox) {
        roadEngineBox.removeAllItems();
        roadEngineBox.addItem("");
        List<String> roads = this.getEngineRoadNames(engineModel);
        for (String roadName : roads) {
            roadEngineBox.addItem(roadName);
        }
        OperationsPanel.padComboBox(roadEngineBox);
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="I18N of Info Message")
    public int getMaxCommentLength() {
        if (this._commentLength == 0) {
            this._commentLength = TrainManifestHeaderText.getStringHeader_Comment().length();
            String comment = "";
            RollingStock engineMax = null;
            for (Engine engine : this.getList()) {
                if (engine.getComment().length() <= this._commentLength) continue;
                this._commentLength = engine.getComment().length();
                comment = engine.getComment();
                engineMax = engine;
            }
            if (engineMax != null) {
                log.info(Bundle.getMessage("InfoMaxComment", engineMax.toString(), comment, this._commentLength));
            }
        }
        return this._commentLength;
    }

    public void load(Element root) {
        if (root.getChild("engines") != null) {
            List engines = root.getChild("engines").getChildren("engine");
            log.debug("readFile sees {} engines", (Object)engines.size());
            for (Element e : engines) {
                this.register(new Engine(e));
            }
        }
    }

    public void store(Element root) {
        Element values = new Element("engines");
        root.addContent((Content)values);
        for (RollingStock rs : this.getByRoadNameList()) {
            Engine eng = (Engine)rs;
            values.addContent((Content)eng.store());
        }
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(EngineManagerXml.class).setDirty(true);
        super.firePropertyChange(p, old, n);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("rolling stock comment")) {
            this._commentLength = 0;
        }
        super.propertyChange(evt);
    }

    @Override
    public void initialize() {
        InstanceManager.getDefault(OperationsSetupXml.class);
        InstanceManager.getDefault(EngineManagerXml.class);
    }
}

