/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines.gui;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.RollingStockAttribute;
import jmri.jmrit.operations.rollingstock.RollingStockEditFrame;
import jmri.jmrit.operations.rollingstock.engines.ConsistManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineLengths;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.EngineManagerXml;
import jmri.jmrit.operations.rollingstock.engines.EngineModels;
import jmri.jmrit.operations.rollingstock.engines.EngineTypes;
import jmri.jmrit.operations.rollingstock.engines.gui.Bundle;
import jmri.jmrit.operations.rollingstock.engines.tools.EngineAttributeEditFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineEditFrame
extends RollingStockEditFrame {
    protected static final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.operations.rollingstock.engines.JmritOperationsEnginesBundle");
    EngineManager engineManager = InstanceManager.getDefault(EngineManager.class);
    EngineManagerXml managerXml = InstanceManager.getDefault(EngineManagerXml.class);
    EngineModels engineModels = InstanceManager.getDefault(EngineModels.class);
    JButton editModelButton = new JButton(Bundle.getMessage("ButtonEdit"));
    JCheckBox bUnitCheckBox = new JCheckBox(Bundle.getMessage("BUnit"));
    JTextField hpTextField = new JTextField(8);
    JTextField teTextField = new JTextField(8);
    private static final String SPEED = "25";
    EngineAttributeEditFrame engineAttributeEditFrame;
    private static final Logger log = LoggerFactory.getLogger(EngineEditFrame.class);

    public EngineEditFrame() {
        super(Bundle.getMessage("TitleEngineAdd"));
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Checks for null")
    public void initComponents() {
        this.groupComboBox = InstanceManager.getDefault(ConsistManager.class).getComboBox();
        this.modelComboBox = this.engineModels.getComboBox();
        super.initComponents();
        this.addButton.setText(Bundle.getMessage("TitleEngineAdd"));
        this.addItem(this.pTypeOptions, this.bUnitCheckBox, 0, 1);
        this.bUnitCheckBox.setSelected(false);
        this.builtTextField.setToolTipText(Bundle.getMessage("TipBuildDate"));
        this.editModelButton.setToolTipText(Bundle.getMessage("TipAddDeleteReplace", Bundle.getMessage("Model").toLowerCase()));
        this.editGroupButton.setToolTipText(Bundle.getMessage("TipAddDeleteReplace", Bundle.getMessage("Consist").toLowerCase()));
        this.bUnitCheckBox.setToolTipText(Bundle.getMessage("TipBoosterUnit"));
        this.deleteButton.setToolTipText(Bundle.getMessage("TipDeleteButton"));
        this.addButton.setToolTipText(Bundle.getMessage("TipAddButton"));
        this.saveButton.setToolTipText(Bundle.getMessage("TipSaveButton"));
        this.pModel.setLayout(new GridBagLayout());
        this.pModel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Model")));
        this.addItem(this.pModel, this.modelComboBox, 1, 0);
        this.addItem(this.pModel, this.editModelButton, 2, 0);
        this.pModel.setVisible(true);
        this.pPower.setLayout(new BoxLayout(this.pPower, 0));
        JPanel pHp = new JPanel();
        pHp.setLayout(new GridBagLayout());
        pHp.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Hp")));
        this.addItem(pHp, this.hpTextField, 0, 0);
        JPanel pTe = new JPanel();
        pTe.setLayout(new GridBagLayout());
        pTe.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TractiveEffort")));
        this.addItem(pTe, this.teTextField, 0, 0);
        this.pPower.add(pHp);
        this.pPower.add(pTe);
        this.pPower.setVisible(true);
        this.teTextField.setToolTipText(Bundle.getMessage("TipConvertTE-HP", SPEED));
        this.pGroup.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Consist")));
        this.addEditButtonAction(this.editModelButton);
        this.addComboBoxAction(this.modelComboBox);
        this.modelComboBox.setSelectedIndex(0);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_LocomotivesAdd", true);
    }

    @Override
    protected ResourceBundle getRb() {
        return rb;
    }

    @Override
    protected RollingStockAttribute getTypeManager() {
        return InstanceManager.getDefault(EngineTypes.class);
    }

    @Override
    protected RollingStockAttribute getLengthManager() {
        return InstanceManager.getDefault(EngineLengths.class);
    }

    public void load(Engine engine) {
        String msg;
        this.setTitle(Bundle.getMessage("TitleEngineEdit"));
        if (!this.engineModels.containsName(engine.getModel()) && JmriJOptionPane.showConfirmDialog(this, msg = Bundle.getMessage("modelNameNotExist", engine.getModel()), Bundle.getMessage("engineAddModel"), 0) == 0) {
            this.engineModels.addName(engine.getModel());
        }
        this.modelComboBox.setSelectedItem(engine.getModel());
        super.load(engine);
        this.pBlocking.setVisible(engine.getConsist() != null);
        this.blockingTextField.setEnabled(false);
        this.bUnitCheckBox.setSelected(engine.isBunit());
        this.hpTextField.setText(engine.getHp());
        this.groupComboBox.setSelectedItem(engine.getConsistName());
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.modelComboBox && this.modelComboBox.getSelectedItem() != null) {
            String model = (String)this.modelComboBox.getSelectedItem();
            this.hpTextField.setText(this.engineModels.getModelHorsepower(model));
            this.weightTonsTextField.setText(this.engineModels.getModelWeight(model));
            if (this.engineModels.getModelLength(model) != null && !this.engineModels.getModelLength(model).isEmpty()) {
                this.lengthComboBox.setSelectedItem(this.engineModels.getModelLength(model));
            }
            if (this.engineModels.getModelType(model) != null && !this.engineModels.getModelType(model).isEmpty()) {
                this.typeComboBox.setSelectedItem(this.engineModels.getModelType(model));
            }
        }
        super.comboBoxActionPerformed(ae);
    }

    @Override
    protected boolean check(RollingStock engine) {
        Engine existingEngine = (Engine)this.engineManager.getByRoadAndNumber((String)this.roadComboBox.getSelectedItem(), this.roadNumberTextField.getText());
        if (!(existingEngine == null || engine != null && existingEngine.getId().equals(engine.getId()))) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("engineExists"), Bundle.getMessage("engineCanNotUpdate"), 0);
            return false;
        }
        return super.check(engine);
    }

    @Override
    protected void save(boolean isSave) {
        super.save(this.engineManager, isSave);
        Engine engine = (Engine)this._rs;
        this.checkAndSetLocationAndTrack(engine);
        engine.setBunit(this.bUnitCheckBox.isSelected());
        if (this.groupComboBox.getSelectedItem() != null) {
            if (this.groupComboBox.getSelectedItem().equals("")) {
                engine.setConsist(null);
                engine.setBlocking(0);
            } else if (!engine.getConsistName().equals(this.groupComboBox.getSelectedItem())) {
                engine.setConsist(InstanceManager.getDefault(ConsistManager.class).getConsistByName((String)this.groupComboBox.getSelectedItem()));
                if (engine.getConsist() != null) {
                    engine.setBlocking(engine.getConsist().getSize());
                    this.blockingTextField.setText(Integer.toString(engine.getBlocking()));
                }
            }
        }
        this.pBlocking.setVisible(engine.getConsist() != null);
        this.convertTractiveEffortToHp();
        if (!this.hpTextField.getText().trim().isEmpty()) {
            try {
                Integer.parseInt(this.hpTextField.getText());
                engine.setHp(this.hpTextField.getText());
            }
            catch (Exception e) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("engineHorsepower"), Bundle.getMessage("engineCanNotHp"), 0);
            }
        }
        if (engine.getConsist() != null) {
            List<Engine> engines = engine.getConsist().getEngines();
            for (Engine cEngine : engines) {
                if (cEngine == engine || cEngine.getLocation() == engine.getLocation() && cEngine.getTrack() == engine.getTrack()) continue;
                int results = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("engineInConsistLocation", engine.toString(), engine.getLocationName(), engine.getTrackName()), Bundle.getMessage("enginePartConsist"), 0);
                if (results != 0) break;
                for (Engine cEngine2 : engines) {
                    if (cEngine2 == engine) continue;
                    this.setLocationAndTrack(cEngine2);
                }
            }
        }
    }

    @Override
    protected void delete() {
        Engine engine = (Engine)this.engineManager.getByRoadAndNumber((String)this.roadComboBox.getSelectedItem(), this.roadNumberTextField.getText());
        if (engine != null) {
            this.engineManager.deregister(engine);
        }
    }

    @Override
    public void buttonEditActionPerformed(ActionEvent ae) {
        if (this.engineAttributeEditFrame != null) {
            this.engineAttributeEditFrame.dispose();
        }
        this.engineAttributeEditFrame = new EngineAttributeEditFrame();
        this.engineAttributeEditFrame.setLocationRelativeTo(this);
        this.engineAttributeEditFrame.addPropertyChangeListener(this);
        if (ae.getSource() == this.editRoadButton) {
            this.engineAttributeEditFrame.initComponents("Road", (String)this.roadComboBox.getSelectedItem());
        }
        if (ae.getSource() == this.editModelButton) {
            this.engineAttributeEditFrame.initComponents("Model", (String)this.modelComboBox.getSelectedItem());
        }
        if (ae.getSource() == this.editTypeButton) {
            this.engineAttributeEditFrame.initComponents("Type", (String)this.typeComboBox.getSelectedItem());
        }
        if (ae.getSource() == this.editLengthButton) {
            this.engineAttributeEditFrame.initComponents("Length", (String)this.lengthComboBox.getSelectedItem());
        }
        if (ae.getSource() == this.editOwnerButton) {
            this.engineAttributeEditFrame.initComponents("Owner", (String)this.ownerComboBox.getSelectedItem());
        }
        if (ae.getSource() == this.editGroupButton) {
            this.engineAttributeEditFrame.initComponents("Consist", (String)this.groupComboBox.getSelectedItem());
        }
    }

    private void convertTractiveEffortToHp() {
        String TE = this.teTextField.getText().trim();
        if (!TE.isEmpty()) {
            TE = TE.replace(",", "");
            int te = 0;
            try {
                te = Integer.parseInt(TE);
            }
            catch (Exception e) {
                log.error("Not able to convert TE {} to HP", (Object)this.teTextField.getText());
            }
            if (te > 0) {
                int hp = te * Integer.parseInt(SPEED) / 625;
                this.hpTextField.setText(Integer.toString(hp));
            }
        }
    }

    @Override
    protected void addPropertyChangeListeners() {
        InstanceManager.getDefault(ConsistManager.class).addPropertyChangeListener(this);
        this.engineModels.addPropertyChangeListener(this);
        this.engineManager.addPropertyChangeListener(this);
        super.addPropertyChangeListeners();
    }

    @Override
    protected void removePropertyChangeListeners() {
        InstanceManager.getDefault(ConsistManager.class).removePropertyChangeListener(this);
        this.engineModels.removePropertyChangeListener(this);
        this.engineManager.removePropertyChangeListener(this);
        if (this._rs != null) {
            this._rs.removePropertyChangeListener(this);
        }
        super.removePropertyChangeListeners();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (e.getPropertyName().equals("EngineLengths")) {
            InstanceManager.getDefault(EngineLengths.class).updateComboBox(this.lengthComboBox);
            if (this._rs != null) {
                this.lengthComboBox.setSelectedItem(this._rs.getLength());
            }
        }
        if (e.getPropertyName().equals("EngineModels")) {
            this.engineModels.updateComboBox(this.modelComboBox);
            if (this._rs != null) {
                this.modelComboBox.setSelectedItem(((Engine)this._rs).getModel());
            }
        }
        if (e.getPropertyName().equals("GroupListLengthChanged")) {
            InstanceManager.getDefault(ConsistManager.class).updateComboBox(this.groupComboBox);
            if (this._rs != null) {
                this.groupComboBox.setSelectedItem(((Engine)this._rs).getConsistName());
            }
        }
        if (e.getPropertyName().equals("dispose")) {
            this.engineAttributeEditFrame = null;
        }
    }
}

