/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines.gui;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.rollingstock.RollingStockSetFrame;
import jmri.jmrit.operations.rollingstock.engines.ConsistManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.EngineManagerXml;
import jmri.jmrit.operations.rollingstock.engines.gui.Bundle;
import jmri.jmrit.operations.rollingstock.engines.tools.EngineAttributeEditFrame;
import jmri.util.swing.JmriJOptionPane;

public class EngineSetFrame
extends RollingStockSetFrame<Engine> {
    protected static final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.operations.rollingstock.engines.JmritOperationsEnginesBundle");
    EngineManager manager = InstanceManager.getDefault(EngineManager.class);
    EngineManagerXml managerXml = InstanceManager.getDefault(EngineManagerXml.class);
    ConsistManager consistManager = InstanceManager.getDefault(ConsistManager.class);
    protected JComboBox<String> consistComboBox = this.consistManager.getComboBox();
    public JCheckBox ignoreConsistCheckBox = new JCheckBox(Bundle.getMessage("Ignore"));
    protected JButton editConsistButton = new JButton(Bundle.getMessage("ButtonEdit"));
    protected boolean askConsistChange = true;
    public Engine _engine;
    private String _help = "package.jmri.jmrit.operations.Operations_LocomotivesSet";
    EngineAttributeEditFrame eaef;

    public EngineSetFrame() {
        super(Bundle.getMessage("TitleEngineSet"));
    }

    public void initComponents(String help) {
        this._help = help;
        this.initComponents();
    }

    @Override
    public void initComponents() {
        super.initComponents();
        this.addHelpMenu(this._help, true);
        this.locationUnknownCheckBox.setVisible(false);
        this.pFinalDestination.setVisible(false);
        this.autoTrainCheckBox.setVisible(false);
        this.pOptional.setLayout(new BoxLayout(this.pOptional, 1));
        JPanel pConsist = new JPanel();
        pConsist.setLayout(new GridBagLayout());
        pConsist.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Consist")));
        this.addItemLeft(pConsist, this.ignoreConsistCheckBox, 1, 0);
        this.consistComboBox.setName("consistComboBox");
        this.addItem(pConsist, this.consistComboBox, 2, 0);
        this.addItem(pConsist, this.editConsistButton, 3, 0);
        this.pOptional.add(pConsist);
        this.ignoreConsistCheckBox.setVisible(false);
        this.addButtonAction(this.editConsistButton);
        this.addCheckBoxAction(this.ignoreConsistCheckBox);
        this.consistManager.addPropertyChangeListener(this);
        this.outOfServiceCheckBox.setToolTipText(this.getRb().getString("TipLocoOutOfService"));
        this.initMinimumSize(new Dimension(500, 400));
    }

    public void load(Engine engine) {
        this._engine = engine;
        this.updateConsistComboBox();
        super.load(engine);
    }

    @Override
    protected ResourceBundle getRb() {
        return rb;
    }

    @Override
    protected void enableComponents(boolean enabled) {
        super.enableComponents(enabled);
        this.ignoreConsistCheckBox.setEnabled(enabled);
        this.consistComboBox.setEnabled(!this.ignoreConsistCheckBox.isSelected() && enabled);
        this.editConsistButton.setEnabled(!this.ignoreConsistCheckBox.isSelected() && enabled && this._engine != null);
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        super.buttonActionPerformed(ae);
        if (ae.getSource() == this.editConsistButton) {
            if (this.eaef != null) {
                this.eaef.dispose();
            }
            this.eaef = new EngineAttributeEditFrame();
            this.eaef.initComponents("Consist", (String)this.consistComboBox.getSelectedItem());
        }
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        super.checkBoxActionPerformed(ae);
        if (ae.getSource() == this.ignoreConsistCheckBox) {
            this.consistComboBox.setEnabled(!this.ignoreConsistCheckBox.isSelected());
            this.editConsistButton.setEnabled(!this.ignoreConsistCheckBox.isSelected());
        }
    }

    protected void updateConsistComboBox() {
        this.consistManager.updateComboBox(this.consistComboBox);
        if (this._engine != null) {
            this.consistComboBox.setSelectedItem(this._engine.getConsistName());
        }
    }

    @Override
    protected boolean save() {
        if (this.change(this._engine)) {
            OperationsXml.save();
            return true;
        }
        return false;
    }

    protected boolean change(Engine engine) {
        List<Engine> list;
        if (this.consistComboBox.getSelectedItem() != null) {
            if (this.consistComboBox.getSelectedItem().equals("")) {
                engine.setConsist(null);
                engine.setBlocking(0);
            } else if (!engine.getConsistName().equals(this.consistComboBox.getSelectedItem())) {
                engine.setConsist(this.consistManager.getConsistByName((String)this.consistComboBox.getSelectedItem()));
                if (engine.getConsist() != null) {
                    engine.setBlocking(engine.getConsist().getSize());
                }
            }
        }
        if (!super.change(engine)) {
            return false;
        }
        this.checkTrain(engine);
        return !this.askConsistChange || this._engine.getConsist() == null || JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("engineInConsist"), Bundle.getMessage("enginePartConsist"), 0) != 0 || this.updateGroup(list = this._engine.getConsist().getEngines());
    }

    @Override
    public void dispose() {
        if (this.eaef != null) {
            this.eaef.dispose();
        }
        this.consistManager.removePropertyChangeListener(this);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (e.getPropertyName().equals("GroupListLengthChanged")) {
            this.updateConsistComboBox();
        }
    }
}

