/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import jmri.InstanceManager;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.gui.Bundle;
import jmri.jmrit.operations.rollingstock.engines.gui.EngineEditFrame;
import jmri.jmrit.operations.rollingstock.engines.gui.EngineSetFrame;
import jmri.jmrit.operations.rollingstock.engines.gui.EnginesTableFrame;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnginesTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    EngineManager engineManager = InstanceManager.getDefault(EngineManager.class);
    private static final int SELECT_COLUMN = 0;
    private static final int NUM_COLUMN = 1;
    private static final int ROAD_COLUMN = 2;
    private static final int MODEL_COLUMN = 3;
    private static final int HP_COLUMN = 4;
    private static final int WEIGHT_COLUMN = 5;
    private static final int TYPE_COLUMN = 6;
    private static final int LENGTH_COLUMN = 7;
    private static final int CONSIST_COLUMN = 8;
    private static final int LOCATION_COLUMN = 9;
    private static final int RFID_WHERE_LAST_SEEN_COLUMN = 10;
    private static final int RFID_WHEN_LAST_SEEN_COLUMN = 11;
    private static final int DESTINATION_COLUMN = 12;
    private static final int PREVIOUS_LOCATION_COLUMN = 13;
    private static final int TRAIN_COLUMN = 14;
    private static final int LAST_TRAIN_COLUMN = 15;
    private static final int MOVES_COLUMN = 16;
    private static final int BUILT_COLUMN = 17;
    private static final int OWNER_COLUMN = 18;
    private static final int VALUE_COLUMN = 19;
    private static final int RFID_COLUMN = 20;
    private static final int LAST_COLUMN = 21;
    private static final int DCC_ADDRESS_COLUMN = 22;
    private static final int COMMENT_COLUMN = 23;
    private static final int SET_COLUMN = 24;
    private static final int EDIT_COLUMN = 25;
    private static final int HIGHEST_COLUMN = 26;
    public final int SORTBY_NUMBER = 0;
    public final int SORTBY_ROAD = 1;
    public final int SORTBY_MODEL = 2;
    public final int SORTBY_LOCATION = 3;
    public final int SORTBY_DESTINATION = 4;
    public final int SORTBY_TRAIN = 5;
    public final int SORTBY_MOVES = 6;
    public final int SORTBY_CONSIST = 7;
    public final int SORTBY_BUILT = 8;
    public final int SORTBY_OWNER = 9;
    public final int SORTBY_VALUE = 10;
    public final int SORTBY_RFID = 11;
    public final int SORTBY_LAST = 12;
    public final int SORTBY_HP = 13;
    public final int SORTBY_DCC_ADDRESS = 14;
    public final int SORTBY_COMMENT = 15;
    private int _sort = 0;
    String _roadNumber = "";
    int _index = 0;
    List<Engine> engineList = null;
    JTable _table;
    EnginesTableFrame _frame;
    private final int[] _enginesTableColumnWidths = new int[]{60, 60, 60, 65, 50, 65, 65, 35, 75, 190, 190, 190, 140, 190, 65, 90, 50, 50, 50, 50, 100, 130, 50, 100, 65, 70};
    EngineEditFrame engineEditFrame = null;
    EngineSetFrame engineSetFrame = null;
    private static final Logger log = LoggerFactory.getLogger(EnginesTableModel.class);

    public EnginesTableModel() {
        this.engineManager.addPropertyChangeListener(this);
        this.updateList();
    }

    public void setSort(int sort) {
        this._sort = sort;
        this.updateList();
        if (sort == 6 || sort == 8 || sort == 9 || sort == 10 || sort == 11 || sort == 12 || sort == 14 || sort == 15) {
            XTableColumnModel tcm = (XTableColumnModel)this._table.getColumnModel();
            tcm.setColumnVisible(tcm.getColumnByModelIndex(16), sort == 6);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(17), sort == 8);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(18), sort == 9);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(19), sort == 10);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(20), sort == 11);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(11), sort == 11);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(10), sort == 11);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(13), sort == 12);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(21), sort == 12);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(15), sort == 12);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(14), sort != 12);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(22), sort == 14);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(23), sort == 15);
        }
        this.fireTableDataChanged();
    }

    public void toggleSelectVisible() {
        XTableColumnModel tcm = (XTableColumnModel)this._table.getColumnModel();
        tcm.setColumnVisible(tcm.getColumnByModelIndex(0), !tcm.isColumnVisible(tcm.getColumnByModelIndex(0)));
    }

    public void resetCheckboxes() {
        for (Engine engine : this.engineList) {
            engine.setSelected(false);
        }
    }

    public String getSortByName() {
        return this.getSortByName(this._sort);
    }

    public String getSortByName(int sort) {
        switch (sort) {
            case 0: {
                return Bundle.getMessage("Number");
            }
            case 1: {
                return Bundle.getMessage("Road");
            }
            case 2: {
                return Bundle.getMessage("Model");
            }
            case 3: {
                return Bundle.getMessage("Location");
            }
            case 4: {
                return Bundle.getMessage("Destination");
            }
            case 5: {
                return Bundle.getMessage("Train");
            }
            case 6: {
                return Bundle.getMessage("Moves");
            }
            case 7: {
                return Bundle.getMessage("Consist");
            }
            case 8: {
                return Bundle.getMessage("Built");
            }
            case 9: {
                return Bundle.getMessage("Owner");
            }
            case 14: {
                return Bundle.getMessage("DccAddress");
            }
            case 13: {
                return Bundle.getMessage("HP");
            }
            case 10: {
                return Setup.getValueLabel();
            }
            case 11: {
                return Setup.getRfidLabel();
            }
            case 12: {
                return Bundle.getMessage("Last");
            }
            case 15: {
                return Bundle.getMessage("Comment");
            }
        }
        return "Error";
    }

    public int findEngineByRoadNumber(String roadNumber) {
        if (this.engineList != null) {
            if (!roadNumber.equals(this._roadNumber)) {
                return this.getIndex(0, roadNumber);
            }
            int index = this.getIndex(this._index, roadNumber);
            if (index > 0) {
                return index;
            }
            return this.getIndex(0, roadNumber);
        }
        return -1;
    }

    private int getIndex(int start, String roadNumber) {
        for (int index = start; index < this.engineList.size(); ++index) {
            String rN;
            Engine e = this.engineList.get(index);
            if (e == null) continue;
            String[] number = e.getNumber().split("-");
            if (roadNumber.startsWith("*") && roadNumber.endsWith("*")) {
                rN = roadNumber.substring(1, roadNumber.length() - 1);
                if (!e.getNumber().contains(rN)) continue;
                this._roadNumber = roadNumber;
                this._index = index + 1;
                return index;
            }
            if (roadNumber.startsWith("*")) {
                rN = roadNumber.substring(1);
                if (!e.getNumber().endsWith(rN) && !number[0].endsWith(rN)) continue;
                this._roadNumber = roadNumber;
                this._index = index + 1;
                return index;
            }
            if (roadNumber.endsWith("*")) {
                rN = roadNumber.substring(0, roadNumber.length() - 1);
                if (!e.getNumber().startsWith(rN)) continue;
                this._roadNumber = roadNumber;
                this._index = index + 1;
                return index;
            }
            if (!e.getNumber().equals(roadNumber) && !number[0].equals(roadNumber)) continue;
            this._roadNumber = roadNumber;
            this._index = index + 1;
            return index;
        }
        this._roadNumber = "";
        return -1;
    }

    public Engine getEngineAtIndex(int index) {
        return this.engineList.get(index);
    }

    private void updateList() {
        this.removePropertyChangeEngines();
        this.engineList = this.getSelectedEngineList();
        for (RollingStock rollingStock : this.engineList) {
            rollingStock.addPropertyChangeListener(this);
        }
    }

    public List<Engine> getSelectedEngineList() {
        return this.getEngineList(this._sort);
    }

    public List<Engine> getEngineList(int sort) {
        List<Engine> list;
        switch (sort) {
            case 1: {
                list = this.engineManager.getByRoadNameList();
                break;
            }
            case 2: {
                list = this.engineManager.getByModelList();
                break;
            }
            case 3: {
                list = this.engineManager.getByLocationList();
                break;
            }
            case 4: {
                list = this.engineManager.getByDestinationList();
                break;
            }
            case 5: {
                list = this.engineManager.getByTrainList();
                break;
            }
            case 6: {
                list = this.engineManager.getByMovesList();
                break;
            }
            case 7: {
                list = this.engineManager.getByConsistList();
                break;
            }
            case 9: {
                list = this.engineManager.getByOwnerList();
                break;
            }
            case 8: {
                list = this.engineManager.getByBuiltList();
                break;
            }
            case 10: {
                list = this.engineManager.getByValueList();
                break;
            }
            case 11: {
                list = this.engineManager.getByRfidList();
                break;
            }
            case 12: {
                list = this.engineManager.getByLastDateList();
                break;
            }
            case 15: {
                list = this.engineManager.getByCommentList();
                break;
            }
            default: {
                list = this.engineManager.getByNumberList();
            }
        }
        return list;
    }

    void initTable(JTable table, EnginesTableFrame frame) {
        this._table = table;
        this._frame = frame;
        this.initTable();
    }

    void initTable() {
        XTableColumnModel tcm = new XTableColumnModel();
        this._table.setColumnModel(tcm);
        this._table.createDefaultColumnsFromModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        tcm.getColumn(24).setCellRenderer(buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(24).setCellEditor(buttonEditor);
        tcm.getColumn(25).setCellRenderer(buttonRenderer);
        tcm.getColumn(25).setCellEditor(buttonEditor);
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            tcm.getColumn(i).setPreferredWidth(this._enginesTableColumnWidths[i]);
        }
        this._frame.loadTableDetails(this._table);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(17), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(18), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(19), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(20), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(11), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(10), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(13), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(21), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(15), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(22), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(23), false);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(16), true);
    }

    @Override
    public int getRowCount() {
        return this.engineList.size();
    }

    @Override
    public int getColumnCount() {
        return 26;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("ButtonSelect");
            }
            case 1: {
                return Bundle.getMessage("Number");
            }
            case 2: {
                return Bundle.getMessage("Road");
            }
            case 3: {
                return Bundle.getMessage("Model");
            }
            case 4: {
                return Bundle.getMessage("HP");
            }
            case 6: {
                return Bundle.getMessage("Type");
            }
            case 7: {
                return Bundle.getMessage("Len");
            }
            case 5: {
                return Bundle.getMessage("Weight");
            }
            case 8: {
                return Bundle.getMessage("Consist");
            }
            case 9: {
                return Bundle.getMessage("Location");
            }
            case 10: {
                return Bundle.getMessage("WhereLastSeen");
            }
            case 11: {
                return Bundle.getMessage("WhenLastSeen");
            }
            case 12: {
                return Bundle.getMessage("Destination");
            }
            case 13: {
                return Bundle.getMessage("LastLocation");
            }
            case 14: {
                return Bundle.getMessage("Train");
            }
            case 15: {
                return Bundle.getMessage("LastTrain");
            }
            case 16: {
                return Bundle.getMessage("Moves");
            }
            case 17: {
                return Bundle.getMessage("Built");
            }
            case 18: {
                return Bundle.getMessage("Owner");
            }
            case 19: {
                return Setup.getValueLabel();
            }
            case 20: {
                return Setup.getRfidLabel();
            }
            case 21: {
                return Bundle.getMessage("LastMoved");
            }
            case 22: {
                return Bundle.getMessage("DccAddress");
            }
            case 23: {
                return Bundle.getMessage("Comment");
            }
            case 24: {
                return Bundle.getMessage("Set");
            }
            case 25: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Boolean.class;
            }
            case 24: 
            case 25: {
                return JButton.class;
            }
            case 7: 
            case 16: {
                return Integer.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 25: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount()) {
            return "ERROR row " + row;
        }
        Engine engine = this.engineList.get(row);
        if (engine == null) {
            return "ERROR engine unknown " + row;
        }
        switch (col) {
            case 0: {
                return engine.isSelected();
            }
            case 1: {
                return engine.getNumber();
            }
            case 2: {
                return engine.getRoadName();
            }
            case 7: {
                return engine.getLengthInteger();
            }
            case 3: {
                return engine.getModel();
            }
            case 4: {
                return engine.getHp();
            }
            case 6: {
                if (engine.isBunit()) {
                    return engine.getTypeName() + " " + Bundle.getMessage("(B)");
                }
                return engine.getTypeName();
            }
            case 5: {
                return engine.getWeightTons();
            }
            case 8: {
                if (engine.isLead()) {
                    return engine.getConsistName() + "*";
                }
                return engine.getConsistName();
            }
            case 9: {
                Object s = engine.getStatus();
                if (!engine.getLocationName().equals("")) {
                    s = engine.getStatus() + engine.getLocationName() + " (" + engine.getTrackName() + ")";
                }
                return s;
            }
            case 10: {
                return engine.getWhereLastSeenName() + (String)(engine.getTrackLastSeenName().equals("") ? "" : " (" + engine.getTrackLastSeenName() + ")");
            }
            case 11: {
                return engine.getWhenLastSeenDate();
            }
            case 12: {
                Object s = "";
                if (!engine.getDestinationName().equals("")) {
                    s = engine.getDestinationName() + " (" + engine.getDestinationTrackName() + ")";
                }
                return s;
            }
            case 13: {
                Object s = "";
                if (!engine.getLastLocationName().equals("")) {
                    s = engine.getLastLocationName() + " (" + engine.getLastTrackName() + ")";
                }
                return s;
            }
            case 14: {
                if (engine.getTrain() != null && engine.getRouteLocation() == null) {
                    return engine.getTrainName() + "*";
                }
                return engine.getTrainName();
            }
            case 15: {
                return engine.getLastTrainName();
            }
            case 16: {
                return engine.getMoves();
            }
            case 17: {
                return engine.getBuilt();
            }
            case 18: {
                return engine.getOwnerName();
            }
            case 19: {
                return engine.getValue();
            }
            case 20: {
                return engine.getRfid();
            }
            case 21: {
                return engine.getSortDate();
            }
            case 22: {
                return engine.getDccAddress();
            }
            case 23: {
                return engine.getComment();
            }
            case 24: {
                return Bundle.getMessage("Set");
            }
            case 25: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return "unknown " + col;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Engine engine = this.engineList.get(row);
        switch (col) {
            case 0: {
                engine.setSelected((Boolean)value);
                break;
            }
            case 16: {
                try {
                    engine.setMoves(Integer.parseInt(value.toString()));
                }
                catch (NumberFormatException e) {
                    log.error("move count must be a number");
                }
                break;
            }
            case 17: {
                engine.setBuilt(value.toString());
                break;
            }
            case 18: {
                engine.setOwnerName(value.toString());
                break;
            }
            case 19: {
                engine.setValue(value.toString());
                break;
            }
            case 20: {
                engine.setRfid(value.toString());
                break;
            }
            case 24: {
                log.debug("Set engine location");
                if (this.engineSetFrame != null) {
                    this.engineSetFrame.dispose();
                }
                SwingUtilities.invokeLater(() -> {
                    this.engineSetFrame = new EngineSetFrame();
                    this.engineSetFrame.initComponents();
                    this.engineSetFrame.load(engine);
                });
                break;
            }
            case 25: {
                log.debug("Edit engine");
                if (this.engineEditFrame != null) {
                    this.engineEditFrame.dispose();
                }
                SwingUtilities.invokeLater(() -> {
                    this.engineEditFrame = new EngineEditFrame();
                    this.engineEditFrame.initComponents();
                    this.engineEditFrame.load(engine);
                });
                break;
            }
        }
    }

    public void dispose() {
        log.debug("dispose EngineTableModel");
        this.engineManager.removePropertyChangeListener(this);
        this.removePropertyChangeEngines();
        if (this.engineSetFrame != null) {
            this.engineSetFrame.dispose();
        }
        if (this.engineEditFrame != null) {
            this.engineEditFrame.dispose();
        }
    }

    private void removePropertyChangeEngines() {
        if (this.engineList != null) {
            for (RollingStock rollingStock : this.engineList) {
                rollingStock.removePropertyChangeListener(this);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Engine engine;
        int row;
        if (e.getPropertyName().equals("RollingStockListLength") || e.getPropertyName().equals("GroupListLengthChanged")) {
            this.updateList();
            this.fireTableDataChanged();
        } else if (e.getPropertyName().equals("rolling stock length") || e.getPropertyName().equals("rolling stock type") || e.getPropertyName().equals("hp")) {
            this.fireTableDataChanged();
        } else if (e.getSource().getClass().equals(Engine.class) && (row = this.engineList.indexOf(engine = (Engine)e.getSource())) >= 0) {
            this.fireTableRowsUpdated(row, row);
        }
    }
}

