/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines.tools;

import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import jmri.InstanceManager;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.RollingStockAttributeEditFrame;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.engines.ConsistManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineLengths;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.EngineModels;
import jmri.jmrit.operations.rollingstock.engines.EngineTypes;
import jmri.jmrit.operations.rollingstock.engines.tools.Bundle;
import jmri.jmrit.operations.rollingstock.engines.tools.EngineAttributeAction;
import jmri.jmrit.operations.rollingstock.engines.tools.EngineDeleteAttributeAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineAttributeEditFrame
extends RollingStockAttributeEditFrame {
    EngineManager engineManager = InstanceManager.getDefault(EngineManager.class);
    public static final String MODEL = "Model";
    public static final String CONSIST = "Consist";
    private static final Logger log = LoggerFactory.getLogger(EngineAttributeEditFrame.class);

    public void initComponents(String attribute) {
        this.initComponents(attribute, "");
    }

    @Override
    public void initComponents(String attribute, String name) {
        super.initComponents(attribute, name);
        this.setTitle(Bundle.getMessage("TitleEngineEditAtrribute", attribute));
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new EngineAttributeAction(this));
        toolMenu.add(new EngineDeleteAttributeAction(this));
        menuBar.add(toolMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_Locomotives", true);
    }

    @Override
    protected void deleteAttributeName(String deleteItem) {
        super.deleteAttributeName(deleteItem);
        if (this._attribute.equals(MODEL)) {
            InstanceManager.getDefault(EngineModels.class).deleteName(deleteItem);
        }
        if (this._attribute.equals("Type")) {
            InstanceManager.getDefault(EngineTypes.class).deleteName(deleteItem);
        }
        if (this._attribute.equals("Length")) {
            InstanceManager.getDefault(EngineLengths.class).deleteName(deleteItem);
        }
        if (this._attribute.equals(CONSIST)) {
            InstanceManager.getDefault(ConsistManager.class).deleteConsist(deleteItem);
        }
    }

    @Override
    protected void addAttributeName(String addItem) {
        super.addAttributeName(addItem);
        if (this._attribute.equals(MODEL)) {
            InstanceManager.getDefault(EngineModels.class).addName(addItem);
        }
        if (this._attribute.equals("Type")) {
            InstanceManager.getDefault(EngineTypes.class).addName(addItem);
        }
        if (this._attribute.equals("Length")) {
            InstanceManager.getDefault(EngineLengths.class).addName(addItem);
            this.comboBox.setSelectedItem(addItem);
        }
        if (this._attribute.equals(CONSIST)) {
            InstanceManager.getDefault(ConsistManager.class).newConsist(addItem);
        }
    }

    @Override
    protected void replaceItem(String oldItem, String newItem) {
        super.replaceItem(oldItem, newItem);
        if (this._attribute.equals(MODEL)) {
            List engines = this.engineManager.getList();
            for (Engine engine : engines) {
                if (!engine.getModel().equals(oldItem)) continue;
                if (InstanceManager.getDefault(EngineModels.class).getModelLength(newItem) != null) {
                    engine.setModel(newItem);
                    continue;
                }
                String length = engine.getLength();
                String hp = engine.getHp();
                String type = engine.getTypeName();
                engine.setModel(newItem);
                engine.setLength(length);
                engine.setHp(hp);
                engine.setTypeName(type);
            }
            InstanceManager.getDefault(EngineModels.class).replaceName(oldItem, newItem);
        }
        if (this._attribute.equals(CONSIST)) {
            InstanceManager.getDefault(ConsistManager.class).replaceConsistName(oldItem, newItem);
        }
        if (this._attribute.equals("Type")) {
            InstanceManager.getDefault(EngineTypes.class).replaceName(oldItem, newItem);
        }
        if (this._attribute.equals("Length")) {
            InstanceManager.getDefault(EngineLengths.class).replaceName(oldItem, newItem);
        }
    }

    @Override
    protected void loadCombobox() {
        super.loadCombobox();
        if (this._attribute.equals(MODEL)) {
            this.comboBox = InstanceManager.getDefault(EngineModels.class).getComboBox();
            InstanceManager.getDefault(EngineModels.class).addPropertyChangeListener(this);
        }
        if (this._attribute.equals("Type")) {
            this.comboBox = InstanceManager.getDefault(EngineTypes.class).getComboBox();
            InstanceManager.getDefault(EngineTypes.class).addPropertyChangeListener(this);
        }
        if (this._attribute.equals("Length")) {
            this.comboBox = InstanceManager.getDefault(EngineLengths.class).getComboBox();
            InstanceManager.getDefault(EngineLengths.class).addPropertyChangeListener(this);
        }
        if (this._attribute.equals(CONSIST)) {
            this.comboBox = InstanceManager.getDefault(ConsistManager.class).getComboBox();
            InstanceManager.getDefault(ConsistManager.class).addPropertyChangeListener(this);
        }
    }

    @Override
    protected void updateAttributeQuanity() {
        if (!showQuanity) {
            return;
        }
        int number = 0;
        String item = (String)this.comboBox.getSelectedItem();
        log.debug("Selected item {}", (Object)item);
        for (Engine eng : this.engineManager.getList()) {
            if (this._attribute.equals("Road") && eng.getRoadName().equals(item)) {
                ++number;
            }
            if (this._attribute.equals(MODEL) && eng.getModel().equals(item)) {
                ++number;
            }
            if (this._attribute.equals(CONSIST) && eng.getConsistName().equals(item)) {
                ++number;
            }
            if (this._attribute.equals("Type") && eng.getTypeName().equals(item)) {
                ++number;
            }
            if (this._attribute.equals("Length") && eng.getLength().equals(item)) {
                ++number;
            }
            if (!this._attribute.equals("Owner") || !eng.getOwnerName().equals(item)) continue;
            ++number;
        }
        this.quanity.setText(Integer.toString(number));
        if (number == 0 && this.deleteUnused) {
            if (this._attribute.equals("Road")) {
                for (RollingStock rs : InstanceManager.getDefault(CarManager.class).getList()) {
                    if (!rs.getRoadName().equals(item)) continue;
                    log.info("Car ({} {}) is assigned road name ({})", new Object[]{rs.getRoadName(), rs.getNumber(), item});
                    return;
                }
            }
            if (this._attribute.equals("Owner")) {
                for (RollingStock rs : InstanceManager.getDefault(CarManager.class).getList()) {
                    if (!rs.getOwnerName().equals(item)) continue;
                    log.info("Car ({} {}) is assigned owner name ({})", new Object[]{rs.getRoadName(), rs.getNumber(), item});
                    return;
                }
            }
            this.confirmDelete(item);
        }
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(EngineModels.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(EngineTypes.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(EngineLengths.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(ConsistManager.class).removePropertyChangeListener(this);
        this.engineManager.removePropertyChangeListener(this);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("EngineModels")) {
            InstanceManager.getDefault(EngineModels.class).updateComboBox(this.comboBox);
        }
        if (e.getPropertyName().equals("EngineTypesLength")) {
            InstanceManager.getDefault(EngineTypes.class).updateComboBox(this.comboBox);
        }
        if (e.getPropertyName().equals("EngineLengths")) {
            InstanceManager.getDefault(EngineLengths.class).updateComboBox(this.comboBox);
        }
        if (e.getPropertyName().equals("GroupListLengthChanged")) {
            InstanceManager.getDefault(ConsistManager.class).updateComboBox(this.comboBox);
        }
        super.propertyChange(e);
    }
}

