/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines.tools;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JTable;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.gui.EngineSetFrame;
import jmri.jmrit.operations.rollingstock.engines.gui.EnginesTableModel;
import jmri.jmrit.operations.rollingstock.engines.tools.Bundle;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnginesSetFrame
extends EngineSetFrame {
    EnginesTableModel _enginesTableModel;
    JTable _enginesTable;
    private static boolean ignoreStatusCheckBoxSelected = true;
    private static boolean ignoreLocationCheckBoxSelected = true;
    private static boolean ignoreConsistCheckBoxSelected = true;
    private static boolean ignoreDestinationCheckBoxSelected = true;
    private static boolean ignoreTrainCheckBoxSelected = true;
    boolean toggle = false;
    private static final Logger log = LoggerFactory.getLogger(EnginesSetFrame.class);

    public void initComponents(JTable enginesTable) {
        this._enginesTable = enginesTable;
        this._enginesTableModel = (EnginesTableModel)enginesTable.getModel();
        super.initComponents("package.jmri.jmrit.operations.Operations_SetEngines");
        this.setTitle(Bundle.getMessage("TitleSetEngines"));
        this.saveButton.setText(Bundle.getMessage("ButtonApply"));
        this.ignoreStatusCheckBox.setVisible(true);
        this.ignoreLocationCheckBox.setVisible(true);
        this.ignoreConsistCheckBox.setVisible(true);
        this.ignoreDestinationCheckBox.setVisible(true);
        this.ignoreTrainCheckBox.setVisible(true);
        this.ignoreAllButton.setVisible(true);
        this.ignoreStatusCheckBox.setSelected(ignoreStatusCheckBoxSelected);
        this.ignoreLocationCheckBox.setSelected(ignoreLocationCheckBoxSelected);
        this.ignoreConsistCheckBox.setSelected(ignoreConsistCheckBoxSelected);
        this.ignoreDestinationCheckBox.setSelected(ignoreDestinationCheckBoxSelected);
        this.ignoreTrainCheckBox.setSelected(ignoreTrainCheckBoxSelected);
        int[] rows = this._enginesTable.getSelectedRows();
        if (rows.length > 0) {
            Engine engine = this._enginesTableModel.getEngineAtIndex(this._enginesTable.convertRowIndexToModel(rows[0]));
            super.load(engine);
        } else {
            this.enableComponents(true);
            this.showMessageDialogWarning();
        }
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        super.buttonActionPerformed(ae);
        if (ae.getSource() == this.ignoreAllButton) {
            this.ignoreAll(this.toggle);
        }
    }

    protected void ignoreAll(boolean b) {
        this.ignoreStatusCheckBox.setSelected(!this.locationUnknownCheckBox.isSelected() & b);
        this.ignoreLocationCheckBox.setSelected(b);
        this.ignoreConsistCheckBox.setSelected(b);
        this.ignoreDestinationCheckBox.setSelected(b);
        this.ignoreTrainCheckBox.setSelected(b);
        this.enableComponents(!this.locationUnknownCheckBox.isSelected());
        this.toggle = !b;
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GUI ease of use")
    protected boolean save() {
        ignoreStatusCheckBoxSelected = this.ignoreStatusCheckBox.isSelected();
        ignoreLocationCheckBoxSelected = this.ignoreLocationCheckBox.isSelected();
        ignoreConsistCheckBoxSelected = this.ignoreConsistCheckBox.isSelected();
        ignoreDestinationCheckBoxSelected = this.ignoreConsistCheckBox.isSelected();
        ignoreTrainCheckBoxSelected = this.ignoreTrainCheckBox.isSelected();
        ArrayList<Engine> engines = new ArrayList<Engine>();
        int[] rows = this._enginesTable.getSelectedRows();
        for (int row : rows) {
            Engine engine = this._enginesTableModel.getEngineAtIndex(this._enginesTable.convertRowIndexToModel(row));
            log.debug("Adding selected engine {} to change list", (Object)engine.toString());
            engines.add(engine);
        }
        if (rows.length == 0) {
            this.showMessageDialogWarning();
            return false;
        }
        if (engines.get(0) != this._engine) {
            log.debug("Default engine isn't the first one selected");
            if (JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("doYouWantToChange", ((Engine)engines.get(0)).toString()), Bundle.getMessage("changeDefaultEngine"), 0) == 0) {
                super.load((Engine)engines.get(0));
                return false;
            }
        }
        this.askConsistChange = false;
        Object object = engines.iterator();
        block1: while (object.hasNext()) {
            Engine engine = (Engine)object.next();
            if (engine.getConsist() == null) continue;
            for (Engine c : engine.getConsist().getEngines()) {
                if (engines.contains(c)) continue;
                this.askConsistChange = true;
                continue block1;
            }
        }
        for (Engine engine : engines) {
            if (!super.change(engine)) {
                return false;
            }
            if (engine.getConsist() == null || this.ignoreConsistCheckBox.isSelected()) continue;
            this.askConsistChange = false;
        }
        return false;
    }

    private void showMessageDialogWarning() {
        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("selectEngines"), Bundle.getMessage("engineNoneSelected"), 2);
    }
}

