/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.ImportCommon;
import jmri.jmrit.operations.rollingstock.engines.Consist;
import jmri.jmrit.operations.rollingstock.engines.ConsistManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.EngineModels;
import jmri.jmrit.operations.rollingstock.engines.tools.Bundle;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportEngines
extends ImportCommon {
    private static final String DEFAULT_ENGINE_TYPE = Bundle.getMessage("engineDefaultType");
    private static final String DEFAULT_ENGINE_HP = Bundle.getMessage("engineDefaultHp");
    private static final int ENG_NUMBER = 0;
    private static final int ENG_ROAD = 1;
    private static final int ENG_MODEL = 2;
    private static final int ENG_LENGTH = 3;
    private static final int ENG_OWNER = 4;
    private static final int ENG_BUILT = 5;
    private static final int ENG_LOCATION = 6;
    private static final int ENG_LOCATION_TRACK_SEPARATOR = 7;
    private static final int ENG_TRACK = 8;
    private static final int ENG_CONSIST = 9;
    private static final int ENG_HP = 13;
    private static final int ENG_WEIGHT = 14;
    private static final int ENG_TYPE = 15;
    EngineManager engineManager = InstanceManager.getDefault(EngineManager.class);
    private static final Logger log = LoggerFactory.getLogger(ImportEngines.class);

    @Override
    public void run() {
        int enginesAdded;
        boolean importOkay;
        BufferedReader in;
        block60: {
            File file = this.getFile();
            if (file == null) {
                return;
            }
            in = this.getBufferedReader(file);
            if (in == null) {
                return;
            }
            this.createStatusFrame(Bundle.getMessage("ImportEngines"));
            importOkay = false;
            boolean comma = false;
            int lineNum = 0;
            enginesAdded = 0;
            String line = " ";
            String engineOwner = "";
            String engineBuilt = "";
            String engineLocationName = "";
            String engineTrackName = "";
            String engineConsistName = "";
            String engineHp = "";
            String engineWeightTons = "";
            String engineType = "";
            if (file.getAbsolutePath().endsWith(".csv")) {
                log.info("Using comma as delimiter for import engines");
                comma = true;
            }
            while (true) {
                this.lineNumber.setText(Bundle.getMessage("LineNumber") + " " + Integer.toString(++lineNum));
                try {
                    line = in.readLine();
                }
                catch (IOException e) {
                    break block60;
                }
                if (line == null) {
                    importOkay = true;
                    break block60;
                }
                if (!this.fstatus.isShowing()) break block60;
                line = line.trim();
                log.debug("Import: {}", (Object)line);
                this.importLine.setText(line);
                if (line.startsWith(Bundle.getMessage("Number"))) continue;
                if (line.equalsIgnoreCase("comma")) {
                    log.info("Using comma as delimiter for import engines");
                    comma = true;
                    continue;
                }
                String[] inputLine = comma ? this.parseCommaLine(line) : line.split("\\s+");
                if (inputLine.length < 1 || line.isEmpty()) {
                    log.debug("Skipping blank line");
                    continue;
                }
                int base = 1;
                if (comma || !inputLine[0].isEmpty()) {
                    --base;
                }
                if (inputLine.length > base + 3) {
                    int results;
                    String status;
                    int results2;
                    String engineNumber = inputLine[base + 0].trim();
                    String engineRoad = inputLine[base + 1].trim();
                    String engineModel = inputLine[base + 2].trim();
                    String engineLength = inputLine[base + 3].trim();
                    engineOwner = "";
                    engineBuilt = "";
                    engineLocationName = "";
                    engineTrackName = "";
                    engineConsistName = "";
                    engineHp = "";
                    engineWeightTons = "";
                    engineType = "";
                    log.debug("Checking engine number ({}) road ({}) model ({}) length ({})", new Object[]{engineNumber, engineRoad, engineModel, engineLength});
                    if (engineNumber.isEmpty()) {
                        log.info("Import line {} missing engine number", (Object)lineNum);
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("RoadNumberNotSpecified", lineNum), Bundle.getMessage("RoadNumberMissing"), 0);
                        break block60;
                    }
                    if (engineRoad.isEmpty()) {
                        log.info("Import line {} missing engine road", (Object)lineNum);
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("RoadNameNotSpecified", lineNum), Bundle.getMessage("RoadNameMissing"), 0);
                        break block60;
                    }
                    if (engineModel.isEmpty()) {
                        log.info("Import line {} missing engine model", (Object)lineNum);
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("EngineModelNotSpecified", lineNum), Bundle.getMessage("EngineModelMissing"), 0);
                        break block60;
                    }
                    if (engineLength.isEmpty()) {
                        log.info("Import line {} missing engine length", (Object)lineNum);
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("EngineLengthNotSpecified", lineNum), Bundle.getMessage("EngineLengthMissing"), 0);
                        break block60;
                    }
                    if (TrainCommon.splitString(engineNumber).length() > Control.max_len_string_road_number) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("EngineRoadNumberTooLong", engineRoad, engineNumber, engineNumber), Bundle.getMessage("RoadNumMustBeLess"), 0);
                        break block60;
                    }
                    if (engineRoad.length() > Control.max_len_string_attibute) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("EngineRoadNameTooLong", engineRoad, engineNumber, engineRoad), Bundle.getMessage("engineAttribute", Control.max_len_string_attibute), 0);
                        break block60;
                    }
                    if (engineModel.length() > Control.max_len_string_attibute) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("EngineModelNameTooLong", engineRoad, engineNumber, engineModel), Bundle.getMessage("engineAttribute", Control.max_len_string_attibute), 0);
                        break block60;
                    }
                    if (!InstanceManager.getDefault(EngineModels.class).containsName(engineModel)) {
                        int results3 = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("Engine") + " (" + engineRoad + " " + engineNumber + ")\n" + Bundle.getMessage("modelNameNotExist", engineModel), Bundle.getMessage("engineAddModel"), 1);
                        if (results3 == 0) {
                            InstanceManager.getDefault(EngineModels.class).addName(engineModel);
                        } else if (results3 == 2) break block60;
                    }
                    if (engineLength.length() > Control.max_len_string_length_name) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("EngineLengthNameTooLong", engineRoad, engineNumber, engineLength), Bundle.getMessage("engineAttribute", Control.max_len_string_length_name), 0);
                        break block60;
                    }
                    try {
                        Integer.parseInt(engineLength);
                    }
                    catch (NumberFormatException e) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("EngineLengthNameNotNumber", engineRoad, engineNumber, engineLength), Bundle.getMessage("EngineLengthMissing"), 0);
                        break block60;
                    }
                    Engine e = (Engine)this.engineManager.getByRoadAndNumber(engineRoad, engineNumber);
                    if (e != null) {
                        log.info("Can not add engine number ({}) road ({}) it already exists!", (Object)engineNumber, (Object)engineRoad);
                        continue;
                    }
                    if (inputLine.length > base + 4 && (engineOwner = inputLine[base + 4].trim()).length() > Control.max_len_string_attibute) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("EngineOwnerNameTooLong", engineRoad, engineNumber, engineOwner), Bundle.getMessage("engineAttribute", Control.max_len_string_attibute), 0);
                        break block60;
                    }
                    if (inputLine.length > base + 5 && (engineBuilt = inputLine[base + 5].trim()).length() > Control.max_len_string_built_name) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("EngineBuiltDateTooLong", engineRoad, engineNumber, engineBuilt), Bundle.getMessage("engineAttribute", Control.max_len_string_built_name), 0);
                        break block60;
                    }
                    if (inputLine.length > base + 6) {
                        engineLocationName = inputLine[base + 6].trim();
                    }
                    if (comma && inputLine.length > base + 8) {
                        engineTrackName = inputLine[base + 8].trim();
                    }
                    if (!comma) {
                        int i;
                        int j = 0;
                        StringBuffer name = new StringBuffer(engineLocationName);
                        for (i = base + 7; i < inputLine.length; ++i) {
                            if (inputLine[i].equals("-")) {
                                j = i + 1;
                                break;
                            }
                            name.append(" " + inputLine[i]);
                        }
                        engineLocationName = name.toString();
                        log.debug("Engine ({} {}) has location ({})", new Object[]{engineRoad, engineNumber, engineLocationName});
                        name = new StringBuffer();
                        if (j != 0 && j < inputLine.length) {
                            name.append(inputLine[j]);
                            for (i = j + 1; i < inputLine.length; ++i) {
                                name.append(" " + inputLine[i]);
                            }
                            log.debug("Engine ({} {}) has track ({})", new Object[]{engineRoad, engineNumber, engineTrackName});
                        }
                        engineTrackName = name.toString();
                    }
                    if (engineLocationName.length() > Control.max_len_string_location_name) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("EngineLocationNameTooLong", engineRoad, engineNumber, engineLocationName), Bundle.getMessage("engineAttribute", Control.max_len_string_location_name), 0);
                        break block60;
                    }
                    if (engineTrackName.length() > Control.max_len_string_track_name) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("EngineTrackNameTooLong", engineRoad, engineNumber, engineTrackName), Bundle.getMessage("engineAttribute", Control.max_len_string_track_name), 0);
                        break block60;
                    }
                    Location location = InstanceManager.getDefault(LocationManager.class).getLocationByName(engineLocationName);
                    Track track = null;
                    if (location == null && !engineLocationName.isEmpty()) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("EngineLocationDoesNotExist", engineRoad, engineNumber, engineLocationName), Bundle.getMessage("engineLocation"), 0);
                        results2 = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToCreateLoc", engineLocationName), Bundle.getMessage("engineLocation"), 0);
                        if (results2 != 0) break block60;
                        log.debug("Create location ({})", (Object)engineLocationName);
                        location = InstanceManager.getDefault(LocationManager.class).newLocation(engineLocationName);
                    }
                    if (location != null && !engineTrackName.isEmpty() && (track = location.getTrackByName(engineTrackName, null)) == null) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("EngineTrackDoesNotExist", engineRoad, engineNumber, engineTrackName, engineLocationName), Bundle.getMessage("engineTrack"), 0);
                        results2 = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToCreateTrack", engineTrackName, engineLocationName), Bundle.getMessage("engineTrack"), 0);
                        if (results2 != 0) break block60;
                        if (!location.isStaging()) {
                            log.debug("Create 1000 foot yard track ({})", (Object)engineTrackName);
                            track = location.addTrack(engineTrackName, "Yard");
                        } else {
                            log.debug("Create 1000 foot staging track ({})", (Object)engineTrackName);
                            track = location.addTrack(engineTrackName, "Staging");
                        }
                        track.setLength(1000);
                    }
                    if (comma && inputLine.length > base + 9) {
                        engineConsistName = inputLine[9].trim();
                        log.debug("Consist name ({})", (Object)engineConsistName);
                    }
                    if (comma && inputLine.length > base + 13) {
                        engineHp = inputLine[13].trim();
                        log.debug("Engine HP ({})", (Object)engineHp);
                    }
                    if (comma && inputLine.length > base + 14) {
                        engineWeightTons = inputLine[14].trim();
                        log.debug("Engine weight tons ({})", (Object)engineWeightTons);
                    }
                    if (comma && inputLine.length > base + 15) {
                        engineType = inputLine[15].trim();
                        log.debug("Engine type ({})", (Object)engineType);
                    }
                    log.debug("Add engine ({} {}) owner ({}) built ({}) location ({}, {})", new Object[]{engineRoad, engineNumber, engineOwner, engineBuilt, engineLocationName, engineTrackName});
                    Engine engine = this.engineManager.newRS(engineRoad, engineNumber);
                    engine.setModel(engineModel);
                    engine.setLength(engineLength);
                    if (engine.getTypeName().equals("")) {
                        if (!engineType.isEmpty()) {
                            engine.setTypeName(engineType);
                        } else {
                            engine.setTypeName(DEFAULT_ENGINE_TYPE);
                        }
                    }
                    if (engine.getHp().equals("")) {
                        if (!engineHp.isEmpty()) {
                            engine.setHp(engineHp);
                        } else {
                            engine.setHp(DEFAULT_ENGINE_HP);
                        }
                    }
                    if (engine.getWeightTons().equals("")) {
                        engine.setWeightTons(engineWeightTons);
                    }
                    engine.setOwnerName(engineOwner);
                    engine.setBuilt(engineBuilt);
                    if (!engineConsistName.isEmpty()) {
                        Consist consist = InstanceManager.getDefault(ConsistManager.class).newConsist(engineConsistName);
                        engine.setConsist(consist);
                    }
                    ++enginesAdded;
                    if (location == null || track == null || (status = engine.setLocation(location, track)).equals(Track.OKAY)) continue;
                    log.debug("Can't set engine's location because of {}", (Object)status);
                    JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("CanNotSetEngineAtLocation", engineRoad, engineNumber, engineModel, engineLocationName, engineTrackName, status), Bundle.getMessage("rsCanNotLoc"), 0);
                    if (status.startsWith(Track.TYPE)) {
                        results = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToAllowService", engineLocationName, engineTrackName, engineRoad, engineNumber, engine.getTypeName()), Bundle.getMessage("ServiceEngineType"), 0);
                        if (results != 0) break block60;
                        location.addTypeName(engine.getTypeName());
                        track.addTypeName(engine.getTypeName());
                        status = engine.setLocation(location, track);
                    }
                    if (status.startsWith(Track.LENGTH) || status.startsWith(Track.CAPACITY)) {
                        results = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantIncreaseLength", engineTrackName), Bundle.getMessage("TrackLength"), 0);
                        if (results != 0) break block60;
                        track.setLength(track.getLength() + 1000);
                        status = engine.setLocation(location, track);
                    }
                    if (status.equals(Track.OKAY)) continue;
                    results = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToForceEngine", engineRoad, engineNumber, engineLocationName, engineTrackName), Bundle.getMessage("OverRide"), 0);
                    if (results == 0) {
                        engine.setLocation(location, track, true);
                        continue;
                    }
                    break block60;
                }
                if (!line.isEmpty()) break;
            }
            log.info("Engine import line {} missing attributes: {}", (Object)lineNum, (Object)line);
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ImportMissingAttributes", lineNum), Bundle.getMessage("EngineAttributeMissing"), 0);
        }
        try {
            in.close();
        }
        catch (IOException e) {
            log.error("Import Engines failed: {}", (Object)e.getLocalizedMessage());
        }
        if (importOkay) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ImportEnginesAdded", enginesAdded), Bundle.getMessage("SuccessfulImport"), 1);
        } else {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ImportEnginesAdded", enginesAdded), Bundle.getMessage("ImportFailed"), 0);
        }
        this.fstatus.dispose();
    }
}

