/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines.tools;

import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.tools.Bundle;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.RosterGroupComboBox;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportRosterEngines
extends Thread {
    EngineManager manager = InstanceManager.getDefault(EngineManager.class);
    private static String defaultEngineLength = Bundle.getMessage("engineDefaultLength");
    private static String defaultEngineType = Bundle.getMessage("engineDefaultType");
    private static String defaultEngineHp = Bundle.getMessage("engineDefaultHp");
    JLabel textEngine = new JLabel(Bundle.getMessage("AddEngine"));
    JLabel textId = new JLabel();
    private static final Logger log = LoggerFactory.getLogger(ImportRosterEngines.class);

    @Override
    public void run() {
        JmriJFrame fstatus = new JmriJFrame(Bundle.getMessage("TitleImportEngines"));
        fstatus.setSize(500, 100);
        JPanel ps = new JPanel();
        ps.add(this.textEngine);
        ps.add(this.textId);
        fstatus.getContentPane().add(ps);
        fstatus.setVisible(true);
        RosterGroupComboBox comboBox = new RosterGroupComboBox();
        ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.roster.JmritRosterBundle");
        JmriJOptionPane.showMessageDialog(null, comboBox, rb.getString("SelectRosterGroup"), 3);
        String groupName = comboBox.getSelectedItem();
        log.debug("User selected roster group: {}", (Object)groupName);
        int enginesAdded = 0;
        List<RosterEntry> engines = Roster.getDefault().getEntriesMatchingCriteria(null, null, null, null, null, null, null, groupName, null, null, null);
        for (RosterEntry re : engines) {
            String number;
            if (re.getRoadName().isEmpty() || re.getRoadNumber().isEmpty()) {
                log.error("Roster Id: {} doesn't have a road name and road number", (Object)re.getId());
                continue;
            }
            String road = re.getRoadName().trim();
            if (road.length() > Control.max_len_string_attibute) {
                road = road.substring(0, Control.max_len_string_attibute);
            }
            if ((number = re.getRoadNumber().trim()).length() > Control.max_len_string_road_number) {
                number = number.substring(0, Control.max_len_string_road_number);
            }
            this.textId.setText(road + " " + number);
            Engine engine = (Engine)this.manager.getByRoadAndNumber(road, number);
            if (engine == null) {
                String owner;
                engine = this.manager.newRS(road, number);
                String model = re.getModel().trim();
                if (model.length() > Control.max_len_string_attibute) {
                    model = model.substring(0, Control.max_len_string_attibute);
                }
                if (model.isEmpty()) {
                    log.warn("Roster Id: {} hasn't been assigned a model name", (Object)re.getId());
                }
                engine.setModel(model);
                if (engine.getLength().equals("")) {
                    engine.setLength(defaultEngineLength);
                }
                if (engine.getTypeName().equals("")) {
                    engine.setTypeName(defaultEngineType);
                }
                if (engine.getHp().equals("")) {
                    engine.setHp(defaultEngineHp);
                }
                if ((owner = re.getOwner().trim()).length() > Control.max_len_string_attibute) {
                    owner = owner.substring(0, Control.max_len_string_attibute);
                }
                engine.setOwnerName(owner);
                ++enginesAdded;
                continue;
            }
            log.info("Can not add roster Id: {}, engine road name ({}) road number ({}) already exists", new Object[]{re.getId(), re.getRoadName(), re.getRoadNumber()});
        }
        fstatus.dispose();
        if (enginesAdded > 0) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ImportEnginesAdded", enginesAdded), Bundle.getMessage("SuccessfulImport"), 1);
        } else {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ImportEnginesAdded", enginesAdded), Bundle.getMessage("ImportFailed"), 0);
        }
    }
}

