/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines.tools;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.operations.rollingstock.engines.Consist;
import jmri.jmrit.operations.rollingstock.engines.ConsistManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.tools.Bundle;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceTrafficController;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceConsistEngines
extends Thread
implements NceListener {
    private boolean syncOK = true;
    EngineManager engineManager = InstanceManager.getDefault(EngineManager.class);
    List<Engine> engineList;
    List<String> consists;
    JLabel textConsist = new JLabel();
    JLabel indexNumber = new JLabel();
    private static final int CS_CONSIST_MEM = 62720;
    private static final int CS_CON_MEM_REAR = 256;
    private static final int CS_CON_MEM_MID = 512;
    private static final int REPLY_16 = 16;
    private int replyLen = 0;
    private int waiting = 0;
    private int index = 0;
    private static final int CONSIST_LNTH = 1536;
    private static final int NUM_CONSIST_READS = 96;
    private static final String NCE = "nce_";
    private static byte[] nceConsistData = new byte[1536];
    NceTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(NceConsistEngines.class);

    public NceConsistEngines(NceTrafficController tc) {
        this.tc = tc;
    }

    @Override
    public void run() {
        if (this.tc == null) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("NceSynchronizationFailed"), Bundle.getMessage("NceConsist"), 0);
            return;
        }
        if (JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("SynchronizeWithNce"), Bundle.getMessage("NceConsist"), 0) != 0) {
            return;
        }
        this.index = 0;
        this.waiting = 0;
        this.syncOK = true;
        JPanel ps = new JPanel();
        JmriJFrame fstatus = new JmriJFrame(Bundle.getMessage("ReadingNceConsistMemory"));
        fstatus.setLocationRelativeTo(null);
        fstatus.setSize(300, 100);
        ps.add(this.textConsist);
        ps.add(this.indexNumber);
        fstatus.getContentPane().add(ps);
        this.textConsist.setText(Bundle.getMessage("ReadNumber"));
        this.textConsist.setVisible(true);
        this.indexNumber.setVisible(true);
        fstatus.setVisible(true);
        for (int readIndex = 0; readIndex < 96; ++readIndex) {
            this.indexNumber.setText(Integer.toString(readIndex));
            fstatus.setVisible(true);
            this.getNceConsist(readIndex);
            if (!this.syncOK) break;
        }
        fstatus.dispose();
        if (this.syncOK) {
            this.engineList = this.engineManager.getByNumberList();
            this.consists = new ArrayList<String>();
            for (int consistNum = 1; consistNum < 128; ++consistNum) {
                InstanceManager.getDefault(ConsistManager.class).deleteConsist(NCE + consistNum);
                int engNum = this.getEngineNumberFromArray(consistNum, 0, 2);
                if (engNum == 0) continue;
                log.debug("NCE consist {} has lead engine {}", (Object)consistNum, (Object)engNum);
                boolean engMatch = false;
                for (Engine engine : this.engineList) {
                    if (!engine.getNumber().equals(Integer.toString(engNum))) continue;
                    log.debug("found lead engine match {}", (Object)engine.getNumber());
                    Consist engConsist = InstanceManager.getDefault(ConsistManager.class).newConsist(NCE + consistNum);
                    engConsist.setConsistNumber(consistNum);
                    engine.setConsist(engConsist);
                    engine.setBlocking(0);
                    engMatch = true;
                    this.consists.add(Integer.toString(consistNum));
                    break;
                }
                if (engMatch) continue;
                log.info("Lead engine {} not found in operations for NCE consist {}", (Object)engNum, (Object)consistNum);
            }
            this.syncEngines(256, 2);
            this.syncEngines(512, 8);
            this.syncEngines(514, 8);
            this.syncEngines(516, 8);
            this.syncEngines(518, 8);
        }
        if (this.syncOK) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("SuccessfulSynchronization"), Bundle.getMessage("NceConsist"), 1);
        } else {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("SynchronizationFailed"), Bundle.getMessage("NceConsist"), 0);
        }
    }

    private void syncEngines(int offset, int step) {
        for (int consistNum = 1; consistNum < 128; ++consistNum) {
            int engNum = this.getEngineNumberFromArray(consistNum, offset, step);
            if (engNum == 0) continue;
            log.debug("NCE consist {} has engine {}", (Object)consistNum, (Object)engNum);
            boolean engMatch = false;
            for (Engine engine : this.engineList) {
                if (!engine.getNumber().equals(Integer.toString(engNum))) continue;
                log.debug("found engine match {}", (Object)engine.getNumber());
                engMatch = true;
                Consist engConsist = InstanceManager.getDefault(ConsistManager.class).getConsistByName(NCE + consistNum);
                if (engConsist != null) {
                    engine.setConsist(engConsist);
                    if (offset == 256) {
                        engine.setBlocking(8);
                        break;
                    }
                    engine.setBlocking(engConsist.getSize());
                    break;
                }
                log.warn("Engine ({}) needs lead engine {} for consist {}", new Object[]{engNum, this.getEngineNumberFromArray(consistNum, 0, 2), consistNum});
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("NceConsistNeedsLeadEngine", engNum, this.getEngineNumberFromArray(consistNum, 0, 2), consistNum), Bundle.getMessage("NceConsist"), 0);
                this.syncOK = false;
            }
            if (engMatch) continue;
            log.warn("Engine {} not found in operations for NCE consist {}", (Object)engNum, (Object)consistNum);
            if (!this.consists.contains(Integer.toString(consistNum))) continue;
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("NceConsistMissingEngineNumber", engNum, consistNum), Bundle.getMessage("NceConsist"), 0);
            this.syncOK = false;
        }
    }

    private int getEngineNumberFromArray(int consistNumber, int offset, int step) {
        int engH = nceConsistData[consistNumber * step + offset] << 8 & 0x3FFF;
        int engL = nceConsistData[consistNumber * step + offset + 1] & 0xFF;
        return engH + engL;
    }

    private void getNceConsist(int cR) {
        NceMessage m = this.readConsistMemory(cR);
        this.tc.sendNceMessage(m, this);
        this.readWait();
    }

    private synchronized boolean readWait() {
        int waitcount = 10;
        while (this.waiting > 0) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (waitcount-- >= 0) continue;
            log.error("read timeout");
            this.syncOK = false;
            return false;
        }
        return true;
    }

    private NceMessage readConsistMemory(int num) {
        int nceConsistAddr = num * 16 + 62720;
        this.replyLen = 16;
        ++this.waiting;
        byte[] bl = NceBinaryCommand.accMemoryRead(nceConsistAddr);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 16);
        return m;
    }

    @Override
    public void message(NceMessage m) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY", "NO_NOTIFY_NOT_NOTIFYALL"}, justification="Only want to notify this thread")
    public void reply(NceReply r) {
        if (this.waiting <= 0) {
            log.error("unexpected response");
            return;
        }
        if (r.getNumDataElements() != this.replyLen) {
            log.error("reply length incorrect");
            return;
        }
        for (int i = 0; i < 16; ++i) {
            NceConsistEngines.nceConsistData[this.index++] = (byte)r.getElement(i);
        }
        --this.waiting;
        NceConsistEngines nceConsistEngines = this;
        synchronized (nceConsistEngines) {
            this.notify();
        }
    }
}

