/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock.engines.tools;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsPanel;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.engines.ConsistManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.EngineModels;
import jmri.jmrit.operations.rollingstock.engines.EngineTypes;
import jmri.jmrit.operations.rollingstock.engines.gui.EnginesTableFrame;
import jmri.jmrit.operations.rollingstock.engines.tools.Bundle;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintEngineRosterFrame
extends OperationsFrame {
    boolean _isPreview;
    EnginesTableFrame _etf;
    private int numberCharPerLine = 90;
    private int lastLength = 19;
    EngineManager engineManager = InstanceManager.getDefault(EngineManager.class);
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    JCheckBox printLocosWithLocation = new JCheckBox(Bundle.getMessage("PrintLocosWithLocation"));
    JComboBox<String> sortByComboBox = new JComboBox();
    JComboBox<String> manifestOrientationComboBox = new JComboBox();
    JComboBox<Integer> fontSizeComboBox = new JComboBox();
    JButton okayButton = new JButton(Bundle.getMessage("ButtonOK"));
    private static final Logger log = LoggerFactory.getLogger(PrintEngineRosterFrame.class);

    public PrintEngineRosterFrame(boolean isPreview, EnginesTableFrame etf) {
        this._isPreview = isPreview;
        this._etf = etf;
        JPanel pSortBy = new JPanel();
        pSortBy.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SortBy")));
        pSortBy.add(this.sortByComboBox);
        this.addComboBoxAction(this.sortByComboBox);
        JPanel pOrientation = new JPanel();
        pOrientation.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutOrientation")));
        pOrientation.add(this.manifestOrientationComboBox);
        this.manifestOrientationComboBox.addItem(Setup.PORTRAIT);
        this.manifestOrientationComboBox.addItem(Setup.LANDSCAPE);
        this.manifestOrientationComboBox.setSelectedItem(Setup.LANDSCAPE);
        JPanel pFontSize = new JPanel();
        pFontSize.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutFontSize")));
        pFontSize.add(this.fontSizeComboBox);
        OperationsPanel.loadFontSizeComboBox(this.fontSizeComboBox);
        this.fontSizeComboBox.setSelectedItem(Control.reportFontSize);
        JPanel pPanel = new JPanel();
        pPanel.setLayout(new GridBagLayout());
        JScrollPane panePanel = new JScrollPane(pPanel);
        panePanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PrintOptions")));
        this.addItemLeft(pPanel, this.printLocosWithLocation, 0, 0);
        JPanel pButtons = new JPanel();
        pButtons.setLayout(new GridBagLayout());
        pButtons.add(this.okayButton);
        pButtons.setBorder(BorderFactory.createTitledBorder(""));
        this.addButtonAction(this.okayButton);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(pSortBy);
        this.getContentPane().add(pOrientation);
        this.getContentPane().add(pFontSize);
        this.getContentPane().add(panePanel);
        this.getContentPane().add(pButtons);
        if (this._isPreview) {
            this.setTitle(Bundle.getMessage("MenuItemPreview"));
        } else {
            this.setTitle(Bundle.getMessage("MenuItemPrint"));
        }
        this.loadSortByComboBox(this.sortByComboBox);
        this.initMinimumSize(new Dimension(300, 300));
    }

    @Override
    public void initComponents() {
        this.sortByComboBox.setSelectedItem(this._etf.enginesTableModel.getSortByName());
    }

    private void loadSortByComboBox(JComboBox<String> box) {
        box.removeAllItems();
        for (int i = this._etf.enginesTableModel.SORTBY_NUMBER; i <= this._etf.enginesTableModel.SORTBY_COMMENT; ++i) {
            box.addItem(this._etf.enginesTableModel.getSortByName(i));
        }
        box.setSelectedItem(this._etf.enginesTableModel.getSortByName());
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        this.setVisible(false);
        this.printEngines();
    }

    private void printEngines() {
        boolean isLandscape = false;
        if (this.manifestOrientationComboBox.getSelectedItem() != null && this.manifestOrientationComboBox.getSelectedItem().equals(Setup.LANDSCAPE)) {
            isLandscape = true;
        }
        int fontSize = (Integer)this.fontSizeComboBox.getSelectedItem();
        try (HardcopyWriter writer = new HardcopyWriter(new Frame(), Bundle.getMessage("TitleEngineRoster"), fontSize, 0.5, 0.5, 0.5, 0.5, this._isPreview, "", isLandscape, true, null, null);){
            this.numberCharPerLine = writer.getCharactersPerLine();
            this.write(writer, this.createHeader());
            this.printRoster(writer);
            writer.close();
        }
        catch (IOException we) {
            log.error("Error printing ConsistRosterEntry: {}", (Object)we.getLocalizedMessage());
        }
        catch (HardcopyWriter.PrintCanceledException ex) {
            log.debug("Print canceled");
        }
    }

    private String createHeader() {
        StringBuffer header = new StringBuffer();
        header.append(this.padAttribute(Bundle.getMessage("Number"), Control.max_len_string_print_road_number) + this.padAttribute(Bundle.getMessage("Road"), InstanceManager.getDefault(CarRoads.class).getMaxNameLength()) + this.padAttribute(Bundle.getMessage("Model"), InstanceManager.getDefault(EngineModels.class).getMaxNameLength()) + this.padAttribute(Bundle.getMessage("Type"), InstanceManager.getDefault(EngineTypes.class).getMaxNameLength()) + this.padAttribute(Bundle.getMessage("Len"), Control.max_len_string_length_name));
        if (this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_TRAIN || this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_DESTINATION) {
            header.append(this.padAttribute(Bundle.getMessage("Train"), Control.max_len_string_train_name / 2));
        } else {
            header.append(this.padAttribute(Bundle.getMessage("Consist"), InstanceManager.getDefault(ConsistManager.class).getMaxNameLength()));
        }
        header.append(this.padAttribute(Bundle.getMessage("Location"), this.locationManager.getMaxLocationAndTrackNameLength() + 3));
        if (this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_OWNER) {
            header.append(this.padAttribute(Bundle.getMessage("Owner"), Control.max_len_string_attibute));
        } else if (this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_MOVES) {
            header.append(this.padAttribute(Bundle.getMessage("Moves"), 5));
        } else if (this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_VALUE) {
            header.append(this.padAttribute(Setup.getValueLabel(), Control.max_len_string_attibute));
        } else if (this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_LAST) {
            header.append(this.padAttribute(Bundle.getMessage("LastMoved"), this.lastLength));
        } else if (this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_RFID) {
            header.append(this.padAttribute(Setup.getRfidLabel(), Control.max_len_string_attibute));
        } else if (this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_DCC_ADDRESS) {
            header.append(this.padAttribute(Bundle.getMessage("DccAddress"), 5));
        } else if (this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_BUILT) {
            header.append(this.padAttribute(Bundle.getMessage("Built"), Control.max_len_string_built_name));
        } else if (this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_DESTINATION) {
            header.append(Bundle.getMessage("Destination"));
        } else {
            header.append(this.padAttribute(Bundle.getMessage("Comment"), this.engineManager.getMaxCommentLength()));
        }
        return header.toString() + "\n";
    }

    private void printRoster(HardcopyWriter writer) throws IOException {
        String train = "";
        String consist = "";
        String location = "";
        String moves = "";
        String owner = "";
        String built = "";
        String dccAddress = "";
        String value = "";
        String rfid = "";
        String last = "";
        String comment = "";
        List<Engine> engines = this._etf.enginesTableModel.getEngineList(this.sortByComboBox.getSelectedIndex());
        for (Engine engine : engines) {
            if (this.printLocosWithLocation.isSelected() && engine.getLocation() == null) continue;
            String destination = "";
            String number = this.padAttribute(engine.getNumber(), Control.max_len_string_print_road_number);
            String road = this.padAttribute(engine.getRoadName(), InstanceManager.getDefault(CarRoads.class).getMaxNameLength());
            String model = this.padAttribute(engine.getModel(), InstanceManager.getDefault(EngineModels.class).getMaxNameLength());
            String type = this.padAttribute(engine.getTypeName(), InstanceManager.getDefault(EngineTypes.class).getMaxNameLength());
            String length = this.padAttribute(engine.getLength(), Control.max_len_string_length_name);
            if (this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_TRAIN || this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_DESTINATION) {
                train = this.padAttribute(engine.getTrainName().trim(), Control.max_len_string_train_name / 2);
            } else {
                consist = this.padAttribute(engine.getConsistName(), InstanceManager.getDefault(ConsistManager.class).getMaxNameLength());
            }
            if (this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_OWNER) {
                owner = this.padAttribute(engine.getOwnerName(), Control.max_len_string_attibute);
            } else if (this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_MOVES) {
                moves = this.padAttribute(Integer.toString(engine.getMoves()), 5);
            } else if (this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_DCC_ADDRESS) {
                dccAddress = this.padAttribute(engine.getDccAddress(), 5);
            } else if (this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_LAST) {
                last = this.padAttribute(engine.getSortDate(), this.lastLength);
            } else if (this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_VALUE) {
                value = this.padAttribute(engine.getValue(), Control.max_len_string_attibute);
            } else if (this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_RFID) {
                rfid = this.padAttribute(engine.getRfid(), Control.max_len_string_attibute);
            } else if (this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_BUILT) {
                built = this.padAttribute(engine.getBuilt(), Control.max_len_string_built_name);
            } else if (this.sortByComboBox.getSelectedIndex() == this._etf.enginesTableModel.SORTBY_DESTINATION) {
                if (engine.getDestination() != null) {
                    destination = this.padAttribute(engine.getDestinationName() + " - " + engine.getDestinationTrackName(), this.locationManager.getMaxLocationAndTrackNameLength() + 3);
                }
            } else {
                comment = this.padAttribute(engine.getComment(), this.engineManager.getMaxCommentLength());
            }
            location = !engine.getLocationName().equals("") ? this.padAttribute(engine.getLocationName() + " - " + engine.getTrackName(), this.locationManager.getMaxLocationAndTrackNameLength() + 3) : this.padAttribute("", this.locationManager.getMaxLocationAndTrackNameLength() + 3);
            String s = number + road + model + type + length + consist + train + location + moves + owner + value + rfid + dccAddress + built + last + comment + destination;
            this.write(writer, s);
        }
    }

    private void write(HardcopyWriter writer, String s) throws IOException {
        if (s.length() > this.numberCharPerLine) {
            s = s.substring(0, this.numberCharPerLine);
        }
        writer.write(s + "\n");
    }

    private String padAttribute(String attribute, int length) {
        return TrainCommon.padAndTruncate(attribute, length) + " ";
    }
}

