/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.router;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.router.Bundle;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Router
extends TrainCommon
implements InstanceManagerAutoDefault {
    TrainManager tmanager = InstanceManager.getDefault(TrainManager.class);
    protected final List<Track> _nextLocationTracks = new ArrayList<Track>();
    protected final List<Track> _lastLocationTracks = new ArrayList<Track>();
    private final List<Track> _otherLocationTracks = new ArrayList<Track>();
    protected final List<Track> _next2ndLocationTracks = new ArrayList<Track>();
    protected final List<Track> _next3rdLocationTracks = new ArrayList<Track>();
    protected final List<Track> _next4thLocationTracks = new ArrayList<Track>();
    protected final List<Train> _nextLocationTrains = new ArrayList<Train>();
    protected final List<Train> _lastLocationTrains = new ArrayList<Train>();
    protected Hashtable<String, Train> _listTrains = new Hashtable();
    protected static final String STATUS_NOT_THIS_TRAIN = Bundle.getMessage("RouterTrain");
    public static final String STATUS_NOT_THIS_TRAIN_PREFIX = STATUS_NOT_THIS_TRAIN.substring(0, STATUS_NOT_THIS_TRAIN.indexOf(40));
    protected static final String STATUS_NOT_ABLE = Bundle.getMessage("RouterNotAble");
    protected static final String STATUS_ROUTER_DISABLED = Bundle.getMessage("RouterDisabled");
    private String _status = "";
    private Train _train = null;
    PrintWriter _buildReport = null;
    Date _startTime;
    private static final String SEVEN = "7";
    private boolean _addtoReport = false;
    private boolean _addtoReportVeryDetailed = false;
    private static final String NO = "no";
    private static final String YES = "yes";
    private static final String NOT_NOW = "not now";
    private static final String NO_SPECIFIED_TRAIN = "no specified train";
    private static final Logger log = LoggerFactory.getLogger(Router.class);

    public String getStatus() {
        return this._status;
    }

    public boolean isCarRouteable(Car car, Train train, Track track, PrintWriter buildReport) {
        Router.addLine(buildReport, SEVEN, Bundle.getMessage("RouterIsCarRoutable", car.toString(), car.getLocationName(), car.getTrackName(), car.getLoadName(), track.getLocation().getName(), track.getName()));
        return this.isCarRouteable(car, train, track.getLocation(), track, buildReport);
    }

    public boolean isCarRouteable(Car car, Train train, Location destination, Track track, PrintWriter buildReport) {
        Car c = car.copy();
        c.setTrack(car.getTrack());
        c.setFinalDestination(destination);
        c.setFinalDestinationTrack(track);
        boolean results = this.setDestination(c, train, buildReport);
        c.setDestination(null, null);
        c.setFinalDestinationTrack(null);
        car.setRoutePath(c.getRoutePath());
        return results;
    }

    public boolean setDestination(Car car, Train train, PrintWriter buildReport) {
        if (car.getTrack() == null || car.getFinalDestination() == null) {
            return false;
        }
        this._startTime = new Date();
        this._status = Track.OKAY;
        this._train = train;
        this._buildReport = buildReport;
        this._addtoReport = Setup.getRouterBuildReportLevel().equals("5") || Setup.getRouterBuildReportLevel().equals(SEVEN);
        this._addtoReportVeryDetailed = Setup.getRouterBuildReportLevel().equals(SEVEN);
        log.debug("Car ({}) at location ({}, {}) final destination ({}, {}) car routing begins", new Object[]{car, car.getLocationName(), car.getTrackName(), car.getFinalDestinationName(), car.getFinalDestinationTrackName()});
        if (this._train != null) {
            log.debug("Routing using train ({})", (Object)train.getName());
        }
        if (car.getKernel() != null && !car.isLead()) {
            return false;
        }
        Car clone = this.clone(car);
        this._status = clone.checkDestination(clone.getDestination(), clone.getDestinationTrack());
        if (!this._status.equals(Track.OKAY)) {
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterCanNotDeliverCar", car.toString(), car.getFinalDestinationName(), car.getFinalDestinationTrackName(), this._status, car.getFinalDestinationTrack() == null ? Bundle.getMessage("RouterDestination") : car.getFinalDestinationTrack().getTrackTypeName()));
            return false;
        }
        if (!this.checkForDestinationTrack(clone)) {
            return false;
        }
        if (this.checkForSingleTrain(car, clone)) {
            return true;
        }
        if (!Setup.isCarRoutingEnabled()) {
            log.debug("Car ({}) final destination ({}) is not served directly by any train", (Object)car, (Object)car.getFinalDestinationName());
            this._status = STATUS_ROUTER_DISABLED;
            car.setFinalDestination(null);
            car.setFinalDestinationTrack(null);
            return false;
        }
        log.debug("Car ({}) final destination ({}) is not served by a single train", (Object)car, (Object)car.getFinalDestinationName());
        if (car.getLocationName().equals(car.getFinalDestinationName())) {
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterCouldNotFindTrain", car.getLocationName(), car.getTrackName(), car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
        }
        if (this._addtoReport) {
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterBeginTwoTrain", car.toString(), car.getLocationName(), car.getFinalDestinationName()));
        }
        this._nextLocationTracks.clear();
        this._next2ndLocationTracks.clear();
        this._next3rdLocationTracks.clear();
        this._next4thLocationTracks.clear();
        this._lastLocationTracks.clear();
        this._otherLocationTracks.clear();
        this._nextLocationTrains.clear();
        this._lastLocationTrains.clear();
        this._listTrains.clear();
        if (this.setCarDestinationTwoTrainsInterchange(car)) {
            if (car.getDestination() == null) {
                log.debug("Was able to find a route via classification/interchange track, but not using specified train or car destination not set, try again using yard tracks");
                if (this.setCarDestinationTwoTrainsYard(car)) {
                    log.debug("Was able to find route via yard ({}, {}) for car ({})", new Object[]{car.getDestinationName(), car.getDestinationTrackName(), car});
                }
            } else {
                log.debug("Was able to find route via interchange ({}, {}) for car ({})", new Object[]{car.getDestinationName(), car.getDestinationTrackName(), car});
            }
        } else if (this.setCarDestinationTwoTrainsYard(car)) {
            log.debug("Was able to find route via yard ({}, {}) for car ({}) using two trains", new Object[]{car.getDestinationName(), car.getDestinationTrackName(), car});
        } else if (this.setCarDestinationMultipleTrains(car, false)) {
            log.debug("Was able to find multiple train route for car ({})", (Object)car);
        } else if (this.setCarDestinationTwoTrainsStaging(car)) {
            log.debug("Was able to find route via staging ({}, {}) for car ({}) using two trains", new Object[]{car.getDestinationName(), car.getDestinationTrackName(), car});
        } else if (this.setCarDestinationMultipleTrains(car, true)) {
            log.debug("Was able to find multiple train route for car ({}) through staging", (Object)car);
        } else {
            log.debug("Wasn't able to set route for car ({}) took {} mSec", (Object)car, (Object)(new Date().getTime() - this._startTime.getTime()));
            this._status = STATUS_NOT_ABLE;
            return false;
        }
        return true;
    }

    private boolean checkForDestinationTrack(Car clone) {
        if (clone.getDestination() != null && clone.getDestinationTrack() == null) {
            String status = "";
            for (Track track : clone.getDestination().getTracksList()) {
                status = track.isRollingStockAccepted(clone);
                if (!status.equals(Track.OKAY) && !status.startsWith(Track.LENGTH)) continue;
                log.debug("Track ({}) will accept car ({})", (Object)track.getName(), (Object)clone.toString());
                break;
            }
            if (!status.equals(Track.OKAY) && !status.startsWith(Track.LENGTH)) {
                this._status = Bundle.getMessage("RouterNoTracks", clone.getDestinationName(), clone.toString());
                Router.addLine(this._buildReport, SEVEN, this._status);
                return false;
            }
        }
        return true;
    }

    private boolean checkForSingleTrain(Car car, Car clone) {
        boolean trainServicesCar = false;
        Train testTrain = null;
        if (this._train != null) {
            trainServicesCar = this._train.isServiceable(this._buildReport, clone);
        }
        if (trainServicesCar) {
            testTrain = this._train;
            log.debug("Train ({}) can service car ({})", (Object)this._train.getName(), (Object)car.toString());
        } else if (this._train != null && !this._train.getServiceStatus().equals("")) {
            String trackName = car.getFinalDestinationTrackName();
            if (car.getFinalDestinationTrack() == null && car.getFinalDestinationName().equals(this._train.getTrainTerminatesName()) && this._train.getTerminationTrack() != null) {
                trackName = this._train.getTerminationTrack().getName();
            }
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterTrainCanNotDueTo", this._train.getName(), car.toString(), car.getFinalDestinationName(), trackName, this._train.getServiceStatus()));
            if (!car.getTrack().isStaging() && !this._train.isServiceAllCarsWithFinalDestinationsEnabled()) {
                this._status = MessageFormat.format(STATUS_NOT_THIS_TRAIN, this._train.getName());
                return true;
            }
        }
        if (car.getTrack().isStaging() && this._train != null && !trainServicesCar) {
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterTrainCanNotStaging", this._train.getName(), car.toString(), car.getLocationName(), clone.getDestinationName(), clone.getDestinationTrackName()));
            if (!this._train.getServiceStatus().equals("")) {
                Router.addLine(this._buildReport, SEVEN, this._train.getServiceStatus());
            }
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterStagingTryRouting", car.toString(), clone.getLocationName(), clone.getDestinationName(), clone.getDestinationTrackName()));
        } else if (!trainServicesCar) {
            ArrayList<Train> excludeTrains = new ArrayList<Train>(Arrays.asList(this._train));
            testTrain = this.tmanager.getTrainForCar(clone, excludeTrains, this._buildReport);
        }
        if (testTrain != null && this._train != null && !trainServicesCar && this._train.isServiceAllCarsWithFinalDestinationsEnabled()) {
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterOptionToCarry", this._train.getName(), testTrain.getName(), car.toString(), clone.getDestinationName(), clone.getDestinationTrackName()));
            testTrain = null;
        }
        if (testTrain != null) {
            return this.finishRouteUsingOneTrain(testTrain, car, clone);
        }
        return false;
    }

    private boolean finishRouteUsingOneTrain(Train testTrain, Car car, Car clone) {
        Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterTrainCanTransport", testTrain.getName(), car.toString(), car.getTrack().getTrackTypeName(), car.getLocationName(), car.getTrackName(), clone.getDestinationName(), clone.getDestinationTrackName()));
        this.showRoute(car, new ArrayList<Train>(Arrays.asList(testTrain)), new ArrayList<Track>(Arrays.asList(car.getFinalDestinationTrack())));
        if (this._train == null) {
            return true;
        }
        if (this._train != testTrain) {
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("TrainDoesNotServiceCar", this._train.getName(), car.toString(), clone.getDestinationName(), clone.getDestinationTrackName()));
            this._status = MessageFormat.format(STATUS_NOT_THIS_TRAIN, testTrain.getName());
            return true;
        }
        this._status = car.setDestination(clone.getDestination(), clone.getDestinationTrack());
        if (this._status.equals(Track.OKAY)) {
            return true;
        }
        Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterCanNotDeliverCar", car.toString(), clone.getDestinationName(), clone.getDestinationTrackName(), this._status, clone.getDestinationTrack() == null ? Bundle.getMessage("RouterDestination") : clone.getDestinationTrack().getTrackTypeName()));
        if ((this._status.startsWith(Track.LENGTH) || this._status.startsWith(Track.SCHEDULE)) && clone.getDestinationTrack() != null && clone.getDestinationTrack().getAlternateTrack() != null && clone.getDestinationTrack().getAlternateTrack() != car.getTrack()) {
            String status = car.setDestination(clone.getDestination(), clone.getDestinationTrack().getAlternateTrack());
            if (status.equals(Track.OKAY)) {
                if (this._train.isServiceable(car)) {
                    Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterSendCarToAlternative", car.toString(), clone.getDestinationTrack().getAlternateTrack().getName(), clone.getDestination().getName()));
                    return true;
                }
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterNotSendCarToAlternative", this._train.getName(), car.toString(), clone.getDestinationTrack().getAlternateTrack().getName(), clone.getDestination().getName()));
            } else {
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterAlternateFailed", clone.getDestinationTrack().getAlternateTrack().getName(), status));
            }
        } else if (clone.getDestinationTrack() != null && clone.getDestinationTrack().getAlternateTrack() != null && clone.getDestinationTrack().getAlternateTrack() == car.getTrack()) {
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterAtAlternate", car.toString(), clone.getDestinationTrack().getAlternateTrack().getName(), clone.getLocationName(), clone.getDestinationTrackName()));
        } else if (car.getLocation() == clone.getDestination()) {
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterIgnoreAlternate", car.toString(), car.getLocationName()));
        }
        if (Setup.isForwardToYardEnabled() && this._status.startsWith(Track.LENGTH) && car.getLocation() != clone.getDestination()) {
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterSpurFull", clone.getDestinationName(), clone.getDestinationTrackName(), clone.getDestinationName()));
            Location dest = clone.getDestination();
            List<Track> yards = dest.getTracksByMoves("Yard");
            log.debug("Found {} yard(s) at destination ({})", (Object)yards.size(), (Object)clone.getDestinationName());
            for (Track track : yards) {
                String status = car.setDestination(dest, track);
                if (status.equals(Track.OKAY)) {
                    if (!this._train.isServiceable(car)) {
                        log.debug("Train ({}) can not deliver car ({}) to yard ({})", new Object[]{this._train.getName(), car, track.getName()});
                        continue;
                    }
                    Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterSendCarToYard", car.toString(), dest.getName(), track.getName(), dest.getName()));
                    return true;
                }
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterCanNotUseYard", track.getLocation().getName(), track.getName(), status));
            }
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterNoYardTracks", dest.getName(), car.toString()));
        }
        car.setDestination(null, null);
        if (car.getTrack().isStaging()) {
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterStagingTryRouting", car.toString(), clone.getLocationName(), clone.getDestinationName(), clone.getDestinationTrackName()));
            return false;
        }
        return true;
    }

    private boolean setCarDestinationTwoTrainsInterchange(Car car) {
        return this.setCarDestinationTwoTrains(car, "Interchange");
    }

    private boolean setCarDestinationTwoTrainsYard(Car car) {
        if (Setup.isCarRoutingViaYardsEnabled()) {
            return this.setCarDestinationTwoTrains(car, "Yard");
        }
        return false;
    }

    private boolean setCarDestinationTwoTrainsStaging(Car car) {
        if (Setup.isCarRoutingViaStagingEnabled()) {
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterAttemptStaging", car.toString(), car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
            return this.setCarDestinationTwoTrains(car, "Staging");
        }
        return false;
    }

    private boolean setCarDestinationTwoTrains(Car car, String trackType) {
        Car testCar = this.clone(car);
        log.debug("Two train routing, find {} track for car ({}) final destination ({}, {})", new Object[]{trackType, car, testCar.getDestinationName(), testCar.getDestinationTrackName()});
        if (this._addtoReportVeryDetailed) {
            Router.addLine(this._buildReport, SEVEN, " ");
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterFindTrack", Track.getTrackTypeName(trackType), car.toString(), testCar.getDestinationName(), testCar.getDestinationTrackName()));
        }
        boolean foundRoute = false;
        List<Track> tracks = this.getTracks(car, testCar, trackType);
        for (Track track : tracks) {
            ArrayList<Train> trains;
            if (this._addtoReportVeryDetailed) {
                Router.addLine(this._buildReport, SEVEN, " ");
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterFoundTrack", Track.getTrackTypeName(trackType), track.getLocation().getName(), track.getName(), car.toString()));
            }
            testCar.setTrack(track);
            testCar.setDestination(car.getFinalDestination());
            testCar.setDestinationTrack(car.getFinalDestinationTrack());
            Train secondTrain = this.tmanager.getTrainForCar(testCar, this._buildReport);
            if (secondTrain == null) {
                String specified = this.canSpecifiedTrainService(testCar);
                if (specified.equals(NOT_NOW)) {
                    secondTrain = this._train;
                } else {
                    if (!this._addtoReportVeryDetailed) continue;
                    Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterNotFindTrain", Track.getTrackTypeName(trackType), track.getLocation().getName(), track.getName(), testCar.getDestinationName(), testCar.getDestinationTrackName()));
                    continue;
                }
            }
            if (this._addtoReportVeryDetailed) {
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterTrainCanTransport", secondTrain.getName(), car.toString(), testCar.getTrack().getTrackTypeName(), testCar.getLocationName(), testCar.getTrackName(), testCar.getDestinationName(), testCar.getDestinationTrackName()));
            }
            this._lastLocationTracks.add(track);
            this._lastLocationTrains.add(secondTrain);
            testCar.setTrack(car.getTrack());
            testCar.setDestination(track.getLocation());
            testCar.setDestinationTrack(track);
            Train firstTrain = null;
            String specified = this.canSpecifiedTrainService(testCar);
            if (specified.equals(YES)) {
                firstTrain = this._train;
            } else if (specified.equals(NOT_NOW)) {
                trains = new ArrayList<Train>(Arrays.asList(this._train, secondTrain));
                tracks = new ArrayList<Track>(Arrays.asList(track, car.getFinalDestinationTrack()));
                this.showRoute(car, trains, tracks);
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterTrainCanNotDueTo", this._train.getName(), car.toString(), track.getLocation().getName(), track.getName(), this._train.getServiceStatus()));
                foundRoute = true;
            } else {
                firstTrain = this.tmanager.getTrainForCar(testCar, this._buildReport);
            }
            if (firstTrain != null && firstTrain.getRoute() == secondTrain.getRoute() && track.isInterchange() && track.getPickupOption().equals("Any")) {
                if (this._addtoReportVeryDetailed) {
                    Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterSameInterchange", firstTrain.getName(), track.getLocation().getName(), track.getName()));
                }
                ArrayList<Train> excludeTrains = new ArrayList<Train>();
                excludeTrains.add(firstTrain);
                firstTrain = this.tmanager.getTrainForCar(testCar, excludeTrains, this._buildReport);
            }
            if (firstTrain == null && this._addtoReportVeryDetailed) {
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterNotFindTrain", testCar.getTrack().getTrackTypeName(), testCar.getTrack().getLocation().getName(), testCar.getTrack().getName(), testCar.getDestinationName(), testCar.getDestinationTrackName()));
            }
            if (this._train != null && car.getTrack().isStaging() && !specified.equals(YES)) {
                if (!this._addtoReport) continue;
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterTrainCanNot", this._train.getName(), car.toString(), car.getLocationName(), car.getTrackName(), track.getLocation().getName(), track.getName()));
                continue;
            }
            if (firstTrain != null && this._train != null && this._train.isServiceAllCarsWithFinalDestinationsEnabled() && !specified.equals(YES)) {
                if (!this._addtoReport) continue;
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterOptionToCarry", this._train.getName(), firstTrain.getName(), car.toString(), track.getLocation().getName(), track.getName()));
                continue;
            }
            if (firstTrain == null) continue;
            foundRoute = true;
            if (this._addtoReportVeryDetailed) {
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterTrainCanTransport", firstTrain.getName(), car.toString(), testCar.getTrack().getTrackTypeName(), testCar.getLocationName(), testCar.getTrackName(), testCar.getDestinationName(), testCar.getDestinationTrackName()));
            }
            trains = new ArrayList<Train>(Arrays.asList(firstTrain, secondTrain));
            tracks = new ArrayList<Track>(Arrays.asList(track, car.getFinalDestinationTrack()));
            this.showRoute(car, trains, tracks);
            this._status = car.checkDestination(track.getLocation(), track);
            if (this._status.startsWith(Track.LENGTH)) {
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterCanNotDeliverCar", car.toString(), track.getLocation().getName(), track.getName(), this._status, track.getTrackTypeName()));
                continue;
            }
            if (!this._status.equals(Track.OKAY)) continue;
            if (this._train != null && this._train != firstTrain) {
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("TrainDoesNotServiceCar", this._train.getName(), car.toString(), testCar.getDestinationName(), testCar.getDestinationTrackName()));
                this._status = MessageFormat.format(STATUS_NOT_THIS_TRAIN, firstTrain.getName());
                continue;
            }
            if (track.isStaging() && firstTrain.getTerminationTrack() != null && firstTrain.getTerminationTrack() != track) {
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterTrainIntoStaging", firstTrain.getName(), firstTrain.getTerminationTrack().getLocation().getName(), firstTrain.getTerminationTrack().getName()));
                continue;
            }
            this._status = car.setDestination(track.getLocation(), track);
            if (this._addtoReport) {
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterTrainCanService", firstTrain.getName(), car.toString(), car.getLocationName(), car.getTrackName(), Track.getTrackTypeName(trackType), track.getLocation().getName(), track.getName()));
            }
            return true;
        }
        if (foundRoute) {
            this._status = this._train != null ? MessageFormat.format(STATUS_NOT_THIS_TRAIN, this._train.getName()) : STATUS_NOT_ABLE;
        }
        return foundRoute;
    }

    private List<Track> getTracks(Car car, Car testCar, String trackType) {
        List<Track> inTracks = InstanceManager.getDefault(LocationManager.class).getTracksByMoves(trackType);
        ArrayList<Track> tracks = new ArrayList<Track>();
        for (Track track : inTracks) {
            if (car.getTrack() == track || car.getFinalDestinationTrack() == track) continue;
            if (trackType.equals("Staging") && track.isModifyLoadsEnabled()) {
                if (!this._addtoReportVeryDetailed) continue;
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterStagingExcluded", track.getLocation().getName(), track.getName()));
                continue;
            }
            String status = track.isRollingStockAccepted(testCar);
            if (!status.equals(Track.OKAY) && !status.startsWith(Track.LENGTH)) {
                if (!this._addtoReportVeryDetailed) continue;
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterCanNotDeliverCar", car.toString(), track.getLocation().getName(), track.getName(), status, track.getTrackTypeName()));
                continue;
            }
            tracks.add(track);
        }
        return tracks;
    }

    private boolean setCarDestinationMultipleTrains(Car car, boolean useStaging) {
        boolean foundRoute;
        if (useStaging && !Setup.isCarRoutingViaStagingEnabled()) {
            return false;
        }
        if (this._addtoReportVeryDetailed) {
            Router.addLine(this._buildReport, SEVEN, " ");
        }
        if (this._lastLocationTracks.isEmpty()) {
            if (useStaging) {
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterCouldNotFindStaging", car.getFinalDestinationName()));
            } else {
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterCouldNotFindLast", car.getFinalDestinationName()));
            }
            return false;
        }
        Car testCar = this.clone(car);
        if (this._nextLocationTracks.isEmpty() && this._otherLocationTracks.isEmpty()) {
            this.loadInterchangeAndYards(car, testCar);
        }
        if (useStaging) {
            this.loadStaging(car, testCar);
        }
        if (this._nextLocationTracks.isEmpty()) {
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterCouldNotFindLoc", car.getLocationName()));
            return false;
        }
        Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterTwoTrainsFailed", car));
        if (this._addtoReport) {
            for (Track t : this._nextLocationTracks) {
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterNextTrack", t.getTrackTypeName(), t.getLocation().getName(), t.getName(), car, car.getLocationName(), car.getTrackName(), this._nextLocationTrains.get(this._nextLocationTracks.indexOf(t))));
            }
            for (Track t : this._lastLocationTracks) {
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterLastTrack", t.getTrackTypeName(), t.getLocation().getName(), t.getName(), car, car.getFinalDestinationName(), car.getFinalDestinationTrackName(), this._lastLocationTrains.get(this._lastLocationTracks.indexOf(t))));
            }
        }
        if (this._addtoReportVeryDetailed) {
            for (Track t : this._otherLocationTracks) {
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterOtherTrack", t.getTrackTypeName(), t.getLocation().getName(), t.getName(), car));
            }
            Router.addLine(this._buildReport, SEVEN, " ");
        }
        if (!(foundRoute = this.routeUsing3Trains(car))) {
            log.debug("Using 3 trains to route car to ({}) was unsuccessful", (Object)car.getFinalDestinationName());
            foundRoute = this.routeUsing4Trains(car);
        }
        if (!foundRoute) {
            log.debug("Using 4 trains to route car to ({}) was unsuccessful", (Object)car.getFinalDestinationName());
            foundRoute = this.routeUsing5Trains(car);
        }
        if (!foundRoute) {
            log.debug("Using 5 trains to route car to ({}) was unsuccessful", (Object)car.getFinalDestinationName());
            foundRoute = this.routeUsing6Trains(car);
        }
        if (!foundRoute) {
            log.debug("Using 6 trains to route car to ({}) was unsuccessful", (Object)car.getFinalDestinationName());
            foundRoute = this.routeUsing7Trains(car);
        }
        if (!foundRoute) {
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterNotAbleToRoute", car.toString(), car.getLocationName(), car.getTrackName(), car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
        }
        return foundRoute;
    }

    private void loadInterchangeAndYards(Car car, Car testCar) {
        List<Track> tracks = InstanceManager.getDefault(LocationManager.class).getTracksByMoves("Interchange");
        this.loadTracksAndTrains(car, testCar, tracks);
        if (Setup.isCarRoutingViaYardsEnabled()) {
            tracks = InstanceManager.getDefault(LocationManager.class).getTracksByMoves("Yard");
            this.loadTracksAndTrains(car, testCar, tracks);
        }
    }

    private void loadStaging(Car car, Car testCar) {
        List<Track> stagingTracks = InstanceManager.getDefault(LocationManager.class).getTracksByMoves("Staging");
        ArrayList<Track> tracks = new ArrayList<Track>();
        for (Track staging : stagingTracks) {
            if (staging.isModifyLoadsEnabled()) continue;
            tracks.add(staging);
        }
        this.loadTracksAndTrains(car, testCar, tracks);
    }

    private boolean routeUsing3Trains(Car car) {
        Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterNTrains", "3", car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
        Car testCar = this.clone(car);
        boolean foundRoute = false;
        block0: for (Track nlt : this._nextLocationTracks) {
            for (Track llt : this._lastLocationTracks) {
                Train middleTrain = this.getTrainForCar(testCar, nlt, llt, this._nextLocationTrains.get(this._nextLocationTracks.indexOf(nlt)), this._lastLocationTrains.get(this._lastLocationTracks.indexOf(llt)));
                if (middleTrain == null) continue;
                log.debug("Found 3 train route, setting car destination ({}, {})", (Object)nlt.getLocation().getName(), (Object)nlt.getName());
                foundRoute = true;
                ArrayList<Train> trains = new ArrayList<Train>(Arrays.asList(this._nextLocationTrains.get(this._nextLocationTracks.indexOf(nlt)), middleTrain, this._lastLocationTrains.get(this._lastLocationTracks.indexOf(llt))));
                ArrayList<Track> tracks = new ArrayList<Track>(Arrays.asList(nlt, llt, car.getFinalDestinationTrack()));
                this.showRoute(car, trains, tracks);
                if (!this.finshSettingRouteFor(car, nlt)) continue block0;
                return true;
            }
        }
        return foundRoute;
    }

    private boolean routeUsing4Trains(Car car) {
        Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterNTrains", "4", car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
        Car testCar = this.clone(car);
        boolean foundRoute = false;
        block0: for (Track nlt : this._nextLocationTracks) {
            for (Track mlt : this._otherLocationTracks) {
                Train middleTrain2 = this.getTrainForCar(testCar, nlt, mlt, this._nextLocationTrains.get(this._nextLocationTracks.indexOf(nlt)), null);
                if (middleTrain2 == null) continue;
                if (!this._next2ndLocationTracks.contains(mlt)) {
                    this._next2ndLocationTracks.add(mlt);
                    if (this._addtoReport) {
                        Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterNextHop", mlt.getTrackTypeName(), mlt.getLocation().getName(), mlt.getName(), car, nlt.getLocation().getName(), nlt.getName(), middleTrain2.getName()));
                    }
                }
                for (Track llt : this._lastLocationTracks) {
                    Train middleTrain3 = this.getTrainForCar(testCar, mlt, llt, middleTrain2, this._lastLocationTrains.get(this._lastLocationTracks.indexOf(llt)));
                    if (middleTrain3 == null) continue;
                    log.debug("Found 4 train route, setting car destination ({}, {})", (Object)nlt.getLocation().getName(), (Object)nlt.getName());
                    foundRoute = true;
                    ArrayList<Train> trains = new ArrayList<Train>(Arrays.asList(this._nextLocationTrains.get(this._nextLocationTracks.indexOf(nlt)), middleTrain2, middleTrain3, this._lastLocationTrains.get(this._lastLocationTracks.indexOf(llt))));
                    ArrayList<Track> tracks = new ArrayList<Track>(Arrays.asList(nlt, mlt, llt, car.getFinalDestinationTrack()));
                    this.showRoute(car, trains, tracks);
                    if (!this.finshSettingRouteFor(car, nlt)) continue block0;
                    return true;
                }
            }
        }
        return foundRoute;
    }

    private boolean routeUsing5Trains(Car car) {
        Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterNTrains", "5", car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
        Car testCar = this.clone(car);
        boolean foundRoute = false;
        block0: for (Track nlt : this._nextLocationTracks) {
            for (Track mlt1 : this._next2ndLocationTracks) {
                Train middleTrain2 = this.getTrainForCar(testCar, nlt, mlt1, this._nextLocationTrains.get(this._nextLocationTracks.indexOf(nlt)), null);
                if (middleTrain2 == null) continue;
                for (Track mlt2 : this._otherLocationTracks) {
                    Train middleTrain3;
                    if (this._next2ndLocationTracks.contains(mlt2) || (middleTrain3 = this.getTrainForCar(testCar, mlt1, mlt2, middleTrain2, null)) == null) continue;
                    if (!this._next3rdLocationTracks.contains(mlt2)) {
                        this._next3rdLocationTracks.add(mlt2);
                        if (this._addtoReport) {
                            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterNextHop", mlt2.getTrackTypeName(), mlt2.getLocation().getName(), mlt2.getName(), car, mlt1.getLocation().getName(), mlt1.getName(), middleTrain3.getName()));
                        }
                    }
                    for (Track llt : this._lastLocationTracks) {
                        Train middleTrain4 = this.getTrainForCar(testCar, mlt2, llt, middleTrain3, this._lastLocationTrains.get(this._lastLocationTracks.indexOf(llt)));
                        if (middleTrain4 == null) continue;
                        log.debug("Found 5 train route, setting car destination ({}, {})", (Object)nlt.getLocation().getName(), (Object)nlt.getName());
                        foundRoute = true;
                        ArrayList<Train> trains = new ArrayList<Train>(Arrays.asList(this._nextLocationTrains.get(this._nextLocationTracks.indexOf(nlt)), middleTrain2, middleTrain3, middleTrain4, this._lastLocationTrains.get(this._lastLocationTracks.indexOf(llt))));
                        ArrayList<Track> tracks = new ArrayList<Track>(Arrays.asList(nlt, mlt1, mlt2, llt, car.getFinalDestinationTrack()));
                        this.showRoute(car, trains, tracks);
                        if (!this.finshSettingRouteFor(car, nlt)) continue block0;
                        return true;
                    }
                }
            }
        }
        return foundRoute;
    }

    private boolean routeUsing6Trains(Car car) {
        Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterNTrains", "6", car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
        Car testCar = this.clone(car);
        boolean foundRoute = false;
        block0: for (Track nlt : this._nextLocationTracks) {
            for (Track mlt1 : this._next2ndLocationTracks) {
                Train middleTrain2 = this.getTrainForCar(testCar, nlt, mlt1, this._nextLocationTrains.get(this._nextLocationTracks.indexOf(nlt)), null);
                if (middleTrain2 == null) continue;
                for (Track mlt2 : this._next3rdLocationTracks) {
                    Train middleTrain3 = this.getTrainForCar(testCar, mlt1, mlt2, middleTrain2, null);
                    if (middleTrain3 == null) continue;
                    for (Track mlt3 : this._otherLocationTracks) {
                        Train middleTrain4;
                        if (this._next2ndLocationTracks.contains(mlt3) || this._next3rdLocationTracks.contains(mlt3) || (middleTrain4 = this.getTrainForCar(testCar, mlt2, mlt3, middleTrain3, null)) == null) continue;
                        if (!this._next4thLocationTracks.contains(mlt3)) {
                            this._next4thLocationTracks.add(mlt3);
                            if (this._addtoReport) {
                                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterNextHop", mlt3.getTrackTypeName(), mlt3.getLocation().getName(), mlt3.getName(), car, mlt2.getLocation().getName(), mlt2.getName(), middleTrain4.getName()));
                            }
                        }
                        for (Track llt : this._lastLocationTracks) {
                            Train middleTrain5 = this.getTrainForCar(testCar, mlt3, llt, middleTrain4, this._lastLocationTrains.get(this._lastLocationTracks.indexOf(llt)));
                            if (middleTrain5 == null) continue;
                            log.debug("Found 6 train route, setting car destination ({}, {})", (Object)nlt.getLocation().getName(), (Object)nlt.getName());
                            foundRoute = true;
                            ArrayList<Train> trains = new ArrayList<Train>(Arrays.asList(this._nextLocationTrains.get(this._nextLocationTracks.indexOf(nlt)), middleTrain2, middleTrain3, middleTrain4, middleTrain5, this._lastLocationTrains.get(this._lastLocationTracks.indexOf(llt))));
                            ArrayList<Track> tracks = new ArrayList<Track>(Arrays.asList(nlt, mlt1, mlt2, mlt3, llt, car.getFinalDestinationTrack()));
                            this.showRoute(car, trains, tracks);
                            if (!this.finshSettingRouteFor(car, nlt)) continue block0;
                            return true;
                        }
                    }
                }
            }
        }
        return foundRoute;
    }

    private boolean routeUsing7Trains(Car car) {
        Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterNTrains", SEVEN, car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
        Car testCar = this.clone(car);
        boolean foundRoute = false;
        block0: for (Track nlt : this._nextLocationTracks) {
            for (Track mlt1 : this._next2ndLocationTracks) {
                Train middleTrain2 = this.getTrainForCar(testCar, nlt, mlt1, this._nextLocationTrains.get(this._nextLocationTracks.indexOf(nlt)), null);
                if (middleTrain2 == null) continue;
                for (Track mlt2 : this._next3rdLocationTracks) {
                    Train middleTrain3 = this.getTrainForCar(testCar, mlt1, mlt2, middleTrain2, null);
                    if (middleTrain3 == null) continue;
                    for (Track mlt3 : this._next4thLocationTracks) {
                        Train middleTrain4 = this.getTrainForCar(testCar, mlt2, mlt3, middleTrain3, null);
                        if (middleTrain4 == null) continue;
                        for (Track mlt4 : this._otherLocationTracks) {
                            Train middleTrain5;
                            if (this._next2ndLocationTracks.contains(mlt4) || this._next3rdLocationTracks.contains(mlt4) || this._next4thLocationTracks.contains(mlt4) || (middleTrain5 = this.getTrainForCar(testCar, mlt3, mlt4, middleTrain4, null)) == null) continue;
                            for (Track llt : this._lastLocationTracks) {
                                Train middleTrain6 = this.getTrainForCar(testCar, mlt4, llt, middleTrain5, this._lastLocationTrains.get(this._lastLocationTracks.indexOf(llt)));
                                if (middleTrain6 == null) continue;
                                log.debug("Found 7 train route, setting car destination ({}, {})", (Object)nlt.getLocation().getName(), (Object)nlt.getName());
                                foundRoute = true;
                                ArrayList<Train> trains = new ArrayList<Train>(Arrays.asList(this._nextLocationTrains.get(this._nextLocationTracks.indexOf(nlt)), middleTrain2, middleTrain3, middleTrain4, middleTrain5, middleTrain6, this._lastLocationTrains.get(this._lastLocationTracks.indexOf(llt))));
                                ArrayList<Track> tracks = new ArrayList<Track>(Arrays.asList(nlt, mlt1, mlt2, mlt3, mlt4, llt, car.getFinalDestinationTrack()));
                                this.showRoute(car, trains, tracks);
                                if (!this.finshSettingRouteFor(car, nlt)) continue block0;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return foundRoute;
    }

    private Train getTrainForCar(Car testCar, Track fromTrack, Track toTrack, Train fromTrain, Train toTrain) {
        String key;
        Train train;
        testCar.setTrack(fromTrack);
        testCar.setDestinationTrack(toTrack);
        ArrayList<Train> excludeTrains = new ArrayList<Train>();
        if (fromTrack.isInterchange() && fromTrack.getPickupOption().equals("Any")) {
            excludeTrains.add(fromTrain);
        }
        if (toTrack.isInterchange() && toTrack.getPickupOption().equals("Any")) {
            excludeTrains.add(toTrain);
        }
        if ((train = this._listTrains.get(key = fromTrack.getId() + toTrack.getId())) == null) {
            train = this.tmanager.getTrainForCar(testCar, excludeTrains, null);
            if (train != null) {
                this._listTrains.put(key, train);
            } else {
                this._listTrains.put(key, new Train("null", "null"));
            }
        } else if (train.getId().equals("null")) {
            return null;
        }
        return train;
    }

    private void showRoute(Car car, List<Train> trains, List<Track> tracks) {
        StringBuffer buf = new StringBuffer(Bundle.getMessage("RouterRouteForCar", car.toString(), car.getLocationName(), car.getTrackName()));
        StringBuffer bufRp = new StringBuffer(Bundle.getMessage("RouterRoutePath", car.getLocationName(), car.getTrackName()));
        for (Track track : tracks) {
            if (this._addtoReport) {
                buf.append(Bundle.getMessage("RouterRouteTrain", trains.get(tracks.indexOf(track)).getName()));
            }
            bufRp.append(Bundle.getMessage("RouterRoutePathTrain", trains.get(tracks.indexOf(track)).getName()));
            if (track != null) {
                buf.append(Bundle.getMessage("RouterRouteTrack", track.getLocation().getName(), track.getName()));
                bufRp.append(Bundle.getMessage("RouterRoutePathTrack", track.getLocation().getName(), track.getName()));
                continue;
            }
            buf.append(Bundle.getMessage("RouterRouteTrack", car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
            bufRp.append(Bundle.getMessage("RouterRoutePathTrack", car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
        }
        car.setRoutePath(bufRp.toString());
        Router.addLine(this._buildReport, SEVEN, buf.toString());
    }

    private boolean finshSettingRouteFor(Car car, Track track) {
        Car ts2 = this.clone(car);
        ts2.setDestinationTrack(track);
        String specified = this.canSpecifiedTrainService(ts2);
        if (specified.equals(NO)) {
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("TrainDoesNotServiceCar", this._train.getName(), car.toString(), track.getLocation().getName(), track.getName()));
            this._status = MessageFormat.format(STATUS_NOT_THIS_TRAIN, this._train.getName());
            return false;
        }
        if (specified.equals(NOT_NOW)) {
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterTrainCanNotDueTo", this._train.getName(), car.toString(), track.getLocation().getName(), track.getName(), this._train.getServiceStatus()));
            return false;
        }
        if (track.isStaging() && this._train != null && this._train.getTerminationTrack() != null && this._train.getTerminationTrack() != track) {
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterTrainIntoStaging", this._train.getName(), this._train.getTerminationTrack().getLocation().getName(), this._train.getTerminationTrack().getName()));
            return false;
        }
        this._status = car.setDestination(track.getLocation(), track);
        if (!this._status.equals(Track.OKAY)) {
            Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterCanNotDeliverCar", car.toString(), track.getLocation().getName(), track.getName(), this._status, track.getTrackTypeName()));
            if (this._status.startsWith(Track.LENGTH) && !this.redirectToAlternate(car, track)) {
                return false;
            }
        }
        return true;
    }

    private boolean redirectToAlternate(Car car, Track track) {
        if (car.getTrack().isSpur() && car.getTrack().getAlternateTrack() != null && this._nextLocationTracks.indexOf(track) == this._nextLocationTracks.size() - 1) {
            Car ts = this.clone(car);
            ts.setDestinationTrack(car.getTrack().getAlternateTrack());
            String specified = this.canSpecifiedTrainService(ts);
            if (specified.equals(YES)) {
                this._status = car.setDestination(car.getTrack().getAlternateTrack().getLocation(), car.getTrack().getAlternateTrack());
                if (this._status.equals(Track.OKAY)) {
                    Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterSendCarToAlternative", car.toString(), car.getTrack().getAlternateTrack().getName(), car.getTrack().getAlternateTrack().getLocation().getName()));
                    return true;
                }
            }
        }
        return false;
    }

    private Car clone(Car car) {
        Car clone = car.copy();
        if (car.getKernel() != null) {
            clone.setLength(Integer.toString(car.getKernel().getTotalLength() - RollingStock.COUPLERS));
        }
        clone.setTrack(car.getTrack());
        clone.setFinalDestination(car.getFinalDestination());
        clone.setDestination(car.getFinalDestination());
        clone.setDestinationTrack(car.getFinalDestinationTrack());
        return clone;
    }

    private void loadTracksAndTrains(Car car, Car testCar, List<Track> tracks) {
        for (Track track : tracks) {
            String status;
            if (track == car.getTrack() || this._lastLocationTracks.contains(track) || !(status = track.isRollingStockAccepted(testCar)).equals(Track.OKAY) && !status.startsWith(Track.LENGTH)) continue;
            testCar.setDestinationTrack(track);
            Train train = null;
            String specified = this.canSpecifiedTrainService(testCar);
            train = specified.equals(YES) || specified.equals(NOT_NOW) ? this._train : this.tmanager.getTrainForCar(testCar, null);
            if (car.getTrack().isStaging() && !specified.equals(YES)) {
                train = null;
            }
            if (train != null && this._train != null && this._train != train && this._train.isServiceAllCarsWithFinalDestinationsEnabled() && !specified.equals(YES)) {
                Router.addLine(this._buildReport, SEVEN, Bundle.getMessage("RouterOptionToCarry", this._train.getName(), train.getName(), car.toString(), track.getLocation().getName(), track.getName()));
                train = null;
            }
            if (train != null) {
                this._nextLocationTracks.add(track);
                this._nextLocationTrains.add(train);
                continue;
            }
            this._otherLocationTracks.add(track);
        }
    }

    private String canSpecifiedTrainService(Car car) {
        if (this._train == null) {
            return NO_SPECIFIED_TRAIN;
        }
        if (this._train.isServiceable(car)) {
            return YES;
        }
        if (!this._train.getServiceStatus().equals("")) {
            return NOT_NOW;
        }
        return NO;
    }
}

