/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jmri.InstanceManager;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.routes.Bundle;
import jmri.jmrit.operations.routes.RouteManagerXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.util.ColorUtil;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteLocation
extends PropertyChangeSupport
implements PropertyChangeListener {
    public static final String NONE = "";
    protected String _id = "";
    protected Location _location = null;
    protected String _locationId = "";
    protected int _trainDir = Setup.getTrainDirection() == 3 ? 1 : 4;
    protected int _maxTrainLength = Setup.getMaxTrainLength();
    protected int _maxCarMoves = Setup.getCarMoves();
    protected String _randomControl = "Off";
    protected boolean _drops = true;
    protected boolean _pickups = true;
    protected boolean _localMoves = true;
    protected int _sequenceNum = 0;
    protected double _grade = 0.0;
    protected int _wait = 0;
    protected String _departureTime = "";
    protected int _trainIconX = 0;
    protected int _trainIconY = 0;
    protected int _blockingOrder = 0;
    protected String _comment = "";
    protected Color _commentColor = Color.black;
    protected int _carMoves = 0;
    protected int _trainWeight = 0;
    protected int _trainLength = 0;
    public static final int EAST = 1;
    public static final int WEST = 2;
    public static final int NORTH = 4;
    public static final int SOUTH = 8;
    public static final String EAST_DIR = Setup.EAST_DIR;
    public static final String WEST_DIR = Setup.WEST_DIR;
    public static final String NORTH_DIR = Setup.NORTH_DIR;
    public static final String SOUTH_DIR = Setup.SOUTH_DIR;
    public static final String DISPOSE = "routeLocationDispose";
    public static final String DELETED = Bundle.getMessage("locationDeleted");
    public static final String DROP_CHANGED_PROPERTY = "dropChange";
    public static final String PICKUP_CHANGED_PROPERTY = "pickupChange";
    public static final String LOCAL_MOVES_CHANGED_PROPERTY = "localMovesChange";
    public static final String MAX_MOVES_CHANGED_PROPERTY = "maxMovesChange";
    public static final String TRAIN_DIRECTION_CHANGED_PROPERTY = "trainDirectionChange";
    public static final String DEPARTURE_TIME_CHANGED_PROPERTY = "routeDepartureTimeChange";
    public static final String MAX_LENGTH_CHANGED_PROPERTY = "maxLengthChange";
    public static final String DISABLED = "Off";
    private static final Logger log = LoggerFactory.getLogger(RouteLocation.class);

    public RouteLocation(String id, Location location) {
        log.debug("New route location ({}) id: {}", (Object)location.getName(), (Object)id);
        this._location = location;
        this._id = id;
        location.addPropertyChangeListener(this);
    }

    public String toString() {
        return this.getName();
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        if (this.getLocation() != null) {
            return this.getLocation().getName();
        }
        return DELETED;
    }

    public String getSplitName() {
        if (this.getLocation() != null) {
            return this.getLocation().getSplitName();
        }
        return DELETED;
    }

    private String getNameId() {
        if (this._location != null) {
            return this._location.getId();
        }
        return this._locationId;
    }

    public Location getLocation() {
        return this._location;
    }

    public int getSequenceNumber() {
        return this._sequenceNum;
    }

    public void setSequenceNumber(int sequence) {
        this._sequenceNum = sequence;
    }

    public int getBlockingOrder() {
        return this._blockingOrder;
    }

    public void setBlockingOrder(int order) {
        this._blockingOrder = order;
    }

    public void setComment(String comment) {
        String old = this._comment;
        this._comment = comment;
        if (!old.equals(this._comment)) {
            this.setDirtyAndFirePropertyChange("RouteLocationComment", old, comment);
        }
    }

    public String getComment() {
        return this._comment;
    }

    public void setCommentColor(Color color) {
        Color old = this._commentColor;
        this._commentColor = color;
        if (!old.equals(this._commentColor)) {
            this.setDirtyAndFirePropertyChange("RouteLocationCommentColor", old, color);
        }
    }

    public Color getCommentColor() {
        return this._commentColor;
    }

    public String getCommentWithColor() {
        return TrainCommon.formatColorString(this.getComment(), this.getCommentColor());
    }

    public void setCommentTextColor(String color) {
        this.setCommentColor(ColorUtil.stringToColor(color));
    }

    public String getCommentTextColor() {
        return ColorUtil.colorToColorName(this.getCommentColor());
    }

    public void setTrainDirection(int direction) {
        int old = this._trainDir;
        this._trainDir = direction;
        if (old != direction) {
            this.setDirtyAndFirePropertyChange(TRAIN_DIRECTION_CHANGED_PROPERTY, Integer.toString(old), Integer.toString(direction));
        }
    }

    public int getTrainDirection() {
        return this._trainDir;
    }

    public String getTrainDirectionString() {
        return Setup.getDirectionString(this.getTrainDirection());
    }

    public void setMaxTrainLength(int length) {
        int old = this._maxTrainLength;
        this._maxTrainLength = length;
        if (old != length) {
            this.setDirtyAndFirePropertyChange(MAX_LENGTH_CHANGED_PROPERTY, Integer.toString(old), Integer.toString(length));
        }
    }

    public int getMaxTrainLength() {
        return this._maxTrainLength;
    }

    public void setTrainLength(int length) {
        int old = this._trainLength;
        this._trainLength = length;
        if (old != length) {
            this.firePropertyChange("trainLength", Integer.toString(old), Integer.toString(length));
        }
    }

    public int getTrainLength() {
        return this._trainLength;
    }

    public void setTrainWeight(int weight) {
        int old = this._trainWeight;
        this._trainWeight = weight;
        if (old != weight) {
            this.firePropertyChange("trainWeight", Integer.toString(old), Integer.toString(weight));
        }
    }

    public int getTrainWeight() {
        return this._trainWeight;
    }

    public void setMaxCarMoves(int moves) {
        int old = this._maxCarMoves;
        this._maxCarMoves = moves;
        if (old != moves) {
            this.setDirtyAndFirePropertyChange(MAX_MOVES_CHANGED_PROPERTY, Integer.toString(old), Integer.toString(moves));
        }
    }

    public int getMaxCarMoves() {
        return this._maxCarMoves;
    }

    public void setRandomControl(String value) {
        String old = this._randomControl;
        this._randomControl = value;
        if (!old.equals(value)) {
            this.setDirtyAndFirePropertyChange("randomControl", old, value);
        }
    }

    public String getRandomControl() {
        return this._randomControl;
    }

    public void setDropAllowed(boolean drops) {
        boolean old = this._drops;
        this._drops = drops;
        if (old != drops) {
            this.setDirtyAndFirePropertyChange(DROP_CHANGED_PROPERTY, old ? "true" : "false", drops ? "true" : "false");
        }
    }

    public boolean isDropAllowed() {
        return this._drops;
    }

    public void setPickUpAllowed(boolean pickups) {
        boolean old = this._pickups;
        this._pickups = pickups;
        if (old != pickups) {
            this.setDirtyAndFirePropertyChange(PICKUP_CHANGED_PROPERTY, old ? "true" : "false", pickups ? "true" : "false");
        }
    }

    public boolean isPickUpAllowed() {
        return this._pickups;
    }

    public void setLocalMovesAllowed(boolean local) {
        boolean old = this._localMoves;
        this._localMoves = local;
        if (old != local) {
            this.setDirtyAndFirePropertyChange(LOCAL_MOVES_CHANGED_PROPERTY, old ? "true" : "false", local ? "true" : "false");
        }
    }

    public boolean isLocalMovesAllowed() {
        return this._localMoves;
    }

    public void setCarMoves(int moves) {
        int old = this._carMoves;
        this._carMoves = moves;
        if (old != moves) {
            this.firePropertyChange("carMoves", Integer.toString(old), Integer.toString(moves));
        }
    }

    public int getCarMoves() {
        return this._carMoves;
    }

    public void setWait(int time) {
        int old = this._wait;
        this._wait = time;
        if (old != time) {
            this.setDirtyAndFirePropertyChange("waitTime", Integer.toString(old), Integer.toString(time));
        }
    }

    public int getWait() {
        return this._wait;
    }

    public void setDepartureTime(String time) {
        String old = this._departureTime;
        this._departureTime = time;
        if (!old.equals(time)) {
            this.setDirtyAndFirePropertyChange(DEPARTURE_TIME_CHANGED_PROPERTY, old, time);
        }
    }

    public void setDepartureTime(String hour, String minute) {
        int m;
        String old = this._departureTime;
        int h = Integer.parseInt((String)hour);
        if (h < 10) {
            hour = "0" + h;
        }
        if ((m = Integer.parseInt((String)minute)) < 10) {
            minute = "0" + m;
        }
        String time = (String)hour + ":" + (String)minute;
        this._departureTime = time;
        if (!old.equals(time)) {
            this.setDirtyAndFirePropertyChange(DEPARTURE_TIME_CHANGED_PROPERTY, old, time);
        }
    }

    public String getDepartureTime() {
        return this._departureTime;
    }

    public String getDepartureTimeHour() {
        String[] time = this.getDepartureTime().split(":");
        return time[0];
    }

    public String getDepartureTimeMinute() {
        String[] time = this.getDepartureTime().split(":");
        return time[1];
    }

    public String getFormatedDepartureTime() {
        if (this.getDepartureTime().equals(NONE) || !Setup.is12hrFormatEnabled()) {
            return this._departureTime;
        }
        String AM_PM = " " + Bundle.getMessage("AM");
        String[] time = this.getDepartureTime().split(":");
        int hour = Integer.parseInt(time[0]);
        if (hour >= 12) {
            AM_PM = " " + Bundle.getMessage("PM");
            hour -= 12;
        }
        if (hour == 0) {
            hour = 12;
        }
        time[0] = Integer.toString(hour);
        return time[0] + ":" + time[1] + AM_PM;
    }

    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="firing property change doesn't matter")
    public void setGrade(double grade) {
        double old = this._grade;
        this._grade = grade;
        if (old != grade) {
            this.setDirtyAndFirePropertyChange("grade", Double.toString(old), Double.toString(grade));
        }
    }

    public double getGrade() {
        return this._grade;
    }

    public void setTrainIconX(int x) {
        int old = this._trainIconX;
        this._trainIconX = x;
        if (old != x) {
            this.setDirtyAndFirePropertyChange("trainIconX", Integer.toString(old), Integer.toString(x));
        }
    }

    public int getTrainIconX() {
        return this._trainIconX;
    }

    public void setTrainIconY(int y) {
        int old = this._trainIconY;
        this._trainIconY = y;
        if (old != y) {
            this.setDirtyAndFirePropertyChange("trainIconY", Integer.toString(old), Integer.toString(y));
        }
    }

    public int getTrainIconY() {
        return this._trainIconY;
    }

    public int getTrainIconRangeX() {
        return this.getLocation().getTrainIconRangeX();
    }

    public int getTrainIconRangeY() {
        return this.getLocation().getTrainIconRangeY();
    }

    public void setTrainIconCoordinates() {
        Location l = InstanceManager.getDefault(LocationManager.class).getLocationByName(this.getName());
        if ((this.getTrainDirection() & 1) == 1) {
            this.setTrainIconX(l.getTrainIconEast().x);
            this.setTrainIconY(l.getTrainIconEast().y);
        }
        if ((this.getTrainDirection() & 2) == 2) {
            this.setTrainIconX(l.getTrainIconWest().x);
            this.setTrainIconY(l.getTrainIconWest().y);
        }
        if ((this.getTrainDirection() & 4) == 4) {
            this.setTrainIconX(l.getTrainIconNorth().x);
            this.setTrainIconY(l.getTrainIconNorth().y);
        }
        if ((this.getTrainDirection() & 8) == 8) {
            this.setTrainIconX(l.getTrainIconSouth().x);
            this.setTrainIconY(l.getTrainIconSouth().y);
        }
    }

    public Point getTrainIconCoordinates() {
        return new Point(this.getTrainIconX(), this.getTrainIconY());
    }

    public void dispose() {
        if (this._location != null) {
            this._location.removePropertyChangeListener(this);
        }
        this.firePropertyChange(DISPOSE, null, DISPOSE);
    }

    public RouteLocation(Element e) {
        Attribute a = e.getAttribute("id");
        if (a != null) {
            this._id = a.getValue();
        } else {
            log.warn("no id attribute in route location element when reading operations");
        }
        a = e.getAttribute("locationId");
        if (a != null) {
            this._locationId = a.getValue();
            this._location = InstanceManager.getDefault(LocationManager.class).getLocationById(a.getValue());
            if (this._location != null) {
                this._location.addPropertyChangeListener(this);
            }
        } else {
            a = e.getAttribute("name");
            if (a != null) {
                this._location = InstanceManager.getDefault(LocationManager.class).getLocationByName(a.getValue());
                if (this._location != null) {
                    this._location.addPropertyChangeListener(this);
                }
                InstanceManager.getDefault(RouteManagerXml.class).setDirty(true);
            }
        }
        if ((a = e.getAttribute("trainDirection")) != null) {
            if (Setup.getTrainDirectionList().contains(a.getValue())) {
                this._trainDir = Setup.getDirectionInt(a.getValue());
                log.debug("found old train direction {} new direction {}", (Object)a.getValue(), (Object)this._trainDir);
            } else {
                try {
                    this._trainDir = Integer.parseInt(a.getValue());
                }
                catch (NumberFormatException ee) {
                    log.error("Route location ({}) direction ({}) is unknown", (Object)this.getName(), (Object)a.getValue());
                }
            }
        }
        if ((a = e.getAttribute("maxTrainLength")) != null) {
            try {
                this._maxTrainLength = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException ee) {
                log.error("Route location ({}) maximum train length ({}) isn't a valid number", (Object)this.getName(), (Object)a.getValue());
            }
        }
        if ((a = e.getAttribute("grade")) != null) {
            try {
                this._grade = Double.parseDouble(a.getValue());
            }
            catch (NumberFormatException ee) {
                log.error("Route location ({}) grade ({}) isn't a valid number", (Object)this.getName(), (Object)a.getValue());
            }
        }
        if ((a = e.getAttribute("maxCarMoves")) != null) {
            try {
                this._maxCarMoves = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException ee) {
                log.error("Route location ({}) maximum car moves ({}) isn't a valid number", (Object)this.getName(), (Object)a.getValue());
            }
        }
        if ((a = e.getAttribute("randomControl")) != null) {
            this._randomControl = a.getValue();
        }
        if ((a = e.getAttribute("pickups")) != null) {
            this._pickups = a.getValue().equals("yes");
        }
        if ((a = e.getAttribute("drops")) != null) {
            this._drops = a.getValue().equals("yes");
        }
        if ((a = e.getAttribute("localMoves")) != null) {
            this._localMoves = a.getValue().equals("yes");
        } else if (!this.isPickUpAllowed() || !this.isDropAllowed()) {
            this._localMoves = false;
        }
        a = e.getAttribute("wait");
        if (a != null) {
            try {
                this._wait = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException ee) {
                log.error("Route location ({}) wait ({}) isn't a valid number", (Object)this.getName(), (Object)a.getValue());
            }
        }
        if ((a = e.getAttribute("departTime")) != null) {
            this._departureTime = a.getValue();
        }
        if ((a = e.getAttribute("order")) != null) {
            try {
                this._blockingOrder = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException ee) {
                log.error("Route location ({}) blocking order ({}) isn't a valid number", (Object)this.getName(), (Object)a.getValue());
            }
        }
        if ((a = e.getAttribute("trainIconX")) != null) {
            try {
                this._trainIconX = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException ee) {
                log.error("Route location ({}) icon x ({}) isn't a valid number", (Object)this.getName(), (Object)a.getValue());
            }
        }
        if ((a = e.getAttribute("trainIconY")) != null) {
            try {
                this._trainIconY = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException ee) {
                log.error("Route location ({}) icon y ({}) isn't a valid number", (Object)this.getName(), (Object)a.getValue());
            }
        }
        if ((a = e.getAttribute("sequenceId")) != null) {
            try {
                this._sequenceNum = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException ee) {
                log.error("Route location ({}) sequence id isn't a valid number {}", (Object)this.getName(), (Object)a.getValue());
            }
        }
        if ((a = e.getAttribute("commentColor")) != null) {
            this.setCommentTextColor(a.getValue());
        }
        if ((a = e.getAttribute("comment")) != null) {
            this._comment = a.getValue();
        }
    }

    public Element store() {
        Element e = new Element("location");
        e.setAttribute("id", this.getId());
        e.setAttribute("name", this.getName());
        e.setAttribute("locationId", this.getNameId());
        e.setAttribute("sequenceId", Integer.toString(this.getSequenceNumber()));
        e.setAttribute("trainDirection", Integer.toString(this.getTrainDirection()));
        e.setAttribute("maxTrainLength", Integer.toString(this.getMaxTrainLength()));
        e.setAttribute("grade", Double.toString(this.getGrade()));
        e.setAttribute("maxCarMoves", Integer.toString(this.getMaxCarMoves()));
        e.setAttribute("randomControl", this.getRandomControl());
        e.setAttribute("pickups", this.isPickUpAllowed() ? "yes" : "no");
        e.setAttribute("drops", this.isDropAllowed() ? "yes" : "no");
        e.setAttribute("localMoves", this.isLocalMovesAllowed() ? "yes" : "no");
        e.setAttribute("wait", Integer.toString(this.getWait()));
        e.setAttribute("departTime", this.getDepartureTime());
        e.setAttribute("order", Integer.toString(this.getBlockingOrder()));
        e.setAttribute("trainIconX", Integer.toString(this.getTrainIconX()));
        e.setAttribute("trainIconY", Integer.toString(this.getTrainIconY()));
        e.setAttribute("commentColor", this.getCommentTextColor());
        e.setAttribute("comment", this.getComment());
        return e;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("locationDispose")) {
            if (this._location != null) {
                this._location.removePropertyChangeListener(this);
            }
            this._location = null;
        }
        if (e.getPropertyName().equals("locationName")) {
            this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
        }
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(RouteManagerXml.class).setDirty(true);
        this.firePropertyChange(p, old, n);
    }
}

