/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes.gui;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.routes.gui.Bundle;
import jmri.jmrit.operations.routes.gui.RouteEditTableModel;
import jmri.jmrit.operations.routes.tools.PrintRouteAction;
import jmri.jmrit.operations.routes.tools.RouteBlockingOrderEditFrameAction;
import jmri.jmrit.operations.routes.tools.RouteCopyAction;
import jmri.jmrit.operations.routes.tools.SetTrainIconRouteAction;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.swing.JTablePersistenceManager;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteEditFrame
extends OperationsFrame
implements PropertyChangeListener {
    RouteEditTableModel routeModel = new RouteEditTableModel();
    JTable routeTable = new JTable(this.routeModel);
    JScrollPane routePane;
    RouteManager routeManager;
    Route _route = null;
    Train _train = null;
    JButton addLocationButton = new JButton(Bundle.getMessage("AddLocation"));
    JButton saveRouteButton = new JButton(Bundle.getMessage("SaveRoute"));
    JButton deleteRouteButton = new JButton(Bundle.getMessage("DeleteRoute"));
    JButton addRouteButton = new JButton(Bundle.getMessage("AddRoute"));
    JRadioButton addLocAtTop = new JRadioButton(Bundle.getMessage("Top"));
    JRadioButton addLocAtMiddle = new JRadioButton(Bundle.getMessage("Middle"));
    JRadioButton addLocAtBottom = new JRadioButton(Bundle.getMessage("Bottom"));
    JTextField routeNameTextField = new JTextField(Control.max_len_string_route_name);
    JTextField commentTextField = new JTextField(35);
    JComboBox<Location> locationBox = InstanceManager.getDefault(LocationManager.class).getComboBox();
    JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
    public static final String NAME = Bundle.getMessage("Name");
    public static final String DISPOSE = "dispose";
    private static final Logger log = LoggerFactory.getLogger(RouteEditFrame.class);

    public RouteEditFrame() {
        super(Bundle.getMessage("TitleRouteEdit"));
    }

    public void initComponents(Route route, Train train) {
        this._train = train;
        this.initComponents(route);
    }

    public void initComponents(Route route) {
        this._route = route;
        this.routeManager = InstanceManager.getDefault(RouteManager.class);
        this.routePane = new JScrollPane(this.routeTable);
        this.routePane.setVerticalScrollBarPolicy(20);
        this.routePane.setBorder(BorderFactory.createTitledBorder(""));
        this.routeModel.initTable(this, this.routeTable, this._route);
        if (this._route != null) {
            this._route.addPropertyChangeListener(this);
            this.routeNameTextField.setText(this._route.getName());
            this.commentTextField.setText(this._route.getComment());
            this.enableButtons(!route.getStatus().equals(Route.TRAIN_BUILT));
            this.addRouteButton.setEnabled(false);
        } else {
            this.setTitle(Bundle.getMessage("TitleRouteAdd"));
            this.enableButtons(false);
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        JScrollPane p1Pane = new JScrollPane(p1);
        p1Pane.setVerticalScrollBarPolicy(21);
        p1Pane.setMinimumSize(new Dimension(300, 3 * this.routeNameTextField.getPreferredSize().height));
        p1Pane.setMaximumSize(new Dimension(2000, 200));
        p1Pane.setBorder(BorderFactory.createTitledBorder(""));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Name")));
        this.addItem(pName, this.routeNameTextField, 0, 0);
        JPanel pComment = new JPanel();
        pComment.setLayout(new GridBagLayout());
        pComment.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Comment")));
        this.addItem(pComment, this.commentTextField, 0, 0);
        p1.add(pName);
        p1.add(pComment);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 0));
        JScrollPane p2Pane = new JScrollPane(p2);
        p2Pane.setVerticalScrollBarPolicy(21);
        p2Pane.setMinimumSize(new Dimension(300, 3 * this.routeNameTextField.getPreferredSize().height));
        p2Pane.setMaximumSize(new Dimension(2000, 200));
        p2Pane.setBorder(BorderFactory.createTitledBorder(""));
        JPanel pLoc = new JPanel();
        pLoc.setLayout(new GridBagLayout());
        pLoc.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Location")));
        this.addItem(pLoc, this.locationBox, 0, 1);
        this.addItem(pLoc, this.addLocationButton, 1, 1);
        this.addItem(pLoc, this.addLocAtTop, 2, 1);
        this.addItem(pLoc, this.addLocAtMiddle, 3, 1);
        this.addItem(pLoc, this.addLocAtBottom, 4, 1);
        p2.add(pLoc);
        JPanel pB = new JPanel();
        pB.setLayout(new GridBagLayout());
        JScrollPane pBPane = new JScrollPane(pB);
        pBPane.setVerticalScrollBarPolicy(21);
        pBPane.setMinimumSize(new Dimension(300, 3 * this.routeNameTextField.getPreferredSize().height));
        pBPane.setMaximumSize(new Dimension(2000, 200));
        pBPane.setBorder(BorderFactory.createTitledBorder(""));
        this.addItem(pB, this.deleteRouteButton, 0, 0);
        this.addItem(pB, this.addRouteButton, 1, 0);
        this.addItem(pB, this.saveRouteButton, 3, 0);
        this.getContentPane().add(p1Pane);
        this.getContentPane().add(this.routePane);
        this.getContentPane().add(p2Pane);
        this.getContentPane().add(pBPane);
        this.addButtonAction(this.addLocationButton);
        this.addButtonAction(this.deleteRouteButton);
        this.addButtonAction(this.addRouteButton);
        this.addButtonAction(this.saveRouteButton);
        ButtonGroup group = new ButtonGroup();
        group.add(this.addLocAtTop);
        group.add(this.addLocAtMiddle);
        group.add(this.addLocAtBottom);
        this.addLocAtBottom.setSelected(true);
        this.addRadioButtonAction(this.addLocAtTop);
        this.addRadioButtonAction(this.addLocAtMiddle);
        this.addRadioButtonAction(this.addLocAtBottom);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.toolMenu);
        this.loadToolMenu();
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_AddRoute", true);
        InstanceManager.getDefault(LocationManager.class).addPropertyChangeListener(this);
        this.initMinimumSize(new Dimension(700, 400));
    }

    private void loadToolMenu() {
        this.toolMenu.removeAll();
        this.toolMenu.add(new RouteBlockingOrderEditFrameAction(this._route));
        this.toolMenu.add(new RouteCopyAction(this._route));
        this.toolMenu.add(new SetTrainIconRouteAction(this._route));
        this.toolMenu.addSeparator();
        this.toolMenu.add(new PrintRouteAction(false, this._route));
        this.toolMenu.add(new PrintRouteAction(true, this._route));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        Route route;
        if (ae.getSource() == this.addLocationButton) {
            log.debug("route add location button activated");
            if (this.locationBox.getSelectedItem() != null) {
                this.addNewRouteLocation();
            } else {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("SelectLocation"), Bundle.getMessage("SelectLocation"), 1);
            }
        }
        if (ae.getSource() == this.saveRouteButton) {
            log.debug("route save button activated");
            route = this.routeManager.getRouteByName(this.routeNameTextField.getText());
            if (this._route == null && route == null) {
                this.saveNewRoute();
            } else {
                if (route != null && route != this._route) {
                    this.reportRouteExists(Bundle.getMessage("save"));
                    return;
                }
                if (this.saveRoute() && Setup.isCloseWindowOnSaveEnabled()) {
                    this.dispose();
                }
            }
        }
        if (ae.getSource() == this.deleteRouteButton) {
            log.debug("route delete button activated");
            if (JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("AreYouSure?", this.routeNameTextField.getText()), Bundle.getMessage("DeleteRoute?"), 0) != 0) {
                return;
            }
            route = this.routeManager.getRouteByName(this.routeNameTextField.getText());
            if (route == null) {
                return;
            }
            this.routeManager.deregister(route);
            this._route = null;
            this.enableButtons(false);
            this.routeModel.dispose();
            OperationsXml.save();
        }
        if (ae.getSource() == this.addRouteButton) {
            route = this.routeManager.getRouteByName(this.routeNameTextField.getText());
            if (route != null) {
                this.reportRouteExists(Bundle.getMessage("add"));
                return;
            }
            this.saveNewRoute();
        }
    }

    private void addNewRouteLocation() {
        RouteLocation rl;
        if (this.routeTable.isEditing()) {
            log.debug("route table edit true");
            this.routeTable.getCellEditor().stopCellEditing();
        }
        Location l = (Location)this.locationBox.getSelectedItem();
        if (this.addLocAtTop.isSelected()) {
            rl = this._route.addLocation(l, 1);
        } else if (this.addLocAtMiddle.isSelected()) {
            if (this.routeTable.getSelectedRow() >= 0) {
                int row = this.routeTable.getSelectedRow();
                rl = this._route.addLocation(l, row + 1);
                this.routeTable.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            } else {
                rl = this._route.addLocation(l, this._route.size() / 2 + 1);
            }
        } else {
            rl = this._route.addLocation(l);
        }
        rl.setTrainDirection(this.routeModel.getLastTrainDirection());
        rl.setMaxTrainLength(this.routeModel.getLastMaxTrainLength());
        if (rl.getLocation().isStaging()) {
            rl.setMaxCarMoves(50);
        } else {
            rl.setMaxCarMoves(this.routeModel.getLastMaxTrainMoves());
        }
        rl.setTrainIconCoordinates();
    }

    private void saveNewRoute() {
        if (!this.checkName(Bundle.getMessage("add"))) {
            return;
        }
        this._route = this.routeManager.newRoute(this.routeNameTextField.getText());
        this.routeModel.initTable(this, this.routeTable, this._route);
        this.enableButtons(true);
        if (this._train != null) {
            this._train.setRoute(this._route);
        }
        if (this._route != null) {
            this._route.addPropertyChangeListener(this);
        }
        this.saveRoute();
        this.loadToolMenu();
        this.selectFirstLocationComboBox();
    }

    private boolean saveRoute() {
        if (this.routeTable.isEditing()) {
            log.debug("route table edit true");
            this.routeTable.getCellEditor().stopCellEditing();
        }
        if (!this.checkName(Bundle.getMessage("save")) || !this.checkTrainDirections()) {
            return false;
        }
        this._route.setName(this.routeNameTextField.getText());
        this._route.setComment(this.commentTextField.getText());
        OperationsXml.save();
        return true;
    }

    private boolean checkName(String s) {
        if (this.routeNameTextField.getText().trim().isEmpty()) {
            log.debug("Must enter a name for the route");
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("MustEnterName"), Bundle.getMessage("CanNotRoute", s), 0);
            return false;
        }
        if (this.routeNameTextField.getText().length() > Control.max_len_string_route_name) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("RouteNameLess", Control.max_len_string_route_name + 1), Bundle.getMessage("CanNotRoute", s), 0);
            return false;
        }
        return true;
    }

    private boolean checkTrainDirections() {
        List<String> directions = Setup.getTrainDirectionList();
        for (RouteLocation rl : this._route.getLocationsBySequenceList()) {
            if (directions.contains(rl.getTrainDirectionString())) continue;
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("RouteDirection", rl.getId()), Bundle.getMessage("RouteDirectionError", rl.getTrainDirectionString()), 0);
            return false;
        }
        return true;
    }

    private void reportRouteExists(String s) {
        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ReportExists"), Bundle.getMessage("CanNotRoute", s), 0);
    }

    private void enableButtons(boolean enabled) {
        this.toolMenu.setEnabled(enabled);
        this.locationBox.setEnabled(enabled);
        this.addLocationButton.setEnabled(enabled);
        this.addLocAtTop.setEnabled(enabled);
        this.addLocAtMiddle.setEnabled(enabled);
        this.addLocAtBottom.setEnabled(enabled);
        this.saveRouteButton.setEnabled(enabled);
        this.deleteRouteButton.setEnabled(enabled);
        this.routeTable.setEnabled(enabled);
        this.addRouteButton.setEnabled(!enabled);
    }

    private void selectFirstLocationComboBox() {
        if (this.locationBox.getItemCount() > 1) {
            this.locationBox.setSelectedIndex(1);
        }
    }

    @Override
    public void dispose() {
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(tpm -> tpm.stopPersisting(this.routeTable));
        if (this._route != null) {
            this._route.removePropertyChangeListener(this);
        }
        this.routeModel.dispose();
        super.dispose();
    }

    private void updateComboBoxes() {
        InstanceManager.getDefault(LocationManager.class).updateComboBox(this.locationBox);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("locationsListLength")) {
            this.updateComboBoxes();
        }
        if (e.getPropertyName().equals("routeStatusChange")) {
            this.enableButtons(!this._route.getStatus().equals(Route.TRAIN_BUILT));
            this.addRouteButton.setEnabled(false);
        }
    }
}

