/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.table.AbstractTableModel;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.routes.gui.Bundle;
import jmri.jmrit.operations.routes.gui.RouteEditFrame;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.jmrit.symbolicprog.ValueRenderer;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.SplitButtonColorChooserPanel;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteEditTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private static final int ID_COLUMN = 0;
    private static final int NAME_COLUMN = 1;
    private static final int TRAIN_DIRECTION_COLUMN = 2;
    private static final int MAXMOVES_COLUMN = 3;
    private static final int RANDOM_CONTROL_COLUMN = 4;
    private static final int PICKUP_COLUMN = 5;
    private static final int DROP_COLUMN = 6;
    private static final int LOCAL_COLUMN = 7;
    private static final int TIME_COLUMN = 8;
    private static final int TRAVEL_COLUMN = 9;
    private static final int MAXLENGTH_COLUMN = 10;
    private static final int GRADE = 11;
    private static final int TRAINICONX = 12;
    private static final int TRAINICONY = 13;
    private static final int COMMENT_COLUMN = 14;
    private static final int UP_COLUMN = 15;
    private static final int DOWN_COLUMN = 16;
    private static final int DELETE_COLUMN = 17;
    private static final int HIGHEST_COLUMN = 18;
    private JTable _table;
    private Route _route;
    private RouteEditFrame _frame;
    List<RouteLocation> _routeList = new ArrayList<RouteLocation>();
    private int _trainDirection = Setup.getDirectionInt(Setup.getTrainDirectionList().get(0));
    private int _maxTrainMoves = Setup.getCarMoves();
    private int _maxTrainLength = Setup.getMaxTrainLength();
    private static final Logger log = LoggerFactory.getLogger(RouteEditTableModel.class);

    private void updateList() {
        if (this._route == null) {
            return;
        }
        this.removePropertyChangeRouteLocations();
        this._routeList = this._route.getLocationsBySequenceList();
        for (RouteLocation rl : this._routeList) {
            rl.addPropertyChangeListener(this);
        }
    }

    protected void initTable(RouteEditFrame frame, JTable table, Route route) {
        this._frame = frame;
        this._table = table;
        this._route = route;
        if (this._route != null) {
            this._route.addPropertyChangeListener(this);
        }
        Setup.getDefault().addPropertyChangeListener(this);
        this.initTable(table);
    }

    private void initTable(JTable table) {
        XTableColumnModel tcm = new XTableColumnModel();
        this._table.setColumnModel(tcm);
        this._table.createDefaultColumnsFromModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(14).setCellRenderer(buttonRenderer);
        tcm.getColumn(14).setCellEditor(buttonEditor);
        tcm.getColumn(15).setCellRenderer(buttonRenderer);
        tcm.getColumn(15).setCellEditor(buttonEditor);
        tcm.getColumn(16).setCellRenderer(buttonRenderer);
        tcm.getColumn(16).setCellEditor(buttonEditor);
        tcm.getColumn(17).setCellRenderer(buttonRenderer);
        tcm.getColumn(17).setCellEditor(buttonEditor);
        table.setDefaultRenderer(JComboBox.class, new ValueRenderer());
        table.setDefaultEditor(JComboBox.class, new ValueEditor());
        table.getColumnModel().getColumn(0).setPreferredWidth(40);
        table.getColumnModel().getColumn(1).setPreferredWidth(150);
        table.getColumnModel().getColumn(2).setPreferredWidth(95);
        table.getColumnModel().getColumn(3).setPreferredWidth(50);
        table.getColumnModel().getColumn(4).setPreferredWidth(65);
        table.getColumnModel().getColumn(5).setPreferredWidth(65);
        table.getColumnModel().getColumn(6).setPreferredWidth(65);
        table.getColumnModel().getColumn(7).setPreferredWidth(75);
        table.getColumnModel().getColumn(9).setPreferredWidth(65);
        table.getColumnModel().getColumn(8).setPreferredWidth(65);
        table.getColumnModel().getColumn(10).setPreferredWidth(75);
        table.getColumnModel().getColumn(11).setPreferredWidth(50);
        table.getColumnModel().getColumn(12).setPreferredWidth(35);
        table.getColumnModel().getColumn(13).setPreferredWidth(35);
        table.getColumnModel().getColumn(14).setPreferredWidth(70);
        table.getColumnModel().getColumn(15).setPreferredWidth(60);
        table.getColumnModel().getColumn(16).setPreferredWidth(70);
        table.getColumnModel().getColumn(17).setPreferredWidth(80);
        this._frame.loadTableDetails(table);
        table.setRowSorter(null);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(8), true);
        this.updateList();
    }

    @Override
    public int getRowCount() {
        return this._routeList.size();
    }

    @Override
    public int getColumnCount() {
        return 18;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("Id");
            }
            case 1: {
                return Bundle.getMessage("Location");
            }
            case 2: {
                return Bundle.getMessage("TrainDirection");
            }
            case 3: {
                return Bundle.getMessage("MaxMoves");
            }
            case 4: {
                return Bundle.getMessage("Random");
            }
            case 5: {
                return Bundle.getMessage("Pickups");
            }
            case 6: {
                return Bundle.getMessage("Drops");
            }
            case 7: {
                return Bundle.getMessage("LocalMoves");
            }
            case 9: {
                return Bundle.getMessage("Travel");
            }
            case 8: {
                return Bundle.getMessage("Time");
            }
            case 10: {
                return Bundle.getMessage("MaxLength");
            }
            case 11: {
                return Bundle.getMessage("Grade");
            }
            case 12: {
                return Bundle.getMessage("X");
            }
            case 13: {
                return Bundle.getMessage("Y");
            }
            case 14: {
                return Bundle.getMessage("Comment");
            }
            case 15: {
                return Bundle.getMessage("Up");
            }
            case 16: {
                return Bundle.getMessage("Down");
            }
            case 17: {
                return Bundle.getMessage("ButtonDelete");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: {
                return String.class;
            }
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                return Integer.class;
            }
            case 11: {
                return Double.class;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return JComboBox.class;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount()) {
            return "ERROR unknown " + row;
        }
        RouteLocation rl = this._routeList.get(row);
        if (rl == null) {
            return "ERROR unknown route location " + row;
        }
        switch (col) {
            case 0: {
                return rl.getId();
            }
            case 1: {
                return rl.getName();
            }
            case 2: {
                JComboBox<String> cb = Setup.getTrainDirectionComboBox();
                cb.setSelectedItem(rl.getTrainDirectionString());
                return cb;
            }
            case 3: {
                return rl.getMaxCarMoves();
            }
            case 4: {
                JComboBox<String> cb = this.getRandomControlComboBox();
                cb.setSelectedItem(rl.getRandomControl());
                return cb;
            }
            case 5: {
                JComboBox<String> cb = this.getYesNoComboBox();
                cb.setSelectedItem(rl.isPickUpAllowed() ? Bundle.getMessage("yes") : Bundle.getMessage("no"));
                return cb;
            }
            case 6: {
                JComboBox<String> cb = this.getYesNoComboBox();
                cb.setSelectedItem(rl.isDropAllowed() ? Bundle.getMessage("yes") : Bundle.getMessage("no"));
                return cb;
            }
            case 7: {
                JComboBox<String> cb = this.getYesNoComboBox();
                cb.setSelectedItem(rl.isLocalMovesAllowed() ? Bundle.getMessage("yes") : Bundle.getMessage("no"));
                return cb;
            }
            case 9: {
                return rl.getWait() + Setup.getTravelTime();
            }
            case 8: {
                JComboBox<String> cb = this.getTimeComboBox();
                cb.setSelectedItem(rl.getDepartureTime());
                return cb;
            }
            case 10: {
                return rl.getMaxTrainLength();
            }
            case 11: {
                return rl.getGrade();
            }
            case 12: {
                return rl.getTrainIconX();
            }
            case 13: {
                return rl.getTrainIconY();
            }
            case 14: {
                if (rl.getComment().equals("")) {
                    return Bundle.getMessage("Add");
                }
                return Bundle.getMessage("ButtonEdit");
            }
            case 15: {
                return Bundle.getMessage("Up");
            }
            case 16: {
                return Bundle.getMessage("Down");
            }
            case 17: {
                return Bundle.getMessage("ButtonDelete");
            }
        }
        return "unknown " + col;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (value == null) {
            log.debug("Warning route table row {} still in edit", (Object)row);
            return;
        }
        RouteLocation rl = this._routeList.get(row);
        if (rl == null) {
            log.error("ERROR unknown route location for row: {}", (Object)row);
        }
        switch (col) {
            case 14: {
                this.setComment(rl);
                break;
            }
            case 15: {
                this.moveUpRouteLocation(rl);
                break;
            }
            case 16: {
                this.moveDownRouteLocation(rl);
                break;
            }
            case 17: {
                this.deleteRouteLocation(rl);
                break;
            }
            case 2: {
                this.setTrainDirection(value, rl);
                break;
            }
            case 3: {
                this.setMaxTrainMoves(value, rl);
                break;
            }
            case 4: {
                this.setRandomControlValue(value, rl);
                break;
            }
            case 5: {
                this.setPickup(value, rl);
                break;
            }
            case 6: {
                this.setDrop(value, rl);
                break;
            }
            case 7: {
                this.setLocal(value, rl);
                break;
            }
            case 9: {
                this.setTravel(value, rl);
                break;
            }
            case 8: {
                this.setDepartureTime(value, rl);
                break;
            }
            case 10: {
                this.setMaxTrainLength(value, rl);
                break;
            }
            case 11: {
                this.setGrade(value, rl);
                break;
            }
            case 12: {
                this.setTrainIconX(value, rl);
                break;
            }
            case 13: {
                this.setTrainIconY(value, rl);
                break;
            }
        }
    }

    private void moveUpRouteLocation(RouteLocation rl) {
        log.debug("move location up");
        this._route.moveLocationUp(rl);
    }

    private void moveDownRouteLocation(RouteLocation rl) {
        log.debug("move location down");
        this._route.moveLocationDown(rl);
    }

    private void deleteRouteLocation(RouteLocation rl) {
        log.debug("Delete location");
        this._route.deleteLocation(rl);
    }

    public int getLastTrainDirection() {
        return this._trainDirection;
    }

    private void setTrainDirection(Object value, RouteLocation rl) {
        this._trainDirection = Setup.getDirectionInt((String)((JComboBox)value).getSelectedItem());
        rl.setTrainDirection(this._trainDirection);
        rl.setTrainIconCoordinates();
    }

    public int getLastMaxTrainMoves() {
        return this._maxTrainMoves;
    }

    private void setMaxTrainMoves(Object value, RouteLocation rl) {
        int moves = (Integer)value;
        if (moves <= 500) {
            rl.setMaxCarMoves(moves);
            this._maxTrainMoves = moves;
        } else {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("MaximumLocationMoves"), Bundle.getMessage("CanNotChangeMoves"), 0);
        }
    }

    private void setRandomControlValue(Object value, RouteLocation rl) {
        rl.setRandomControl((String)((JComboBox)value).getSelectedItem());
    }

    private void setDrop(Object value, RouteLocation rl) {
        rl.setDropAllowed(((String)((JComboBox)value).getSelectedItem()).equals(Bundle.getMessage("yes")));
    }

    private void setPickup(Object value, RouteLocation rl) {
        rl.setPickUpAllowed(((String)((JComboBox)value).getSelectedItem()).equals(Bundle.getMessage("yes")));
    }

    private void setLocal(Object value, RouteLocation rl) {
        rl.setLocalMovesAllowed(((String)((JComboBox)value).getSelectedItem()).equals(Bundle.getMessage("yes")));
    }

    public int getLastMaxTrainLength() {
        return this._maxTrainLength;
    }

    private void setTravel(Object value, RouteLocation rl) {
        int wait = (Integer)value;
        rl.setWait(wait - Setup.getTravelTime());
    }

    private void setDepartureTime(Object value, RouteLocation rl) {
        rl.setDepartureTime((String)((JComboBox)value).getSelectedItem());
    }

    private void setMaxTrainLength(Object value, RouteLocation rl) {
        int length = (Integer)value;
        if (length < 0) {
            log.error("Maximum departure length must be a postive number");
            return;
        }
        if (length > Setup.getMaxTrainLength()) {
            log.error("Maximum departure length can not exceed maximum train length");
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("DepartureLengthNotExceed", length, Setup.getMaxTrainLength()), Bundle.getMessage("CanNotChangeMaxLength"), 0);
            return;
        }
        if (rl != this._route.getTerminatesRouteLocation() && (length < 500 && Setup.getLengthUnit().equals(Setup.FEET) || length < 160 && Setup.getLengthUnit().equals(Setup.METER)) && JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("LimitTrainLength", length, Setup.getLengthUnit().toLowerCase(), rl.getName()), Bundle.getMessage("WarningTooShort"), 2) != 0) {
            return;
        }
        rl.setMaxTrainLength(length);
        this._maxTrainLength = length;
    }

    private void setGrade(Object value, RouteLocation rl) {
        double grade = (Double)value;
        if (grade <= 6.0 && grade >= -6.0) {
            rl.setGrade(grade);
        } else {
            log.error("Maximum grade is 6 percent");
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("MaxGrade"), Bundle.getMessage("CanNotChangeGrade"), 0);
        }
    }

    private void setTrainIconX(Object value, RouteLocation rl) {
        int x = (Integer)value;
        rl.setTrainIconX(x);
    }

    private void setTrainIconY(Object value, RouteLocation rl) {
        int y = (Integer)value;
        rl.setTrainIconY(y);
    }

    private void setComment(final RouteLocation rl) {
        final JDialog dialog = new JDialog();
        dialog.setLayout(new BorderLayout());
        dialog.setTitle(Bundle.getMessage("Comment") + " " + rl.getName());
        final JTextArea commentTextArea = new JTextArea(5, 100);
        JScrollPane commentScroller = new JScrollPane(commentTextArea);
        dialog.add((Component)commentScroller, "Center");
        commentTextArea.setText(rl.getComment());
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        dialog.add((Component)buttonPane, "South");
        JPanel pTextColor = new JPanel();
        pTextColor.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TextColor")));
        final JColorChooser commentColorChooser = new JColorChooser(rl.getCommentColor());
        AbstractColorChooserPanel[] commentColorPanels = new AbstractColorChooserPanel[]{new SplitButtonColorChooserPanel()};
        commentColorChooser.setChooserPanels(commentColorPanels);
        commentColorChooser.setPreviewPanel(new JPanel());
        pTextColor.add(commentColorChooser);
        buttonPane.add(pTextColor);
        JButton okayButton = new JButton(Bundle.getMessage("ButtonOK"));
        okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                rl.setComment(commentTextArea.getText());
                rl.setCommentColor(commentColorChooser.getColor());
                dialog.dispose();
            }
        });
        buttonPane.add(okayButton);
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                dialog.dispose();
            }
        });
        buttonPane.add(cancelButton);
        dialog.setModal(true);
        dialog.pack();
        dialog.setVisible(true);
    }

    private JComboBox<String> getYesNoComboBox() {
        JComboBox<String> cb = new JComboBox<String>();
        cb.addItem(Bundle.getMessage("yes"));
        cb.addItem(Bundle.getMessage("no"));
        return cb;
    }

    private JComboBox<String> getRandomControlComboBox() {
        JComboBox<String> cb = new JComboBox<String>();
        cb.addItem("Off");
        for (int i = 10; i < 101; i += 10) {
            cb.addItem(Integer.toString(i));
        }
        return cb;
    }

    protected JComboBox<String> getTimeComboBox() {
        JComboBox<String> timeBox = new JComboBox<String>();
        timeBox.addItem("");
        for (int i = 0; i < 24; ++i) {
            Object hour = i < 10 ? "0" + Integer.toString(i) : Integer.toString(i);
            for (int j = 0; j < 60; ++j) {
                Object minute = j < 10 ? "0" + Integer.toString(j) : Integer.toString(j);
                timeBox.addItem((String)hour + ":" + (String)minute);
            }
        }
        return timeBox;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        RouteLocation rl;
        int row;
        if (e.getPropertyName().equals("routeListChange")) {
            this.updateList();
            this.fireTableDataChanged();
        }
        if (e.getPropertyName().equals("setupTrainDirectionChange") || e.getPropertyName().equals("setupTravelTimeChange")) {
            this.fireTableDataChanged();
        }
        if (e.getSource().getClass().equals(RouteLocation.class) && (row = this._routeList.indexOf(rl = (RouteLocation)e.getSource())) >= 0) {
            this.fireTableRowsUpdated(row, row);
        }
    }

    private void removePropertyChangeRouteLocations() {
        for (RouteLocation rl : this._routeList) {
            rl.removePropertyChangeListener(this);
        }
    }

    public void dispose() {
        this.removePropertyChangeRouteLocations();
        if (this._route != null) {
            this._route.removePropertyChangeListener(this);
        }
        Setup.getDefault().removePropertyChangeListener(this);
        this._routeList.clear();
        this.fireTableDataChanged();
    }
}

