/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes.gui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsMenu;
import jmri.jmrit.operations.routes.gui.Bundle;
import jmri.jmrit.operations.routes.gui.RouteEditFrame;
import jmri.jmrit.operations.routes.gui.RoutesTableModel;
import jmri.jmrit.operations.routes.tools.ExportRoutesAction;
import jmri.jmrit.operations.routes.tools.ImportRoutesAction;
import jmri.jmrit.operations.routes.tools.PrintRoutesAction;
import jmri.jmrit.operations.routes.tools.RouteCopyAction;
import jmri.jmrit.operations.routes.tools.SetTrainIconPositionAction;
import jmri.jmrit.operations.routes.tools.ShowRoutesServingLocationAction;
import jmri.swing.JTablePersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutesTableFrame
extends OperationsFrame {
    RoutesTableModel routesModel = new RoutesTableModel();
    JTable routesTable;
    JLabel textSort = new JLabel(Bundle.getMessage("SortBy"));
    JLabel textSep = new JLabel("          ");
    JRadioButton sortByName = new JRadioButton(Bundle.getMessage("Name"));
    JRadioButton sortById = new JRadioButton(Bundle.getMessage("Id"));
    JButton addButton = new JButton(Bundle.getMessage("AddRoute"));
    private static final Logger log = LoggerFactory.getLogger(RoutesTableFrame.class);

    public RoutesTableFrame() {
        super(Bundle.getMessage("TitleRoutesTable"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.routesTable = new JTable(this.routesModel);
        JScrollPane routesPane = new JScrollPane(this.routesTable);
        routesPane.setVerticalScrollBarPolicy(20);
        this.routesModel.initTable(this, this.routesTable);
        this.getContentPane().add(routesPane);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new FlowLayout());
        controlPanel.add(this.textSort);
        controlPanel.add(this.sortByName);
        controlPanel.add(this.sortById);
        controlPanel.add(this.textSep);
        controlPanel.add(this.addButton);
        controlPanel.setMaximumSize(new Dimension(1025, 50));
        this.getContentPane().add(controlPanel);
        this.sortByName.setSelected(true);
        this.addButtonAction(this.addButton);
        this.addButton.setToolTipText(Bundle.getMessage("AddRouteTip"));
        this.addRadioButtonAction(this.sortByName);
        this.addRadioButtonAction(this.sortById);
        ButtonGroup bGroup = new ButtonGroup();
        bGroup.add(this.sortByName);
        bGroup.add(this.sortById);
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new RouteCopyAction());
        toolMenu.add(new SetTrainIconPositionAction());
        toolMenu.add(new ExportRoutesAction());
        toolMenu.add(new ImportRoutesAction());
        toolMenu.addSeparator();
        toolMenu.add(new ShowRoutesServingLocationAction(null));
        toolMenu.addSeparator();
        toolMenu.add(new PrintRoutesAction(false));
        toolMenu.add(new PrintRoutesAction(true));
        menuBar.add(toolMenu);
        menuBar.add(new OperationsMenu());
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_Routes", true);
        this.initMinimumSize(new Dimension(700, 300));
        this.createShutDownTask();
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button activated");
        this.clearTableSort(this.routesTable);
        if (ae.getSource() == this.sortByName) {
            this.routesModel.setSort(this.routesModel.SORTBYNAME);
        }
        if (ae.getSource() == this.sortById) {
            this.routesModel.setSort(this.routesModel.SORTBYID);
        }
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.addButton) {
            RouteEditFrame f = new RouteEditFrame();
            f.initComponents(null);
        }
    }

    @Override
    public void dispose() {
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(tpm -> tpm.stopPersisting(this.routesTable));
        this.routesModel.dispose();
        super.dispose();
    }
}

