/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.routes.gui.Bundle;
import jmri.jmrit.operations.routes.gui.RouteEditFrame;
import jmri.jmrit.operations.routes.gui.RoutesTableFrame;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutesTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    RouteManager routemanager;
    public static final int ID_COLUMN = 0;
    public static final int NAME_COLUMN = 1;
    public static final int COMMENT_COLUMN = 2;
    public static final int DEPARTS_COLUMN = 3;
    public static final int MIN_LENGTH_COLUMN = 4;
    public static final int MAX_LENGTH_COLUMN = 5;
    public static final int STATUS_COLUMN = 6;
    public static final int EDIT_COLUMN = 7;
    private static final int HIGHESTCOLUMN = 8;
    public final int SORTBYNAME = 1;
    public final int SORTBYID = 2;
    private int _sort = 1;
    List<Route> sysList = null;
    RouteEditFrame ref = null;
    protected static final String NEW_LINE = "\n";
    private static final Logger log = LoggerFactory.getLogger(RoutesTableModel.class);

    public RoutesTableModel() {
        Setup.getDefault().addPropertyChangeListener(this);
        this.routemanager = InstanceManager.getDefault(RouteManager.class);
        this.routemanager.addPropertyChangeListener(this);
        InstanceManager.getDefault(LocationManager.class).addPropertyChangeListener(this);
        this.updateList();
    }

    public void setSort(int sort) {
        this._sort = sort;
        this.updateList();
        this.fireTableDataChanged();
    }

    private void updateList() {
        this.removePropertyChangeRoutes();
        this.sysList = this._sort == 2 ? this.routemanager.getRoutesByIdList() : this.routemanager.getRoutesByNameList();
        for (Route route : this.sysList) {
            route.addPropertyChangeListener(this);
        }
    }

    void initTable(RoutesTableFrame frame, JTable table) {
        TableColumnModel tcm = table.getColumnModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(7).setCellRenderer(buttonRenderer);
        tcm.getColumn(7).setCellEditor(buttonEditor);
        table.getColumnModel().getColumn(0).setPreferredWidth(30);
        table.getColumnModel().getColumn(1).setPreferredWidth(220);
        table.getColumnModel().getColumn(2).setPreferredWidth(380);
        table.getColumnModel().getColumn(6).setPreferredWidth(70);
        table.getColumnModel().getColumn(3).setPreferredWidth(75);
        table.getColumnModel().getColumn(4).setPreferredWidth(75);
        table.getColumnModel().getColumn(5).setPreferredWidth(75);
        table.getColumnModel().getColumn(7).setPreferredWidth(80);
        frame.loadTableDetails(table);
    }

    @Override
    public int getRowCount() {
        return this.sysList.size();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("Id");
            }
            case 1: {
                return Bundle.getMessage("Name");
            }
            case 2: {
                return Bundle.getMessage("Comment");
            }
            case 3: {
                return Bundle.getMessage("DepartsDirection");
            }
            case 4: {
                return Bundle.getMessage("MinLength");
            }
            case 5: {
                return Bundle.getMessage("MaxLength");
            }
            case 6: {
                return Bundle.getMessage("Status");
            }
            case 7: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                return String.class;
            }
            case 0: 
            case 4: 
            case 5: {
                return Integer.class;
            }
            case 7: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount()) {
            return "ERROR unknown " + row;
        }
        Route route = this.sysList.get(row);
        if (route == null) {
            return "ERROR route unknown " + row;
        }
        switch (col) {
            case 0: {
                return Integer.parseInt(route.getId());
            }
            case 1: {
                return route.getName();
            }
            case 2: {
                return route.getComment();
            }
            case 3: {
                return route.getDepartureDirection();
            }
            case 4: {
                return route.getRouteMinimumTrainLength();
            }
            case 5: {
                return route.getRouteMaximumTrainLength();
            }
            case 6: {
                return route.getStatus();
            }
            case 7: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return "unknown " + col;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 7: {
                this.editRoute(row);
                break;
            }
        }
    }

    private void editRoute(int row) {
        Route route;
        log.debug("Edit route");
        if (this.ref != null) {
            this.ref.dispose();
        }
        if ((route = this.sysList.get(row)) != null && route.getStatus().equals(Route.TRAIN_BUILT)) {
            StringBuffer buf = new StringBuffer(Bundle.getMessage("DoNotModifyRoute"));
            for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByIdList()) {
                if (train.getRoute() != route || !train.isBuilt()) continue;
                buf.append(NEW_LINE + Bundle.getMessage("TrainIsBuilt", train.getName(), route.getName()));
            }
            JmriJOptionPane.showMessageDialog(null, buf.toString(), Bundle.getMessage("TrainBuilt"), 2);
        }
        SwingUtilities.invokeLater(() -> {
            this.ref = new RouteEditFrame();
            this.ref.initComponents(this.sysList.get(row));
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Route route;
        int row;
        if (e.getPropertyName().equals("locationsListLength") || e.getPropertyName().equals("setupTrainDirectionChange")) {
            this.fireTableDataChanged();
        } else if (e.getPropertyName().equals("routesListLengthChanged")) {
            this.updateList();
            this.fireTableDataChanged();
        } else if (e.getSource().getClass().equals(Route.class) && (row = this.sysList.indexOf(route = (Route)e.getSource())) >= 0) {
            this.fireTableRowsUpdated(row, row);
        }
    }

    private void removePropertyChangeRoutes() {
        if (this.sysList != null) {
            for (Route route : this.sysList) {
                route.removePropertyChangeListener(this);
            }
        }
    }

    public void dispose() {
        if (this.ref != null) {
            this.ref.dispose();
        }
        Setup.getDefault().removePropertyChangeListener(this);
        this.routemanager.removePropertyChangeListener(this);
        InstanceManager.getDefault(LocationManager.class).removePropertyChangeListener(this);
        this.removePropertyChangeRoutes();
    }
}

