/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes.tools;

import java.io.BufferedReader;
import java.io.File;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.rollingstock.ImportCommon;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.routes.tools.Bundle;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportRoutes
extends ImportCommon {
    RouteManager routeManager = InstanceManager.getDefault(RouteManager.class);
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    int routesAdded = 0;
    protected static final int FIELD_ROUTE_NAME = 0;
    protected static final int FIELD_EMPTY = 1;
    protected static final int FIELD_ROUTE_COMMENT = 2;
    protected static final int FIELD_ROUTE_LOCATION_EMPTY = 0;
    protected static final int FIELD_ROUTE_LOCATION_NAME = 1;
    protected static final int FIELD_ROUTE_LOCATION_DIRECTION = 2;
    protected static final int FIELD_ROUTE_LOCATION_MOVES = 3;
    protected static final int FIELD_ROUTE_LOCATION_RANDOM = 4;
    protected static final int FIELD_ROUTE_LOCATION_PICKUP_ALLOWED = 5;
    protected static final int FIELD_ROUTE_LOCATION_DROP_ALLOWED = 6;
    protected static final int FIELD_ROUTE_LOCATION_LOCAL_MOVES_ALLOWED = 7;
    protected static final int FIELD_ROUTE_LOCATION_TRAVEL = 8;
    protected static final int FIELD_ROUTE_LOCATION_DEPARTURE_TIME = 9;
    protected static final int FIELD_ROUTE_LOCATION_TRAIN_LENGTH = 10;
    protected static final int FIELD_ROUTE_LOCATION_GRADE = 11;
    protected static final int FIELD_ROUTE_LOCATION_ICON_X = 12;
    protected static final int FIELD_ROUTE_LOCATION_ICON_Y = 13;
    protected static final int FIELD_ROUTE_LOCATION_COMMENT = 14;
    protected static final int FIELD_ROUTE_LOCATION_COMMENT_COLOR = 15;
    private static final Logger log = LoggerFactory.getLogger(ImportRoutes.class);

    @Override
    public void run() {
        File file = this.getFile();
        if (file == null) {
            return;
        }
        BufferedReader rdr = this.getBufferedReader(file);
        if (rdr == null) {
            return;
        }
        this.createStatusFrame(Bundle.getMessage("TitleImportRoutes"));
        boolean headerFound = false;
        Route route = null;
        block0: while (true) {
            String[] inputLine;
            if ((inputLine = this.readNextLine(rdr)) == BREAK) {
                log.debug("Done");
                break;
            }
            if (inputLine.length < 1) {
                log.debug("Skipping blank line");
                continue;
            }
            if (!headerFound && inputLine[0].equals(Bundle.getMessage("Route"))) {
                headerFound = true;
                int elementNum = 0;
                String[] stringArray = inputLine;
                int n = stringArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block0;
                    String lineElement = stringArray[n2];
                    log.debug("Header {} is: {}", (Object)elementNum++, (Object)lineElement);
                    ++n2;
                }
            }
            if (inputLine.length == 3) {
                log.debug("Found start of route: {}", (Object)inputLine[0]);
                route = this.routeManager.getRouteByName(inputLine[0]);
                if (route != null) {
                    log.info("Route: {} already exists, will not import!", (Object)inputLine[0]);
                    route = null;
                } else {
                    ++this.routesAdded;
                    route = this.routeManager.newRoute(inputLine[0]);
                    log.info("Creating route: {}", (Object)inputLine[0]);
                    route.setComment(inputLine[2]);
                }
            }
            if (route == null || inputLine.length != 16) continue;
            log.debug("Adding route location: {}", (Object)inputLine[1]);
            Location location = this.locationManager.getLocationByName(inputLine[1]);
            if (location == null) {
                log.error("Location ({}) in route ({}) does not exist", (Object)inputLine[1], (Object)route.getName());
                break;
            }
            RouteLocation rl = route.addLocation(location);
            rl.setTrainDirection(Setup.getDirectionInt(inputLine[2]));
            rl.setMaxCarMoves(Integer.parseInt(inputLine[3]));
            rl.setRandomControl(inputLine[4]);
            rl.setPickUpAllowed(inputLine[5].equals(Bundle.getMessage("yes")));
            rl.setDropAllowed(inputLine[6].equals(Bundle.getMessage("yes")));
            rl.setLocalMovesAllowed(inputLine[7].equals(Bundle.getMessage("yes")));
            rl.setWait(Integer.parseInt(inputLine[8]) - Setup.getTravelTime());
            rl.setDepartureTime(inputLine[9]);
            rl.setMaxTrainLength(Integer.parseInt(inputLine[10]));
            rl.setGrade(Double.parseDouble(inputLine[11]));
            rl.setTrainIconX(Integer.parseInt(inputLine[12]));
            rl.setTrainIconY(Integer.parseInt(inputLine[13]));
            rl.setComment(inputLine[14]);
            rl.setCommentTextColor(inputLine[15]);
        }
        ThreadingUtil.runOnGUI(() -> {
            if (this.importOkay) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ImportRoutesAdded", this.routesAdded), Bundle.getMessage("SuccessfulImport"), 1);
            } else {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ImportRoutesAdded", this.routesAdded), Bundle.getMessage("ImportFailed"), 0);
            }
        });
        this.fstatus.dispose();
    }
}

