/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes.tools;

import java.awt.Frame;
import java.io.IOException;
import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.routes.tools.Bundle;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintRoutes {
    static final String NEW_LINE = "\n";
    static final String TAB = "\t";
    static final String SPACE = " ";
    private static final char FORM_FEED = '\f';
    private static final int MAX_NAME_LENGTH = Control.max_len_string_location_name;
    boolean _isPreview;
    private static final Logger log = LoggerFactory.getLogger(PrintRoutes.class);

    public PrintRoutes(boolean isPreview) {
        this._isPreview = isPreview;
        this.printRoutes();
    }

    public PrintRoutes(boolean isPreview, Route route) {
        this._isPreview = isPreview;
        this.printRoute(route);
    }

    private void printRoutes() {
        try (HardcopyWriter writer = new HardcopyWriter(new Frame(), Bundle.getMessage("TitleRoutesTable"), Control.reportFontSize, 0.5, 0.5, 0.5, 0.5, this._isPreview);){
            writer.write(SPACE);
            List<Route> routes = InstanceManager.getDefault(RouteManager.class).getRoutesByNameList();
            for (int i = 0; i < routes.size(); ++i) {
                Route route = routes.get(i);
                writer.write(route.getName() + NEW_LINE);
                this.printRoute(writer, route);
                if (i == routes.size() - 1) continue;
                writer.write(12);
            }
        }
        catch (HardcopyWriter.PrintCanceledException ex) {
            log.debug("Print canceled");
        }
        catch (IOException e1) {
            log.error("Exception in print routes: {}", (Object)e1.getLocalizedMessage());
        }
    }

    private void printRoute(Route route) {
        if (route == null) {
            return;
        }
        try (HardcopyWriter writer = new HardcopyWriter(new Frame(), Bundle.getMessage("TitleRoute", route.getName()), Control.reportFontSize, 0.5, 0.5, 0.5, 0.5, this._isPreview);){
            this.printRoute(writer, route);
        }
        catch (HardcopyWriter.PrintCanceledException ex) {
            log.debug("Print canceled");
        }
        catch (IOException e1) {
            log.error("Exception in print routes: {}", (Object)e1.getLocalizedMessage());
        }
    }

    private void printRoute(HardcopyWriter writer, Route route) throws IOException {
        String s;
        writer.write(route.getComment() + NEW_LINE);
        if (!route.getComment().isBlank()) {
            writer.write(NEW_LINE);
        }
        writer.write(this.getPrintHeader1());
        List<RouteLocation> routeList = route.getLocationsBySequenceList();
        for (RouteLocation rl : routeList) {
            s = this.padAndTruncate(rl.getName(), MAX_NAME_LENGTH) + rl.getTrainDirectionString() + TAB + this.padAndTruncate(Integer.toString(rl.getMaxCarMoves()), 4) + this.padAndTruncate(rl.isPickUpAllowed() ? Bundle.getMessage("yes") : Bundle.getMessage("no"), 6) + this.padAndTruncate(rl.isDropAllowed() ? Bundle.getMessage("yes") : Bundle.getMessage("no"), 6) + (rl.isLocalMovesAllowed() ? Bundle.getMessage("yes") : Bundle.getMessage("no")) + TAB + (rl.getWait() + Setup.getTravelTime()) + TAB + rl.getMaxTrainLength() + TAB + rl.getGrade() + TAB + this.padAndTruncate(Integer.toString(rl.getTrainIconX()), 5) + rl.getTrainIconY() + NEW_LINE;
            writer.write(s);
        }
        writer.write(this.getPrintHeader2());
        for (RouteLocation rl : routeList) {
            s = this.padAndTruncate(rl.getName(), MAX_NAME_LENGTH) + rl.getDepartureTime() + TAB + rl.getComment() + NEW_LINE;
            writer.write(s);
        }
    }

    private String getPrintHeader1() {
        String s = Bundle.getMessage("Location") + "\t    " + Bundle.getMessage("Direction") + SPACE + Bundle.getMessage("MaxMoves") + SPACE + Bundle.getMessage("Pull?") + SPACE + Bundle.getMessage("Drop?") + SPACE + Bundle.getMessage("Local?") + SPACE + Bundle.getMessage("Travel") + TAB + Bundle.getMessage("Length") + TAB + Bundle.getMessage("Grade") + TAB + Bundle.getMessage("X") + "    " + Bundle.getMessage("Y") + NEW_LINE;
        return s;
    }

    private String getPrintHeader2() {
        String s = NEW_LINE + Bundle.getMessage("Location") + TAB + Bundle.getMessage("DepartTime") + TAB + Bundle.getMessage("Comment") + NEW_LINE;
        return s;
    }

    private String padAndTruncate(String string, int fieldSize) {
        return TrainCommon.padAndTruncate(string, fieldSize);
    }
}

