/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.routes.gui.RouteEditFrame;
import jmri.jmrit.operations.routes.tools.Bundle;
import jmri.jmrit.operations.setup.Control;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteCopyFrame
extends OperationsFrame {
    RouteManager routeManager = InstanceManager.getDefault(RouteManager.class);
    JLabel textCopyRoute = new JLabel(Bundle.getMessage("CopyRoute"));
    JLabel textRouteName = new JLabel(Bundle.getMessage("RouteName"));
    JTextField routeNameTextField = new JTextField(Control.max_len_string_route_name);
    JCheckBox invertCheckBox = new JCheckBox(Bundle.getMessage("Invert"));
    JButton copyButton = new JButton(Bundle.getMessage("ButtonCopy"));
    JComboBox<Route> routeBox = InstanceManager.getDefault(RouteManager.class).getComboBox();
    private static final Logger log = LoggerFactory.getLogger(RouteCopyFrame.class);

    public RouteCopyFrame(Route route) {
        super(Bundle.getMessage("TitleRouteCopy"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new GridBagLayout());
        this.addItem(p1, this.textRouteName, 0, 1);
        this.addItemWidth(p1, this.routeNameTextField, 3, 1, 1);
        this.addItem(p1, this.textCopyRoute, 0, 2);
        this.addItemWidth(p1, this.routeBox, 3, 1, 2);
        this.addItem(p1, this.invertCheckBox, 0, 4);
        this.addItem(p1, this.copyButton, 1, 4);
        this.getContentPane().add(p1);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_CopyRoute", true);
        this.initMinimumSize(new Dimension(600, 200));
        this.addButtonAction(this.copyButton);
        this.routeBox.setSelectedItem(route);
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.copyButton) {
            log.debug("copy route button activated");
            if (!this.checkName()) {
                return;
            }
            Route newRoute = this.routeManager.getRouteByName(this.routeNameTextField.getText());
            if (newRoute != null) {
                this.reportRouteExists(Bundle.getMessage("add"));
                return;
            }
            if (this.routeBox.getSelectedItem() == null) {
                this.reportRouteDoesNotExist();
                return;
            }
            Route oldRoute = (Route)this.routeBox.getSelectedItem();
            newRoute = this.routeManager.copyRoute(oldRoute, this.routeNameTextField.getText(), this.invertCheckBox.isSelected());
            RouteEditFrame f = new RouteEditFrame();
            f.initComponents(newRoute);
        }
    }

    private void reportRouteExists(String s) {
        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ReportExists"), Bundle.getMessage("CanNotRoute", s), 0);
    }

    private void reportRouteDoesNotExist() {
        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("CopyRoute"), Bundle.getMessage("CopyRoute"), 0);
    }

    private boolean checkName() {
        if (this.routeNameTextField.getText().trim().isEmpty()) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("EnterRouteName"), Bundle.getMessage("EnterRouteName"), 0);
            return false;
        }
        if (this.routeNameTextField.getText().length() > Control.max_len_string_route_name) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("RouteNameLess", Control.max_len_string_route_name + 1), Bundle.getMessage("CanNotAddRoute"), 0);
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

