/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import jmri.InstanceManager;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.routes.tools.Bundle;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.TrainIcon;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetTrainIconPositionFrame
extends OperationsFrame {
    RouteManager routeManager = InstanceManager.getDefault(RouteManager.class);
    JLabel textEastX = new JLabel("   X  ");
    JLabel textEastY = new JLabel("   Y  ");
    JLabel textWestX = new JLabel("   X  ");
    JLabel textWestY = new JLabel("   Y  ");
    JLabel textNorthX = new JLabel("   X  ");
    JLabel textNorthY = new JLabel("   Y  ");
    JLabel textSouthX = new JLabel("   X  ");
    JLabel textSouthY = new JLabel("   Y  ");
    JLabel textRangeX = new JLabel("   X +/-");
    JLabel textRangeY = new JLabel("   Y +/-");
    JButton placeButton = new JButton(Bundle.getMessage("PlaceTestIcon"));
    JButton applyButton = new JButton(Bundle.getMessage("UpdateRoutes"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JComboBox<Location> locationBox = InstanceManager.getDefault(LocationManager.class).getComboBox();
    JSpinner spinTrainIconEastX = new JSpinner(new SpinnerNumberModel(0, 0, 10000, 1));
    JSpinner spinTrainIconEastY = new JSpinner(new SpinnerNumberModel(0, 0, 10000, 1));
    JSpinner spinTrainIconWestX = new JSpinner(new SpinnerNumberModel(0, 0, 10000, 1));
    JSpinner spinTrainIconWestY = new JSpinner(new SpinnerNumberModel(0, 0, 10000, 1));
    JSpinner spinTrainIconNorthX = new JSpinner(new SpinnerNumberModel(0, 0, 10000, 1));
    JSpinner spinTrainIconNorthY = new JSpinner(new SpinnerNumberModel(0, 0, 10000, 1));
    JSpinner spinTrainIconSouthX = new JSpinner(new SpinnerNumberModel(0, 0, 10000, 1));
    JSpinner spinTrainIconSouthY = new JSpinner(new SpinnerNumberModel(0, 0, 10000, 1));
    JSpinner spinTrainIconRangeX = new JSpinner(new SpinnerNumberModel(25, 0, 1000, 1));
    JSpinner spinTrainIconRangeY = new JSpinner(new SpinnerNumberModel(25, 0, 1000, 1));
    TrainIcon _tIonEast;
    TrainIcon _tIonWest;
    TrainIcon _tIonNorth;
    TrainIcon _tIonSouth;
    private static final Logger log = LoggerFactory.getLogger(SetTrainIconPositionFrame.class);

    public SetTrainIconPositionFrame() {
        super(Bundle.getMessage("MenuSetTrainIcon"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.placeButton.setToolTipText(Bundle.getMessage("TipPlaceButton") + " \"" + Setup.getPanelName() + "\"");
        this.applyButton.setToolTipText(Bundle.getMessage("TipApplyAllButton"));
        this.saveButton.setToolTipText(Bundle.getMessage("TipSaveButton"));
        JPanel pLocation = new JPanel();
        pLocation.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Location")));
        pLocation.add(this.locationBox);
        JPanel pEast = new JPanel();
        pEast.setLayout(new GridBagLayout());
        pEast.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("EastTrainIcon")));
        this.addItem(pEast, this.textEastX, 0, 0);
        this.addItem(pEast, this.spinTrainIconEastX, 1, 0);
        this.addItem(pEast, this.textEastY, 2, 0);
        this.addItem(pEast, this.spinTrainIconEastY, 3, 0);
        JPanel pWest = new JPanel();
        pWest.setLayout(new GridBagLayout());
        pWest.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("WestTrainIcon")));
        this.addItem(pWest, this.textWestX, 0, 0);
        this.addItem(pWest, this.spinTrainIconWestX, 1, 0);
        this.addItem(pWest, this.textWestY, 2, 0);
        this.addItem(pWest, this.spinTrainIconWestY, 3, 0);
        JPanel pNorth = new JPanel();
        pNorth.setLayout(new GridBagLayout());
        pNorth.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("NorthTrainIcon")));
        this.addItem(pNorth, this.textNorthX, 0, 0);
        this.addItem(pNorth, this.spinTrainIconNorthX, 1, 0);
        this.addItem(pNorth, this.textNorthY, 2, 0);
        this.addItem(pNorth, this.spinTrainIconNorthY, 3, 0);
        JPanel pSouth = new JPanel();
        pSouth.setLayout(new GridBagLayout());
        pSouth.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SouthTrainIcon")));
        this.addItem(pSouth, this.textSouthX, 0, 0);
        this.addItem(pSouth, this.spinTrainIconSouthX, 1, 0);
        this.addItem(pSouth, this.textSouthY, 2, 0);
        this.addItem(pSouth, this.spinTrainIconSouthY, 3, 0);
        JPanel pRange = new JPanel();
        pRange.setLayout(new GridBagLayout());
        pRange.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("RangeTrainIcon")));
        this.addItem(pRange, this.textRangeX, 0, 0);
        this.addItem(pRange, this.spinTrainIconRangeX, 1, 0);
        this.addItem(pRange, this.textRangeY, 2, 0);
        this.addItem(pRange, this.spinTrainIconRangeY, 3, 0);
        JPanel pControl = new JPanel();
        pControl.setLayout(new GridBagLayout());
        pControl.setBorder(BorderFactory.createTitledBorder(""));
        this.addItem(pControl, this.placeButton, 0, 0);
        this.addItem(pControl, this.applyButton, 1, 0);
        this.addItem(pControl, this.saveButton, 2, 0);
        pEast.setVisible((Setup.getTrainDirection() & 1) == 1);
        pWest.setVisible((Setup.getTrainDirection() & 2) == 2);
        pNorth.setVisible((Setup.getTrainDirection() & 4) == 4);
        pSouth.setVisible((Setup.getTrainDirection() & 8) == 8);
        this.getContentPane().add(pLocation);
        this.getContentPane().add(pNorth);
        this.getContentPane().add(pSouth);
        this.getContentPane().add(pEast);
        this.getContentPane().add(pWest);
        this.getContentPane().add(pRange);
        this.getContentPane().add(pControl);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_SetTrainIconCoordinates", true);
        this.addButtonAction(this.placeButton);
        this.addButtonAction(this.applyButton);
        this.addButtonAction(this.saveButton);
        this.addComboBoxAction(this.locationBox);
        this.spinnersEnable(false);
        this.addSpinnerChangeListerner(this.spinTrainIconEastX);
        this.addSpinnerChangeListerner(this.spinTrainIconEastY);
        this.addSpinnerChangeListerner(this.spinTrainIconWestX);
        this.addSpinnerChangeListerner(this.spinTrainIconWestY);
        this.addSpinnerChangeListerner(this.spinTrainIconNorthX);
        this.addSpinnerChangeListerner(this.spinTrainIconNorthY);
        this.addSpinnerChangeListerner(this.spinTrainIconSouthX);
        this.addSpinnerChangeListerner(this.spinTrainIconSouthY);
        this.addSpinnerChangeListerner(this.spinTrainIconRangeX);
        this.addSpinnerChangeListerner(this.spinTrainIconRangeY);
        this.initMinimumSize(new Dimension(500, 400));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        int value;
        if (this.locationBox.getSelectedItem() == null) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("SelectLocationToEdit"), Bundle.getMessage("NoLocationSelected"), 0);
            return;
        }
        Location location = (Location)this.locationBox.getSelectedItem();
        if (location == null) {
            return;
        }
        if (ae.getSource() == this.placeButton) {
            this.placeTestIcons();
        }
        if (ae.getSource() == this.applyButton && (value = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("DoYouWantAllRoutes"), Bundle.getMessage("UpdateTrainIcon", location.getName()), 0)) == 0) {
            this.saveSpinnerValues(location);
            this.updateTrainIconCoordinates(location);
        }
        if (ae.getSource() == this.saveButton) {
            value = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("UpdateDefaults"), Bundle.getMessage("UpdateTrainIcon", location.getName()), 0);
            if (value == 0) {
                this.saveSpinnerValues(location);
            }
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        if (this.locationBox.getSelectedItem() == null) {
            this.resetSpinners();
            this.removeIcons();
        } else {
            this.loadSpinners((Location)this.locationBox.getSelectedItem());
        }
    }

    @Override
    public void spinnerChangeEvent(ChangeEvent ae) {
        if (ae.getSource() == this.spinTrainIconEastX && this._tIonEast != null) {
            this._tIonEast.setLocation((Integer)this.spinTrainIconEastX.getValue(), this._tIonEast.getLocation().y);
        }
        if (ae.getSource() == this.spinTrainIconEastY && this._tIonEast != null) {
            this._tIonEast.setLocation(this._tIonEast.getLocation().x, (Integer)this.spinTrainIconEastY.getValue());
        }
        if (ae.getSource() == this.spinTrainIconWestX && this._tIonWest != null) {
            this._tIonWest.setLocation((Integer)this.spinTrainIconWestX.getValue(), this._tIonWest.getLocation().y);
        }
        if (ae.getSource() == this.spinTrainIconWestY && this._tIonWest != null) {
            this._tIonWest.setLocation(this._tIonWest.getLocation().x, (Integer)this.spinTrainIconWestY.getValue());
        }
        if (ae.getSource() == this.spinTrainIconNorthX && this._tIonNorth != null) {
            this._tIonNorth.setLocation((Integer)this.spinTrainIconNorthX.getValue(), this._tIonNorth.getLocation().y);
        }
        if (ae.getSource() == this.spinTrainIconNorthY && this._tIonNorth != null) {
            this._tIonNorth.setLocation(this._tIonNorth.getLocation().x, (Integer)this.spinTrainIconNorthY.getValue());
        }
        if (ae.getSource() == this.spinTrainIconSouthX && this._tIonSouth != null) {
            this._tIonSouth.setLocation((Integer)this.spinTrainIconSouthX.getValue(), this._tIonSouth.getLocation().y);
        }
        if (ae.getSource() == this.spinTrainIconSouthY && this._tIonSouth != null) {
            this._tIonSouth.setLocation(this._tIonSouth.getLocation().x, (Integer)this.spinTrainIconSouthY.getValue());
        }
    }

    private void resetSpinners() {
        this.spinnersEnable(false);
        this.spinTrainIconEastX.setValue(0);
        this.spinTrainIconEastY.setValue(0);
        this.spinTrainIconWestX.setValue(0);
        this.spinTrainIconWestY.setValue(0);
        this.spinTrainIconNorthX.setValue(0);
        this.spinTrainIconNorthY.setValue(0);
        this.spinTrainIconSouthX.setValue(0);
        this.spinTrainIconSouthY.setValue(0);
    }

    private void loadSpinners(Location location) {
        log.debug("Load spinners location {}", (Object)location.getName());
        this.spinnersEnable(true);
        this.spinTrainIconEastX.setValue(location.getTrainIconEast().x);
        this.spinTrainIconEastY.setValue(location.getTrainIconEast().y);
        this.spinTrainIconWestX.setValue(location.getTrainIconWest().x);
        this.spinTrainIconWestY.setValue(location.getTrainIconWest().y);
        this.spinTrainIconNorthX.setValue(location.getTrainIconNorth().x);
        this.spinTrainIconNorthY.setValue(location.getTrainIconNorth().y);
        this.spinTrainIconSouthX.setValue(location.getTrainIconSouth().x);
        this.spinTrainIconSouthY.setValue(location.getTrainIconSouth().y);
        this.spinTrainIconRangeX.setValue(location.getTrainIconRangeX());
        this.spinTrainIconRangeY.setValue(location.getTrainIconRangeY());
    }

    private void spinnersEnable(boolean enable) {
        this.spinTrainIconEastX.setEnabled(enable);
        this.spinTrainIconEastY.setEnabled(enable);
        this.spinTrainIconWestX.setEnabled(enable);
        this.spinTrainIconWestY.setEnabled(enable);
        this.spinTrainIconNorthX.setEnabled(enable);
        this.spinTrainIconNorthY.setEnabled(enable);
        this.spinTrainIconSouthX.setEnabled(enable);
        this.spinTrainIconSouthY.setEnabled(enable);
        this.spinTrainIconRangeX.setEnabled(enable);
        this.spinTrainIconRangeY.setEnabled(enable);
    }

    private void saveSpinnerValues(Location location) {
        log.debug("Save train icons coordinates for location {}", (Object)location.getName());
        location.setTrainIconEast(new Point((Integer)this.spinTrainIconEastX.getValue(), (Integer)this.spinTrainIconEastY.getValue()));
        location.setTrainIconWest(new Point((Integer)this.spinTrainIconWestX.getValue(), (Integer)this.spinTrainIconWestY.getValue()));
        location.setTrainIconNorth(new Point((Integer)this.spinTrainIconNorthX.getValue(), (Integer)this.spinTrainIconNorthY.getValue()));
        location.setTrainIconSouth(new Point((Integer)this.spinTrainIconSouthX.getValue(), (Integer)this.spinTrainIconSouthY.getValue()));
        location.setTrainIconRangeX((Integer)this.spinTrainIconRangeX.getValue());
        location.setTrainIconRangeY((Integer)this.spinTrainIconRangeY.getValue());
    }

    private void placeTestIcons() {
        this.removeIcons();
        if (this.locationBox.getSelectedItem() == null) {
            return;
        }
        Editor editor = InstanceManager.getDefault(EditorManager.class).getTargetFrame(Setup.getPanelName());
        if (editor == null) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("LoadPanel", Setup.getPanelName()), Bundle.getMessage("PanelNotFound"), 0);
            return;
        }
        Location location = (Location)this.locationBox.getSelectedItem();
        if (location != null) {
            if ((Setup.getTrainDirection() & 1) == 1) {
                this._tIonEast = editor.addTrainIcon(Bundle.getMessage("East"));
                this._tIonEast.getToolTip().setText(location.getName());
                this._tIonEast.getToolTip().setBackgroundColor(Color.white);
                this._tIonEast.setLocoColor(Setup.getTrainIconColorEast());
                this._tIonEast.setLocation((Integer)this.spinTrainIconEastX.getValue(), (Integer)this.spinTrainIconEastY.getValue());
                this.addIconListener(this._tIonEast);
            }
            if ((Setup.getTrainDirection() & 2) == 2) {
                this._tIonWest = editor.addTrainIcon(Bundle.getMessage("West"));
                this._tIonWest.getToolTip().setText(location.getName());
                this._tIonWest.getToolTip().setBackgroundColor(Color.white);
                this._tIonWest.setLocoColor(Setup.getTrainIconColorWest());
                this._tIonWest.setLocation((Integer)this.spinTrainIconWestX.getValue(), (Integer)this.spinTrainIconWestY.getValue());
                this.addIconListener(this._tIonWest);
            }
            if ((Setup.getTrainDirection() & 4) == 4) {
                this._tIonNorth = editor.addTrainIcon(Bundle.getMessage("North"));
                this._tIonNorth.getToolTip().setText(location.getName());
                this._tIonNorth.getToolTip().setBackgroundColor(Color.white);
                this._tIonNorth.setLocoColor(Setup.getTrainIconColorNorth());
                this._tIonNorth.setLocation((Integer)this.spinTrainIconNorthX.getValue(), (Integer)this.spinTrainIconNorthY.getValue());
                this.addIconListener(this._tIonNorth);
            }
            if ((Setup.getTrainDirection() & 8) == 8) {
                this._tIonSouth = editor.addTrainIcon(Bundle.getMessage("South"));
                this._tIonSouth.getToolTip().setText(location.getName());
                this._tIonSouth.getToolTip().setBackgroundColor(Color.white);
                this._tIonSouth.setLocoColor(Setup.getTrainIconColorSouth());
                this._tIonSouth.setLocation((Integer)this.spinTrainIconSouthX.getValue(), (Integer)this.spinTrainIconSouthY.getValue());
                this.addIconListener(this._tIonSouth);
            }
        }
    }

    public void updateTrainIconCoordinates(Location location) {
        for (Route route : InstanceManager.getDefault(RouteManager.class).getRoutesByIdList()) {
            for (RouteLocation rl : route.getLocationsBySequenceList()) {
                if (!rl.getName().equals(location.getName())) continue;
                log.debug("Updating train icon for route location {} in route {}", (Object)rl.getName(), (Object)route.getName());
                rl.setTrainIconCoordinates();
            }
        }
    }

    private void removeIcons() {
        if (this._tIonEast != null) {
            this._tIonEast.remove();
        }
        if (this._tIonWest != null) {
            this._tIonWest.remove();
        }
        if (this._tIonNorth != null) {
            this._tIonNorth.remove();
        }
        if (this._tIonSouth != null) {
            this._tIonSouth.remove();
        }
    }

    private void addIconListener(TrainIcon tI) {
        tI.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                SetTrainIconPositionFrame.this.trainIconMoved(e);
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }
        });
    }

    protected void trainIconMoved(ComponentEvent ae) {
        if (ae.getSource() == this._tIonEast) {
            log.debug("East train icon X: {} Y: {}", (Object)this._tIonEast.getLocation().x, (Object)this._tIonEast.getLocation().y);
            this.spinTrainIconEastX.setValue(this._tIonEast.getLocation().x);
            this.spinTrainIconEastY.setValue(this._tIonEast.getLocation().y);
        }
        if (ae.getSource() == this._tIonWest) {
            log.debug("West train icon X: {} Y: {}", (Object)this._tIonWest.getLocation().x, (Object)this._tIonWest.getLocation().y);
            this.spinTrainIconWestX.setValue(this._tIonWest.getLocation().x);
            this.spinTrainIconWestY.setValue(this._tIonWest.getLocation().y);
        }
        if (ae.getSource() == this._tIonNorth) {
            log.debug("North train icon X: {} Y: {}", (Object)this._tIonNorth.getLocation().x, (Object)this._tIonNorth.getLocation().y);
            this.spinTrainIconNorthX.setValue(this._tIonNorth.getLocation().x);
            this.spinTrainIconNorthY.setValue(this._tIonNorth.getLocation().y);
        }
        if (ae.getSource() == this._tIonSouth) {
            log.debug("South train icon X: {} Y: {}", (Object)this._tIonSouth.getLocation().x, (Object)this._tIonSouth.getLocation().y);
            this.spinTrainIconSouthX.setValue(this._tIonSouth.getLocation().x);
            this.spinTrainIconSouthY.setValue(this._tIonSouth.getLocation().y);
        }
    }

    @Override
    public void dispose() {
        this.removeIcons();
        super.dispose();
    }
}

