/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.routes.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.routes.gui.RouteEditFrame;
import jmri.jmrit.operations.routes.tools.Bundle;
import jmri.jmrit.operations.trains.TrainManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowRoutesServingLocationFrame
extends OperationsFrame
implements PropertyChangeListener {
    Location _location = null;
    JPanel pRoutes = new JPanel();
    JComboBox<Location> locationComboBox = new JComboBox();
    private static final Logger log = LoggerFactory.getLogger(ShowRoutesServingLocationFrame.class);

    public ShowRoutesServingLocationFrame() {
        super(Bundle.getMessage("TitleShowRoutes"));
    }

    public void initComponents(Location location) {
        this._location = location;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pLocations = new JPanel();
        pLocations.setLayout(new GridBagLayout());
        pLocations.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Location")));
        pLocations.setMaximumSize(new Dimension(2000, 50));
        this.addItem(pLocations, this.locationComboBox, 0, 0);
        this.pRoutes.setLayout(new GridBagLayout());
        JScrollPane routesPane = new JScrollPane(this.pRoutes);
        routesPane.setVerticalScrollBarPolicy(20);
        routesPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TitleRoutesTable")));
        this.getContentPane().add(pLocations);
        this.getContentPane().add(routesPane);
        this.addComboBoxAction(this.locationComboBox);
        this.updateLocationsComboBox();
        if (location != null) {
            location.addPropertyChangeListener(this);
        }
        this.addPropertyChangeAllRoutes();
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_ShowRoutesServicingThisLocation", true);
        this.setPreferredSize(null);
        this.initMinimumSize();
    }

    private void updateRoutePane() {
        log.debug("Updating for location ({})", (Object)this._location);
        this.pRoutes.removeAll();
        int y = 0;
        block0: for (Route route : InstanceManager.getDefault(RouteManager.class).getRoutesByNameList()) {
            for (RouteLocation rl : route.getLocationsBySequenceList()) {
                if (this._location == null || !rl.getName().equals(this._location.getName())) continue;
                JButton button = new JButton(route.getName());
                this.addButtonAction(button);
                this.addItemLeft(this.pRoutes, button, 1, y++);
                continue block0;
            }
        }
        this.pRoutes.repaint();
        this.pRoutes.revalidate();
        this.pack();
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource().equals(this.locationComboBox)) {
            this._location = (Location)this.locationComboBox.getSelectedItem();
            this.updateRoutePane();
        }
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        JButton button = (JButton)ae.getSource();
        log.debug("Edit route button ({})", (Object)button.getText());
        Route route = InstanceManager.getDefault(RouteManager.class).getRouteByName(button.getText());
        RouteEditFrame frame = new RouteEditFrame();
        frame.initComponents(route);
    }

    private void updateLocationsComboBox() {
        InstanceManager.getDefault(LocationManager.class).updateComboBox(this.locationComboBox);
        this.locationComboBox.setSelectedItem(this._location);
    }

    @Override
    public void dispose() {
        if (this._location != null) {
            this._location.removePropertyChangeListener(this);
        }
        this.removePropertyChangeAllRoutes();
        super.dispose();
    }

    public void addPropertyChangeAllRoutes() {
        InstanceManager.getDefault(RouteManager.class).addPropertyChangeListener(this);
        for (Route route : InstanceManager.getDefault(RouteManager.class).getRoutesByNameList()) {
            route.addPropertyChangeListener(this);
        }
    }

    public void removePropertyChangeAllRoutes() {
        InstanceManager.getDefault(TrainManager.class).removePropertyChangeListener(this);
        for (Route route : InstanceManager.getDefault(RouteManager.class).getRoutesByNameList()) {
            route.removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("routesListLengthChanged")) {
            this.removePropertyChangeAllRoutes();
            this.addPropertyChangeAllRoutes();
        }
        if (e.getPropertyName().equals("routesListLengthChanged") || e.getPropertyName().equals("routeListChange") || e.getPropertyName().equals("routeNameChange") || e.getPropertyName().equals("locationName")) {
            this.updateRoutePane();
        }
    }
}

