/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.setup;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.TrainManifestHeaderText;
import jmri.jmrit.operations.trains.TrainManifestText;
import jmri.jmrit.operations.trains.TrainSwitchListText;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationsSetupXml
extends OperationsXml
implements InstanceManagerAutoDefault,
InstanceManagerAutoInitialize {
    private String operationsFileName = "Operations.xml";
    private static final Logger log = LoggerFactory.getLogger(OperationsSetupXml.class);

    @Override
    public void writeFile(String name) throws FileNotFoundException, IOException {
        log.debug("writeFile {}", (Object)name);
        File file = this.findFile(name);
        if (file == null) {
            file = new File(name);
        }
        Element root = new Element("operations-config");
        Document doc = OperationsSetupXml.newDocument(root, this.dtdLocation + "operations-config.dtd");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "text/xsl");
        m.put("href", "/xml/XSLT/operations-config.xsl");
        ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
        doc.addContent(0, (Content)p);
        root.addContent((Content)Setup.store());
        root.addContent((Content)TrainManifestHeaderText.store());
        root.addContent((Content)TrainManifestText.store());
        root.addContent((Content)TrainSwitchListText.store());
        root.addContent((Content)Control.store());
        this.writeXML(file, doc);
        this.setDirty(false);
    }

    @Override
    public void readFile(String name) throws JDOMException, IOException {
        if (this.findFile(name) == null) {
            log.debug("{} file could not be found", (Object)name);
            return;
        }
        Element root = this.rootFromName(name);
        if (root == null) {
            log.debug("{} file could not be read", (Object)name);
            return;
        }
        if (!root.getName().equals("operations-config")) {
            log.warn("OperationsPro settings file corrupted");
            return;
        }
        Setup.load(root);
        TrainManifestHeaderText.load(root);
        TrainManifestText.load(root);
        TrainSwitchListText.load(root);
        Control.load(root);
        this.setDirty(false);
    }

    @Override
    public void setOperationsFileName(String name) {
        this.operationsFileName = name;
    }

    @Override
    public String getOperationsFileName() {
        return this.operationsFileName;
    }

    @Override
    public void initialize() {
        this.load();
    }
}

