/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.setup.backup;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.setup.backup.Bundle;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSave {
    static Thread autoSave = null;
    private static final Logger log = LoggerFactory.getLogger(AutoSave.class);

    public static synchronized void start() {
        if (Setup.isAutoSaveEnabled() && autoSave == null) {
            autoSave = ThreadingUtil.newThread(() -> AutoSave.saveFiles());
            autoSave.setName("Operations Auto Save");
            autoSave.start();
        }
    }

    public static synchronized void stop() {
        if (autoSave != null) {
            autoSave.interrupt();
            try {
                autoSave.join();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            autoSave = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="I18N of Info Message")
    private static void saveFiles() {
        while (true) {
            Thread thread = autoSave;
            synchronized (thread) {
                if (!Setup.isAutoSaveEnabled()) {
                    break;
                }
                try {
                    autoSave.wait(60000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (OperationsXml.areFilesDirty()) {
                    log.debug("Detected dirty operation files");
                    try {
                        autoSave.wait(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!Setup.isAutoSaveEnabled()) {
                        break;
                    }
                    if (InstanceManager.getDefault(TrainManager.class).isAnyTrainBuilding()) {
                        log.debug("Detected trains being built");
                        continue;
                    }
                    if (OperationsXml.areFilesDirty()) {
                        OperationsXml.save();
                        log.info(Bundle.getMessage("InfoFilesSaved"));
                    }
                }
            }
        }
        autoSave = null;
    }
}

