/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.setup.backup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.setup.backup.Bundle;
import jmri.jmrit.operations.setup.backup.DefaultBackup;
import jmri.util.swing.ExceptionContext;
import jmri.util.swing.ExceptionDisplayFrame;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.UnexpectedExceptionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupDialog
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JLabel captionLabel;
    private JTextField setNameTextField;
    private JLabel infoLabel1;
    private JLabel infoLabel2;
    private JButton backupButton;
    private DefaultBackup backup = new DefaultBackup();
    private static final Logger log = LoggerFactory.getLogger(BackupDialog.class);

    public BackupDialog() {
        this.initComponents();
    }

    private void initComponents() {
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setModal(true);
        this.setTitle(Bundle.getMessage("BackupDialog.this.title"));
        this.setBounds(100, 100, 395, 199);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagLayout gbl = new GridBagLayout();
        gbl.columnWidths = new int[]{0, 0};
        gbl.rowHeights = new int[]{0, 0, 0, 0, 0};
        gbl.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.contentPanel.setLayout(gbl);
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.captionLabel = new JLabel(Bundle.getMessage("BackupDialog.nameLabel.text"));
        GridBagConstraints gbc_captionLabel = new GridBagConstraints();
        gbc_captionLabel.anchor = 17;
        gbc_captionLabel.insets = new Insets(0, 0, 5, 0);
        gbc_captionLabel.gridx = 0;
        gbc_captionLabel.gridy = 0;
        this.contentPanel.add((Component)this.captionLabel, gbc_captionLabel);
        this.setNameTextField = new JTextField();
        this.setNameTextField.setText(this.backup.suggestBackupSetName());
        this.setNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                BackupDialog.this.enableBackupButton();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                BackupDialog.this.enableBackupButton();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                BackupDialog.this.enableBackupButton();
            }
        });
        GridBagConstraints gbc_setNameTextField = new GridBagConstraints();
        gbc_setNameTextField.insets = new Insets(0, 0, 5, 0);
        gbc_setNameTextField.fill = 2;
        gbc_setNameTextField.gridx = 0;
        gbc_setNameTextField.gridy = 1;
        this.contentPanel.add((Component)this.setNameTextField, gbc_setNameTextField);
        this.setNameTextField.setColumns(10);
        this.infoLabel1 = new JLabel(Bundle.getMessage("BackupDialog.notesLabel1.text"));
        GridBagConstraints gbc_infoLabel1 = new GridBagConstraints();
        gbc_infoLabel1.insets = new Insets(0, 0, 5, 0);
        gbc_infoLabel1.anchor = 18;
        gbc_infoLabel1.gridx = 0;
        gbc_infoLabel1.gridy = 2;
        this.contentPanel.add((Component)this.infoLabel1, gbc_infoLabel1);
        this.infoLabel2 = new JLabel(Bundle.getMessage("BackupDialog.notesLabel2.text"));
        GridBagConstraints gbc_infoLabel2 = new GridBagConstraints();
        gbc_infoLabel2.anchor = 17;
        gbc_infoLabel2.gridx = 0;
        gbc_infoLabel2.gridy = 3;
        this.contentPanel.add((Component)this.infoLabel2, gbc_infoLabel2);
        JPanel buttonPane = new JPanel();
        FlowLayout fl_buttonPane = new FlowLayout(1);
        buttonPane.setLayout(fl_buttonPane);
        this.getContentPane().add((Component)buttonPane, "South");
        this.backupButton = new JButton(Bundle.getMessage("BackupDialog.backupButton.text"));
        this.backupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BackupDialog.this.do_backupButton_actionPerformed(e);
            }
        });
        buttonPane.add(this.backupButton);
        this.getRootPane().setDefaultButton(this.backupButton);
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BackupDialog.this.do_cancelButton_actionPerformed(arg0);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
    }

    protected void do_backupButton_actionPerformed(ActionEvent e) {
        String setName = null;
        try {
            int result;
            log.debug("backup button activated");
            setName = this.setNameTextField.getText();
            if (!OperationsXml.checkFileName(setName)) {
                log.error("Back up set name must not contain reserved characters");
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("NameResChar") + "\n" + Bundle.getMessage("ReservedChar"), Bundle.getMessage("CanNotUseName"), 0);
                return;
            }
            if (OperationsXml.areFilesDirty()) {
                if (Setup.isAutoSaveEnabled()) {
                    OperationsXml.save();
                } else if (JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("OperationsFilesModified"), Bundle.getMessage("SaveOperationFiles"), 0) == 0) {
                    OperationsXml.save();
                }
            }
            if (this.backup.checkIfBackupSetExists(setName) && (result = JmriJOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("DirectoryAreadyExists"), setName), Bundle.getMessage("OverwriteBackupDirectory"), 2)) != 0) {
                return;
            }
            this.backup.backupFilesToSetName(setName);
            this.dispose();
        }
        catch (IOException ex) {
            ExceptionContext context = new ExceptionContext(ex, Bundle.getMessage("BackupDialog.BackingUp") + " " + setName, Bundle.getMessage("BackupDialog.Ensure"));
            ExceptionDisplayFrame.displayExceptionDisplayFrame((Component)this, context);
        }
        catch (RuntimeException ex) {
            log.error("Doing backup...", (Throwable)ex);
            UnexpectedExceptionContext context = new UnexpectedExceptionContext(ex, Bundle.getMessage("BackupDialog.BackingUp") + " " + setName);
            ExceptionDisplayFrame.displayExceptionDisplayFrame((Component)this, context);
        }
        catch (Exception ex) {
            log.error("Doing backup...", (Throwable)ex);
            UnexpectedExceptionContext context = new UnexpectedExceptionContext(ex, Bundle.getMessage("BackupDialog.BackingUp") + " " + setName);
            ExceptionDisplayFrame.displayExceptionDisplayFrame((Component)this, context);
        }
    }

    protected void do_cancelButton_actionPerformed(ActionEvent arg0) {
        this.dispose();
    }

    private void enableBackupButton() {
        String s = this.setNameTextField.getText();
        this.backupButton.setEnabled(s.length() > 0);
    }

    protected void do_helpButton_actionPerformed(ActionEvent e) {
    }
}

