/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.setup.backup;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.Date;

public class BackupSet {
    private String _setName;
    private Date _lastModifiedDate;
    private File _dir;

    public String getSetName() {
        return this._setName;
    }

    public Date getLastModifiedDate() {
        return this._lastModifiedDate;
    }

    public BackupSet(File dir) {
        this._dir = dir;
        this._setName = dir.getName();
        this._lastModifiedDate = new Date(dir.lastModified());
    }

    public void delete() {
        this.deleteDirectoryAndFiles(this._dir);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="not possible")
    private void deleteDirectoryAndFiles(File dir) {
        Boolean ok;
        for (File f : dir.listFiles()) {
            if (!f.isFile() || (ok = Boolean.valueOf(f.delete())).booleanValue()) continue;
            throw new RuntimeException("Failed to delete file: " + f.getAbsolutePath());
        }
        ok = dir.delete();
        if (!ok.booleanValue()) {
            throw new RuntimeException("Failed to delete directory: " + dir.getAbsolutePath());
        }
    }

    public String toString() {
        return String.format("%s (%s)", this._setName, this._lastModifiedDate);
    }
}

