/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.setup.backup;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.jmrit.operations.OperationsManager;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.setup.backup.AutoBackup;
import jmri.jmrit.operations.setup.backup.BackupBase;
import jmri.jmrit.operations.setup.backup.BackupSet;
import jmri.jmrit.operations.setup.backup.Bundle;
import jmri.jmrit.operations.setup.backup.DefaultBackup;
import jmri.util.swing.ExceptionContext;
import jmri.util.swing.ExceptionDisplayFrame;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.UnexpectedExceptionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreDialog
extends JDialog {
    private JPanel mainPanel;
    private JPanel contentPanel;
    private JRadioButton automaticBackupsRadioButton;
    private JRadioButton defaultBackupsRadioButton;
    private JComboBox<BackupSet> comboBox;
    private JButton restoreButton;
    private BackupBase backup;
    private String setName;
    private JLabel newLabelLabel;
    private static final Logger log = LoggerFactory.getLogger(RestoreDialog.class);

    public RestoreDialog() {
        this.initComponents();
    }

    private void initComponents() {
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setModal(true);
        this.setTitle(Bundle.getMessage("RestoreDialog.this.title"));
        this.setBounds(100, 100, 378, 251);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setBorder(null);
        this.setContentPane(this.mainPanel);
        this.contentPanel = new JPanel();
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.mainPanel.add((Component)this.contentPanel, "North");
        JPanel panel = new JPanel();
        panel.setAlignmentX(0.0f);
        panel.setLayout(new FlowLayout(0));
        panel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), Bundle.getMessage("RestoreDialog.label.text"), 4, 2, null, new Color(0, 0, 0)));
        this.contentPanel.add(panel);
        ButtonGroup fromGroup = new ButtonGroup();
        this.automaticBackupsRadioButton = new JRadioButton(Bundle.getMessage("RestoreDialog.radioButton.autoBackup"));
        this.automaticBackupsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestoreDialog.this.do_automaticBackupsRadioButton_actionPerformed(e);
            }
        });
        panel.add(this.automaticBackupsRadioButton);
        fromGroup.add(this.automaticBackupsRadioButton);
        this.defaultBackupsRadioButton = new JRadioButton(Bundle.getMessage("RestoreDialog.radioButton.defaultBackup"));
        this.defaultBackupsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestoreDialog.this.do_defaultBackupsRadioButton_actionPerformed(e);
            }
        });
        panel.add(this.defaultBackupsRadioButton);
        fromGroup.add(this.defaultBackupsRadioButton);
        this.newLabelLabel = new JLabel(Bundle.getMessage("RestoreDialog.label2.text"));
        this.newLabelLabel.setBorder(new EmptyBorder(10, 0, 5, 0));
        this.contentPanel.add(this.newLabelLabel);
        this.comboBox = new JComboBox();
        this.comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                RestoreDialog.this.do_comboBox_itemStateChanged(arg0);
            }
        });
        this.comboBox.setAlignmentX(0.0f);
        this.contentPanel.add(this.comboBox);
        JPanel buttonPane = new JPanel();
        FlowLayout fl_buttonPane = new FlowLayout(1);
        buttonPane.setLayout(fl_buttonPane);
        this.mainPanel.add((Component)buttonPane, "South");
        this.restoreButton = new JButton(Bundle.getMessage("RestoreDialog.retoreButton.text"));
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestoreDialog.this.do_restoreButton_actionPerformed(e);
            }
        });
        buttonPane.add(this.restoreButton);
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RestoreDialog.this.do_cancelButton_actionPerformed(arg0);
            }
        });
        buttonPane.add(cancelButton);
        this.defaultBackupsRadioButton.doClick();
    }

    protected void do_automaticBackupsRadioButton_actionPerformed(ActionEvent e) {
        this.backup = new AutoBackup();
        this.loadComboBox();
    }

    protected void do_defaultBackupsRadioButton_actionPerformed(ActionEvent e) {
        this.backup = new DefaultBackup();
        this.loadComboBox();
    }

    protected void do_cancelButton_actionPerformed(ActionEvent arg0) {
        this.dispose();
    }

    protected void do_comboBox_itemStateChanged(ItemEvent arg0) {
        int stateChange = arg0.getStateChange();
        if (stateChange == 1) {
            this.restoreButton.setEnabled(true);
        } else if (stateChange == 2) {
            this.restoreButton.setEnabled(false);
        }
    }

    protected void do_helpButton_actionPerformed(ActionEvent arg0) {
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="I18N of Info Message")
    protected void do_restoreButton_actionPerformed(ActionEvent e) {
        log.debug("restore button activated");
        if (OperationsXml.areFilesDirty() && JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("OperationsFilesModified"), Bundle.getMessage("SaveOperationFiles"), 0) == 0) {
            OperationsXml.save();
        }
        try {
            AutoBackup auto = new AutoBackup();
            auto.autoBackup();
            this.backup.deleteOperationsFiles();
            this.setName = ((BackupSet)this.comboBox.getSelectedItem()).getSetName();
            Date date = ((BackupSet)this.comboBox.getSelectedItem()).getLastModifiedDate();
            String sd = String.format("%s", date);
            log.info(Bundle.getMessage("InfoRestoringSet", this.setName, sd));
            this.backup.restoreFilesFromSetName(this.setName);
            InstanceManager.getDefault(OperationsManager.class).setShutDownTask(null);
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("YouMustRestartAfterRestore"), Bundle.getMessage("RestoreSuccessful"), 1);
            this.dispose();
            try {
                InstanceManager.getDefault(ShutDownManager.class).restart();
            }
            catch (Exception er) {
                log.error("Continuing after error in handleRestart", (Throwable)er);
            }
        }
        catch (IOException ex) {
            ExceptionContext context = new ExceptionContext(ex, Bundle.getMessage("RestoreDialog.restoring") + " " + this.setName, "Hint about checking valid names, etc.");
            ExceptionDisplayFrame.displayExceptionDisplayFrame((Component)this, context);
        }
        catch (Exception ex) {
            log.error("Doing restore from {}", (Object)this.setName, (Object)ex);
            UnexpectedExceptionContext context = new UnexpectedExceptionContext(ex, Bundle.getMessage("RestoreDialog.restoring") + " " + this.setName);
            ExceptionDisplayFrame.displayExceptionDisplayFrame((Component)this, context);
        }
    }

    private void loadComboBox() {
        this.restoreButton.setEnabled(false);
        this.comboBox.removeAllItems();
        BackupSet[] sets = this.backup.getBackupSets();
        DefaultComboBoxModel<BackupSet> model = new DefaultComboBoxModel<BackupSet>(sets);
        model.setSelectedItem(null);
        this.comboBox.setModel(model);
        if (model.getSize() > 0) {
            this.comboBox.setSelectedIndex(model.getSize() - 1);
        }
    }
}

