/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.setup.backup;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.jmrit.operations.OperationsManager;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.setup.backup.AutoBackup;
import jmri.jmrit.operations.setup.backup.Bundle;
import jmri.jmrit.operations.setup.backup.DefaultBackup;
import jmri.util.swing.ExceptionContext;
import jmri.util.swing.ExceptionDisplayFrame;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreFilesAction
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(RestoreFilesAction.class);

    public RestoreFilesAction() {
        super(Bundle.getMessage("Restore"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.restore();
    }

    private void restore() {
        if (OperationsXml.areFilesDirty() && JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("OperationsFilesModified"), Bundle.getMessage("SaveOperationFiles"), 0) == 0) {
            OperationsXml.save();
        }
        DefaultBackup backup = new DefaultBackup();
        JmriJFileChooser fc = new JmriJFileChooser(backup.getBackupRoot());
        fc.addChoosableFileFilter(new FileFilter());
        fc.setFileSelectionMode(1);
        int retVal = fc.showOpenDialog(null);
        if (retVal != 0) {
            return;
        }
        if (fc.getSelectedFile() == null) {
            return;
        }
        AutoBackup autoBackup = new AutoBackup();
        try {
            autoBackup.autoBackup();
            File directory = fc.getSelectedFile();
            backup.deleteOperationsFiles();
            backup.restoreFilesFromDirectory(directory);
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("YouMustRestartAfterRestore"), Bundle.getMessage("RestoreSuccessful"), 1);
            InstanceManager.getDefault(OperationsManager.class).setShutDownTask(null);
            try {
                InstanceManager.getDefault(ShutDownManager.class).restart();
            }
            catch (Exception er) {
                log.error("Continuing after error in handleRestart", (Throwable)er);
            }
        }
        catch (IOException ex) {
            ExceptionContext context = new ExceptionContext(ex, Bundle.getMessage("RestoreDialog.restore.files"), Bundle.getMessage("RestoreDialog.makeSure"));
            ExceptionDisplayFrame.displayExceptionDisplayFrame(null, context);
        }
    }

    private static class FileFilter
    extends javax.swing.filechooser.FileFilter {
        private FileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            return name.matches(".*\\.xml");
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("BackupFolders");
        }
    }
}

