/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.setup.gui;

import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jmri.InstanceManager;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.setup.gui.BuildReportOptionFrame;
import jmri.jmrit.operations.setup.gui.Bundle;
import jmri.jmrit.operations.setup.gui.OperationsPreferencesPanel;
import jmri.util.swing.JmriJOptionPane;

public class BuildReportOptionPanel
extends OperationsPreferencesPanel {
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JRadioButton buildReportMin = new JRadioButton(Bundle.getMessage("Minimal"));
    JRadioButton buildReportNor = new JRadioButton(Bundle.getMessage("Normal"));
    JRadioButton buildReportMax = new JRadioButton(Bundle.getMessage("Detailed"));
    JRadioButton buildReportVD = new JRadioButton(Bundle.getMessage("VeryDetailed"));
    JRadioButton buildReportRouterNor = new JRadioButton(Bundle.getMessage("Normal"));
    JRadioButton buildReportRouterMax = new JRadioButton(Bundle.getMessage("Detailed"));
    JRadioButton buildReportRouterVD = new JRadioButton(Bundle.getMessage("VeryDetailed"));
    JCheckBox buildReportCheckBox = new JCheckBox(Bundle.getMessage("BuildReportEdit"));
    JCheckBox buildReportIndentCheckBox = new JCheckBox(Bundle.getMessage("BuildReportIndent"));
    JCheckBox buildReportAlwaysPreviewCheckBox = new JCheckBox(Bundle.getMessage("BuildReportAlwaysPreview"));
    JComboBox<Integer> fontSizeComboBox = new JComboBox();

    public BuildReportOptionPanel() {
        this.saveButton.setToolTipText(Bundle.getMessage("SaveToolTip"));
        this.buildReportCheckBox.setToolTipText(Bundle.getMessage("CreatesTextFileTip"));
        this.setLayout(new BoxLayout(this, 1));
        JPanel pReport = new JPanel();
        pReport.setLayout(new GridBagLayout());
        pReport.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutReportOptions")));
        this.addItemWidth(pReport, this.buildReportCheckBox, 3, 1, 1);
        this.addItemWidth(pReport, this.buildReportIndentCheckBox, 3, 1, 2);
        this.addItemWidth(pReport, this.buildReportAlwaysPreviewCheckBox, 3, 1, 3);
        JPanel pFontSize = new JPanel();
        pFontSize.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutFontSize")));
        pFontSize.add(this.fontSizeComboBox);
        JPanel pLevel = new JPanel();
        pLevel.setLayout(new GridBagLayout());
        pLevel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BuildReport")));
        this.addItemLeft(pLevel, this.buildReportMin, 1, 0);
        this.addItemLeft(pLevel, this.buildReportNor, 2, 0);
        this.addItemLeft(pLevel, this.buildReportMax, 3, 0);
        this.addItemLeft(pLevel, this.buildReportVD, 4, 0);
        JPanel pRouterLevel = new JPanel();
        pRouterLevel.setLayout(new GridBagLayout());
        pRouterLevel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BuildReportRouter")));
        this.addItemLeft(pRouterLevel, this.buildReportRouterNor, 2, 0);
        this.addItemLeft(pRouterLevel, this.buildReportRouterMax, 3, 0);
        this.addItemLeft(pRouterLevel, this.buildReportRouterVD, 4, 0);
        JPanel pControl = new JPanel();
        pControl.setBorder(BorderFactory.createTitledBorder(""));
        pControl.setLayout(new GridBagLayout());
        this.addItem(pControl, this.saveButton, 0, 0);
        this.add(pReport);
        this.add(pLevel);
        this.add(pRouterLevel);
        this.add(pFontSize);
        this.add(pControl);
        this.buildReportCheckBox.setSelected(Setup.isBuildReportEditorEnabled());
        this.buildReportIndentCheckBox.setSelected(Setup.isBuildReportIndentEnabled());
        this.buildReportIndentCheckBox.setEnabled(this.buildReportCheckBox.isSelected());
        this.buildReportAlwaysPreviewCheckBox.setSelected(Setup.isBuildReportAlwaysPreviewEnabled());
        ButtonGroup buildReportGroup = new ButtonGroup();
        buildReportGroup.add(this.buildReportMin);
        buildReportGroup.add(this.buildReportNor);
        buildReportGroup.add(this.buildReportMax);
        buildReportGroup.add(this.buildReportVD);
        ButtonGroup buildReportRouterGroup = new ButtonGroup();
        buildReportRouterGroup.add(this.buildReportRouterNor);
        buildReportRouterGroup.add(this.buildReportRouterMax);
        buildReportRouterGroup.add(this.buildReportRouterVD);
        this.setBuildReportRadioButton();
        this.setBuildReportRouterRadioButton();
        BuildReportOptionPanel.loadFontSizeComboBox(this.fontSizeComboBox);
        this.fontSizeComboBox.setSelectedItem(Setup.getBuildReportFontSize());
        this.addButtonAction(this.saveButton);
        this.addCheckBoxAction(this.buildReportCheckBox);
        this.addRadioButtonAction(this.buildReportMin);
        this.addRadioButtonAction(this.buildReportNor);
        this.addRadioButtonAction(this.buildReportMax);
        this.addRadioButtonAction(this.buildReportVD);
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveButton) {
            this.savePreferences();
            Container topLevelAncestor = this.getTopLevelAncestor();
            if (Setup.isCloseWindowOnSaveEnabled() && topLevelAncestor instanceof BuildReportOptionFrame) {
                ((BuildReportOptionFrame)topLevelAncestor).dispose();
            }
        }
    }

    @Override
    protected void checkBoxActionPerformed(ActionEvent ae) {
        this.buildReportIndentCheckBox.setEnabled(this.buildReportCheckBox.isSelected());
        if (this.buildReportCheckBox.isSelected()) {
            this.fontSizeComboBox.setSelectedItem(7);
        }
    }

    @Override
    protected void radioButtonActionPerformed(ActionEvent ae) {
        this.setBuildReportRouterRadioButton();
    }

    private void setBuildReportRadioButton() {
        this.buildReportMin.setSelected(Setup.getBuildReportLevel().equals("1"));
        this.buildReportNor.setSelected(Setup.getBuildReportLevel().equals("3"));
        this.buildReportMax.setSelected(Setup.getBuildReportLevel().equals("5"));
        this.buildReportVD.setSelected(Setup.getBuildReportLevel().equals("7"));
    }

    private void setBuildReportRouterRadioButton() {
        this.buildReportRouterNor.setEnabled(this.buildReportVD.isSelected());
        this.buildReportRouterMax.setEnabled(this.buildReportVD.isSelected());
        this.buildReportRouterVD.setEnabled(this.buildReportVD.isSelected());
        this.buildReportRouterMax.setSelected(Setup.getRouterBuildReportLevel().equals("5"));
        this.buildReportRouterVD.setSelected(Setup.getRouterBuildReportLevel().equals("7"));
        this.buildReportRouterNor.setSelected(Setup.getRouterBuildReportLevel().equals("3") || !this.buildReportVD.isSelected());
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return Bundle.getMessage("TitleBuildReportOptions");
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        Setup.setBuildReportFontSize((Integer)this.fontSizeComboBox.getSelectedItem());
        if (this.buildReportMin.isSelected()) {
            Setup.setBuildReportLevel("1");
        } else if (this.buildReportNor.isSelected()) {
            Setup.setBuildReportLevel("3");
        } else if (this.buildReportMax.isSelected()) {
            Setup.setBuildReportLevel("5");
        } else if (this.buildReportVD.isSelected()) {
            Setup.setBuildReportLevel("7");
        }
        String oldReportLevel = Setup.getRouterBuildReportLevel();
        if (this.buildReportRouterNor.isSelected()) {
            Setup.setRouterBuildReportLevel("3");
        } else if (this.buildReportRouterMax.isSelected()) {
            Setup.setRouterBuildReportLevel("5");
        } else if (this.buildReportRouterVD.isSelected()) {
            Setup.setRouterBuildReportLevel("7");
        }
        if (!oldReportLevel.equals(Setup.getRouterBuildReportLevel())) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("buildReportRouter"), Bundle.getMessage("buildReportRouterTitle"), 1);
        }
        Setup.setBuildReportEditorEnabled(this.buildReportCheckBox.isSelected());
        Setup.setBuildReportIndentEnabled(this.buildReportIndentCheckBox.isSelected());
        Setup.setBuildReportAlwaysPreviewEnabled(this.buildReportAlwaysPreviewCheckBox.isSelected());
        InstanceManager.getDefault(OperationsSetupXml.class).writeOperationsFile();
    }

    @Override
    public boolean isDirty() {
        String reportLevel = Setup.getBuildReportLevel();
        if (this.buildReportMin.isSelected()) {
            reportLevel = "1";
        } else if (this.buildReportNor.isSelected()) {
            reportLevel = "3";
        } else if (this.buildReportMax.isSelected()) {
            reportLevel = "5";
        } else if (this.buildReportVD.isSelected()) {
            reportLevel = "7";
        }
        String routerReportLevel = Setup.getRouterBuildReportLevel();
        if (this.buildReportRouterNor.isSelected()) {
            routerReportLevel = "3";
        } else if (this.buildReportRouterMax.isSelected()) {
            routerReportLevel = "5";
        } else if (this.buildReportRouterVD.isSelected()) {
            routerReportLevel = "7";
        }
        return Setup.getBuildReportFontSize() != (Integer)this.fontSizeComboBox.getSelectedItem() || !reportLevel.equals(Setup.getBuildReportLevel()) || !routerReportLevel.equals(Setup.getRouterBuildReportLevel()) || Setup.isBuildReportEditorEnabled() != this.buildReportCheckBox.isSelected() || Setup.isBuildReportIndentEnabled() != this.buildReportIndentCheckBox.isSelected() || Setup.isBuildReportAlwaysPreviewEnabled() != this.buildReportAlwaysPreviewCheckBox.isSelected();
    }
}

